/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public class FilterReport
implements IReport {
    private static final long serialVersionUID = -1515524938023295459L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    public void writeReport(PrintWriter printWriter) {
        throw new UnsupportedOperationException();
    }

    public void writeReportDetailed(PrintWriter printWriter, Filter inFilter) {
        Serializable[] problem22;
        this.filter = null;
        printWriter.println("              Filter: " + inFilter);
        printWriter.println("           Filter On: " + inFilter.isFilterOn());
        printWriter.println("     Filter problems: " + inFilter.isFilteringSites());
        printWriter.println("     Filter problems: " + inFilter.isFilteringProblems());
        printWriter.println("      Filter clients: " + inFilter.isFilteringAccounts());
        printWriter.println("      Filter on time: " + inFilter.isFilteringElapsedTime());
        printWriter.println("    Filter languages: " + inFilter.isFilteringLanguages());
        printWriter.println("   Filter judgements: " + inFilter.isFilteringJudgements());
        printWriter.println("   Filter run states: " + inFilter.isFilteringRunStates());
        printWriter.println("  Filter clar states: " + inFilter.isFilteringClarificationStates());
        printWriter.println();
        if (inFilter.isFilteringElapsedTime()) {
            printWriter.println("-- Filtering on submitted time --");
            if (inFilter.getStartElapsedTime() == -1L) {
                printWriter.println("   Filtering up to and including " + inFilter.getEndElapsedTime() + " minutes");
            } else if (inFilter.getEndElapsedTime() == -1L) {
                printWriter.println("   Filtering starting " + inFilter.getStartElapsedTime() + " minutes (inclusive)");
            } else {
                printWriter.println("   Filtering " + inFilter.getStartElapsedTime() + " through " + inFilter.getEndElapsedTime() + " minutes");
            }
        } else {
            printWriter.println("-- Not filtering on submitted time --");
        }
        printWriter.println();
        ElementId[] elementIds = null;
        elementIds = inFilter.getProblemIdList();
        printWriter.println("-- " + elementIds.length + " Problems filtered --");
        ElementId[] elementIdArray = elementIds;
        int n = elementIds.length;
        int n2 = 0;
        while (n2 < n) {
            ElementId elementId = elementIdArray[n2];
            problem22 = this.contest.getProblem(elementId);
            if (problem22 == null) {
                printWriter.println("   Not displayed " + problem22);
            } else {
                printWriter.println("   " + problem22);
            }
            ++n2;
        }
        printWriter.println();
        Integer[] integerIds = null;
        integerIds = inFilter.getSiteIdList();
        printWriter.println("-- " + integerIds.length + " Sites filtered --");
        problem22 = integerIds;
        int n3 = integerIds.length;
        n = 0;
        while (n < n3) {
            Integer integer = problem22[n];
            Site site = this.contest.getSite(integer);
            if (site == null) {
                printWriter.println("   Not displayed " + site);
            } else {
                printWriter.println("   " + site.getSiteNumber() + " " + site.getDisplayName());
            }
            ++n;
        }
        printWriter.println();
        elementIds = inFilter.getLanguageIdList();
        printWriter.println("-- " + elementIds.length + " Languages filtered --");
        problem22 = elementIds;
        n3 = elementIds.length;
        n = 0;
        while (n < n3) {
            Serializable elementId = problem22[n];
            Language language = this.contest.getLanguage((ElementId)elementId);
            if (language == null) {
                printWriter.println("   Not displayed " + language);
            } else {
                printWriter.println("   " + language);
            }
            ++n;
        }
        printWriter.println();
        elementIds = inFilter.getJudgementIdList();
        printWriter.println("-- " + elementIds.length + " Judgements filtered --");
        problem22 = elementIds;
        n3 = elementIds.length;
        n = 0;
        while (n < n3) {
            Serializable elementId = problem22[n];
            Judgement judgement = this.contest.getJudgement((ElementId)elementId);
            if (judgement == null) {
                printWriter.println("   Not displayed " + judgement);
            } else {
                printWriter.println("   " + judgement);
            }
            ++n;
        }
        printWriter.println();
        ClientId[] clientIds = inFilter.getAccountList();
        printWriter.println("-- " + clientIds.length + " Accounts filtered --");
        ClientId[] clientIdArray = clientIds;
        int problem22 = clientIds.length;
        n3 = 0;
        while (n3 < problem22) {
            ClientId clientId = clientIdArray[n3];
            Account account = this.contest.getAccount(clientId);
            if (account == null) {
                printWriter.println("   Not displayed " + account);
            } else {
                printWriter.println("   " + clientId + " " + account.getDisplayName());
            }
            ++n3;
        }
        printWriter.println();
        Run.RunStates[] runStatesList = inFilter.getRunStates();
        printWriter.println("-- " + runStatesList.length + " Run states filtered --");
        Run.RunStates[] runStatesArray = runStatesList;
        int n4 = runStatesList.length;
        problem22 = 0;
        while (problem22 < n4) {
            Run.RunStates runStates = runStatesArray[problem22];
            printWriter.println("   " + (Object)((Object)runStates));
            ++problem22;
        }
        printWriter.println();
        Clarification.ClarificationStates[] clarificationStatesList = inFilter.getClarificationStatesList();
        printWriter.println("-- " + clarificationStatesList.length + " Clarirification states filtered --");
        Clarification.ClarificationStates[] clarificationStatesArray = clarificationStatesList;
        int n5 = clarificationStatesList.length;
        n4 = 0;
        while (n4 < n5) {
            Clarification.ClarificationStates clarificationStates = clarificationStatesArray[n4];
            printWriter.println("   " + (Object)((Object)clarificationStates));
            ++n4;
        }
        printWriter.println();
    }

    public void writeReport(PrintWriter printWriter, Filter inFilter) {
        printWriter.println();
        printWriter.println("  '" + inFilter + " " + inFilter);
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Filters";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Filters Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

