/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class FastestSolvedReport
implements IReport {
    private static final long serialVersionUID = 3878379207856922664L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        Problem[] problems = this.contest.getProblems();
        if (problems == null || problems.length == 0) {
            printWriter.println("No problems defined, no summary");
            return;
        }
        int numDeleted = 0;
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            Run[] runList = this.filterForProblem(runs, problem);
            Arrays.sort(runList, new RunCompartorByElapsed());
            printWriter.println("Problem " + problem);
            printWriter.println();
            printWriter.println("Rank Elap Run# Team");
            int numberSolved = 0;
            int rank = 0;
            int tieRank = 0;
            long lastElapsed = -1L;
            Run[] runArray = runList;
            int n3 = runList.length;
            int n4 = 0;
            while (n4 < n3) {
                Run run = runArray[n4];
                if (!run.isDeleted() && run.isSolved() && this.filter.matches(run)) {
                    ++numberSolved;
                    long elapsed = run.getElapsedMins();
                    String teamName = run.getSubmitter().toString();
                    Account account = this.contest.getAccount(run.getSubmitter());
                    if (account != null) {
                        teamName = account.getDisplayName();
                    }
                    teamName = String.valueOf(teamName) + " (Site " + run.getSubmitter().getSiteNumber() + ")";
                    if (elapsed != lastElapsed) {
                        tieRank = ++rank;
                        printWriter.format(" %3d %4d %4d ", tieRank, elapsed, run.getNumber());
                        printWriter.println(teamName);
                        lastElapsed = elapsed;
                    } else {
                        ++rank;
                        printWriter.format(" %3d %4d %4d ", tieRank, elapsed, run.getNumber());
                        printWriter.println(teamName);
                    }
                } else if (run.isDeleted() && this.filter.matches(run)) {
                    ++numDeleted;
                }
                ++n4;
            }
            printWriter.println();
            if (numberSolved > 0) {
                printWriter.println("There are " + numberSolved + " runs solving " + problem);
            } else {
                printWriter.println("No solutions for problem " + problem);
            }
            printWriter.println();
            ++n2;
        }
        if (numDeleted > 0) {
            printWriter.println("There are " + numDeleted + " runs marked deleted");
        }
    }

    private Run[] filterForProblem(Run[] runs, Problem problem) {
        Vector<Run> runVector = new Vector<Run>();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getProblemId().equals(problem.getElementId())) {
                runVector.addElement(run);
            }
            ++n2;
        }
        return runVector.toArray(new Run[runVector.size()]);
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Fastest Solved by Problem";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Fastest Solved by Problem";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

