/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class ExtractRuns {
    private IInternalContest contest;
    private String extractDirectory = "extract";
    private VersionInfo versionInfo = new VersionInfo();

    public boolean extractRun(ElementId runId) throws IOException {
        Run run = this.contest.getRun(runId);
        String targetDirectory = String.valueOf(this.extractDirectory) + File.separator + "site" + run.getSiteNumber() + "run" + run.getNumber();
        if (!new File(targetDirectory).isDirectory()) {
            new File(targetDirectory).mkdirs();
        }
        String filename = String.valueOf(targetDirectory) + File.separator + "pc2.run" + run.getNumber() + ".txt";
        this.writeInfoFile(filename, run);
        RunFiles runFiles = this.contest.getRunFiles(run);
        if (runFiles != null) {
            SerializedFile serializedFile = runFiles.getMainFile();
            filename = String.valueOf(targetDirectory) + File.separator + serializedFile.getName();
            serializedFile.writeFile(filename);
            if (runFiles.getOtherFiles() != null) {
                SerializedFile[] serializedFileArray = runFiles.getOtherFiles();
                int n = serializedFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializedFile file = serializedFileArray[n2];
                    filename = String.valueOf(targetDirectory) + File.separator + file.getName();
                    file.writeFile(filename);
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    private void writeInfoFile(String filename, Run run) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        printWriter.println();
        ContestTime contestTime = this.contest.getContestTime();
        printWriter.println();
        printWriter.println(this.versionInfo.getSystemName());
        printWriter.println(this.versionInfo.getSystemVersionInfo());
        if (contestTime != null) {
            printWriter.println();
            printWriter.println("Contest on " + contestTime.getResumeTime().getTime());
        }
        printWriter.println();
        printWriter.println("Run   : " + run.getNumber());
        printWriter.println("Site  : " + run.getSiteNumber());
        printWriter.println("Team  : " + run.getSubmitter());
        printWriter.println("Prob  : " + this.contest.getProblem(run.getProblemId()));
        printWriter.println("Lang  : " + this.contest.getLanguage(run.getLanguageId()));
        printWriter.println("Elaps : " + run.getElapsedMins());
        printWriter.println();
        printWriter.println("done at " + new Date());
        printWriter.close();
    }

    public ExtractRuns(IInternalContest contest) {
        this.contest = contest;
    }

    public String getExtractDirectory() {
        return this.extractDirectory;
    }

    public void setExtractDirectory(String extractDirectory) {
        this.extractDirectory = extractDirectory;
    }
}

