/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.PlaybackEvent;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class ExtractPlaybackLoadFilesReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private static final String DELIMITER = "|";
    private IInternalContest contest;
    private IInternalController controller;
    private String extractDirectory;
    private String reportFilename;
    private Log log;
    private Filter filter;
    private String reportDirectory = "reports";
    private String universalFileSeparator = "/";

    private void writeRow(PrintWriter printWriter, Run run) throws Exception {
        RunFiles runFiles = this.contest.getRunFiles(run);
        SerializedFile mainfile = runFiles.getMainFile();
        String mainFileName = mainfile.getName();
        String targetDirectory = String.valueOf(this.extractDirectory) + this.universalFileSeparator + "site" + run.getSiteNumber() + "run" + run.getNumber();
        if (!new File(targetDirectory).isDirectory()) {
            new File(targetDirectory).mkdirs();
        }
        String outputFileName = String.valueOf(targetDirectory) + this.universalFileSeparator + mainFileName;
        mainfile.writeFile(outputFileName);
        outputFileName = String.valueOf(this.removeUpTo(targetDirectory, File.separator).substring(1)) + this.universalFileSeparator + mainFileName;
        this.writeValues(printWriter, "action", PlaybackEvent.Action.RUN_SUBMIT.toString());
        this.writeValues(printWriter, "id", run.getNumber());
        this.writeValues(printWriter, "elapsed", run.getElapsedMins());
        this.writeValues(printWriter, "language", this.contest.getLanguage(run.getLanguageId()).getDisplayName());
        this.writeValues(printWriter, "problem", this.contest.getProblem(run.getProblemId()).getDisplayName());
        this.writeValues(printWriter, "site", run.getSiteNumber());
        this.writeValues(printWriter, "submitclient", run.getSubmitter().getName());
        this.writeValues(printWriter, "mainfile", outputFileName);
        printWriter.println();
    }

    private void writeValues(PrintWriter printWriter, String key, long number) {
        printWriter.print(String.valueOf(key) + "=" + number + DELIMITER + " ");
    }

    private void writeValues(PrintWriter printWriter, String key, String value) {
        printWriter.print(String.valueOf(key) + "=" + value + DELIMITER + " ");
    }

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        printWriter.println("# ------------------------------------------------------------");
        printWriter.println();
        printWriter.println("# " + this.getReportTitle());
        printWriter.println("# Created on " + new Date());
        printWriter.println("# Created by: " + new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        Vector<String> failedRunExtract = new Vector<String>();
        this.extractDirectory = String.valueOf(this.removeUpTo(this.reportFilename, String.valueOf(this.reportDirectory) + File.separator)) + ".files";
        int nonExtractedRuns = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            try {
                if (this.isThisSite(run.getSiteNumber())) {
                    this.writeRow(printWriter, run);
                } else {
                    printWriter.println("# Remote run site " + run.getSiteNumber() + " not extracted " + run);
                    failedRunExtract.add("Remote run: " + run);
                    ++nonExtractedRuns;
                }
            }
            catch (Exception e) {
                failedRunExtract.add("Failed run: " + run);
                ++nonExtractedRuns;
                printWriter.println("# error extracting run " + run + " " + e.getMessage());
            }
            ++n2;
        }
        String[] list = failedRunExtract.toArray(new String[failedRunExtract.size()]);
        printWriter.println();
        if (nonExtractedRuns > 0) {
            printWriter.println("# " + nonExtractedRuns + " extracting runs NOT extracted");
            String[] stringArray = list;
            int n3 = list.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                printWriter.println("# " + s);
                ++n;
            }
        } else {
            printWriter.println("# All " + list.length + " runs extracted");
        }
        printWriter.println();
        printWriter.println("# EOF " + this.getReportTitle());
        printWriter.println("# ------------------------------------------------------------");
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    protected String removeUpTo(String source, String targetString) {
        int index = source.indexOf(targetString);
        if (index > 0) {
            String debug2 = source.substring(index);
            return debug2;
        }
        return source;
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println("# " + this.getReportTitle() + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("# end ");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.reportFilename = filename;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.reportFilename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Extract Replay Runs";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Extract Replay Runs";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

