/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class ContestReport
implements IReport {
    private static final long serialVersionUID = 8827529273455158045L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    protected String getContestXML() throws IOException {
        Problem[] problems;
        Language[] languages;
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("contest");
        Language[] languageArray = languages = this.contest.getLanguages();
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            IMemento languageMemento = mementoRoot.createChild("language");
            languageMemento.putString("name", language.toString());
            languageMemento.putBoolean("autofill", true);
            ++n2;
        }
        Problem[] problemArray = problems = this.contest.getProblems();
        int n3 = problems.length;
        n = 0;
        while (n < n3) {
            Problem problem = problemArray[n];
            IMemento problemMemento = mementoRoot.createChild("problem");
            problemMemento.putString("name", problem.toString());
            if (problem.isUsingPC2Validator()) {
                problemMemento.putBoolean("useInternalValidator", true);
                problemMemento.putInteger("internalValidatorOption", problem.getWhichPC2Validator());
            }
            if (problem.getDataFileName() != null) {
                problemMemento.putString("datafilename", problem.getDataFileName());
            }
            if (problem.getAnswerFileName() != null) {
                problemMemento.putString("answerfilename", problem.getAnswerFileName());
            }
            ++n;
        }
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n4 = runs.length;
        n3 = 0;
        while (n3 < n4) {
            Run run = runArray[n3];
            if (this.filter.matches(run)) {
                String languageName = this.contest.getLanguage(run.getLanguageId()).toString();
                String problemName = this.contest.getProblem(run.getProblemId()).toString();
                IMemento runMemento = mementoRoot.createChild("Run");
                runMemento.putInteger("site", run.getSiteNumber());
                runMemento.putInteger("number", run.getNumber());
                runMemento.putInteger("site", run.getSiteNumber());
                runMemento.putLong("elapsed", run.getElapsedMins());
                runMemento.putString("languageName", languageName);
                runMemento.putString("problemName", problemName);
            }
            ++n3;
        }
        System.out.println("There were " + this.filter.countRuns(runs) + " runs.");
        return mementoRoot.saveToString();
    }

    public void writeReport(PrintWriter printWriter) throws IOException {
        String xmlString = this.getContestXML();
        printWriter.println(xmlString);
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter inFilter) {
        this.filter = inFilter;
        return new String[0];
    }

    public String createReportXML(Filter arg0) {
        try {
            return this.getContestXML();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public String getReportTitle() {
        return "Contest";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Contest Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

