/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunCompartorByTeamProblemElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class ContestAnalysisReport
implements IReport {
    private static final long serialVersionUID = 8827529273455158045L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) throws IOException {
        printWriter.println();
        printWriter.println("Contest Title: " + this.contest.getContestInformation().getContestTitle());
        printWriter.println();
        printWriter.println(String.valueOf(this.contest.getSites().length) + " sites.");
        this.printRunsClarsBySite(printWriter);
    }

    protected void printRunsFromDisabledTeams(PrintWriter printWriter) {
        printWriter.println("Runs submitted by Teams not shown on scoreboard/standings");
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunCompartorByTeamProblemElapsed());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId;
            Run run = runArray[n2];
            if (this.filter.matches(run) && !this.contest.getAccount(clientId = run.getSubmitter()).isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                printWriter.format("#%3d %3d %-10.10s ", run.getNumber(), run.getElapsedMins(), this.getJudgementName(run));
                printWriter.print(clientId + " '" + this.contest.getAccount(clientId).getDisplayName() + "'");
                printWriter.println();
            }
            ++n2;
        }
    }

    protected void printRunsClarsBySite(PrintWriter printWriter) {
        int siteNum;
        int numSites = this.contest.getSites().length;
        int[] numRuns = new int[numSites];
        int[] numRunsDeleted = new int[numSites];
        int[] numClars = new int[numSites];
        int[] numClarsDeleted = new int[numSites];
        int[] numClarsForAll = new int[numSites];
        int[] numUnjudgedRuns = new int[numSites];
        int totalUnjudgedRuns = 0;
        int[] numClarsUnAnswered = new int[numSites];
        int totalUnanswered = 0;
        ISubmission[] iSubmissionArray = this.contest.getRuns();
        int n = iSubmissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = iSubmissionArray[n2];
            if (this.filter.matches(run)) {
                int n3 = siteNum = run.getSiteNumber() - 1;
                numRuns[n3] = numRuns[n3] + 1;
                if (run.isDeleted()) {
                    int n4 = siteNum;
                    numRunsDeleted[n4] = numRunsDeleted[n4] + 1;
                }
                if (!run.isJudged()) {
                    int n5 = siteNum;
                    numUnjudgedRuns[n5] = numUnjudgedRuns[n5] + 1;
                    ++totalUnjudgedRuns;
                }
            }
            ++n2;
        }
        iSubmissionArray = this.contest.getClarifications();
        n = iSubmissionArray.length;
        n2 = 0;
        while (n2 < n) {
            ISubmission clarification = iSubmissionArray[n2];
            if (this.filter.matches((Clarification)clarification)) {
                int n6 = siteNum = clarification.getSiteNumber() - 1;
                numClars[n6] = numClars[n6] + 1;
                if (((Clarification)clarification).isSendToAll()) {
                    int n7 = siteNum;
                    numClarsForAll[n7] = numClarsForAll[n7] + 1;
                }
                if (!((Clarification)clarification).isAnswered()) {
                    int n8 = siteNum;
                    numClarsUnAnswered[n8] = numClarsUnAnswered[n8] + 1;
                    ++totalUnanswered;
                }
                if (((Clarification)clarification).isDeleted()) {
                    int n9 = siteNum;
                    numClarsDeleted[n9] = numClarsDeleted[n9] + 1;
                }
            }
            ++n2;
        }
        int totalRunsDeleted = 0;
        int totalClars = 0;
        int totalRuns = 0;
        int totalClarsDeleted = 0;
        int totalClarsToAll = 0;
        int i = 0;
        while (i < numSites) {
            int siteNum2 = i + 1;
            if (this.filter.matchesSite(this.contest.getSite(siteNum2))) {
                printWriter.format("%2d %-15s ", siteNum2, this.contest.getSite(siteNum2).getDisplayName());
                printWriter.format("%4d runs (%2d unjudged, %2d deleted)", numRuns[i], numUnjudgedRuns[i], numRunsDeleted[i]);
                printWriter.format("%4d clars, %d to All (%2d unanswered, %2d deleted)", numClars[i], numClarsForAll[i], numClarsUnAnswered[i], numClarsDeleted[i]);
                totalRunsDeleted += numRunsDeleted[i];
                totalClars += numClars[i];
                totalRuns += numRuns[i];
                totalClarsDeleted += numClarsDeleted[i];
                totalClarsToAll += numClarsForAll[i];
                printWriter.println();
            }
            ++i;
        }
        printWriter.format("   %-15s ", "Total");
        printWriter.format("%4d runs (%2d unjudged, %2d deleted)", totalRuns, totalUnjudgedRuns, totalRunsDeleted);
        printWriter.format("%4d clars, %d to All (%2d unanswered, %2d deleted)", totalClars, totalClarsToAll, totalUnanswered, totalClarsDeleted);
        printWriter.println();
        printWriter.println();
        if (totalUnanswered == 0) {
            printWriter.println("There are NO unanswered clars");
        } else {
            printWriter.println("Note: " + totalUnanswered + " unanswered clars");
        }
        if (totalUnjudgedRuns == 0) {
            printWriter.println("There are NO unjudged runs");
        } else {
            printWriter.println("Note: " + totalUnjudgedRuns + " unjudged runs");
        }
        printWriter.println();
        printWriter.println("Runs after first Yes ");
        Run solvedRun = null;
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunCompartorByTeamProblemElapsed());
        ElementId lastProblemId = null;
        ClientId lastClientId = null;
        int numYesAfterYes = 0;
        int numNoAfterYes = 0;
        Run[] runArray = runs;
        int n10 = runs.length;
        int n11 = 0;
        while (n11 < n10) {
            Run run = runArray[n11];
            if (this.filter.matches(run) && !run.isDeleted()) {
                if (lastClientId == null) {
                    lastProblemId = run.getProblemId();
                    lastClientId = run.getSubmitter();
                    if (run.isSolved()) {
                        solvedRun = run;
                    }
                } else {
                    if (lastClientId.equals(run.getSubmitter()) && run.getProblemId().equals(lastProblemId) && solvedRun != null) {
                        if (run.isSolved()) {
                            ++numYesAfterYes;
                        } else {
                            ++numNoAfterYes;
                        }
                        printWriter.print("Found   ");
                        printWriter.format("#%3d %3d %-10.10s ", run.getNumber(), run.getElapsedMins(), this.getJudgementName(run));
                        printWriter.print(lastClientId + " '" + this.contest.getAccount(lastClientId).getDisplayName() + "'");
                        printWriter.println();
                        printWriter.print("  After ");
                        printWriter.format("#%3d %3d %-10.10s ", solvedRun.getNumber(), solvedRun.getElapsedMins(), this.getJudgementName(solvedRun));
                        printWriter.print(this.contest.getProblem(run.getProblemId()));
                        printWriter.println();
                        printWriter.println();
                    }
                    solvedRun = run.isSolved() ? run : null;
                    lastProblemId = run.getProblemId();
                    lastClientId = run.getSubmitter();
                }
            }
            ++n11;
        }
        if (numYesAfterYes > 0) {
            printWriter.println("Total Yes judgements after earlier Yes judgement: " + numYesAfterYes);
        } else {
            printWriter.println("There are NO 'Yes' judgements after earlier Yes judgements");
        }
        if (numNoAfterYes > 0) {
            printWriter.println("Total No judgements after earlier Yes judgement: " + numNoAfterYes);
        } else {
            printWriter.println("There are NO 'No' judgements after earlier Yes judgements");
        }
        printWriter.println();
        this.printRunsFromDisabledTeams(printWriter);
        printWriter.println();
    }

    private String getJudgementName(Run run) {
        if (run.isJudged()) {
            JudgementRecord judgementRecord = run.getJudgementRecord();
            if (judgementRecord != null) {
                ElementId judgementId = judgementRecord.getJudgementId();
                Judgement judgement = this.contest.getJudgement(judgementId);
                return judgement.toString();
            }
            if (run.isSolved()) {
                return "yes";
            }
            return "no";
        }
        return run.getStatus().toString();
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Contest Analysis";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Contest Analysis Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

