/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class BalloonDeliveryReport
implements IReport {
    private static final long serialVersionUID = -5374491950286834509L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        if (this.filter.isFilterOn()) {
            printWriter.println(this.filter.toString());
        }
        ClientSettings[] clientSettingsList = this.contest.getClientSettingsList();
        Arrays.sort(clientSettingsList, new ClientSettingsComparator());
        int balloonDeliveries = 0;
        int foundMatching = 0;
        ClientId lastClientId = null;
        ClientSettings[] clientSettingsArray = clientSettingsList;
        int n = clientSettingsList.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray[n2];
            Hashtable<String, BalloonDeliveryInfo> hashtable = clientSettings.getBalloonList();
            Object[] keyList = hashtable.keySet().toArray(new String[hashtable.keySet().size()]);
            Arrays.sort(keyList);
            Object[] objectArray = keyList;
            int n3 = keyList.length;
            int n4 = 0;
            while (n4 < n3) {
                Object key = objectArray[n4];
                BalloonDeliveryInfo balloonDeliveryInfo = hashtable.get(key);
                ++balloonDeliveries;
                boolean matchesFilter = true;
                if (this.filter.isFilterOn()) {
                    boolean bl = matchesFilter = this.filter.matches(balloonDeliveryInfo.getClientId()) && this.filter.matchesProblem(balloonDeliveryInfo.getProblemId());
                }
                if (matchesFilter) {
                    ++foundMatching;
                    if (lastClientId == null || lastClientId.equals(balloonDeliveryInfo.getClientId())) {
                        printWriter.println();
                        lastClientId = balloonDeliveryInfo.getClientId();
                        printWriter.println("     Client " + lastClientId.toString());
                    }
                    try {
                        this.printBalloonDeliveryInfo(printWriter, balloonDeliveryInfo);
                    }
                    catch (Exception e) {
                        printWriter.println("For " + (String)key + " exception " + e.getMessage());
                        this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        printWriter.println();
        printWriter.println("There were " + balloonDeliveries + " delivered");
        if (balloonDeliveries > 0) {
            if (foundMatching > 0) {
                printWriter.println("There were only " + foundMatching + " deliveries that matched the filter.");
            } else {
                printWriter.println("There were no matching balloons for this report");
            }
        }
    }

    private void printBalloonDeliveryInfo(PrintWriter printWriter, BalloonDeliveryInfo balloonDeliveryInfo) {
        Problem problem = this.contest.getProblem(balloonDeliveryInfo.getProblemId());
        printWriter.println("            " + problem + " at " + balloonDeliveryInfo.getTimeSent());
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Balloons Delivery";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Balloon Delivery Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

