/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.JudgementReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class AllReports
implements IReport {
    private static final long serialVersionUID = 7194244117875846407L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    public void writeReport(PrintWriter printWriter) {
        IReport[] listOfReports = new IReport[13];
        int repNo = 0;
        listOfReports[repNo++] = new ContestAnalysisReport();
        listOfReports[repNo++] = new SolutionsByProblemReport();
        listOfReports[repNo++] = new ListRunLanguages();
        listOfReports[repNo++] = new FastestSolvedReport();
        listOfReports[repNo++] = new RunsByTeamReport();
        listOfReports[repNo++] = new RunsReport();
        listOfReports[repNo++] = new ProblemsReport();
        listOfReports[repNo++] = new LanguagesReport();
        listOfReports[repNo++] = new AccountsReport();
        listOfReports[repNo++] = new ClarificationsReport();
        listOfReports[repNo++] = new OldRunsReport();
        listOfReports[repNo++] = new BalloonSummaryReport();
        listOfReports[repNo++] = new JudgementReport();
        IReport[] iReportArray = listOfReports;
        int n = listOfReports.length;
        int n2 = 0;
        while (n2 < n) {
            IReport report = iReportArray[n2];
            try {
                if (report != null) {
                    report.setContestAndController(this.contest, this.controller);
                    printWriter.println("**** " + report.getReportTitle() + " Report");
                    report.writeReport(printWriter);
                    printWriter.println();
                }
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            ++n2;
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println("On: " + Utilities.getL10nDateTime());
        printWriter.println();
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end " + this.getReportTitle() + " report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "All Reports";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "All Reports Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

