/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class AccountsReport
implements IReport {
    private static final long serialVersionUID = -8628612595677727400L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter accountFilter = new Filter();
    private Filter filter;

    private void writeSummaryRow(PrintWriter printWriter, int site) {
        ClientType.Type[] types;
        int total = 0;
        ClientType.Type[] typeArray = types = ClientType.Type.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            Vector<Account> vector = this.contest.getAccounts(type, site);
            total += vector.size();
            String countString = String.valueOf(vector.size());
            if (vector.size() == 0) {
                countString = "-";
            }
            printWriter.format("%7s", countString);
            ++n2;
        }
        printWriter.format("%7s", total);
        printWriter.println();
    }

    private void printAccountSummaryBySite(PrintWriter printWriter) {
        Site[] sites = this.contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        printWriter.println();
        ClientType.Type[] types = ClientType.Type.values();
        printWriter.print("Site # ");
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = objectArray[n2];
            int truncIndex = Math.min(type.toString().length(), 5);
            printWriter.format("%7s", type.toString().substring(0, truncIndex).toLowerCase());
            ++n2;
        }
        printWriter.format("%7s", "total");
        printWriter.println();
        objectArray = sites;
        n = sites.length;
        n2 = 0;
        while (n2 < n) {
            ClientType.Type site = objectArray[n2];
            printWriter.print("Site " + ((Site)((Object)site)).getSiteNumber());
            this.writeSummaryRow(printWriter, ((Site)((Object)site)).getSiteNumber());
            ++n2;
        }
    }

    public void writeReport(PrintWriter printWriter) {
        this.printAccountSummaryBySite(printWriter);
        this.printAccountsByGroup(printWriter);
    }

    private void printAccountsByGroup(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Accounts --");
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            Vector<Account> accounts = this.accountFilter.isThisSiteOnly() ? this.contest.getAccounts(ctype, this.accountFilter.getSiteNumber()) : this.contest.getAccounts(ctype);
            if (accounts.size() > 0) {
                printWriter.println();
                printWriter.print("Accounts " + ctype.toString() + " there are " + accounts.size());
                if (this.accountFilter.isThisSiteOnly()) {
                    printWriter.print(" for site " + this.accountFilter.getSiteNumber());
                }
                printWriter.println();
                Account[] sortedAccounts = accounts.toArray(new Account[accounts.size()]);
                Arrays.sort(sortedAccounts, new AccountComparator());
                Account[] accountArray = sortedAccounts;
                int n3 = sortedAccounts.length;
                int n4 = 0;
                while (n4 < n3) {
                    Permission.Type type;
                    Account account = accountArray[n4];
                    printWriter.print("   Site " + account.getSiteNumber());
                    printWriter.format(" %-15s", account.getClientId().getName());
                    printWriter.println(" id=" + account.getElementId());
                    printWriter.format("%22s", " ");
                    printWriter.print("'" + account.getDisplayName() + "' ");
                    ClientId clientId = this.contest.getClientId();
                    if (clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR) || clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                        printWriter.print("password '" + account.getPassword() + "' ");
                    }
                    if (account.isAllowed(type = Permission.Type.LOGIN)) {
                        printWriter.print((Object)((Object)type) + " ");
                    }
                    if (account.isAllowed(type = Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                        printWriter.print((Object)((Object)type) + " ");
                    }
                    printWriter.println();
                    printWriter.format("%22s", " ");
                    printWriter.print("alias '" + account.getAliasName() + "' ");
                    ElementId groupId = account.getGroupId();
                    if (groupId != null) {
                        Group group = this.contest.getGroup(groupId);
                        if (group != null) {
                            printWriter.print("group '" + group + "' (" + groupId + ")");
                        } else {
                            printWriter.print("group invalid (" + groupId + ")");
                        }
                    } else {
                        printWriter.print("group ''");
                    }
                    printWriter.println();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Accounts";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Accounts Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

