/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class AccountPermissionReport
implements IReport {
    private static final long serialVersionUID = 240824146830266565L;
    private IInternalContest contest;
    private IInternalController controller;
    private Filter filter = new Filter();

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        this.printHeader(printWriter);
        this.writeReport(printWriter);
        this.printFooter(printWriter);
        printWriter.close();
        printWriter = null;
    }

    public void writeReport(PrintWriter printWriter) {
        Account[] accounts = this.getAllAccounts();
        Arrays.sort(accounts, new AccountComparator());
        ClientType.Type previousClientType = ClientType.Type.UNKNOWN;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (this.filter.matchesAccount(account)) {
                ClientType.Type clientType = account.getClientId().getClientType();
                if (!previousClientType.equals((Object)clientType)) {
                    printWriter.println();
                    printWriter.println("Type: " + clientType.toString());
                }
                AccountPermissionReport.printPermissions(printWriter, account);
            }
            ++n2;
        }
    }

    public static final void printPermissions(PrintWriter printWriter, Account account) {
        Permission.Type[] types = Permission.Type.values();
        Permission permission = new Permission();
        printWriter.println("  " + account.getClientId().getName() + " (site " + account.getSiteNumber() + ") ");
        int count = 1;
        Permission.Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            if (account.isAllowed(type)) {
                printWriter.println("    " + count + " " + (Object)((Object)type) + " " + permission.getDescription(type));
                ++count;
            }
            ++n2;
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Account Permissions Report";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    public String getPluginTitle() {
        return "Permissions Report";
    }

    private Account[] getAllAccounts() {
        Vector<Account> allAccounts = new Vector<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            if (!ClientType.Type.ALL.equals((Object)ctype) && this.contest.getAccounts(ctype).size() > 0) {
                Vector<Account> accounts = this.contest.getAccounts(ctype);
                allAccounts.addAll(accounts);
            }
            ++n2;
        }
        Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
        return accountList;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

