/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.packet;

import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.list.ClarificationList;
import edu.csus.ecs.pc2.core.list.LanguageDisplayList;
import edu.csus.ecs.pc2.core.list.ProblemDisplayList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestLoginSuccessData;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketType;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

public final class PacketFactory {
    public static final String LOGIN = "LOGIN";
    public static final String RUN = "RUN";
    public static final String PASSWORD = "PASSWORD";
    public static final String JUDGEMENT_RECORD = "JUDGEMENT_RECORD";
    public static final String RUN_LIST = "RUN_LIST";
    public static final String RUN_FILES = "RUN_FILES";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String PROBLEM = "PROBLEM";
    public static final String GENERAL_PROBLEM = "GENERAL_PROBLEM";
    public static final String GROUP = "GROUP";
    public static final String CLARIFICATION_ANSWER = "CLARIFICATION_ANSWER";
    public static final String REQUESTED_RUN_ELEMENT_ID = "REQUESTED_RUN_ELEMENT_ID";
    public static final String CLIENT_ID = "CLIENT_ID";
    public static final String CONTEST_PASSWORD = "CONTEST_PASSWORD";
    public static final String LOGGED_IN_USERS = "LOGGED_IN_USERS";
    public static final String SITE_NUMBER = "SITE_NUMBER";
    public static final String JUDGEMENT = "JUDGEMENT";
    public static final String SITE = "SITE";
    public static final String CONTEST_TIME = "CONTEST_TIME";
    public static final String CLARIFICATION = "CLARIFICATION";
    public static final String REQUESTED_CLARIFICATION_ELEMENT_ID = "REQUESTED_CLARIFICATION_ELEMENT_ID";
    public static final String ACCOUNT = "ACCOUNT";
    public static final String ACCOUNT_ARRAY = "ACCOUNT_ARRAY";
    public static final String CLIENT_TYPE = "CLIENT_TYPE";
    public static final String COUNT = "COUNT";
    public static final String START_COUNT = "START_COUNT";
    public static final String CREATE_ACCOUNT_ACTIVE = "CREATE_ACCOUNT_ACTIVE";
    public static final String ELAPSED_TIME = "ELAPSED_TIME";
    public static final String CONTEST_LENGTH_TIME = "CONTEST_LENGTH_TIME";
    public static final String REMAINING_TIME = "REMAINING_TIME";
    public static final String CONNECTION_HANDLE_ID = "CONNECTION_HANDLE_ID";
    public static final String PROBLEM_DATA_FILES = "PROBLEM_DATA_FILES";
    public static final String LANGUAGE_DISPLAY_LIST = "LANGUAGE_DISPLAY_LIST";
    public static final String PROBLEM_DISPLAY_LIST = "PROBLEM_DISPLAY_LIST";
    public static final String DEFAULT_CLARIFICATION_ANSWER = "DEFAULT_CLARIFICATION_ANSWER";
    public static final String CONTEST_SETTINGS = "CONTEST_SETTINGS";
    public static final String SITE_LIST = "SITE_LIST";
    public static final String MESSAGE_STRING = "MESSAGE_STRING";
    public static final String CONTEST_INFORMATION = "CONTEST_INFORMATION";
    public static final String CLIENT_SETTINGS_LIST = "CLIENT_SETTINGS_LIST";
    public static final String CLIENT_SETTINGS = "CLIENT_SETTINGS";
    public static final String BALLOON_SETTINGS_LIST = "BALLOON_SETTINGS_LIST";
    public static final String PACKET = "PACKET";
    public static final String NEW_PASSWORD = "NEW_PASSWORD";
    public static final String PASSWORD_CHANGED = "PASSWORD_CHANGED";
    public static final String SEND_SETTINGS = "SEND_SETTINGS";
    public static final String RUN_RESULTS_FILE = "RUN_RESULTS_FILE";
    public static final String GROUP_LIST = "GROUP_LIST";
    public static final String PROBLEM_LIST = "PROBLEM_LIST";
    public static final String LANGUAGE_LIST = "LANGUAGE_LIST";
    public static final String JUDGEMENT_LIST = "JUDGEMENT_LIST";
    public static final String CONTEST_TIME_LIST = "CONTEST_TIME_LIST";
    public static final String CLARIFICATION_LIST = "CLARIFICATION_LIST";
    public static final String CONNECTION_HANDLE_ID_LIST = "CONNECTION_HANDLE_ID_LIST";
    public static final ClientId ALL_SERVERS = new ClientId(0, ClientType.Type.SERVER, 0);
    public static final String READ_ONLY = "READ_ONLY";
    public static final String BALLOON_SETTINGS = "BALLOON_SETTINGS";
    public static final String EVENT_NAME = "EVENT_NAME";
    public static final String MESSAGE = "MESSAGE";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String COMPUTER_JUDGE = "COMPUTER_JUDGE";
    public static final String FROM_HUMAN = "FROM_HUMAN";
    public static final String RUN_STATUS = "RUN_STATUS";
    public static final String SERVER_CLOCK_OFFSET = "SERVER_CLOCK_OFFSET";

    private PacketFactory() {
    }

    public static Packet createLoginRequest(ClientId source, String loginName, String password, ClientId destination) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(LOGIN, loginName);
        prop.put(PASSWORD, password);
        return PacketFactory.createPacket(PacketType.Type.LOGIN_REQUEST, source, destination, prop);
    }

    public static Packet createPasswordChangeRequest(ClientId source, ClientId destination, String password, String newPassword) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(PASSWORD, password);
        prop.put(NEW_PASSWORD, newPassword);
        return PacketFactory.createPacket(PacketType.Type.PASSWORD_CHANGE_REQUEST, source, destination, prop);
    }

    public static Packet createPasswordChangeResult(ClientId source, ClientId destination, boolean passwordChanged, String message) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(PASSWORD_CHANGED, new Boolean(passwordChanged));
        prop.put(MESSAGE_STRING, message);
        return PacketFactory.createPacket(PacketType.Type.PASSWORD_CHANGE_RESULTS, source, destination, prop);
    }

    protected static Packet createPacket(PacketType.Type type, ClientId source, ClientId destination, Serializable serializable) {
        Packet packet = new Packet(type, source, destination, serializable);
        return packet;
    }

    public static Packet createMessage(ClientId source, ClientId destination, String message) {
        Packet packet = new Packet(PacketType.Type.MESSAGE, source, destination, (Serializable)((Object)message));
        return packet;
    }

    public static Packet createSubmittedRun(ClientId source, ClientId destination, Run run, RunFiles runFiles) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        prop.put(RUN_FILES, runFiles);
        Packet packet = new Packet(PacketType.Type.RUN_SUBMISSION, source, destination, prop);
        return packet;
    }

    public static void dumpPacket(PrintWriter pw, Packet packet) {
        PacketFactory.dumpPacket(pw, packet);
        pw.println("Packet " + (Object)((Object)packet.getType()));
        pw.println("  From: " + packet.getSourceId());
        pw.println("    To: " + packet.getDestinationId());
        Object obj = packet.getContent();
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            Enumeration<Object> enumeration = prop.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                pw.println("   key: " + element + " is: " + prop.get(element).getClass().getName() + " " + prop.get(element));
            }
        } else {
            pw.println("  Contains: " + obj.toString() + " " + obj);
        }
        pw.println();
    }

    public static void dumpPacket(Log log, Packet packet, String message) {
        log.info("Packet " + (Object)((Object)packet.getType()) + " (Seq #" + packet.getPacketNumber() + " ) " + message);
        log.info("  From: " + packet.getSourceId());
        log.info("    To: " + packet.getDestinationId());
        Object obj = packet.getContent();
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            Enumeration<Object> enumeration = prop.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                log.info("   key: " + element + " is: " + prop.get(element).getClass().getName() + " " + prop.get(element));
            }
        } else {
            log.info("  Contains: " + obj.toString() + " " + obj);
        }
    }

    public static void dumpPacket(PrintStream pw, Packet packet, String message) {
        pw.println("Packet " + (Object)((Object)packet.getType()) + " (Seq #" + packet.getPacketNumber() + " ) " + message);
        pw.println("  From: " + packet.getSourceId());
        pw.println("    To: " + packet.getDestinationId());
        Object obj = packet.getContent();
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            Enumeration<Object> enumeration = prop.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                pw.println("   key: " + element + " is: " + prop.get(element).getClass().getName() + " " + prop.get(element));
            }
        } else {
            pw.println("  Contains: " + obj.toString() + " " + obj);
        }
        pw.println();
    }

    public static Packet createRunAvailable(ClientId source, ClientId destination, Run run) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        Packet packet = new Packet(PacketType.Type.RUN_AVAILABLE, source, destination, prop);
        return packet;
    }

    public static Packet createRunUpdated(ClientId source, ClientId destination, Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoModifiedRun) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, whoModifiedRun);
        prop.put(RUN, run);
        if (judgementRecord != null) {
            prop.put(JUDGEMENT_RECORD, judgementRecord);
        }
        if (runResultFiles != null) {
            prop.put(RUN_RESULTS_FILE, runResultFiles);
        }
        Packet packet = new Packet(PacketType.Type.RUN_UPDATE, source, destination, prop);
        return packet;
    }

    public static Packet createRunUpdateNotification(ClientId source, ClientId destination, Run run, ClientId whoModifiedRun) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, whoModifiedRun);
        prop.put(RUN, run);
        Packet packet = new Packet(PacketType.Type.RUN_UPDATE_NOTIFICATION, source, destination, prop);
        return packet;
    }

    public static Packet createCheckedOutRun(ClientId source, ClientId destination, Run run, RunFiles runFiles, ClientId id, RunResultFiles[] runResultFiles) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        if (runFiles != null) {
            prop.put(RUN_FILES, runFiles);
        }
        if (runResultFiles != null) {
            prop.put(RUN_RESULTS_FILE, runResultFiles);
        }
        prop.put(CLIENT_ID, id);
        Packet packet = new Packet(PacketType.Type.RUN_CHECKOUT, source, destination, prop);
        return packet;
    }

    public static Packet createCheckedOutRunNotification(ClientId source, ClientId destination, Run run, ClientId id) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        prop.put(CLIENT_ID, id);
        Packet packet = new Packet(PacketType.Type.RUN_CHECKOUT_NOTIFICATION, source, destination, prop);
        return packet;
    }

    public static Packet createRunNotAvailable(ClientId source, ClientId destination, Run run) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        Packet packet = new Packet(PacketType.Type.RUN_NOTAVAILABLE, source, destination, prop);
        return packet;
    }

    public static Packet createRunRevoked(ClientId source, ClientId destination, Run run, ClientId revokedFrom) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        prop.put(CLIENT_ID, revokedFrom);
        Packet packet = new Packet(PacketType.Type.RUN_REVOKED, source, destination, prop);
        return packet;
    }

    public static Packet createRunList(ClientId source, ClientId destination, Run[] runs) {
        Properties prop = new Properties();
        prop.put(RUN_LIST, runs);
        Packet packet = new Packet(PacketType.Type.RUN_LIST, source, destination, prop);
        return packet;
    }

    public static Packet createClarList(ClientId source, ClientId destination, ClarificationList clarList) {
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_LIST, source, destination, clarList);
        return packet;
    }

    public static Packet createUnCheckoutRun(ClientId source, ClientId destination, Run beingJudgingRun, ClientId whoUncheckedOutRun) {
        Properties prop = new Properties();
        prop.put(RUN, beingJudgingRun);
        prop.put(CLIENT_ID, whoUncheckedOutRun);
        Packet packet = new Packet(PacketType.Type.RUN_UNCHECKOUT, source, destination, prop);
        return packet;
    }

    public static Packet createRunJudgement(ClientId source, ClientId destination, Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(RUN, run);
        prop.put(JUDGEMENT_RECORD, judgementRecord);
        if (runResultFiles != null) {
            prop.put(RUN_RESULTS_FILE, runResultFiles);
        }
        Packet packet = new Packet(PacketType.Type.RUN_JUDGEMENT, source, destination, prop);
        return packet;
    }

    public static Object getObjectValue(Packet packet, String key) {
        try {
            Properties props = (Properties)packet.getContent();
            return props.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStringValue(Packet packet, String key) {
        return (String)PacketFactory.getObjectValue(packet, key);
    }

    public static Boolean getBooleanValue(Packet packet, String key) {
        return (Boolean)PacketFactory.getObjectValue(packet, key);
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Language language) {
        Properties prop = new Properties();
        prop.put(LANGUAGE, language);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, BalloonSettings balloonSettings) {
        Properties prop = new Properties();
        prop.put(BALLOON_SETTINGS, balloonSettings);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Problem problem, ProblemDataFiles problemDataFiles) {
        Properties prop = new Properties();
        prop.put(PROBLEM, problem);
        if (problemDataFiles != null) {
            prop.put(PROBLEM_DATA_FILES, problemDataFiles);
        }
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, BalloonSettings balloonSettings) {
        Properties prop = new Properties();
        prop.put(BALLOON_SETTINGS, balloonSettings);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Language language) {
        Properties prop = new Properties();
        prop.put(LANGUAGE, language);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Site site) {
        Properties prop = new Properties();
        prop.put(SITE, site);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Group group) {
        Properties prop = new Properties();
        prop.put(GROUP, group);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Judgement judgement) {
        Properties prop = new Properties();
        prop.put(JUDGEMENT, judgement);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Problem problem, ProblemDataFiles problemDataFiles) {
        Properties prop = new Properties();
        prop.put(PROBLEM, problem);
        if (problemDataFiles != null) {
            prop.put(PROBLEM_DATA_FILES, problemDataFiles);
        }
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createStartContestClock(ClientId source, ClientId destination, int siteNumber, ClientId who) {
        Properties prop = new Properties();
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        prop.put(CLIENT_ID, who);
        Packet packet = new Packet(PacketType.Type.START_CONTEST_CLOCK, source, destination, prop);
        return packet;
    }

    public static Packet createStopContestClock(ClientId source, ClientId destination, int siteNumber, ClientId who) {
        Properties prop = new Properties();
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        prop.put(CLIENT_ID, who);
        Packet packet = new Packet(PacketType.Type.STOP_CONTEST_CLOCK, source, destination, prop);
        return packet;
    }

    public static Packet createContestStopped(ClientId source, ClientId destination, int inSiteNumber, ClientId who) {
        Properties prop = new Properties();
        prop.put(SITE_NUMBER, new Integer(inSiteNumber));
        prop.put(CLIENT_ID, who);
        Packet packet = new Packet(PacketType.Type.CLOCK_STOPPED, source, destination, prop);
        return packet;
    }

    public static Packet createContestStarted(ClientId source, ClientId destination, int inSiteNumber, ClientId who) {
        Properties prop = new Properties();
        prop.put(SITE_NUMBER, new Integer(inSiteNumber));
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        prop.put(SERVER_CLOCK_OFFSET, gregorianCalendar);
        prop.put(CLIENT_ID, who);
        Packet packet = new Packet(PacketType.Type.CLOCK_STARTED, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateContestTime(ClientId source, ClientId destination, ContestTime contestTime, int siteNumber, ClientId whoModifiedIt) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, whoModifiedIt);
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        prop.put(CONTEST_TIME, contestTime);
        Packet packet = new Packet(PacketType.Type.UPDATE_CONTEST_CLOCK, source, destination, prop);
        return packet;
    }

    public static Packet createAccountLogin(ClientId source, ClientId destination, ConnectionHandlerID connectionHandlerID) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, destination);
        prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        Packet packet = new Packet(PacketType.Type.ACCOUNT_LOGIN, source, destination, prop);
        return packet;
    }

    public static Packet createLogoff(ClientId source, ClientId destination, ClientId userId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userId);
        Packet packet = new Packet(PacketType.Type.LOGOUT, source, destination, prop);
        return packet;
    }

    public static Packet createClarSubmissionConfirm(ClientId source, ClientId destination, Clarification newClarification) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, newClarification);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_SUBMISSION_CONFIRM, source, destination, prop);
        return packet;
    }

    public static Packet createClarificationSubmission(ClientId source, ClientId destination, Clarification clarification2) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(CLARIFICATION, clarification2);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_SUBMISSION, source, destination, prop);
        return packet;
    }

    public static Packet createRunSubmissionConfirm(ClientId source, ClientId destination, Run run) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        Packet packet = new Packet(PacketType.Type.RUN_SUBMISSION_CONFIRM, source, destination, prop);
        return packet;
    }

    public static Packet createLogin(ClientId source, ClientId destination, ConnectionHandlerID connectionHandlerID, ClientId loggedInClientId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, loggedInClientId);
        prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        Packet packet = new Packet(PacketType.Type.LOGIN, source, destination, prop);
        return packet;
    }

    public static Packet createLoginSuccess(ClientId source, ClientId destination, ContestTime contestTime, int siteNumber, ContestInformation information, ContestLoginSuccessData data) {
        try {
            Properties prop = new Properties();
            prop.put(SITE_NUMBER, new Integer(siteNumber));
            prop.put(CONTEST_TIME, contestTime);
            prop.put(CONTEST_TIME_LIST, data.getContestTimes());
            prop.put(CLIENT_ID, destination);
            prop.put(PROBLEM_LIST, data.getProblems());
            prop.put(LANGUAGE_LIST, data.getLanguages());
            prop.put(JUDGEMENT_LIST, data.getJudgements());
            prop.put(SITE_LIST, data.getSites());
            prop.put(RUN_LIST, data.getRuns());
            prop.put(CLARIFICATION_LIST, data.getClarifications());
            prop.put(LOGGED_IN_USERS, data.getLoggedInUsers());
            prop.put(CONNECTION_HANDLE_ID_LIST, data.getConnectionHandlerIDs());
            prop.put(ACCOUNT_ARRAY, data.getAccounts());
            prop.put(PROBLEM_DATA_FILES, data.getProblemDataFiles());
            prop.put(CONTEST_INFORMATION, information);
            prop.put(CLIENT_SETTINGS_LIST, data.getClientSettings());
            prop.put(BALLOON_SETTINGS_LIST, data.getBalloonSettingsArray());
            prop.put(GROUP_LIST, data.getGroups());
            prop.put(GENERAL_PROBLEM, data.getGeneralProblem());
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            prop.put(SERVER_CLOCK_OFFSET, gregorianCalendar);
            if (data.getContestSecurityPassword() != null) {
                prop.put(CONTEST_PASSWORD, data.getContestSecurityPassword());
            }
            Packet packet = new Packet(PacketType.Type.LOGIN_SUCCESS, source, destination, prop);
            return packet;
        }
        catch (Exception e) {
            System.err.println("Exception creating LOGIN_SUCCESS ");
            e.printStackTrace(System.err);
            StaticLog.log("Exception in createLoginSuccess ", e);
            throw new SecurityException(e.getMessage());
        }
    }

    public static Packet createContestSettingsPacket(ClientId source, ClientId destination, Packet loginSuccessPacket) {
        try {
            if (loginSuccessPacket.getType().equals((Object)PacketType.Type.LOGIN_SUCCESS)) {
                Properties properties = (Properties)loginSuccessPacket.getContent();
                Packet contestSettingsPacket = new Packet(PacketType.Type.SERVER_SETTINGS, source, destination, properties);
                return contestSettingsPacket;
            }
            throw new IllegalArgumentException("Packet loginSuccessPacket is not LOGIN_SUCCESS " + loginSuccessPacket);
        }
        catch (Exception e) {
            System.err.println("Exception creating SERVER_SETTINGS ");
            e.printStackTrace(System.err);
            StaticLog.log("Exception in createContestUpdate ", e);
            throw new SecurityException(e.getMessage());
        }
    }

    public static Packet createSettings(ClientId source, ClientId destination, Properties props) {
        Packet packet = new Packet(PacketType.Type.SETTINGS, source, destination, props);
        return packet;
    }

    public static Packet createLoginDenied(ClientId source, ClientId destination, String string) {
        Properties props = new Properties();
        props.put(MESSAGE_STRING, string);
        Packet packet = new Packet(PacketType.Type.LOGIN_FAILED, source, destination, props);
        return packet;
    }

    public static Packet createRunRequest(ClientId source, ClientId destination, Run run, ClientId requesingId, boolean readOnly, boolean computerJudge) {
        Properties props = new Properties();
        props.put(RUN, run);
        props.put(CLIENT_ID, requesingId);
        props.put(READ_ONLY, new Boolean(readOnly));
        props.put(COMPUTER_JUDGE, new Boolean(computerJudge));
        Packet packet = new Packet(PacketType.Type.RUN_REQUEST, source, destination, props);
        return packet;
    }

    public static Packet createFetchRun(ClientId source, ClientId destination, Run run, ClientId requesingId) {
        Properties props = new Properties();
        props.put(RUN, run);
        props.put(CLIENT_ID, requesingId);
        Packet packet = new Packet(PacketType.Type.FETCH_RUN, source, destination, props);
        return packet;
    }

    public static Packet createFetchedRun(ClientId source, ClientId destination, Run run, RunFiles runFiles, ClientId requesingId, RunResultFiles[] runResultFiles) {
        Properties props = new Properties();
        props.put(RUN, run);
        props.put(CLIENT_ID, requesingId);
        props.put(RUN_FILES, runFiles);
        if (runResultFiles != null) {
            props.put(RUN_RESULTS_FILE, runResultFiles);
        }
        Packet packet = new Packet(PacketType.Type.FETCHED_REQUESTED_RUN, source, destination, props);
        return packet;
    }

    public static Packet createClarificationRequest(ClientId source, ClientId destination, ElementId elementId, ClientId userId) {
        Properties props = new Properties();
        props.put(REQUESTED_CLARIFICATION_ELEMENT_ID, elementId);
        props.put(CLIENT_ID, userId);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_REQUEST, source, destination, props);
        return packet;
    }

    public static Packet createCheckedOutClarification(ClientId source, ClientId destination, Clarification clarification, ClientId whoCheckedOut) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        prop.put(CLIENT_ID, whoCheckedOut);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_CHECKOUT, source, destination, prop);
        return packet;
    }

    public static Packet createUnCheckoutClarification(ClientId source, ClientId destination, Clarification clarification) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        prop.put(CLIENT_ID, source);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_UNCHECKOUT, source, destination, prop);
        return packet;
    }

    public static Packet createClarificationAvailable(ClientId source, ClientId destination, Clarification clarification) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_AVAILABLE, source, destination, prop);
        return packet;
    }

    public static Packet createClarificationRevoked(ClientId source, ClientId destination, Clarification clarification, ClientId revokedFrom) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        prop.put(CLIENT_ID, revokedFrom);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_REVOKED, source, destination, prop);
        return packet;
    }

    public static Packet createClarificationUpdate(ClientId source, ClientId destination, Clarification clarification) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_UPDATE, source, destination, prop);
        return packet;
    }

    public static Packet createAnsweredClarification(ClientId source, ClientId destination, Clarification clarification, String answer) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        prop.put(CLARIFICATION_ANSWER, answer);
        prop.put(CLIENT_ID, source);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_ANSWER, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Site site) {
        Properties prop = new Properties();
        prop.put(SITE, site);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Account account) {
        Properties prop = new Properties();
        prop.put(ACCOUNT, account);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Account[] accounts) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(SITE_NUMBER, (Object)source.getSiteNumber());
        prop.put(ACCOUNT_ARRAY, accounts);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createGenerateAccounts(ClientId source, ClientId destination, int siteNumber, ClientType.Type type, int count, int startNumber, boolean isActive) {
        Properties prop = new Properties();
        prop.put(CLIENT_TYPE, (Object)type);
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        prop.put(COUNT, new Integer(count));
        prop.put(START_COUNT, new Integer(startNumber));
        prop.put(CREATE_ACCOUNT_ACTIVE, new Boolean(isActive));
        Packet packet = new Packet(PacketType.Type.GENERATE_ACCOUNTS, source, destination, prop);
        return packet;
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, ClientType.Type type, int count) {
        Properties prop = new Properties();
        prop.put(CLIENT_TYPE, (Object)type);
        prop.put(COUNT, new Integer(count));
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Account account) {
        Properties prop = new Properties();
        prop.put(ACCOUNT, account);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Group group) {
        Properties prop = new Properties();
        prop.put(GROUP, group);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createRunRejudgeRequest(ClientId source, ClientId destination, Run run, ClientId requesterId) {
        Properties props = new Properties();
        props.put(RUN, run);
        props.put(CLIENT_ID, requesterId);
        Packet packet = new Packet(PacketType.Type.RUN_REJUDGE_REQUEST, source, destination, props);
        return packet;
    }

    public static Packet createRejudgeCheckedOut(ClientId source, ClientId destination, Run run, RunFiles runFiles, ClientId id) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        if (runFiles != null) {
            prop.put(RUN_FILES, runFiles);
        }
        prop.put(CLIENT_ID, id);
        Packet packet = new Packet(PacketType.Type.RUN_REJUDGE_CHECKOUT, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateContestLengthTime(ClientId source, ClientId destination, long timeValue, int siteNumber) {
        Properties prop = new Properties();
        prop.put(CONTEST_LENGTH_TIME, new Long(timeValue));
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateContestRemainingTime(ClientId source, ClientId destination, long timeValue, int siteNumber) {
        Properties prop = new Properties();
        prop.put(REMAINING_TIME, new Long(timeValue));
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateContestElapsedTime(ClientId source, ClientId destination, long timeValue, int siteNumber) {
        Properties prop = new Properties();
        prop.put(ELAPSED_TIME, new Long(timeValue));
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createDroppedConnection(ClientId source, ClientId destination, ConnectionHandlerID connectionHandlerID) {
        Properties prop = new Properties();
        prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        Packet packet = new Packet(PacketType.Type.DROPPED_CONNECTION, source, destination, prop);
        return packet;
    }

    public static Packet createEstablishedConnection(ClientId source, ClientId destination, ConnectionHandlerID connectionHandlerID) {
        Properties prop = new Properties();
        prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        Packet packet = new Packet(PacketType.Type.ESTABLISHED_CONNECTION, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Run run, ClientId id) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        prop.put(CLIENT_ID, id);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Run run, JudgementRecord judgementRecord, ClientId id) {
        Properties prop = new Properties();
        prop.put(RUN, run);
        if (judgementRecord != null) {
            prop.put(JUDGEMENT_RECORD, judgementRecord);
        }
        prop.put(CLIENT_ID, id);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createForceLogoff(ClientId source, ClientId destination, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        Packet packet = new Packet(PacketType.Type.FORCE_DISCONNECTION, source, destination, prop);
        return packet;
    }

    public static Packet createForceLogoff(ClientId source, ClientId destination, ConnectionHandlerID connectionHandlerID) {
        Properties prop = new Properties();
        prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        Packet packet = new Packet(PacketType.Type.FORCE_DISCONNECTION, source, destination, prop);
        return packet;
    }

    public static Packet createStartAllClocks(ClientId source, ClientId destination, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        Packet packet = new Packet(PacketType.Type.START_ALL_CLOCKS, source, destination, prop);
        return packet;
    }

    public static Packet createResetContest(ClientId source, ClientId destination, int siteNumber, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        prop.put(SITE_NUMBER, new Integer(siteNumber));
        Packet packet = new Packet(PacketType.Type.RESET_CONTEST, source, destination, prop);
        return packet;
    }

    public static Packet createResetAllSites(ClientId source, ClientId destination, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        Packet packet = new Packet(PacketType.Type.RESET_ALL_CONTESTS, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, LanguageDisplayList languageDisplayList, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        prop.put(LANGUAGE_DISPLAY_LIST, languageDisplayList);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, ProblemDisplayList problemDisplayList, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        prop.put(PROBLEM_DISPLAY_LIST, problemDisplayList);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSettingDefaultClarificationAnswer(ClientId source, ClientId destination, String answer, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        prop.put(DEFAULT_CLARIFICATION_ANSWER, answer);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createStopAllClocks(ClientId source, ClientId destination, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        Packet packet = new Packet(PacketType.Type.STOP_ALL_CLOCKS, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Clarification clarification, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, userLoginId);
        prop.put(CLARIFICATION, clarification);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Clarification clarification, String answer, ClientId userLoginId) {
        Properties prop = new Properties();
        prop.put(CLARIFICATION, clarification);
        prop.put(CLIENT_ID, userLoginId);
        if (answer != null) {
            prop.put(CLARIFICATION_ANSWER, answer);
        }
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, ContestTime inContestTime) {
        Properties prop = new Properties();
        prop.put(CONTEST_TIME, inContestTime);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createLogin(ClientId source, String password, ClientId destination, boolean sendSettings) {
        Properties prop = new Properties();
        prop.put(LOGIN, "" + (Object)((Object)source.getClientType()) + source.getClientNumber());
        prop.put(PASSWORD, password);
        prop.put(SEND_SETTINGS, new Boolean(sendSettings));
        return PacketFactory.createPacket(PacketType.Type.LOGIN_REQUEST, source, destination, prop);
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, Account[] accounts) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, source);
        prop.put(SITE_NUMBER, (Object)source.getSiteNumber());
        prop.put(ACCOUNT_ARRAY, accounts);
        return PacketFactory.createPacket(PacketType.Type.ADD_SETTING, source, destination, prop);
    }

    public static Packet createAddSetting(ClientId source, ClientId destination, ClientSettings clientSettings) {
        Properties prop = new Properties();
        prop.put(CLIENT_SETTINGS, clientSettings);
        Packet packet = new Packet(PacketType.Type.ADD_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createRunJudgmentUpdate(ClientId source, ClientId destination, Run run, ClientId whoJudgedId) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, whoJudgedId);
        prop.put(RUN, run);
        return PacketFactory.createPacket(PacketType.Type.RUN_JUDGEMENT_UPDATE, source, destination, prop);
    }

    public static Packet clonePacket(ClientId source, ClientId destination, Packet packet) {
        return PacketFactory.createPacket(packet.getType(), source, destination, (Properties)packet.getContent());
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Judgement judgement) {
        Properties prop = new Properties();
        prop.put(JUDGEMENT, judgement);
        return PacketFactory.createPacket(PacketType.Type.RUN_JUDGEMENT_UPDATE, source, destination, prop);
    }

    public static Packet createAnsweredClarificationUpdate(ClientId source, ClientId destination, Clarification clarification, String answer, ClientId whoAnsweredIt) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, whoAnsweredIt);
        prop.put(CLARIFICATION, clarification);
        prop.put(CLARIFICATION_ANSWER, answer);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_ANSWER_UPDATE, source, destination, prop);
        return packet;
    }

    public static Packet createClarificationNotAvailable(ClientId source, ClientId destination, Clarification clarification, ClientId requestFromId2) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, requestFromId2);
        prop.put(CLARIFICATION, clarification);
        Packet packet = new Packet(PacketType.Type.CLARIFICATION_NOT_AVAILABLE, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, ClientSettings clientSettings) {
        Properties prop = new Properties();
        prop.put(CLIENT_SETTINGS, clientSettings);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, ContestInformation contestInformation) {
        Properties prop = new Properties();
        prop.put(CONTEST_INFORMATION, contestInformation);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createUpdateSetting(ClientId source, ClientId destination, Judgement[] judgements) {
        Properties prop = new Properties();
        prop.put(JUDGEMENT_LIST, judgements);
        Packet packet = new Packet(PacketType.Type.UPDATE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createDeleteSetting(ClientId source, ClientId destination, Judgement judgement) {
        Properties prop = new Properties();
        prop.put(JUDGEMENT, judgement);
        Packet packet = new Packet(PacketType.Type.DELETE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createDeleteSetting(ClientId source, ClientId destination, Problem problem) {
        Properties prop = new Properties();
        prop.put(PROBLEM, problem);
        Packet packet = new Packet(PacketType.Type.DELETE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createDeleteSetting(ClientId source, ClientId destination, Language language) {
        Properties prop = new Properties();
        prop.put(LANGUAGE, language);
        Packet packet = new Packet(PacketType.Type.DELETE_SETTING, source, destination, prop);
        return packet;
    }

    public static Packet createReconnectPacket(ClientId source, ClientId destination, int inSiteNumber) {
        Properties prop = new Properties();
        prop.put(SITE_NUMBER, new Integer(inSiteNumber));
        prop.put(CLIENT_ID, source);
        Packet packet = new Packet(PacketType.Type.RECONNECT_SITE_REQUEST, source, destination, prop);
        return packet;
    }

    public static Packet createSecurityMessagePacket(ClientId source, ClientId destination, String message, ClientId whoCanceledRun, ConnectionHandlerID connectionHandlerID, ContestSecurityException contestSecurityException, Packet inPacket) {
        Properties prop = new Properties();
        if (whoCanceledRun != null) {
            prop.put(CLIENT_ID, whoCanceledRun);
        }
        prop.put(MESSAGE, message);
        if (connectionHandlerID != null) {
            prop.put(CONNECTION_HANDLE_ID, connectionHandlerID);
        }
        if (inPacket != null) {
            prop.put(PACKET, inPacket);
        }
        if (contestSecurityException != null) {
            prop.put(EXCEPTION, contestSecurityException);
        }
        Packet packet = new Packet(PacketType.Type.SECURITY_MESSAGE, source, destination, prop);
        return packet;
    }

    public static Packet createRunStatusPacket(ClientId source, ClientId destination, Run run, ClientId judgeClient, RunExecutionStatus status) {
        Properties prop = new Properties();
        prop.put(CLIENT_ID, judgeClient);
        prop.put(RUN, run);
        prop.put(RUN_STATUS, (Object)status);
        return PacketFactory.createPacket(PacketType.Type.RUN_EXECUTION_STATUS, source, destination, prop);
    }
}

