/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.packet;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.packet.PacketType;
import java.io.Serializable;
import java.util.Date;

public class Packet
implements Serializable {
    private static final long serialVersionUID = 1201529987796311669L;
    private ClientId sourceId = null;
    private ClientId destinationId = null;
    private PacketType.Type type = PacketType.Type.UNKNOWN;
    private Serializable content = null;
    private Date createDate = new Date();
    private static int packetCounter = 0;
    private int packetNumber = 0;

    public Packet(PacketType.Type type, ClientId source, ClientId destination, Serializable content) {
        this.sourceId = source;
        this.destinationId = destination;
        this.content = content;
        this.type = type;
        this.packetNumber = ++packetCounter;
    }

    protected Packet(PacketType.Type type, ClientId source, ClientId destination) {
        this.sourceId = source;
        this.destinationId = destination;
        this.content = null;
        this.type = type;
        this.packetNumber = ++packetCounter;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Serializable content) {
        this.content = content;
    }

    public ClientId getDestinationId() {
        return this.destinationId;
    }

    protected void setDestinationId(ClientId destinationId) {
        this.destinationId = destinationId;
    }

    public ClientId getSourceId() {
        return this.sourceId;
    }

    protected void setSourceId(ClientId sourceId) {
        this.sourceId = sourceId;
    }

    public PacketType.Type getType() {
        return this.type;
    }

    public String toString() {
        return "Packet[" + (Object)((Object)this.type) + "] #" + this.packetNumber + " " + this.sourceId + " -> " + this.destinationId;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public int getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(int packetNumber) {
        this.packetNumber = packetNumber;
    }
}

