/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model.playback;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.EventStatus;
import edu.csus.ecs.pc2.core.model.playback.PlaybackEvent;
import edu.csus.ecs.pc2.core.model.playback.PlaybackParseException;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.Vector;

public class PlaybackManager {
    public static final String ACTION_KEY = "action";
    public static final String ID_KEY = "id";
    public static final String SITE_KEY = "site";
    public static final String PROBLEM_KEY = "problem";
    public static final String LANGUAGE_KEY = "language";
    public static final String MAINFILE_KEY = "mainfile";
    public static final String SUBMIT_CLIENT_KEY = "submitclient";
    public static final String ELAPSED_KEY = "elapsed";
    private static final String DELIMITER = "";
    private int sequenceNumber = 1;

    public PlaybackEvent[] loadPlayback(String filename, IInternalContest contest) throws Exception {
        Vector<PlaybackEvent> events = new Vector<PlaybackEvent>();
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String[] lines = Utilities.loadFile(filename);
        String sourceDirectory = Utilities.dirname(filename);
        int invalidLines = 0;
        int lineNumber = 0;
        Exception savedException = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                ++lineNumber;
                if (s.trim().length() != 0 && !s.trim().startsWith("#")) {
                    PlaybackEvent playbackEvent = this.createPlayBackEvent(lineNumber, contest, s, "[|]", sourceDirectory);
                    if (playbackEvent != null) {
                        events.add(playbackEvent);
                    } else {
                        ++invalidLines;
                        System.out.println("Line " + lineNumber + ": unable to parse line: " + s);
                    }
                }
            }
            catch (Exception e) {
                if (++invalidLines == 1) {
                    savedException = e;
                }
                System.out.println("Line " + lineNumber + " : " + s);
                System.out.println("Line " + lineNumber + " : Exception = " + e.getMessage());
                e.printStackTrace();
            }
            ++n2;
        }
        if (savedException != null) {
            System.out.println("Errors on " + invalidLines + " lines, loading " + filename);
            throw savedException;
        }
        return events.toArray(new PlaybackEvent[events.size()]);
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected PlaybackEvent createPlayBackEvent(int lineNumber, IInternalContest contest, String s, String delimit, String sourceDir) throws PlaybackParseException {
        int number;
        SerializedFile[] files;
        Run run;
        ClientId clientId;
        String elapsedTimeStr;
        String[] fields = s.split(delimit);
        if (fields.length < 3) {
            throw new PlaybackParseException("line must have 3 or more fields");
        }
        PlaybackEvent playbackEvent = null;
        Properties properties = this.mapFieldsNameValuePairs(fields);
        String command = this.getAndCheckValue(properties, ACTION_KEY, "action name/value", lineNumber);
        PlaybackEvent.Action action = PlaybackEvent.Action.UNDEFINED;
        if (command.equalsIgnoreCase(PlaybackEvent.Action.RUN_SUBMIT.toString())) {
            action = PlaybackEvent.Action.RUN_SUBMIT;
            String problemName = this.getAndCheckValue(properties, PROBLEM_KEY, "Problem name", lineNumber);
            String languageName = this.getAndCheckValue(properties, LANGUAGE_KEY, "Language name", lineNumber);
            String mainfileName = this.getAndCheckValue(properties, MAINFILE_KEY, "Main filename", lineNumber);
            String siteId = this.getAndCheckValue(properties, SITE_KEY, "Site number", lineNumber);
            String submitClientName = this.getAndCheckValue(properties, SUBMIT_CLIENT_KEY, "Client id", lineNumber);
            elapsedTimeStr = this.getAndCheckValue(properties, ELAPSED_KEY, "Elapsed time", false, lineNumber);
            Language language = this.findLanguage(contest, languageName);
            Problem problem = this.findProblem(contest, problemName);
            clientId = this.findClient(contest, siteId, submitClientName);
            run = new Run(clientId, language, problem);
            files = new SerializedFile[1];
            try {
                SerializedFile file = new SerializedFile(String.valueOf(sourceDir) + File.separator + mainfileName);
                if (file == null || file.getBuffer() == null) {
                    throw new PlaybackParseException(lineNumber, "Could not read/find " + mainfileName);
                }
                if (file.getBuffer().length == 0) {
                    throw new PlaybackParseException(lineNumber, "No bytes for file " + mainfileName);
                }
                files[0] = file;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PlaybackParseException(e);
            }
            String idStr = this.getAndCheckValue(properties, ID_KEY, "run/clar number", lineNumber);
            number = Integer.parseInt(idStr);
            if (number < 1) {
                throw new PlaybackParseException(lineNumber, "invalid run/clar number: " + idStr);
            }
        } else {
            throw new PlaybackParseException(lineNumber, "Unknown event: " + command);
        }
        run.setElapsedMins(PlaybackManager.getIntegerValue(elapsedTimeStr));
        run.setNumber(number);
        playbackEvent = new PlaybackEvent(action, clientId, run);
        playbackEvent.setClientId(clientId);
        playbackEvent.setFiles(files);
        return playbackEvent;
    }

    private ClientId findClient(IInternalContest contest, String siteId, String loginName) throws PlaybackParseException {
        int siteNumber = PlaybackManager.getIntegerValue(siteId);
        if (loginName.startsWith("team") && loginName.length() > 4) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(4));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("t") && loginName.length() > 1) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(1));
            return new ClientId(siteNumber, ClientType.Type.TEAM, number);
        }
        if (loginName.startsWith("judge") && loginName.length() > 5) {
            int number = PlaybackManager.getIntegerValue(loginName.substring(5));
            return new ClientId(siteNumber, ClientType.Type.JUDGE, number);
        }
        throw new PlaybackParseException("Could not find/match client: " + loginName);
    }

    private Problem findProblem(IInternalContest contest, String problemName) throws PlaybackParseException {
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getDisplayName().trim().equalsIgnoreCase(problemName.trim())) {
                return problem;
            }
            ++n2;
        }
        throw new PlaybackParseException("Could not find/match problem: " + problemName);
    }

    private Language findLanguage(IInternalContest contest, String languageName) throws PlaybackParseException {
        Language[] languageArray = contest.getLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (language.getDisplayName().trim().equalsIgnoreCase(languageName.trim())) {
                return language;
            }
            ++n2;
        }
        throw new PlaybackParseException("Could not find/match language: " + languageName);
    }

    private String getAndCheckValue(Properties properties, String key, String message, int lineNumber) throws PlaybackParseException {
        return this.getAndCheckValue(properties, key, message, true, lineNumber);
    }

    private String getAndCheckValue(Properties properties, String key, String message, boolean requiredOption, int lineNumber) throws PlaybackParseException {
        String value = properties.getProperty(key);
        if (value == null && requiredOption) {
            throw new PlaybackParseException(lineNumber, String.valueOf(message) + " value missing (key = " + key + ")");
        }
        return value;
    }

    private Properties mapFieldsNameValuePairs(String[] fields) throws PlaybackParseException {
        Properties properties = new Properties();
        int fieldNumber = 0;
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            ++fieldNumber;
            if (field.trim().length() != 0) {
                int index = field.indexOf("=");
                if (index == -1) {
                    throw new PlaybackParseException("Missing = in name/value pair, field " + fieldNumber + ": " + field);
                }
                String key = field.substring(0, index).trim().toLowerCase();
                String value = field.substring(index + 1);
                properties.put(key, value);
            }
            ++n2;
        }
        return properties;
    }

    public void sendToJudgesAndOthers(IInternalController controller, Packet packet, boolean sendToServers) {
        controller.sendToAdministrators(packet);
        controller.sendToJudges(packet);
        controller.sendToScoreboards(packet);
        if (sendToServers) {
            controller.sendToServers(packet);
        }
    }

    private void writeValues(String key, long number) {
        System.out.print(String.valueOf(key) + "=" + number + " ");
    }

    private void writeValues(String key, String value) {
        System.out.print(String.valueOf(key) + "=" + value + " ");
    }

    private void dump(String message, PlaybackEvent playbackEvent) {
        Run run = playbackEvent.getRun();
        System.out.println(message);
        this.writeValues(ACTION_KEY, playbackEvent.getAction().toString());
        this.writeValues(ID_KEY, run.getNumber());
        this.writeValues(ELAPSED_KEY, run.getElapsedMins());
        this.writeValues(LANGUAGE_KEY, run.getLanguageId().toString());
        this.writeValues(PROBLEM_KEY, run.getProblemId().toString());
        this.writeValues(SITE_KEY, run.getSiteNumber());
        this.writeValues(SUBMIT_CLIENT_KEY, run.getSubmitter().getName());
        this.writeValues("File size", playbackEvent.getFiles()[0].getBuffer().length);
        System.out.println();
    }

    public void executeEvent(PlaybackEvent playbackEvent, IInternalContest contest, IInternalController controller) throws Exception {
        if (Utilities.isDebugMode()) {
            this.dump("in executeEvent", playbackEvent);
        }
        switch (playbackEvent.getAction()) {
            case RUN_SUBMIT: {
                SerializedFile file = playbackEvent.getFiles()[0];
                SerializedFile[] files = new SerializedFile[]{file};
                RunFiles runFiles = new RunFiles(playbackEvent.getRun(), file, new SerializedFile[0]);
                Run theRun = playbackEvent.getRun();
                long savedElapsed = theRun.getElapsedMins();
                Run newRun = contest.acceptRun(theRun, runFiles);
                if (savedElapsed > 0L) {
                    newRun.setElapsedMins(savedElapsed);
                }
                ++this.sequenceNumber;
                playbackEvent.setEventStatus(EventStatus.COMPLETED);
                ClientId fromId = contest.getClientId();
                Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(contest.getClientId(), fromId, newRun);
                controller.sendToClient(confirmPacket);
                this.sendToJudgesAndOthers(controller, confirmPacket, true);
                break;
            }
            default: {
                throw new Exception(playbackEvent.getAction().toString());
            }
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

