/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.log.StaticLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;

public class SerializedFile
implements Serializable {
    public static final String SVN_ID = "$Id: SerializedFile.java 821 2007-10-08 06:52:25Z laned $";
    static final long serialVersionUID = -254619749606639287L;
    private static File file;
    private byte[] buffer;
    private String name;
    private String absolutePath;
    private String sha1sum;
    private int fileType = 1;
    private int newLineCount = 0;

    public SerializedFile() {
        this.name = null;
        this.buffer = null;
        file = null;
        this.fileType = 1;
    }

    public SerializedFile(String fileName) {
        file = new File(fileName);
        this.setName(file.getName());
        if (!file.exists()) {
            this.info("SerializedFile:" + fileName + " does not exist");
        } else {
            try {
                this.buffer = this.file2buffer(fileName);
                this.absolutePath = file.getAbsolutePath();
                this.generateSHA1(this.buffer);
                this.generateFileType(this.buffer);
            }
            catch (Exception e) {
                StaticLog.log("Exception in SerializeFile for file " + fileName, e);
            }
        }
    }

    private void info(String string) {
    }

    public SerializedFile(String fileName, int limit) {
        file = new File(fileName);
        this.setName(file.getName());
        if (!file.exists()) {
            this.info("SerializedFile:" + fileName + " does not exist");
        } else {
            try {
                this.buffer = this.file2buffer(fileName, limit);
                this.absolutePath = file.getAbsolutePath();
                this.generateSHA1(this.buffer);
                this.generateFileType(this.buffer);
            }
            catch (Exception e) {
                StaticLog.log("Exception in SerializeFile for file " + fileName, e);
            }
        }
    }

    public void buffer2file(byte[] b, String fileName) {
        try {
            FileOutputStream outputStream = null;
            outputStream = new FileOutputStream(fileName);
            outputStream.write(b, 0, b.length);
            outputStream.close();
        }
        catch (Exception e) {
            StaticLog.log("Exception in buffer2file for file " + fileName, e);
        }
    }

    public void writeFile(String fileName) throws IOException {
        if (this.buffer == null || this.buffer.length <= 0) {
            throw new IOException("Unable to write file, buffer is null or buffer.length is zero");
        }
        FileOutputStream outputStream = null;
        outputStream = new FileOutputStream(fileName);
        outputStream.write(this.buffer, 0, this.buffer.length);
        outputStream.close();
    }

    public byte[] file2buffer(String fileName) {
        FileInputStream inputStream = null;
        int len = 0;
        try {
            inputStream = new FileInputStream(fileName);
            len = ((InputStream)inputStream).available();
        }
        catch (Exception e) {
            StaticLog.log("Exception in file2buffer for file " + fileName, e);
        }
        byte[] b = new byte[len];
        try {
            ((InputStream)inputStream).read(b);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            StaticLog.log("Exception in file2buffer for file " + fileName, e);
        }
        return b;
    }

    public byte[] file2buffer(String fileName, int limit) {
        FileInputStream inputStream = null;
        int len = 0;
        try {
            inputStream = new FileInputStream(fileName);
            len = ((InputStream)inputStream).available();
        }
        catch (Exception e) {
            StaticLog.log("Exception in file2buffer", e);
        }
        if (len > limit) {
            len = limit;
        }
        byte[] b = new byte[len];
        try {
            ((InputStream)inputStream).read(b);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            StaticLog.log("Exception in generateSHA1", e);
        }
        return b;
    }

    public void generateSHA1(byte[] buf) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.reset();
            md.update(buf);
            byte[] digested = md.digest();
            String out = "";
            int i = 0;
            while (i < digested.length) {
                out = String.valueOf(out) + new Integer(digested[i]).toString();
                ++i;
            }
            this.sha1sum = out;
        }
        catch (Exception ex99) {
            StaticLog.log("Exception in generateSHA1", ex99);
        }
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public File getFile() {
        return file;
    }

    public String getSHA1sum() {
        return this.sha1sum;
    }

    public String getName() {
        return this.name;
    }

    public void setFile(File file) {
        SerializedFile.file = file;
    }

    void setSHA1sum(String newSHA1sum) {
        this.sha1sum = newSHA1sum;
    }

    private void setName(String name) {
        this.name = name;
    }

    public void generateFileType(byte[] buf) {
        int dosFlag = 0;
        int unixFlag = 0;
        int macFlag = 0;
        int lastChar = 0;
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 10) {
                if (lastChar == 13) {
                    ++dosFlag;
                    --macFlag;
                } else {
                    ++unixFlag;
                }
            } else if (buf[i] == 13) {
                ++macFlag;
            }
            if (buf[i] > 127) {
                this.fileType = 1;
                this.newLineCount = 0;
                return;
            }
            lastChar = buf[i];
            ++i;
        }
        if (dosFlag != 0 && unixFlag == 0 && macFlag == 0) {
            this.fileType = 2;
            this.newLineCount = dosFlag;
        } else if (dosFlag == 0 && unixFlag != 0 && macFlag == 0) {
            this.fileType = 8;
            this.newLineCount = unixFlag;
        } else if (dosFlag == 0 && unixFlag == 0 && macFlag != 0) {
            this.fileType = 4;
            this.newLineCount = macFlag;
        } else if (dosFlag == 0 && unixFlag == 0 && macFlag == 0) {
            this.fileType = 16;
            this.newLineCount = 0;
        } else {
            this.fileType = 32;
            this.newLineCount = 0;
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    public boolean convertFile(int convertFileToType) {
        if (this.fileType == 1 || this.fileType == 16 || this.fileType == 32) {
            return false;
        }
        if (this.fileType == convertFileToType) {
            return true;
        }
        byte[] newbuffer = convertFileToType == 2 ? new byte[this.buffer.length + this.newLineCount] : (this.fileType == 2 ? new byte[this.buffer.length - this.newLineCount] : new byte[this.buffer.length]);
        int counter = 0;
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer[i] == 13 || this.buffer[i] == 10) {
                if (this.fileType == 2) {
                    if (convertFileToType == 8) {
                        newbuffer[counter++] = 10;
                        ++i;
                    } else {
                        newbuffer[counter++] = 13;
                        ++i;
                    }
                } else if (this.fileType == 8) {
                    if (convertFileToType == 4) {
                        newbuffer[counter++] = 13;
                    } else {
                        newbuffer[counter++] = 13;
                        newbuffer[counter++] = 10;
                    }
                } else if (this.fileType == 4) {
                    if (convertFileToType == 8) {
                        newbuffer[counter++] = 10;
                    } else {
                        newbuffer[counter++] = 13;
                        newbuffer[counter++] = 10;
                    }
                }
            } else {
                newbuffer[counter++] = this.buffer[i];
            }
            ++i;
        }
        String s = "Converted file from ";
        if (this.fileType == 1) {
            s = String.valueOf(s) + "Binary";
        } else if (this.fileType == 2) {
            s = String.valueOf(s) + "DOS";
        } else if (this.fileType == 4) {
            s = String.valueOf(s) + "Apple";
        } else if (this.fileType == 8) {
            s = String.valueOf(s) + "Unix";
        } else if (this.fileType == 16) {
            s = String.valueOf(s) + "ASCII_Generic";
        } else if (this.fileType == 32) {
            s = String.valueOf(s) + "ASCII_Other";
        }
        s = String.valueOf(s) + " to ";
        if (convertFileToType == 1) {
            s = String.valueOf(s) + "Binary";
        } else if (convertFileToType == 2) {
            s = String.valueOf(s) + "DOS";
        } else if (convertFileToType == 4) {
            s = String.valueOf(s) + "Apple";
        } else if (convertFileToType == 8) {
            s = String.valueOf(s) + "Unix";
        } else if (convertFileToType == 16) {
            s = String.valueOf(s) + "ASCII_Generic";
        } else if (convertFileToType == 32) {
            s = String.valueOf(s) + "ASCII_Other";
        }
        StaticLog.info(s);
        this.fileType = convertFileToType;
        this.buffer = newbuffer;
        return true;
    }
}

