/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import java.util.Vector;

public class Run
extends ISubmission {
    private static final long serialVersionUID = 4643865629642121895L;
    private Vector<JudgementRecord> judgementList = new Vector();
    private boolean deleted;
    private RunStates status = RunStates.INITIAL;
    private String systemOS = null;

    public Run(ClientId submitter, Language languageId, Problem problemId) {
        this.setSubmitter(submitter);
        this.setLanguageId(languageId.getElementId());
        this.setProblemId(problemId.getElementId());
        this.status = problemId.isComputerJudged() ? RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT : RunStates.NEW;
        this.setElementId(new ElementId("Run"));
        this.systemOS = System.getProperty("os.name", "?");
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public RunStates getStatus() {
        return this.status;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setStatus(RunStates status) {
        this.status = status;
    }

    public boolean isJudged() {
        return this.status == RunStates.JUDGED || this.status == RunStates.BEING_RE_JUDGED || this.status == RunStates.MANUAL_REVIEW;
    }

    public JudgementRecord getJudgementRecord() {
        if (this.judgementList.size() == 0) {
            return null;
        }
        if (this.judgementList.size() == 1) {
            return this.judgementList.elementAt(0);
        }
        int i = this.judgementList.size() - 1;
        while (i >= 0) {
            JudgementRecord judgement = this.judgementList.elementAt(i);
            if (judgement.isActive()) {
                return judgement;
            }
            --i;
        }
        return null;
    }

    public boolean isSolved() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return false;
        }
        return judgementRecord.isSolved();
    }

    public JudgementRecord[] getAllJudgementRecords() {
        if (this.judgementList.size() == 0) {
            return new JudgementRecord[0];
        }
        JudgementRecord[] judgementRecordArray = new JudgementRecord[this.judgementList.size()];
        int i = this.judgementList.size() - 1;
        while (i >= 0) {
            JudgementRecord judgementRecord;
            judgementRecordArray[i] = judgementRecord = this.judgementList.elementAt(i);
            --i;
        }
        return judgementRecordArray;
    }

    public void addJudgement(JudgementRecord judgement) {
        if (judgement == null) {
            throw new IllegalArgumentException("Input judgement is null");
        }
        JudgementRecord lastJudgement = this.getJudgementRecord();
        if (lastJudgement != null) {
            lastJudgement.setActive(false);
            if (lastJudgement.isComputerJudgement() && !judgement.isComputerJudgement()) {
                judgement.setPreviousComputerJudgementId(judgement.getElementId());
            }
        }
        this.judgementList.addElement(judgement);
    }

    public JudgementRecord getComputerJudgementRecord() {
        if (this.judgementList.size() == 0) {
            return null;
        }
        if (this.judgementList.size() == 1) {
            JudgementRecord judgementRecord = this.judgementList.elementAt(0);
            if (judgementRecord.isComputerJudgement()) {
                return judgementRecord;
            }
            return null;
        }
        int i = this.judgementList.size() - 1;
        while (i >= 0) {
            JudgementRecord judgement = this.judgementList.elementAt(i);
            if (judgement.isActive() && judgement.isComputerJudgement()) {
                return judgement;
            }
            --i;
        }
        return null;
    }

    public long getJudgedMinutes() {
        JudgementRecord judgement = this.getJudgementRecord();
        if (judgement == null) {
            return 0L;
        }
        return judgement.getJudgedMinutes();
    }

    public String getCommentsForTeam() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return "";
        }
        if (judgementRecord.getCommentForTeam() == null) {
            return "";
        }
        return judgementRecord.getCommentForTeam().getComment();
    }

    public String getCommentsForJudge() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord == null) {
            return "";
        }
        if (judgementRecord.getCommentForJudge() == null) {
            return "";
        }
        return judgementRecord.getCommentForJudge().getComment();
    }

    public boolean isSendToTeams() {
        JudgementRecord judgementRecord = this.getJudgementRecord();
        if (judgementRecord != null) {
            return judgementRecord.isSendToTeam();
        }
        return false;
    }

    public String getSystemOS() {
        return this.systemOS;
    }

    public String toString() {
        return "Run " + this.getNumber() + " " + (Object)((Object)this.getStatus()) + " from " + this.getSubmitter() + " id " + this.getElementId().toString();
    }

    public boolean isSameAs(Run run) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (this.getElapsedMins() == run.getElapsedMins()) break block8;
                                    return false;
                                }
                                catch (Exception exception) {
                                    return false;
                                }
                            }
                            if (this.isDeleted() == run.isDeleted()) break block9;
                            return false;
                        }
                        if (this.getSubmitter().equals(run.getSubmitter())) break block10;
                        return false;
                    }
                    if (this.getProblemId().equals(run.getProblemId())) break block11;
                    return false;
                }
                if (this.getLanguageId().equals(run.getLanguageId())) break block12;
                return false;
            }
            if (this.getStatus() == run.getStatus()) break block13;
            return false;
        }
        return this.getJudgementRecord().equals(run.getJudgementRecord());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunStates {
        INITIAL,
        NEW,
        CHECKED_OUT,
        BEING_JUDGED,
        BEING_RE_JUDGED,
        HOLD,
        REJUDGE,
        JUDGED,
        QUEUED_FOR_COMPUTER_JUDGEMENT,
        BEING_COMPUTER_JUDGED,
        MANUAL_REVIEW;

    }
}

