/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.exception.ClarificationUnavailableException;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.RunUnavailableException;
import edu.csus.ecs.pc2.core.exception.UnableToUncheckoutRunException;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.BalloonSettingsList;
import edu.csus.ecs.pc2.core.list.ClarificationList;
import edu.csus.ecs.pc2.core.list.ClientSettingsList;
import edu.csus.ecs.pc2.core.list.ConnectionHandlerList;
import edu.csus.ecs.pc2.core.list.ContestTimeList;
import edu.csus.ecs.pc2.core.list.GroupDisplayList;
import edu.csus.ecs.pc2.core.list.GroupList;
import edu.csus.ecs.pc2.core.list.JudgementDisplayList;
import edu.csus.ecs.pc2.core.list.JudgementList;
import edu.csus.ecs.pc2.core.list.LanguageDisplayList;
import edu.csus.ecs.pc2.core.list.LanguageList;
import edu.csus.ecs.pc2.core.list.LoginList;
import edu.csus.ecs.pc2.core.list.ProblemDisplayList;
import edu.csus.ecs.pc2.core.list.ProblemList;
import edu.csus.ecs.pc2.core.list.RunFilesList;
import edu.csus.ecs.pc2.core.list.RunList;
import edu.csus.ecs.pc2.core.list.RunResultsFileList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ConnectionEvent;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IChangePasswordListener;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IConnectionListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.PasswordChangeEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemDataFilesList;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.model.SiteList;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.SecurityMessageHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalContest
implements IInternalContest {
    private ClientId localClientId = null;
    private Vector<IRunListener> runListenerList = new Vector();
    private Vector<IClarificationListener> clarificationListenerList = new Vector();
    private Vector<IProblemListener> problemListenerList = new Vector();
    private Vector<ILanguageListener> languageListenerList = new Vector();
    private Vector<IChangePasswordListener> changePasswordListenerList = new Vector();
    private Vector<ILoginListener> loginListenerList = new Vector();
    private Vector<IContestTimeListener> contestTimeListenerList = new Vector();
    private Vector<IJudgementListener> judgementListenerList = new Vector();
    private Vector<ISiteListener> siteListenerList = new Vector();
    private Vector<IConnectionListener> connectionListenerList = new Vector();
    private Vector<IClientSettingsListener> clientSettingsListenerList = new Vector();
    private Vector<IContestInformationListener> contestInformationListenerList = new Vector();
    private Vector<IBalloonSettingsListener> balloonSettingsListenerList = new Vector();
    private Vector<IGroupListener> groupListenerList = new Vector();
    private Hashtable<ElementId, ClientId> runCheckOutList = new Hashtable(200);
    private Hashtable<ElementId, ClientId> clarCheckOutList = new Hashtable(200);
    private AccountList accountList = new AccountList();
    private BalloonSettingsList balloonSettingsList = new BalloonSettingsList();
    private Vector<IAccountListener> accountListenerList = new Vector();
    private GroupList groupList = new GroupList();
    private Problem generalProblem = null;
    private LoginList localLoginList = new LoginList();
    private LoginList remoteLoginList = new LoginList();
    private ConnectionHandlerList localConnectionHandlerList = new ConnectionHandlerList();
    private ConnectionHandlerList remoteConnectionHandlerList = new ConnectionHandlerList();
    private ContestTimeList contestTimeList = new ContestTimeList();
    private RunList runList = new RunList();
    private RunFilesList runFilesList = new RunFilesList();
    private RunResultsFileList runResultFilesList = new RunResultsFileList();
    private ClarificationList clarificationList = new ClarificationList();
    private SiteList siteList = new SiteList();
    private ClientSettingsList clientSettingsList = new ClientSettingsList();
    private ContestInformation contestInformation = new ContestInformation();
    private int siteNumber = 1;
    private ProblemList problemList = new ProblemList();
    private ProblemDataFilesList problemDataFilesList = new ProblemDataFilesList();
    private ProblemDisplayList problemDisplayList = new ProblemDisplayList();
    private LanguageList languageList = new LanguageList();
    private LanguageDisplayList languageDisplayList = new LanguageDisplayList();
    private JudgementDisplayList judgementDisplayList = new JudgementDisplayList();
    private GroupDisplayList groupDisplayList = new GroupDisplayList();
    private JudgementList judgementList = new JudgementList();
    private SecurityMessageHandler securityMessageHandler;

    private Site createFakeSite(int nextSiteNumber) {
        Site site = new Site("Site " + nextSiteNumber, nextSiteNumber);
        Properties props = new Properties();
        props.put("IP_KEY", "localhost");
        int port = 50002 + (nextSiteNumber - 1) * 1000;
        props.put("PORT_KEY", "" + port);
        site.setConnectionInfo(props);
        site.setPassword("site" + nextSiteNumber);
        return site;
    }

    @Override
    public void initializeSubmissions(int siteNum) {
        int i;
        this.runList = new RunList(siteNum, true);
        this.runFilesList = new RunFilesList(siteNum);
        this.runResultFilesList = new RunResultsFileList(siteNum);
        this.clarificationList = new ClarificationList(siteNum, true);
        try {
            this.runList.loadFromDisk(siteNum);
            Run[] runs = this.runList.getList();
            i = 0;
            while (i < runs.length) {
                Run.RunStates status = runs[i].getStatus();
                if (status.equals((Object)Run.RunStates.BEING_COMPUTER_JUDGED)) {
                    status = Run.RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT;
                } else if (status.equals((Object)Run.RunStates.BEING_JUDGED)) {
                    status = runs[i].getComputerJudgementRecord() == null ? Run.RunStates.NEW : Run.RunStates.MANUAL_REVIEW;
                } else if (status.equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
                    status = Run.RunStates.JUDGED;
                }
                if (!runs[i].getStatus().equals((Object)status)) {
                    StaticLog.info("Changing Run " + runs[i].getElementId() + " from " + (Object)((Object)runs[i].getStatus()) + "to NEW");
                    this.runList.updateRunStatus(runs[i], status);
                }
                ++i;
            }
        }
        catch (Exception e) {
            StaticLog.log("Trouble loading runs from disk ", e);
        }
        try {
            this.clarificationList.loadFromDisk(siteNum);
            Clarification[] clarList = this.clarificationList.getList();
            i = 0;
            while (i < clarList.length) {
                if (clarList[i].getState().equals((Object)Clarification.ClarificationStates.BEING_ANSWERED)) {
                    StaticLog.info("Changing Clarification " + clarList[i].getElementId() + " from BEING_ANSWERED by " + clarList[i].getWhoCheckedItOutId() + "to NEW");
                    this.clarificationList.updateClarification(clarList[i], Clarification.ClarificationStates.NEW, null);
                }
                ++i;
            }
        }
        catch (Exception e) {
            StaticLog.log("Trouble loading clarifications from disk ", e);
        }
    }

    @Override
    public void initializeStartupData(int siteNum) {
        if (this.siteList.size() == 0) {
            Site site = this.createFakeSite(1);
            site.setActive(true);
            this.siteList.add(site);
            this.contestInformation.setContestTitle("Default Contest Title");
            if (this.getGeneralProblem() == null) {
                this.setGeneralProblem(new Problem("General"));
            }
        }
        if (this.getContestTime(siteNum) == null) {
            ContestTime contestTime = new ContestTime();
            contestTime.setSiteNumber(siteNum);
            this.addContestTime(contestTime);
        }
        if (this.getAccounts(ClientType.Type.SERVER) == null) {
            this.generateNewAccounts(ClientType.Type.SERVER.toString(), 1, true);
        }
        if (this.getAccounts(ClientType.Type.ADMINISTRATOR) != null) {
            this.generateNewAccounts(ClientType.Type.ADMINISTRATOR.toString(), 1, true);
        }
    }

    @Override
    public void addRunListener(IRunListener runListener) {
        this.runListenerList.addElement(runListener);
    }

    @Override
    public void removeRunListener(IRunListener runListener) {
        this.runListenerList.removeElement(runListener);
    }

    @Override
    public void addClarificationListener(IClarificationListener clarificationListener) {
        this.clarificationListenerList.addElement(clarificationListener);
    }

    @Override
    public void removeClarificationListener(IClarificationListener clarificationListener) {
        this.clarificationListenerList.remove(clarificationListener);
    }

    @Override
    public void addContestTimeListener(IContestTimeListener contestTimeListener) {
        this.contestTimeListenerList.addElement(contestTimeListener);
    }

    @Override
    public void removeContestTimeListener(IContestTimeListener contestTimeListener) {
        this.contestTimeListenerList.removeElement(contestTimeListener);
    }

    @Override
    public void addJudgementListener(IJudgementListener judgementListener) {
        this.judgementListenerList.addElement(judgementListener);
    }

    @Override
    public void removeJudgementListener(IJudgementListener judgementListener) {
        this.judgementListenerList.remove(judgementListener);
    }

    private void fireRunListener(RunEvent runEvent) {
        int i = 0;
        while (i < this.runListenerList.size()) {
            if (runEvent.getAction() == RunEvent.Action.ADDED) {
                this.runListenerList.elementAt(i).runAdded(runEvent);
            } else if (runEvent.getAction() == RunEvent.Action.DELETED) {
                this.runListenerList.elementAt(i).runRemoved(runEvent);
            } else {
                this.runListenerList.elementAt(i).runChanged(runEvent);
            }
            ++i;
        }
    }

    private void fireContestTimeListener(ContestTimeEvent contestTimeEvent) {
        int i = 0;
        while (i < this.contestTimeListenerList.size()) {
            if (contestTimeEvent.getAction() == ContestTimeEvent.Action.ADDED) {
                this.contestTimeListenerList.elementAt(i).contestTimeAdded(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.DELETED) {
                this.contestTimeListenerList.elementAt(i).contestTimeRemoved(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CLOCK_STARTED) {
                this.contestTimeListenerList.elementAt(i).contestStarted(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CLOCK_STOPPED) {
                this.contestTimeListenerList.elementAt(i).contestStopped(contestTimeEvent);
            } else if (contestTimeEvent.getAction() == ContestTimeEvent.Action.CHANGED) {
                this.contestTimeListenerList.elementAt(i).contestTimeChanged(contestTimeEvent);
            } else {
                this.contestTimeListenerList.elementAt(i).contestTimeChanged(contestTimeEvent);
            }
            ++i;
        }
    }

    private void fireProblemListener(ProblemEvent problemEvent) {
        int i = 0;
        while (i < this.problemListenerList.size()) {
            if (problemEvent.getAction() == ProblemEvent.Action.ADDED) {
                this.problemListenerList.elementAt(i).problemAdded(problemEvent);
            } else if (problemEvent.getAction() == ProblemEvent.Action.DELETED) {
                this.problemListenerList.elementAt(i).problemRemoved(problemEvent);
            } else {
                this.problemListenerList.elementAt(i).problemChanged(problemEvent);
            }
            ++i;
        }
    }

    private void fireLanguageListener(LanguageEvent languageEvent) {
        int i = 0;
        while (i < this.languageListenerList.size()) {
            if (languageEvent.getAction() == LanguageEvent.Action.ADDED) {
                this.languageListenerList.elementAt(i).languageAdded(languageEvent);
            } else if (languageEvent.getAction() == LanguageEvent.Action.DELETED) {
                this.languageListenerList.elementAt(i).languageRemoved(languageEvent);
            } else {
                this.languageListenerList.elementAt(i).languageChanged(languageEvent);
            }
            ++i;
        }
    }

    private void fireLoginListener(LoginEvent loginEvent) {
        int i = 0;
        while (i < this.loginListenerList.size()) {
            if (loginEvent.getAction() == LoginEvent.Action.NEW_LOGIN) {
                this.loginListenerList.elementAt(i).loginAdded(loginEvent);
            } else if (loginEvent.getAction() == LoginEvent.Action.LOGOFF) {
                this.loginListenerList.elementAt(i).loginRemoved(loginEvent);
            } else if (loginEvent.getAction() == LoginEvent.Action.LOGIN_DENIED) {
                this.loginListenerList.elementAt(i).loginDenied(loginEvent);
            } else {
                throw new UnsupportedOperationException("Unknown login action " + (Object)((Object)loginEvent.getAction()));
            }
            ++i;
        }
    }

    private void fireJudgementListener(JudgementEvent judgementEvent) {
        int i = 0;
        while (i < this.judgementListenerList.size()) {
            if (judgementEvent.getAction() == JudgementEvent.Action.ADDED) {
                this.judgementListenerList.elementAt(i).judgementAdded(judgementEvent);
            } else if (judgementEvent.getAction() == JudgementEvent.Action.DELETED) {
                this.judgementListenerList.elementAt(i).judgementRemoved(judgementEvent);
            } else {
                this.judgementListenerList.elementAt(i).judgementChanged(judgementEvent);
            }
            ++i;
        }
    }

    private void fireSiteListener(SiteEvent siteEvent) {
        int i = 0;
        while (i < this.siteListenerList.size()) {
            if (siteEvent.getAction() == SiteEvent.Action.ADDED) {
                this.siteListenerList.elementAt(i).siteAdded(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.DELETED) {
                this.siteListenerList.elementAt(i).siteRemoved(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.CHANGED) {
                this.siteListenerList.elementAt(i).siteChanged(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.LOGIN) {
                this.siteListenerList.elementAt(i).siteLoggedOn(siteEvent);
            } else if (siteEvent.getAction() == SiteEvent.Action.LOGOFF) {
                this.siteListenerList.elementAt(i).siteLoggedOff(siteEvent);
            } else {
                this.siteListenerList.elementAt(i).siteAdded(siteEvent);
            }
            ++i;
        }
    }

    private void fireConnectionListener(ConnectionEvent connectionEvent) {
        int i = 0;
        while (i < this.connectionListenerList.size()) {
            if (connectionEvent.getAction() == ConnectionEvent.Action.ESTABLISHED) {
                this.connectionListenerList.elementAt(i).connectionEstablished(connectionEvent);
            } else if (connectionEvent.getAction() == ConnectionEvent.Action.DROPPED) {
                this.connectionListenerList.elementAt(i).connectionDropped(connectionEvent);
            } else {
                throw new UnsupportedOperationException("Unknown connection action " + (Object)((Object)connectionEvent.getAction()));
            }
            ++i;
        }
    }

    private void fireBalloonSettingsListener(BalloonSettingsEvent balloonSettingsEvent) {
        int i = 0;
        while (i < this.balloonSettingsListenerList.size()) {
            if (balloonSettingsEvent.getAction() == BalloonSettingsEvent.Action.ADDED) {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsAdded(balloonSettingsEvent);
            } else if (balloonSettingsEvent.getAction() == BalloonSettingsEvent.Action.DELETED) {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsRemoved(balloonSettingsEvent);
            } else {
                this.balloonSettingsListenerList.elementAt(i).balloonSettingsChanged(balloonSettingsEvent);
            }
            ++i;
        }
    }

    @Override
    public void addLocalLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        this.localLoginList.add(inClientId, connectionHandlerID);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addRemoteLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        this.remoteLoginList.add(inClientId, connectionHandlerID);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addLogin(ClientId inClientId, ConnectionHandlerID connectionHandlerID) {
        if (inClientId.getSiteNumber() == this.siteNumber) {
            this.localLoginList.add(inClientId, connectionHandlerID);
        } else {
            this.remoteLoginList.add(inClientId, connectionHandlerID);
        }
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.NEW_LOGIN, inClientId, connectionHandlerID, "New");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void loginDenied(ClientId clientId, ConnectionHandlerID connectionHandlerID, String message) {
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGIN_DENIED, clientId, connectionHandlerID, message);
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void addLanguage(Language language) {
        this.languageDisplayList.add(language);
        this.languageList.add(language);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.ADDED, language);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void addProblem(Problem problem) {
        this.problemDisplayList.add(problem);
        this.problemList.add(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.ADDED, problem);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void addJudgement(Judgement judgement) {
        this.judgementDisplayList.add(judgement);
        this.judgementList.add(judgement);
        JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.ADDED, judgement);
        this.fireJudgementListener(judgementEvent);
    }

    @Override
    public void addSite(Site site) {
        this.siteList.add(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.ADDED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void updateSite(Site site) {
        this.siteList.update(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.CHANGED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void addAccount(Account account) {
        this.accountList.add(account);
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED, account);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public void addAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.accountList.add(account);
            ++n2;
        }
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED_ACCOUNTS, accounts);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public Judgement[] getJudgements() {
        return this.judgementDisplayList.getList();
    }

    @Override
    public Run acceptRun(Run run, RunFiles runFiles) {
        run.setElapsedMins(this.getContestTime().getElapsedMins());
        run.setSiteNumber(this.getSiteNumber());
        Run newRun = this.runList.addNewRun(run);
        if (runFiles != null) {
            this.runFilesList.add(newRun, runFiles);
        }
        this.addRun(newRun);
        return newRun;
    }

    @Override
    public Clarification acceptClarification(Clarification clarification) {
        clarification.setElapsedMins(this.getContestTime().getElapsedMins());
        clarification.setSiteNumber(this.getSiteNumber());
        Clarification newClarification = this.clarificationList.addNewClarification(clarification);
        this.addClarification(clarification);
        return newClarification;
    }

    @Override
    public void answerClarification(Clarification clarification, String answer, ClientId whoAnsweredIt, boolean sendToAll) {
        if (this.clarificationList.get(clarification) != null) {
            Clarification answerClarification = this.clarificationList.updateClarification(clarification, Clarification.ClarificationStates.ANSWERED, whoAnsweredIt, answer, sendToAll);
            ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ANSWERED_CLARIFICATION, answerClarification);
            clarificationEvent.setWhoModifiedClarification(whoAnsweredIt);
            this.fireClarificationListener(clarificationEvent);
        } else {
            this.clarificationList.add(clarification);
            Clarification updatedClarification = this.clarificationList.get(clarification);
            ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ANSWERED_CLARIFICATION, updatedClarification);
            clarificationEvent.setWhoModifiedClarification(whoAnsweredIt);
            this.fireClarificationListener(clarificationEvent);
        }
    }

    @Override
    public void updateClarification(Clarification clarification, ClientId whoChangedIt) {
        this.clarificationList.updateClarification(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHANGED, this.clarificationList.get(clarification));
        if (whoChangedIt != null) {
            clarificationEvent.setWhoModifiedClarification(whoChangedIt);
        }
        clarificationEvent.setSentToClientId(whoChangedIt);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void clarificationNotAvailable(Clarification clar) {
        ClarificationEvent clarEvent = new ClarificationEvent(ClarificationEvent.Action.CLARIFICATION_NOT_AVAILABLE, clar);
        this.fireClarificationListener(clarEvent);
    }

    @Override
    public void addRun(Run run) {
        this.runList.add(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.ADDED, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public void addRun(Run run, RunFiles runFiles, ClientId whoCheckedOutRunId) {
        this.runList.add(run);
        this.runFilesList.add(run, runFiles);
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHECKEDOUT_RUN, run, runFiles, null);
        runEvent.setSentToClientId(whoCheckedOutRunId);
        this.fireRunListener(runEvent);
    }

    @Override
    public void availableRun(Run run) {
        this.runList.add(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_AVAILABLE, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public Vector<Account> generateNewAccounts(String clientTypeName, int count, boolean active) {
        return this.generateNewAccounts(clientTypeName, count, 1, active);
    }

    @Override
    public Vector<Account> generateNewAccounts(String clientTypeName, int count, int startNumber, boolean active) {
        ClientType.Type type = ClientType.Type.valueOf(clientTypeName.toUpperCase());
        Vector<Account> newAccounts = this.accountList.generateNewAccounts(type, count, startNumber, AccountList.PasswordType.JOE, this.siteNumber, active);
        int i = 0;
        while (i < newAccounts.size()) {
            Account account = newAccounts.elementAt(i);
            AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.ADDED, account);
            this.fireAccountListener(accountEvent);
            ++i;
        }
        return newAccounts;
    }

    @Override
    public void generateNewSites(int count, boolean active) {
        int numSites = this.siteList.size();
        int i = 0;
        while (i < count) {
            int nextSiteNumber = i + numSites + 1;
            Site site = new Site("Site " + nextSiteNumber, nextSiteNumber);
            site.setPassword("site" + nextSiteNumber);
            site.setActive(active);
            this.addSite(site);
            ++i;
        }
    }

    @Override
    public void addAccountListener(IAccountListener accountListener) {
        this.accountListenerList.addElement(accountListener);
    }

    @Override
    public void removeAccountListener(IAccountListener accountListener) {
        this.accountListenerList.removeElement(accountListener);
    }

    private void fireAccountListener(AccountEvent accountEvent) {
        int i = 0;
        while (i < this.accountListenerList.size()) {
            if (accountEvent.getAction() == AccountEvent.Action.ADDED) {
                this.accountListenerList.elementAt(i).accountAdded(accountEvent);
            } else if (accountEvent.getAction() == AccountEvent.Action.ADDED_ACCOUNTS) {
                this.accountListenerList.elementAt(i).accountsAdded(accountEvent);
            } else if (accountEvent.getAction() == AccountEvent.Action.CHANGED_ACCOUNTS) {
                this.accountListenerList.elementAt(i).accountsModified(accountEvent);
            } else {
                this.accountListenerList.elementAt(i).accountModified(accountEvent);
            }
            ++i;
        }
    }

    @Override
    public Problem[] getProblems() {
        return this.problemDisplayList.getList();
    }

    @Override
    public Language[] getLanguages() {
        return this.languageDisplayList.getList();
    }

    @Override
    public ClientId getClientId() {
        return this.localClientId;
    }

    @Override
    public void setClientId(ClientId clientId) {
        this.localClientId = clientId;
        try {
            this.securityMessageHandler = new SecurityMessageHandler(clientId);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (this.isAllowed(this.localClientId, Permission.Type.ALLOWED_TO_FETCH_RUN) && !this.runFilesList.isWriteToDisk() && !this.runFilesList.isCacheRunFiles()) {
            this.runFilesList.setCacheRunFiles(true);
        }
    }

    @Override
    public Log getSecurityAlertLog() {
        return this.securityMessageHandler.getLog();
    }

    @Override
    public Site[] getSites() {
        return this.siteList.getList();
    }

    @Override
    public String getTitle() {
        ClientId id = this.getClientId();
        if (id == null) {
            return "(Client not logged in)";
        }
        String titleCase = id.getClientType().toString();
        titleCase = String.valueOf(titleCase.charAt(0)) + titleCase.substring(1);
        return String.valueOf(titleCase) + " " + id.getClientNumber() + " (Site " + id.getSiteNumber() + ")";
    }

    @Override
    public void addProblemListener(IProblemListener problemListener) {
        this.problemListenerList.addElement(problemListener);
    }

    @Override
    public void removeProblemListener(IProblemListener problemListener) {
        this.problemListenerList.remove(problemListener);
    }

    @Override
    public void addLanguageListener(ILanguageListener languageListener) {
        this.languageListenerList.addElement(languageListener);
    }

    @Override
    public void removeLanguageListener(ILanguageListener languageListener) {
        this.languageListenerList.remove(languageListener);
    }

    @Override
    public void addChangePasswordListener(IChangePasswordListener changePasswordListener) {
        this.changePasswordListenerList.add(changePasswordListener);
    }

    @Override
    public void removeChangePasswordListener(IChangePasswordListener changePasswordListener) {
        this.changePasswordListenerList.remove(changePasswordListener);
    }

    @Override
    public void addLoginListener(ILoginListener loginListener) {
        this.loginListenerList.addElement(loginListener);
    }

    @Override
    public void removeLoginListener(ILoginListener loginListener) {
        this.loginListenerList.remove(loginListener);
    }

    @Override
    public void addSiteListener(ISiteListener siteListener) {
        this.siteListenerList.add(siteListener);
    }

    @Override
    public void removeSiteListener(ISiteListener siteListener) {
        this.siteListenerList.remove(siteListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener connectionListener) {
        this.connectionListenerList.addElement(connectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener connectionListener) {
        this.connectionListenerList.remove(connectionListener);
    }

    @Override
    public void addBalloonSettingsListener(IBalloonSettingsListener balloonSettingsListener) {
        this.balloonSettingsListenerList.addElement(balloonSettingsListener);
    }

    @Override
    public void removeBalloonSettingsListener(IBalloonSettingsListener balloonSettingsListener) {
        this.balloonSettingsListenerList.remove(balloonSettingsListener);
    }

    @Override
    public Run getRun(ElementId id) {
        return this.runList.get(id);
    }

    @Override
    public Clarification getClarification(ElementId id) {
        return this.clarificationList.get(id);
    }

    @Override
    public Vector<Account> getAccounts(ClientType.Type type, int inSiteNumber) {
        return this.accountList.getAccounts(type, inSiteNumber);
    }

    @Override
    public Vector<Account> getAccounts(ClientType.Type type) {
        return this.accountList.getAccounts(type);
    }

    @Override
    public boolean isValidLoginAndPassword(ClientId inClientId, String password) {
        return this.accountList.isValidLoginAndPassword(inClientId, password);
    }

    @Override
    public ClientId getLoginClientId(ConnectionHandlerID connectionHandlerID) {
        ClientId clientId = this.localLoginList.getClientId(connectionHandlerID);
        if (clientId == null) {
            clientId = this.remoteLoginList.getClientId(connectionHandlerID);
        }
        return clientId;
    }

    @Override
    public boolean isLoggedIn() {
        return this.localClientId != null;
    }

    @Override
    public boolean isRemoteLoggedIn(ClientId clientId) {
        return this.remoteLoginList.isLoggedIn(clientId);
    }

    @Override
    public boolean isLocalLoggedIn(ClientId clientId) {
        return this.localLoginList.isLoggedIn(clientId);
    }

    @Override
    public Date getLocalLoggedInDate(ClientId clientId) {
        return this.localLoginList.getLoggedInDate(clientId);
    }

    @Override
    public ConnectionHandlerID getConnectionHandleID(ClientId sourceId) {
        ConnectionHandlerID connectionHandlerID = this.localLoginList.getConnectionHandleID(sourceId);
        if (connectionHandlerID == null) {
            connectionHandlerID = this.remoteLoginList.getConnectionHandleID(sourceId);
        }
        return connectionHandlerID;
    }

    @Override
    public ClientId getClientId(ConnectionHandlerID connectionHandlerID) {
        return this.localLoginList.getClientId(connectionHandlerID);
    }

    @Override
    public boolean isConnected(ConnectionHandlerID connectionHandlerID) {
        return this.localConnectionHandlerList.get(connectionHandlerID) != null;
    }

    @Override
    public boolean isConnectedToRemoteSite(ConnectionHandlerID connectionHandlerID) {
        return this.remoteConnectionHandlerList.get(connectionHandlerID) != null;
    }

    @Override
    public ConnectionHandlerID[] getConnectionHandleIDs() {
        ConnectionHandlerID[] localList = this.localConnectionHandlerList.getList();
        ConnectionHandlerID[] remoteList = this.remoteConnectionHandlerList.getList();
        if (localList.length > 0 && remoteList.length > 0) {
            ConnectionHandlerID[] allConnections = new ConnectionHandlerID[localList.length + remoteList.length];
            System.arraycopy(localList, 0, allConnections, 0, localList.length);
            System.arraycopy(remoteList, 0, allConnections, localList.length, remoteList.length);
            return allConnections;
        }
        if (localList.length > 0) {
            return localList;
        }
        return remoteList;
    }

    @Override
    public void removeRemoteLogin(ClientId sourceId) {
        if (this.isRemoteLoggedIn(sourceId)) {
            this.remoteLoginList.remove(sourceId);
        }
        ConnectionHandlerID connectionHandlerID = this.getConnectionHandleID(sourceId);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGOFF, sourceId, connectionHandlerID, "Remote Logoff");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public void removeLogin(ClientId sourceId) {
        if (this.isLocalLoggedIn(sourceId)) {
            this.localLoginList.remove(sourceId);
        } else {
            this.remoteLoginList.remove(sourceId);
        }
        ConnectionHandlerID connectionHandlerID = this.getConnectionHandleID(sourceId);
        LoginEvent loginEvent = new LoginEvent(LoginEvent.Action.LOGOFF, sourceId, connectionHandlerID, "Logoff");
        this.fireLoginListener(loginEvent);
    }

    @Override
    public int getSiteNumber() {
        return this.siteNumber;
    }

    @Override
    public void setSiteNumber(int number) {
        this.siteNumber = number;
    }

    @Override
    public boolean isAllowed(Permission.Type type) {
        return this.isAllowed(this.getClientId(), type);
    }

    @Override
    public boolean isAllowed(ClientId clientId, Permission.Type type) {
        Account account = this.getAccount(clientId);
        if (account == null) {
            return false;
        }
        return account.isAllowed(type);
    }

    @Override
    public ContestTime getContestTime() {
        return this.getContestTime(this.getSiteNumber());
    }

    @Override
    public ContestTime getContestTime(int inSiteNumber) {
        return this.contestTimeList.get(inSiteNumber);
    }

    @Override
    public ContestTime[] getContestTimes() {
        return this.contestTimeList.getList();
    }

    @Override
    public void startContest(int inSiteNumber) {
        ContestTime contestTime = this.getContestTime(inSiteNumber);
        if (contestTime == null) {
            throw new SecurityException("Unable to start clock site " + inSiteNumber + " not found");
        }
        contestTime.startContestClock();
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CLOCK_STARTED, contestTime, inSiteNumber);
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void stopContest(int inSiteNumber) {
        ContestTime contestTime = this.getContestTime(inSiteNumber);
        if (contestTime == null) {
            throw new SecurityException("Unable to stop clock site " + inSiteNumber + " not found");
        }
        contestTime.stopContestClock();
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CLOCK_STOPPED, contestTime, inSiteNumber);
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void addContestTime(ContestTime contestTime) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        this.contestTimeList.add(contestTime);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.ADDED, contestTime, contestTime.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public ClientId[] getLocalLoggedInClients(ClientType.Type type) {
        Enumeration<ClientId> localClients = this.localLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (localClients.hasMoreElements()) {
            ClientId element = localClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    @Override
    public ClientId[] getRemoteLoggedInClients(ClientType.Type type) {
        Enumeration<ClientId> remoteClients = this.remoteLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (remoteClients.hasMoreElements()) {
            ClientId element = remoteClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    @Override
    public ClientId[] getAllLoggedInClients(ClientType.Type type) {
        ClientId element;
        Enumeration<ClientId> localClients = this.localLoginList.getClients(type);
        Enumeration<ClientId> remoteClients = this.remoteLoginList.getClients(type);
        Vector<ClientId> v = new Vector<ClientId>();
        while (localClients.hasMoreElements()) {
            element = localClients.nextElement();
            v.addElement(element);
        }
        while (remoteClients.hasMoreElements()) {
            element = remoteClients.nextElement();
            v.addElement(element);
        }
        return v.toArray(new ClientId[v.size()]);
    }

    public static void info(String s) {
        System.err.println(String.valueOf(Thread.currentThread().getName()) + " " + s);
    }

    @Override
    public Run[] getRuns() {
        return this.runList.getList();
    }

    @Override
    public void runUpdated(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoUpdatedRun) {
        boolean manualReview = this.getProblem(run.getProblemId()).isManualReview();
        this.runList.updateRun(run, judgementRecord, manualReview);
        Run newRun = this.runList.get(run.getElementId());
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, newRun, null, null);
        runEvent.setWhoModifiedRun(whoUpdatedRun);
        this.fireRunListener(runEvent);
    }

    @Override
    public void updateRunStatus(Run run, RunExecutionStatus status, ClientId whoUpdatedRun) {
        RunEvent.Action action = null;
        switch (status) {
            case EXECUTING: {
                action = RunEvent.Action.RUN_EXECUTING;
                break;
            }
            case VALIDATING: {
                action = RunEvent.Action.RUN_VALIDATING;
                break;
            }
            default: {
                action = RunEvent.Action.RUN_COMPILING;
            }
        }
        RunEvent runEvent = new RunEvent(action, run, null, null);
        runEvent.setWhoModifiedRun(whoUpdatedRun);
        this.fireRunListener(runEvent);
    }

    @Override
    public void runNotAvailable(Run run) {
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_NOT_AVIALABLE, run, null, null);
        this.fireRunListener(runEvent);
    }

    @Override
    public Run checkoutRun(Run run, ClientId whoChangedRun, boolean reCheckoutRun, boolean computerJudge) throws RunUnavailableException {
        Hashtable<ElementId, ClientId> hashtable = this.runCheckOutList;
        synchronized (hashtable) {
            boolean canBeCheckedOut;
            ClientId clientId = this.runCheckOutList.get(run.getElementId());
            if (clientId != null) {
                throw new RunUnavailableException("Client " + clientId + " already checked out run " + run.getNumber() + " (site " + run.getSiteNumber() + ")");
            }
            Run newRun = this.runList.get(run.getElementId());
            if (newRun == null) {
                throw new RunUnavailableException("Run " + run.getNumber() + " (site " + run.getSiteNumber() + ") not found");
            }
            boolean bl = canBeCheckedOut = newRun.getStatus().equals((Object)Run.RunStates.NEW) || newRun.getStatus().equals((Object)Run.RunStates.QUEUED_FOR_COMPUTER_JUDGEMENT) || newRun.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW);
            if (reCheckoutRun && run.isJudged()) {
                canBeCheckedOut = true;
            }
            if (canBeCheckedOut) {
                this.runCheckOutList.put(newRun.getElementId(), whoChangedRun);
                newRun.setStatus(Run.RunStates.BEING_JUDGED);
                if (reCheckoutRun) {
                    newRun.setStatus(Run.RunStates.BEING_RE_JUDGED);
                }
                this.runList.updateRun(newRun);
                return this.runList.get(run.getElementId());
            }
            throw new RunUnavailableException("Client " + clientId + " can not checked out run " + run.getNumber() + " (site " + run.getSiteNumber() + ")");
        }
    }

    @Override
    public void updateRun(Run run, ClientId whoChangedRun) {
        this.updateRun(run, null, whoChangedRun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRun(Run run, RunFiles runFiles, ClientId whoChangedRun, RunResultFiles[] runResultFiles) {
        Hashtable<ElementId, ClientId> hashtable;
        boolean unCheckoutRun = false;
        boolean checkOutRun = false;
        switch (run.getStatus()) {
            case CHECKED_OUT: 
            case BEING_JUDGED: 
            case BEING_RE_JUDGED: 
            case HOLD: {
                checkOutRun = true;
                break;
            }
            case NEW: 
            case REJUDGE: 
            case JUDGED: {
                unCheckoutRun = true;
            }
        }
        if (checkOutRun) {
            hashtable = this.runCheckOutList;
            synchronized (hashtable) {
                this.runCheckOutList.put(run.getElementId(), whoChangedRun);
            }
        }
        if (unCheckoutRun) {
            hashtable = this.runCheckOutList;
            synchronized (hashtable) {
                ClientId clientId = this.runCheckOutList.get(run.getElementId());
                if (clientId != null) {
                    this.runCheckOutList.remove(run.getElementId());
                }
            }
        }
        this.runList.updateRun(run);
        if (this.runFilesList.isCacheRunFiles()) {
            this.runFilesList.add(run, runFiles);
        }
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, this.runList.get(run), runFiles, runResultFiles);
        runEvent.setWhoModifiedRun(whoChangedRun);
        if (run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED) || run.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
            runEvent.setDetailedAction(RunEvent.Action.CHECKEDOUT_RUN);
        }
        if (checkOutRun) {
            runEvent.setSentToClientId(whoChangedRun);
        }
        this.fireRunListener(runEvent);
    }

    @Override
    public RunFiles getRunFiles(Run run) {
        return this.runFilesList.getRunFiles(run);
    }

    @Override
    public void addRunJudgement(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoJudgedItId) {
        Exception ex;
        Run theRun = this.runList.get(run);
        ClientId whoCheckedOut = this.runCheckOutList.get(run.getElementId());
        ClientId whoChangedItId = judgementRecord.getJudgerClientId();
        if (whoCheckedOut == null) {
            ex = new Exception("addRunJudgement - not in checkedout list, whoCheckedOut is null ");
            StaticLog.log("Odd that. ", ex);
            InternalContest.info("Exception in log" + ex.getMessage());
        } else if (!whoChangedItId.equals(whoCheckedOut)) {
            if (whoChangedItId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR)) {
                InternalContest.info("Admin updating run " + run);
            } else {
                ex = new Exception("addRunJudgement - who checked out and who it is differ ");
                InternalContest.info("Exception in log" + ex.getMessage());
            }
        }
        boolean manualReview = this.getProblem(theRun.getProblemId()).isManualReview();
        this.runList.updateRun(theRun, judgementRecord, manualReview);
        this.runResultFilesList.add(theRun, judgementRecord, runResultFiles);
        if (whoCheckedOut != null) {
            InternalContest.info("Found checked out by " + whoCheckedOut + " judgement updated by " + judgementRecord.getJudgerClientId());
            this.runCheckOutList.remove(run.getElementId());
        }
        theRun = this.runList.get(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.CHANGED, theRun, null, null);
        this.fireRunListener(runEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRunCheckOut(Run run, ClientId fromId) throws UnableToUncheckoutRunException {
        ClientId whoCheckedOut = this.runCheckOutList.get(run.getElementId());
        if (whoCheckedOut == null) {
            throw new UnableToUncheckoutRunException(fromId + " can not checkout " + run + " not checked out");
        }
        boolean userCheckedOutRun = fromId.equals(whoCheckedOut);
        if (this.isAdministrator(fromId) && this.isAllowed(fromId, Permission.Type.EDIT_RUN)) {
            userCheckedOutRun = true;
        }
        if (!userCheckedOutRun) {
            throw new UnableToUncheckoutRunException(fromId + " can not checkout " + run + " checked out to " + whoCheckedOut);
        }
        Run theRun = this.getRun(run.getElementId());
        if (theRun.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
            if (theRun.getComputerJudgementRecord() == null) {
                run.setStatus(Run.RunStates.NEW);
            } else {
                run.setStatus(Run.RunStates.MANUAL_REVIEW);
            }
        } else if (theRun.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
            run.setStatus(Run.RunStates.JUDGED);
        }
        Hashtable<ElementId, ClientId> hashtable = this.runCheckOutList;
        synchronized (hashtable) {
            this.runCheckOutList.remove(run.getElementId());
        }
        this.runList.updateRun(run);
        theRun = this.runList.get(run);
        RunEvent runEvent = new RunEvent(RunEvent.Action.RUN_AVAILABLE, theRun, null, null);
        this.fireRunListener(runEvent);
    }

    protected boolean isAdministrator(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    @Override
    public ClientId getRunCheckedOutBy(Run run) {
        return this.runCheckOutList.get(run.getElementId());
    }

    @Override
    public ElementId[] getRunIdsCheckedOutBy(ClientId judgeID) {
        Vector<ElementId> v = new Vector<ElementId>();
        Enumeration<ElementId> runIDs = this.runCheckOutList.keys();
        while (runIDs.hasMoreElements()) {
            ElementId runId = runIDs.nextElement();
            ClientId cID = this.runCheckOutList.get(runId);
            if (!cID.equals(judgeID)) continue;
            v.addElement(runId);
        }
        return v.toArray(new ElementId[v.size()]);
    }

    @Override
    public Clarification[] getClarifications() {
        return this.clarificationList.getList();
    }

    @Override
    public void passwordChanged(boolean success, ClientId clientId, String message) {
        PasswordChangeEvent.Action action = PasswordChangeEvent.Action.PASSWORD_NOT_CHANGED;
        if (success) {
            action = PasswordChangeEvent.Action.PASSWORD_CHANGED;
        }
        PasswordChangeEvent passwordChangeEvent = new PasswordChangeEvent(clientId, action, message);
        this.firePasswordChangeListener(passwordChangeEvent);
    }

    private void firePasswordChangeListener(PasswordChangeEvent passwordChangeEvent) {
        int i = 0;
        while (i < this.changePasswordListenerList.size()) {
            if (passwordChangeEvent.getAction() == PasswordChangeEvent.Action.PASSWORD_CHANGED) {
                this.changePasswordListenerList.elementAt(i).passwordChanged(passwordChangeEvent);
            } else if (passwordChangeEvent.getAction() == PasswordChangeEvent.Action.PASSWORD_NOT_CHANGED) {
                this.changePasswordListenerList.elementAt(i).passwordNotChanged(passwordChangeEvent);
            } else {
                throw new IllegalArgumentException("Unhandled  ");
            }
            ++i;
        }
    }

    @Override
    public void updateLanguage(Language language) {
        this.languageList.update(language);
        this.languageDisplayList.update(language);
        LanguageEvent languageEvent = new LanguageEvent(LanguageEvent.Action.CHANGED, language);
        this.fireLanguageListener(languageEvent);
    }

    @Override
    public void updateProblem(Problem problem) {
        this.problemList.update(problem);
        this.problemDisplayList.update(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.CHANGED, problem);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void updateContestTime(ContestTime contestTime, int inSiteNumber) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        if (inSiteNumber != contestTime.getSiteNumber()) {
            throw new IllegalArgumentException("contestTime site number (" + contestTime + ") does not match " + inSiteNumber);
        }
        this.contestTimeList.update(contestTime);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CHANGED, contestTime, contestTime.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void updateContestTime(ContestTime contestTime) {
        if (contestTime == null) {
            throw new IllegalArgumentException("contestTime is null");
        }
        this.contestTimeList.update(contestTime);
        ContestTimeEvent contestTimeEvent = new ContestTimeEvent(ContestTimeEvent.Action.CHANGED, contestTime, contestTime.getSiteNumber());
        this.fireContestTimeListener(contestTimeEvent);
    }

    @Override
    public void updateJudgement(Judgement judgement) {
        this.judgementList.update(judgement);
        JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.CHANGED, judgement);
        this.fireJudgementListener(judgementEvent);
    }

    @Override
    public void changeSite(Site site) {
        this.siteList.update(site);
        SiteEvent siteEvent = new SiteEvent(SiteEvent.Action.CHANGED, site);
        this.fireSiteListener(siteEvent);
    }

    @Override
    public void updateAccount(Account account) {
        this.accountList.update(account);
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.CHANGED, account);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public void updateAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.accountList.update(account);
            ++n2;
        }
        AccountEvent accountEvent = new AccountEvent(AccountEvent.Action.CHANGED_ACCOUNTS, accounts);
        this.fireAccountListener(accountEvent);
    }

    @Override
    public Language getLanguage(ElementId elementId) {
        return (Language)this.languageList.get(elementId);
    }

    @Override
    public ContestTime getContestTime(ElementId elementId) {
        return this.contestTimeList.get(elementId);
    }

    @Override
    public Problem getProblem(ElementId elementId) {
        if (this.generalProblem != null && this.generalProblem.getElementId().equals(elementId)) {
            return this.generalProblem;
        }
        return (Problem)this.problemList.get(elementId);
    }

    @Override
    public Judgement getJudgement(ElementId elementId) {
        return (Judgement)this.judgementList.get(elementId);
    }

    @Override
    public Account getAccount(ClientId inClientId) {
        return this.accountList.getAccount(inClientId);
    }

    @Override
    public Site getSite(int number) {
        Site[] sites;
        Site[] siteArray = sites = this.siteList.getList();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            if (site.getSiteNumber() == number) {
                return site;
            }
            ++n2;
        }
        return null;
    }

    private void fireClarificationListener(ClarificationEvent clarificationEvent) {
        int i = 0;
        while (i < this.clarificationListenerList.size()) {
            if (clarificationEvent.getAction() == ClarificationEvent.Action.ADDED) {
                this.clarificationListenerList.elementAt(i).clarificationAdded(clarificationEvent);
            } else if (clarificationEvent.getAction() == ClarificationEvent.Action.DELETED) {
                this.clarificationListenerList.elementAt(i).clarificationRemoved(clarificationEvent);
            } else {
                this.clarificationListenerList.elementAt(i).clarificationChanged(clarificationEvent);
            }
            ++i;
        }
    }

    @Override
    public void addClarification(Clarification clarification) {
        this.clarificationList.add(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.ADDED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void addClarification(Clarification clarification, ClientId whoCheckedOutId) {
        this.clarificationList.add(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHECKEDOUT_CLARIFICATION, clarification);
        clarificationEvent.setSentToClientId(whoCheckedOutId);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void removeClarification(Clarification clarification) {
        this.clarificationList.delete(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.DELETED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void changeClarification(Clarification clarification) {
        this.clarificationList.updateClarification(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CHANGED, clarification);
        this.fireClarificationListener(clarificationEvent);
    }

    @Override
    public void connectionEstablished(ConnectionHandlerID connectionHandlerID) {
        this.connectionEstablished(connectionHandlerID, new Date());
    }

    @Override
    public void connectionEstablished(ConnectionHandlerID connectionHandlerID, Date connectDate) {
        this.localConnectionHandlerList.add(connectionHandlerID, connectDate);
        ConnectionEvent connectionEvent = new ConnectionEvent(ConnectionEvent.Action.ESTABLISHED, connectionHandlerID);
        this.fireConnectionListener(connectionEvent);
    }

    @Override
    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        if (connectionHandlerID != null) {
            this.localConnectionHandlerList.remove(connectionHandlerID);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(ConnectionEvent.Action.DROPPED, connectionHandlerID);
        this.fireConnectionListener(connectionEvent);
    }

    @Override
    public ConnectionHandlerID[] getConnectionHandlerIDs() {
        return this.localConnectionHandlerList.getList();
    }

    @Override
    public Clarification[] getClarifications(ClientId clientId) {
        Vector<Clarification> clientClarifications = new Vector<Clarification>();
        Enumeration<Clarification> enumeration = this.clarificationList.getClarList();
        while (enumeration.hasMoreElements()) {
            Clarification clarification = enumeration.nextElement();
            if (!clarification.isSendToAll() && !clientId.equals(clarification.getSubmitter())) continue;
            clientClarifications.add(clarification);
        }
        return clientClarifications.toArray(new Clarification[clientClarifications.size()]);
    }

    @Override
    public Run[] getRuns(ClientId clientId) {
        Vector<Run> clientRuns = new Vector<Run>();
        Enumeration<Run> enumeration = this.runList.getRunList();
        while (enumeration.hasMoreElements()) {
            Run run = enumeration.nextElement();
            if (!clientId.equals(run.getSubmitter())) continue;
            clientRuns.add(run);
        }
        return clientRuns.toArray(new Run[clientRuns.size()]);
    }

    @Override
    public void addProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        this.problemDisplayList.add(problem);
        this.problemList.add(problem);
        if (problemDataFiles != null) {
            this.problemDataFilesList.add(problemDataFiles);
        }
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.ADDED, problem, problemDataFiles);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public void updateProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        this.problemList.update(problem);
        this.problemDataFilesList.update(problemDataFiles);
        this.problemDisplayList.update(problem);
        ProblemEvent problemEvent = new ProblemEvent(ProblemEvent.Action.CHANGED, problem, problemDataFiles);
        this.fireProblemListener(problemEvent);
    }

    @Override
    public ProblemDataFiles getProblemDataFile(Problem problem) {
        return (ProblemDataFiles)this.problemDataFilesList.get(problem);
    }

    @Override
    public ProblemDataFiles[] getProblemDataFiles() {
        return this.problemDataFilesList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelClarificationCheckOut(Clarification clarification, ClientId whoCancelledIt) {
        this.clarificationList.updateClarification(clarification, Clarification.ClarificationStates.NEW, whoCancelledIt);
        Hashtable<ElementId, ClientId> hashtable = this.clarCheckOutList;
        synchronized (hashtable) {
            this.clarCheckOutList.remove(clarification.getElementId());
        }
        Clarification theClarification = this.clarificationList.get(clarification);
        ClarificationEvent clarificationEvent = new ClarificationEvent(ClarificationEvent.Action.CLARIFICATION_AVIALABLE, theClarification);
        this.fireClarificationListener(clarificationEvent);
    }

    private void fireClientSettingsListener(ClientSettingsEvent clientSettingsEvent) {
        int i = 0;
        while (i < this.clientSettingsListenerList.size()) {
            if (clientSettingsEvent.getAction() == ClientSettingsEvent.Action.ADDED) {
                this.clientSettingsListenerList.elementAt(i).clientSettingsAdded(clientSettingsEvent);
            } else if (clientSettingsEvent.getAction() == ClientSettingsEvent.Action.DELETED) {
                this.clientSettingsListenerList.elementAt(i).clientSettingsRemoved(clientSettingsEvent);
            } else {
                this.clientSettingsListenerList.elementAt(i).clientSettingsChanged(clientSettingsEvent);
            }
            ++i;
        }
    }

    @Override
    public void addClientSettings(ClientSettings clientSettings) {
        this.clientSettingsList.add(clientSettings);
        ClientSettingsEvent clientSettingsEvent = new ClientSettingsEvent(ClientSettingsEvent.Action.ADDED, clientSettings.getClientId(), clientSettings);
        this.fireClientSettingsListener(clientSettingsEvent);
    }

    @Override
    public ClientSettings getClientSettings() {
        return this.clientSettingsList.get(this.getClientId());
    }

    @Override
    public ClientSettings getClientSettings(ClientId clientId) {
        return this.clientSettingsList.get(clientId);
    }

    @Override
    public ClientSettings[] getClientSettingsList() {
        return this.clientSettingsList.getList();
    }

    @Override
    public void updateClientSettings(ClientSettings clientSettings) {
        this.clientSettingsList.update(clientSettings);
        ClientSettingsEvent clientSettingsEvent = new ClientSettingsEvent(ClientSettingsEvent.Action.CHANGED, clientSettings.getClientId(), clientSettings);
        this.fireClientSettingsListener(clientSettingsEvent);
    }

    @Override
    public void addClientSettingsListener(IClientSettingsListener clientSettingsListener) {
        this.clientSettingsListenerList.addElement(clientSettingsListener);
    }

    @Override
    public void removeClientSettingsListener(IClientSettingsListener clientSettingsListener) {
        this.clientSettingsListenerList.remove(clientSettingsListener);
    }

    private void fireContestInformationListener(ContestInformationEvent contestInformationEvent) {
        int i = 0;
        while (i < this.contestInformationListenerList.size()) {
            if (contestInformationEvent.getAction() == ContestInformationEvent.Action.ADDED) {
                this.contestInformationListenerList.elementAt(i).contestInformationAdded(contestInformationEvent);
            } else if (contestInformationEvent.getAction() == ContestInformationEvent.Action.DELETED) {
                this.contestInformationListenerList.elementAt(i).contestInformationRemoved(contestInformationEvent);
            } else {
                this.contestInformationListenerList.elementAt(i).contestInformationChanged(contestInformationEvent);
            }
            ++i;
        }
    }

    @Override
    public void addContestInformation(ContestInformation inContestInformation) {
        this.contestInformation = inContestInformation;
        ContestInformationEvent contestInformationEvent = new ContestInformationEvent(ContestInformationEvent.Action.ADDED, this.contestInformation);
        this.fireContestInformationListener(contestInformationEvent);
    }

    @Override
    public void updateContestInformation(ContestInformation inContestInformation) {
        this.contestInformation = inContestInformation;
        ContestInformationEvent contestInformationEvent = new ContestInformationEvent(ContestInformationEvent.Action.CHANGED, this.contestInformation);
        this.fireContestInformationListener(contestInformationEvent);
    }

    @Override
    public void addContestInformationListener(IContestInformationListener contestInformationListener) {
        this.contestInformationListenerList.addElement(contestInformationListener);
    }

    @Override
    public void removeContestInformationListener(IContestInformationListener contestInformationListener) {
        this.contestInformationListenerList.remove(contestInformationListener);
    }

    @Override
    public ContestInformation getContestInformation() {
        return this.contestInformation;
    }

    @Override
    public void setJudgementList(Judgement[] judgements) {
        Judgement judgement;
        Judgement[] judgementArray = this.judgementDisplayList.getList();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            judgement = judgementArray[n2];
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.DELETED, judgement);
            this.fireJudgementListener(judgementEvent);
            ++n2;
        }
        this.judgementDisplayList = new JudgementDisplayList();
        judgementArray = judgements;
        n = judgements.length;
        n2 = 0;
        while (n2 < n) {
            judgement = judgementArray[n2];
            Judgement judgementFromList = (Judgement)this.judgementList.get(judgement.getElementId());
            if (judgementFromList == null) {
                this.judgementList.add(judgement);
            }
            this.judgementDisplayList.add(judgement);
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.ADDED, judgement);
            this.fireJudgementListener(judgementEvent);
            ++n2;
        }
    }

    @Override
    public void removeJudgement(Judgement judgement) {
        int idx = this.judgementDisplayList.indexOf(judgement);
        if (idx != -1) {
            this.judgementDisplayList.remove(idx);
            JudgementEvent judgementEvent = new JudgementEvent(JudgementEvent.Action.DELETED, judgement);
            this.fireJudgementListener(judgementEvent);
        }
    }

    @Override
    public int getMaxRetryMSecs() {
        return 700;
    }

    @Override
    public int getMaxConnectionRetries() {
        return 5;
    }

    @Override
    public void addBalloonSettings(BalloonSettings balloonSettings) {
        this.balloonSettingsList.add(balloonSettings);
        BalloonSettingsEvent balloonSettingsEvent = new BalloonSettingsEvent(BalloonSettingsEvent.Action.ADDED, balloonSettings);
        this.fireBalloonSettingsListener(balloonSettingsEvent);
    }

    @Override
    public void updateBalloonSettings(BalloonSettings balloonSettings) {
        this.balloonSettingsList.update(balloonSettings);
        BalloonSettingsEvent balloonSettingsEvent = new BalloonSettingsEvent(BalloonSettingsEvent.Action.CHANGED, balloonSettings);
        this.fireBalloonSettingsListener(balloonSettingsEvent);
    }

    @Override
    public BalloonSettings getBalloonSettings(int siteNum) {
        BalloonSettings[] balloonSettingsArray = this.balloonSettingsList.getList();
        int n = balloonSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            BalloonSettings balloonSettings = balloonSettingsArray[n2];
            if (siteNum == balloonSettings.getSiteNumber()) {
                return balloonSettings;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public BalloonSettings[] getBalloonSettings() {
        return this.balloonSettingsList.getList();
    }

    @Override
    public BalloonSettings getBalloonSettings(ElementId elementId) {
        return this.balloonSettingsList.get(elementId);
    }

    @Override
    public void addGroup(Group group) {
        this.groupDisplayList.add(group);
        this.groupList.add(group);
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.ADDED, group);
        this.fireGroupListener(groupEvent);
    }

    private void fireGroupListener(GroupEvent groupEvent) {
        int i = 0;
        while (i < this.groupListenerList.size()) {
            if (groupEvent.getAction() == GroupEvent.Action.ADDED) {
                this.groupListenerList.elementAt(i).groupAdded(groupEvent);
            } else if (groupEvent.getAction() == GroupEvent.Action.DELETED) {
                this.groupListenerList.elementAt(i).groupRemoved(groupEvent);
            } else {
                this.groupListenerList.elementAt(i).groupChanged(groupEvent);
            }
            ++i;
        }
    }

    @Override
    public void removeGroup(Group group) {
        int idx = this.groupDisplayList.indexOf(group);
        if (idx != -1) {
            this.groupDisplayList.remove(idx);
            GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.DELETED, group);
            this.fireGroupListener(groupEvent);
        }
    }

    @Override
    public void updateGroup(Group group) {
        this.groupList.update(group);
        this.groupDisplayList.update(group);
        GroupEvent groupEvent = new GroupEvent(GroupEvent.Action.CHANGED, group);
        this.fireGroupListener(groupEvent);
    }

    @Override
    public Group[] getGroups() {
        return this.groupDisplayList.getList();
    }

    @Override
    public void addGroupListener(IGroupListener groupListener) {
        this.groupListenerList.addElement(groupListener);
    }

    @Override
    public void removeGroupListener(IGroupListener groupListener) {
        this.groupListenerList.remove(groupListener);
    }

    @Override
    public Group getGroup(ElementId elementId) {
        return (Group)this.groupList.get(elementId);
    }

    @Override
    public Problem getGeneralProblem() {
        return this.generalProblem;
    }

    @Override
    public void setGeneralProblem(Problem generalProblem) {
        this.generalProblem = generalProblem;
    }

    @Override
    public Clarification checkoutClarification(Clarification clar, ClientId whoChangedClar) throws ClarificationUnavailableException {
        Hashtable<ElementId, ClientId> hashtable = this.clarCheckOutList;
        synchronized (hashtable) {
            ClientId clientId = this.clarCheckOutList.get(clar.getElementId());
            if (clientId != null) {
                throw new ClarificationUnavailableException("Client " + clientId + " already checked out clar " + clar.getNumber() + " (site " + clar.getSiteNumber() + ")");
            }
            Clarification newClar = this.clarificationList.get(clar.getElementId());
            if (newClar == null) {
                throw new ClarificationUnavailableException("Run " + clar.getNumber() + " (site " + clar.getSiteNumber() + ") not found");
            }
            if (newClar.getState().equals((Object)Clarification.ClarificationStates.NEW)) {
                this.clarCheckOutList.put(newClar.getElementId(), whoChangedClar);
                newClar.setState(Clarification.ClarificationStates.BEING_ANSWERED);
                newClar.setWhoCheckedItOutId(whoChangedClar);
                this.clarificationList.updateClarification(newClar);
                return this.clarificationList.get(clar.getElementId());
            }
            throw new ClarificationUnavailableException("Client " + clientId + " can not checked out clar " + clar.getNumber() + " (site " + clar.getSiteNumber() + ")");
        }
    }

    @Override
    public void newSecurityMessage(ClientId clientId, String message, String eventName, ContestSecurityException contestSecurityException) {
        this.securityMessageHandler.newMessage(clientId, eventName, message, contestSecurityException);
    }

    @Override
    public void addSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageHandler.addSecurityMessageListener(securityMessageListener);
    }

    @Override
    public void removeSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageHandler.addSecurityMessageListener(securityMessageListener);
    }

    @Override
    public RunResultFiles[] getRunResultFiles(Run run) {
        return this.runResultFilesList.getRunResultFiles(run);
    }

    @Override
    public void resetData() {
        this.runFilesList.clearCache();
    }

    @Override
    public boolean isSendAdditionalRunStatusMessages() {
        return this.contestInformation.isSendAdditionalRunStatusInformation();
    }
}

