/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -8373119928926075959L;
    private Hashtable<Run.RunStates, Date> runStateHash = new Hashtable();
    private boolean filteringRunStates = false;
    private boolean filteringElapsedTime = false;
    private long startElapsedTime = -1L;
    private long endElapsedTime = -1L;
    private Hashtable<Clarification.ClarificationStates, Date> clarificationStateHash = new Hashtable();
    private boolean filteringClarificationStates = false;
    private Hashtable<ElementId, Date> problemIdHash = new Hashtable();
    private boolean filteringProblems = false;
    private Hashtable<ElementId, Date> languageIdHash = new Hashtable();
    private Hashtable<Integer, Date> siteIdHash = new Hashtable();
    private boolean filteringLanguages = false;
    private boolean filteringSites = false;
    private Hashtable<ElementId, Date> judgementIdHash = new Hashtable();
    private boolean filteringJudgements = false;
    private Hashtable<ClientId, Date> clientIdHash = new Hashtable();
    private Hashtable<ClientType.Type, Date> clientTypeHash = new Hashtable();
    private boolean filteringAccounts = false;
    private boolean thisSiteOnly;
    private int filterSiteNumber = 0;
    private boolean filterEnabled = true;

    private ElementId getJudgementId(Run run) {
        JudgementRecord judgementRecord = run.getJudgementRecord();
        if (judgementRecord != null) {
            return judgementRecord.getJudgementId();
        }
        return null;
    }

    public boolean matches(Run run) {
        if (this.filterEnabled) {
            ElementId judgementElementId = this.getJudgementId(run);
            return this.matchesSites(run) && this.matchesAccount(run.getSubmitter()) && this.matchesRunState(run.getStatus()) && this.matchesProblem(run.getProblemId()) && this.matchesLanguage(run.getLanguageId()) && this.matchesJudgement(judgementElementId) && this.matchesElapsedTimeSubmission(run);
        }
        return true;
    }

    public boolean matches(Clarification clarification) {
        if (this.filterEnabled) {
            return this.matchesSites(clarification) && this.matchesAccount(clarification.getSubmitter()) && this.matchesClarificationState(clarification.getState()) && this.matchesProblem(clarification.getProblemId()) && this.matchesLanguage(clarification.getLanguageId()) && this.matchesElapsedTimeSubmission(clarification);
        }
        return true;
    }

    public boolean matches(ClientId clientId) {
        if (this.filterEnabled) {
            return this.matchesSites(clientId) && this.matchesAccount(clientId);
        }
        return true;
    }

    public boolean matchesSites(ClientId clientId) {
        return this.matchesSites(clientId.getSiteNumber());
    }

    public boolean isThisSiteOnly() {
        return this.thisSiteOnly;
    }

    public void setThisSiteOnly(boolean thisSiteOnly) {
        this.thisSiteOnly = thisSiteOnly;
    }

    public void setSiteNumber(int siteNumber) {
        this.filterSiteNumber = siteNumber;
    }

    public int getSiteNumber() {
        return this.filterSiteNumber;
    }

    public void setUsingJudgementFilter(boolean turnOn) {
        this.filteringJudgements = turnOn;
    }

    public boolean isFilteringJudgements() {
        return this.filteringJudgements;
    }

    public void addJudgement(Judgement judgement) {
        this.addJudgement(judgement.getElementId());
    }

    private void addJudgement(ElementId elementId) {
        this.filteringJudgements = true;
        this.judgementIdHash.put(elementId, new Date());
    }

    public boolean matchesJudgement(Judgement judgement) {
        return this.matchesJudgement(judgement.getElementId());
    }

    public boolean matchesJudgement(ElementId judgementId) {
        if (this.filteringJudgements) {
            if (judgementId == null) {
                return false;
            }
            return this.judgementIdHash.containsKey(judgementId);
        }
        return true;
    }

    public void setUsingProblemFilter(boolean turnOn) {
        this.filteringProblems = turnOn;
    }

    public boolean isFilteringProblems() {
        return this.filteringProblems;
    }

    public void addProblem(Problem problem) {
        this.addProblem(problem.getElementId());
    }

    private void addProblem(ElementId elementId) {
        this.problemIdHash.put(elementId, new Date());
        this.filteringProblems = true;
    }

    public boolean matchesProblem(Problem problem) {
        return this.matchesProblem(problem.getElementId());
    }

    public boolean matchesProblem(ElementId problemId) {
        if (this.filteringProblems) {
            return this.problemIdHash.containsKey(problemId);
        }
        return true;
    }

    public void setUsingLanguageFilter(boolean turnOn) {
        this.filteringLanguages = turnOn;
    }

    public void setUsingSitesFilter(boolean turnOn) {
        this.filteringSites = turnOn;
    }

    public boolean isFilteringSites() {
        return this.filteringSites;
    }

    public boolean isFilteringLanguages() {
        return this.filteringLanguages;
    }

    public void addLanguage(Language language) {
        this.addLanguage(language.getElementId());
    }

    private void addLanguage(ElementId elementId) {
        this.languageIdHash.put(elementId, new Date());
        this.filteringLanguages = true;
    }

    public boolean matchesLanguage(Language language) {
        return this.matchesLanguage(language.getElementId());
    }

    public boolean matchesLanguage(ElementId languageId) {
        if (this.filteringLanguages) {
            return this.languageIdHash.containsKey(languageId);
        }
        return true;
    }

    public void addSite(Site site) {
        this.addSite(site.getSiteNumber());
    }

    public void addSite(int siteNumber) {
        this.siteIdHash.put(new Integer(siteNumber), new Date());
        this.filteringSites = true;
    }

    private boolean matchesSites(ISubmission submission) {
        return this.matchesSites(submission.getSiteNumber());
    }

    private boolean matchesSites(int siteNumber) {
        if (this.filteringSites) {
            return this.siteIdHash.containsKey(new Integer(siteNumber));
        }
        return true;
    }

    public boolean matchesSite(Site site) {
        return this.matchesSites(site.getSiteNumber());
    }

    public boolean matchesAccount(Account account) {
        if (this.filteringAccounts) {
            if (this.matchesAccount(account.getClientId())) {
                return true;
            }
            return this.matchesClientType(account.getClientId().getClientType());
        }
        return true;
    }

    private boolean matchesClientType(ClientType.Type type) {
        if (this.filteringAccounts) {
            return this.clientTypeHash.containsKey((Object)type);
        }
        return false;
    }

    public boolean matchesAccount(ClientId clientId) {
        if (this.filteringAccounts) {
            if (this.matchesSites(clientId)) {
                return this.clientIdHash.containsKey(clientId);
            }
            return false;
        }
        return this.matchesSites(clientId);
    }

    public void clearJudgementList() {
        this.filteringJudgements = false;
        this.judgementIdHash = new Hashtable();
    }

    public void clearAccountList() {
        this.filteringAccounts = false;
        this.clientIdHash = new Hashtable();
    }

    public void clearProblemList() {
        this.filteringProblems = false;
        this.problemIdHash = new Hashtable();
    }

    public void clearLanguageList() {
        this.filteringLanguages = false;
        this.languageIdHash = new Hashtable();
    }

    public void clearSiteList() {
        this.filteringSites = false;
        this.siteIdHash = new Hashtable();
    }

    public void removeSite(Site site) {
        if (this.siteIdHash.containsKey(site.getElementId())) {
            this.siteIdHash.remove(site.getElementId());
        }
    }

    public void removeProblem(Problem problem) {
        if (this.problemIdHash.containsKey(problem.getElementId())) {
            this.problemIdHash.remove(problem.getElementId());
        }
    }

    public ElementId[] getJudgementIdList() {
        ElementId[] elementIds = new ElementId[this.judgementIdHash.size()];
        Enumeration<ElementId> enumeration = this.judgementIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ElementId[] getProblemIdList() {
        ElementId[] elementIds = new ElementId[this.problemIdHash.size()];
        Enumeration<ElementId> enumeration = this.problemIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ElementId[] getLanguageIdList() {
        ElementId[] elementIds = new ElementId[this.languageIdHash.size()];
        Enumeration<ElementId> enumeration = this.languageIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ElementId element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public Integer[] getSiteIdList() {
        Integer[] elementIds = new Integer[this.siteIdHash.size()];
        Enumeration<Integer> enumeration = this.siteIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Integer element;
            elementIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return elementIds;
    }

    public ClientId[] getAccountList() {
        ClientId[] clientIds = new ClientId[this.clientIdHash.size()];
        Enumeration<ClientId> enumeration = this.clientIdHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ClientId element;
            clientIds[i] = element = enumeration.nextElement();
            ++i;
        }
        return clientIds;
    }

    public void setUsingRunStatesFilter(boolean turnOn) {
        this.filteringRunStates = turnOn;
    }

    public boolean isFilteringRunStates() {
        return this.filteringRunStates;
    }

    public void addAccount(Account account) {
        this.addAccount(account.getClientId());
    }

    public void addAccount(ClientId clientId) {
        this.filteringAccounts = true;
        this.clientIdHash.put(clientId, new Date());
    }

    public void addAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.addAccount(account);
            ++n2;
        }
    }

    public void removeAccount(Account account) {
        if (this.clientIdHash.get(account.getClientId()) != null) {
            this.clientIdHash.remove(account.getClientId());
        }
    }

    public void removeAccounts(Account[] accounts) {
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            this.removeAccount(account);
            ++n2;
        }
    }

    public void addClientType(ClientType.Type type) {
        this.filteringAccounts = true;
        this.clientTypeHash.put(type, new Date());
    }

    public void addRunState(Run.RunStates runStates) {
        this.runStateHash.put(runStates, new Date());
        this.filteringRunStates = true;
    }

    public boolean matchesRunState(Run.RunStates runStates) {
        if (this.filteringRunStates) {
            return this.runStateHash.containsKey((Object)runStates);
        }
        return true;
    }

    public boolean matchesElapsedTime(Run run) {
        return this.matchesElapsedTimeSubmission(run);
    }

    public boolean matchesElapsedTime(Clarification clarification) {
        return this.matchesElapsedTimeSubmission(clarification);
    }

    protected boolean matchesElapsedTimeSubmission(ISubmission submission) {
        if (this.filteringElapsedTime) {
            long elapsedTime = submission.getElapsedMins();
            if (this.startElapsedTime != -1L && elapsedTime < this.startElapsedTime) {
                return false;
            }
            return this.endElapsedTime == -1L || elapsedTime <= this.endElapsedTime;
        }
        return true;
    }

    public void clearRunStatesList() {
        this.filteringRunStates = false;
        this.runStateHash = new Hashtable();
    }

    public void removeRunState(Run.RunStates runStates) {
        if (this.runStateHash.containsKey((Object)runStates)) {
            this.runStateHash.remove((Object)runStates);
        }
    }

    public void removeClarificationStates(Clarification.ClarificationStates clarificationStates) {
        if (this.clarificationStateHash.containsKey((Object)clarificationStates)) {
            this.clarificationStateHash.remove((Object)clarificationStates);
        }
    }

    public Clarification.ClarificationStates[] getClarificationStatesList() {
        Clarification.ClarificationStates[] clarificationStates = new Clarification.ClarificationStates[this.clarificationStateHash.size()];
        Enumeration<Clarification.ClarificationStates> enumeration = this.clarificationStateHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            clarificationStates[i] = enumeration.nextElement();
            ++i;
        }
        return clarificationStates;
    }

    public Run.RunStates[] getRunStates() {
        Run.RunStates[] runStates = new Run.RunStates[this.runStateHash.size()];
        Enumeration<Run.RunStates> enumeration = this.runStateHash.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            runStates[i] = enumeration.nextElement();
            ++i;
        }
        return runStates;
    }

    public boolean matchesClarificationState(Clarification.ClarificationStates clarificationStates) {
        if (this.filteringClarificationStates) {
            return this.clarificationStateHash.containsKey((Object)clarificationStates);
        }
        return true;
    }

    public void addClarificationState(Clarification.ClarificationStates clarificationStates) {
        this.clarificationStateHash.put(clarificationStates, new Date());
        this.filteringClarificationStates = true;
    }

    public void clearClarificationStateList() {
        this.filteringClarificationStates = false;
        this.clarificationStateHash = new Hashtable();
    }

    public String toString() {
        if (this.filterEnabled) {
            String filterInfo = "Filter ON";
            if (this.thisSiteOnly || this.filteringSites) {
                filterInfo = String.valueOf(filterInfo) + " Site(s) ";
            }
            if (this.filteringProblems) {
                filterInfo = String.valueOf(filterInfo) + " problem(s) ";
            }
            if (this.filteringJudgements) {
                filterInfo = String.valueOf(filterInfo) + " judgement(s) ";
            }
            if (this.filteringLanguages) {
                filterInfo = String.valueOf(filterInfo) + " language(s) ";
            }
            if (this.filteringRunStates) {
                filterInfo = String.valueOf(filterInfo) + " run state(s)";
            }
            if (this.filteringClarificationStates) {
                filterInfo = String.valueOf(filterInfo) + " clar state(s)";
            }
            if (this.filteringAccounts) {
                filterInfo = String.valueOf(filterInfo) + " account(s))";
            }
            return filterInfo;
        }
        return "";
    }

    public long getStartElapsedTime() {
        return this.startElapsedTime;
    }

    public void setStartElapsedTime(long startElapsedTime) {
        this.filteringElapsedTime = true;
        this.startElapsedTime = startElapsedTime;
    }

    public long getEndElapsedTime() {
        return this.endElapsedTime;
    }

    public void setEndElapsedTime(long endElapsedTime) {
        this.filteringElapsedTime = true;
        this.endElapsedTime = endElapsedTime;
    }

    public boolean isFilteringElapsedTime() {
        return this.filteringElapsedTime;
    }

    public void setFilteringElapsedTime(boolean filteringElapsedTime) {
        this.filteringElapsedTime = filteringElapsedTime;
    }

    public boolean isFilteringAccounts() {
        return this.filteringAccounts;
    }

    public void setFilteringAccounts(boolean filteringAccounts) {
        this.filteringAccounts = filteringAccounts;
    }

    public void setFilterOff() {
        this.filterEnabled = false;
    }

    public void setFilter(boolean filterOn) {
        this.filterEnabled = filterOn;
    }

    public void setFilterOn() {
        this.filterEnabled = true;
    }

    public boolean isFilterOn() {
        if (this.filterEnabled) {
            return this.filteringSites || this.filteringAccounts || this.filteringClarificationStates || this.filteringProblems || this.filteringJudgements || this.filteringLanguages || this.filteringElapsedTime || this.filteringRunStates || this.thisSiteOnly;
        }
        return false;
    }

    public boolean isFilteringClarificationStates() {
        return this.filteringClarificationStates;
    }

    public void clearElapsedTime() {
        this.startElapsedTime = -1L;
        this.endElapsedTime = -1L;
        this.filteringElapsedTime = false;
    }

    public int countRuns(Run[] runs) {
        int count = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (this.matches(run)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int countClarifications(Clarification[] clarifications) {
        int count = 0;
        Clarification[] clarificationArray = clarifications;
        int n = clarifications.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if (this.matches(clarification)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int countAccounts(Account[] accounts) {
        int count = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (this.matchesAccount(account)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int countClientIds(ClientId[] clientIds) {
        int count = 0;
        ClientId[] clientIdArray = clientIds;
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            if (this.matchesAccount(clientId)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

