/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Site;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ConfigurationIO {
    private String directoryName = "db";

    private ConfigurationIO(String dirname) {
        this.directoryName = dirname;
        Utilities.insureDir(dirname);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public ConfigurationIO(int siteNumber) {
        this("db." + siteNumber);
    }

    public boolean loadFromDisk(int siteNumber, IInternalContest contest, Log log) {
        Configuration configuration = new Configuration();
        try {
            if (configuration.loadFromDisk(this.getFileName())) {
                int n;
                int n2;
                IElementObject[] iElementObjectArray;
                ConfigKeys key = ConfigKeys.SITE_NUMBER;
                if (configuration.containsKey(key)) {
                    Integer diskSiteNumber = (Integer)configuration.get(key.toString());
                    if (diskSiteNumber != siteNumber) {
                        System.err.println("FATAL ERROR Attempted to load site " + siteNumber + " from Site " + diskSiteNumber);
                        log.info("FATAL ERROR Attempted to load site " + siteNumber + " from Site " + diskSiteNumber);
                        System.exit(22);
                    }
                    contest.setSiteNumber(diskSiteNumber);
                    log.info("Loading site number " + diskSiteNumber);
                } else {
                    System.err.println("WARNING Attempted to load site " + siteNumber + " but key " + (Object)((Object)ConfigKeys.SITE_NUMBER) + " not found");
                    log.info("WARNING Attempted to load site " + siteNumber + " but key " + (Object)((Object)ConfigKeys.SITE_NUMBER) + " not found");
                }
                try {
                    key = ConfigKeys.LANGUAGES;
                    if (configuration.containsKey(key)) {
                        Language[] languages = (Language[])configuration.get(key.toString());
                        iElementObjectArray = languages;
                        n2 = languages.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject language = iElementObjectArray[n];
                            contest.addLanguage((Language)language);
                            ++n;
                        }
                        log.info("Loaded " + languages.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading languages ", e);
                }
                try {
                    key = ConfigKeys.PROBLEMS;
                    if (configuration.containsKey(key)) {
                        Problem[] problems = (Problem[])configuration.get(key.toString());
                        iElementObjectArray = problems;
                        n2 = problems.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject problem = iElementObjectArray[n];
                            contest.addProblem((Problem)problem);
                            ++n;
                        }
                        log.info("Loaded " + problems.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading problems ", e);
                }
                try {
                    key = ConfigKeys.CONTEST_TIME_LIST;
                    if (configuration.containsKey(key)) {
                        ContestTime[] contestTimes = (ContestTime[])configuration.get(key.toString());
                        iElementObjectArray = contestTimes;
                        n2 = contestTimes.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject contestTime = iElementObjectArray[n];
                            contest.addContestTime((ContestTime)contestTime);
                            ++n;
                        }
                        log.info("Loaded " + contestTimes.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading contest times ", e);
                }
                try {
                    key = ConfigKeys.BALLOON_SETTINGS_LIST;
                    if (configuration.containsKey(key)) {
                        BalloonSettings[] balloonSettings = (BalloonSettings[])configuration.get(key.toString());
                        iElementObjectArray = balloonSettings;
                        n2 = balloonSettings.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject balloonSetting = iElementObjectArray[n];
                            contest.addBalloonSettings((BalloonSettings)balloonSetting);
                            ++n;
                        }
                        log.info("Loaded " + balloonSettings.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading contest information/title ", e);
                }
                try {
                    key = ConfigKeys.CONTEST_TIME;
                    if (configuration.containsKey(key)) {
                        ContestTime contestTime = (ContestTime)configuration.get(key.toString());
                        contest.addContestTime(contestTime);
                        log.info("Loaded " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading contest time ", e);
                }
                try {
                    key = ConfigKeys.GENERAL_PROBLEM;
                    if (configuration.containsKey(key)) {
                        Problem genProblem = (Problem)configuration.get(key.toString());
                        contest.setGeneralProblem(genProblem);
                        log.info("Loaded " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading general problem ", e);
                }
                try {
                    key = ConfigKeys.ACCOUNTS;
                    if (configuration.containsKey(key)) {
                        Account[] accounts = (Account[])configuration.get(key.toString());
                        iElementObjectArray = accounts;
                        n2 = accounts.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject account = iElementObjectArray[n];
                            contest.addAccount((Account)account);
                            ++n;
                        }
                        log.info("Loaded " + accounts.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading accounts ", e);
                }
                try {
                    key = ConfigKeys.JUDGEMENTS;
                    if (configuration.containsKey(key)) {
                        Judgement[] judgements = (Judgement[])configuration.get(key.toString());
                        iElementObjectArray = judgements;
                        n2 = judgements.length;
                        n = 0;
                        while (n < n2) {
                            IElementObject judgement = iElementObjectArray[n];
                            contest.addJudgement((Judgement)judgement);
                            ++n;
                        }
                        log.info("Loaded " + judgements.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading judgements ", e);
                }
                try {
                    key = ConfigKeys.PROBLEM_DATA_FILES;
                    if (configuration.containsKey(key)) {
                        ProblemDataFiles[] problemDataFiles = (ProblemDataFiles[])configuration.get(key.toString());
                        int count = 0;
                        ProblemDataFiles[] problemDataFilesArray = problemDataFiles;
                        int n3 = problemDataFiles.length;
                        n2 = 0;
                        while (n2 < n3) {
                            ProblemDataFiles problemDataFiles2 = problemDataFilesArray[n2];
                            Problem problem = contest.getProblem(problemDataFiles2.getProblemId());
                            if (problem != null) {
                                contest.updateProblem(problem, problemDataFiles2);
                                ++count;
                            } else {
                                log.warning("Could not find problem for problemDataFiles problem id=" + problemDataFiles2.getProblemId());
                            }
                            log.info("Loaded " + count + " of " + problemDataFiles.length + " " + key.toString().toLowerCase());
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading problem data files ", e);
                }
                try {
                    key = ConfigKeys.SITES;
                    if (configuration.containsKey(key)) {
                        Site[] sites;
                        Site[] siteArray = sites = (Site[])configuration.get(key.toString());
                        n2 = sites.length;
                        int n4 = 0;
                        while (n4 < n2) {
                            Site site = siteArray[n4];
                            contest.addSite(site);
                            ++n4;
                        }
                        log.info("Loaded " + sites.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading sites ", e);
                }
                try {
                    key = ConfigKeys.CONTEST_INFORMATION;
                    if (configuration.containsKey(key)) {
                        ContestInformation contestInformation = (ContestInformation)configuration.get(key.toString());
                        contest.addContestInformation(contestInformation);
                        log.info("Loaded Contest Information " + contestInformation.getContestTitle());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading contest information/title ", e);
                }
                try {
                    key = ConfigKeys.CLIENT_SETTINGS_LIST;
                    if (configuration.containsKey(key)) {
                        ClientSettings[] clientSettingsList;
                        ClientSettings[] clientSettingsArray = clientSettingsList = (ClientSettings[])configuration.get(key.toString());
                        n2 = clientSettingsList.length;
                        int n5 = 0;
                        while (n5 < n2) {
                            ClientSettings clientSettings = clientSettingsArray[n5];
                            contest.addClientSettings(clientSettings);
                            ++n5;
                        }
                        log.info("Loaded " + clientSettingsList.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while updating client settings ", e);
                }
                try {
                    key = ConfigKeys.GROUPS;
                    if (configuration.containsKey(key)) {
                        Group[] groups;
                        Group[] groupArray = groups = (Group[])configuration.get(key.toString());
                        n2 = groups.length;
                        int n6 = 0;
                        while (n6 < n2) {
                            Group group = groupArray[n6];
                            contest.addGroup(group);
                            ++n6;
                        }
                        log.info("Loaded " + groups.length + " " + key.toString().toLowerCase());
                    }
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while loading judgements ", e);
                }
                return true;
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info("No configuration file exists " + this.getFileName());
            return false;
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Loading configuration from disk", e);
            return false;
        }
    }

    private Account[] getAllAccounts(IInternalContest contest) {
        Vector<Account> allAccounts = new Vector<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            if (contest.getAccounts(ctype).size() > 0) {
                Vector<Account> accounts = contest.getAccounts(ctype);
                allAccounts.addAll(accounts);
            }
            ++n2;
        }
        Account[] accounts = allAccounts.toArray(new Account[allAccounts.size()]);
        return accounts;
    }

    public void saveToDisk(IInternalContest contest, Log log) throws IOException {
        Configuration configuration = new Configuration();
        configuration.add(ConfigKeys.SITE_NUMBER, new Integer(contest.getSiteNumber()));
        configuration.add(ConfigKeys.ACCOUNTS, (Serializable)this.getAllAccounts(contest));
        configuration.add(ConfigKeys.CONTEST_TIME, contest.getContestTime());
        configuration.add(ConfigKeys.CONTEST_TIME_LIST, (Serializable)contest.getContestTimes());
        configuration.add(ConfigKeys.BALLOON_SETTINGS_LIST, (Serializable)contest.getBalloonSettings());
        if (contest.getGeneralProblem() != null) {
            configuration.add(ConfigKeys.GENERAL_PROBLEM, contest.getGeneralProblem());
        }
        configuration.add(ConfigKeys.PROBLEM_DATA_FILES, (Serializable)contest.getProblemDataFiles());
        configuration.add(ConfigKeys.JUDGEMENTS, (Serializable)contest.getJudgements());
        configuration.add(ConfigKeys.LANGUAGES, (Serializable)contest.getLanguages());
        configuration.add(ConfigKeys.PROBLEMS, (Serializable)contest.getProblems());
        configuration.add(ConfigKeys.SITES, (Serializable)contest.getSites());
        configuration.add(ConfigKeys.CONTEST_INFORMATION, contest.getContestInformation());
        configuration.add(ConfigKeys.CLIENT_SETTINGS_LIST, (Serializable)contest.getClientSettingsList());
        configuration.add(ConfigKeys.GROUPS, (Serializable)contest.getGroups());
        configuration.writeToDisk(this.getFileName());
        configuration = null;
    }

    public String getFileName() {
        return String.valueOf(this.getDirectoryName()) + File.separator + "settings.dat";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigKeys {
        SITE_NUMBER,
        PROBLEMS,
        LANGUAGES,
        CONTEST_TIME,
        SITES,
        ACCOUNTS,
        JUDGEMENTS,
        PROBLEM_DATA_FILES,
        GENERAL_PROBLEM,
        CONTEST_TIME_LIST,
        CONTEST_INFORMATION,
        CLIENT_SETTINGS_LIST,
        BALLOON_SETTINGS_LIST,
        GROUPS;

    }

    private class Configuration {
        private Hashtable<String, Object> configItemHash = new Hashtable();

        private Configuration() {
        }

        public boolean add(ConfigKeys key, Serializable object) {
            if (object == null) {
                return false;
            }
            this.configItemHash.put(key.toString(), object);
            return true;
        }

        public boolean containsKey(ConfigKeys key) {
            return this.configItemHash.containsKey(key.toString());
        }

        public Object get(String key) {
            return this.configItemHash.get(key);
        }

        public boolean writeToDisk(String fileName) throws IOException {
            return Utilities.writeObjectToFile(ConfigurationIO.this.getFileName(), this.configItemHash);
        }

        public boolean loadFromDisk(String filename) throws IOException, ClassNotFoundException {
            Object readObject = Utilities.readObjectFromFile(filename);
            if (readObject instanceof Hashtable) {
                this.configItemHash = (Hashtable)readObject;
                return true;
            }
            return false;
        }
    }
}

