/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;

public class Account
implements IElementObject {
    private static final long serialVersionUID = -1098364914694875689L;
    private ClientId clientId;
    private ElementId elementId;
    private String password;
    private String displayName;
    private String aliasName = "";
    private String externalId = "";
    private ElementId groupId;
    private PermissionList permissionList = new PermissionList();
    private String shortSchoolName = "";
    private String longSchoolName = "";
    private String externalName = "";

    public Account(ClientId clientId, String password, int siteNumber) {
        this.elementId = new ElementId(clientId.toString());
        this.clientId = clientId;
        this.setPassword(password);
        this.elementId.setSiteNumber(siteNumber);
        this.displayName = String.valueOf(clientId.getClientType().toString().toLowerCase()) + clientId.getClientNumber();
    }

    public String toString() {
        return this.displayName;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPassword() {
        StringBuffer sb = new StringBuffer(this.password);
        String p = new String("");
        int i = 0;
        while (i < sb.length()) {
            p = String.valueOf(p) + (char)(sb.charAt(i) ^ 0xFAFA);
            ++i;
        }
        return p;
    }

    public void setPassword(String inPassword) {
        if (inPassword == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(inPassword);
        StringBuffer newStringBuffer = new StringBuffer();
        this.password = "";
        int i = 0;
        while (i < inPassword.length()) {
            newStringBuffer.append((char)(sb.charAt(i) ^ 0xFAFA));
            ++i;
        }
        this.password = new String(newStringBuffer);
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    public boolean isSameAs(Account account) {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    try {
                                                        if (this.displayName.equals(account.getDisplayName())) break block14;
                                                        return false;
                                                    }
                                                    catch (Exception exception) {
                                                        return false;
                                                    }
                                                }
                                                if (this.getPassword().equals(account.getPassword())) break block15;
                                                return false;
                                            }
                                            if (this.getClientId().getClientNumber() == account.getClientId().getClientNumber()) break block16;
                                            return false;
                                        }
                                        if (this.getClientId().getClientType() == account.getClientId().getClientType()) break block17;
                                        return false;
                                    }
                                    if (this.getClientId().equals(account.getClientId())) break block18;
                                    return false;
                                }
                                if (this.groupId != null && account.getGroupId() != null) break block19;
                                if (this.groupId != null || account.getGroupId() != null) {
                                    return false;
                                }
                                break block20;
                            }
                            if (this.groupId.equals(account.getGroupId())) break block20;
                            return false;
                        }
                        if (this.aliasName.equals(account.getAliasName())) break block21;
                        return false;
                    }
                    if (this.externalId.equals(account.getExternalId())) break block22;
                    return false;
                }
                if (this.externalName.equals(account.getExternalName())) break block23;
                return false;
            }
            if (this.longSchoolName.equals(account.getLongSchoolName())) break block24;
            return false;
        }
        return this.shortSchoolName.equals(account.getShortSchoolName());
    }

    public void clearListAndLoadPermissions(PermissionList newPermissionList) {
        this.permissionList.clearAndLoadPermissions(newPermissionList);
    }

    public void addPermission(Permission.Type type) {
        this.permissionList.addPermission(type);
    }

    public void removePermission(Permission.Type type) {
        this.permissionList.removePermission(type);
    }

    public boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    public PermissionList getPermissionList() {
        return this.permissionList;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ElementId getGroupId() {
        return this.groupId;
    }

    public void setGroupId(ElementId groupId) {
        this.groupId = groupId;
    }

    public void setShortSchoolName(String shortSchoolName) {
        this.shortSchoolName = shortSchoolName;
    }

    public void setLongSchoolName(String longSchoolName) {
        this.longSchoolName = longSchoolName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getLongSchoolName() {
        return this.longSchoolName;
    }

    public String getShortSchoolName() {
        return this.shortSchoolName;
    }
}

