/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static final String SVN_ID = "$Id: LogFormatter.java 222 2007-04-15 01:40:22Z laned $";
    private SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd HHmmss.SSS");
    private String separator = System.getProperty("line.separator");

    public LogFormatter(boolean useSeparator) {
        if (!useSeparator) {
            this.separator = "";
        }
    }

    private String getDateString(Date inDate) {
        return this.formatter.format(inDate.getTime());
    }

    public String format(LogRecord logRecord) {
        String level = logRecord.getLevel().toString().equalsIgnoreCase("finest") ? "DEBUG" : logRecord.getLevel().toString();
        Date date = new Date(logRecord.getMillis());
        String line = String.valueOf(this.getDateString(date)) + "|" + level + "|" + Thread.currentThread().getName() + "|" + logRecord.getSourceMethodName() + "|" + logRecord.getMessage() + this.separator;
        if (logRecord.getThrown() != null) {
            StackTraceElement[] elements;
            Throwable throwable = logRecord.getThrown();
            line = String.valueOf(line) + "|" + throwable.getClass().getName() + ": " + throwable.getMessage() + this.separator;
            StackTraceElement[] stackTraceElementArray = elements = throwable.getStackTrace();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                String sourceName = "(Unknown Source)";
                if (stackTraceElement.getFileName() != null) {
                    sourceName = "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
                }
                line = String.valueOf(line) + "|" + "    at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " " + sourceName + this.separator;
                ++n2;
            }
        }
        return line;
    }
}

