/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class EvaluationLog
implements UIPlugin {
    private static final long serialVersionUID = -3187268249635199184L;
    private IInternalContest contest;
    private IInternalController controller;
    private PrintWriter evalLog = null;
    private boolean logOpened = false;

    public EvaluationLog(String logFileName, IInternalContest contest, IInternalController controller) {
        try {
            this.logOpened = false;
            this.evalLog = new PrintWriter(new FileOutputStream(logFileName, true), true);
            this.logOpened = true;
            this.setContestAndController(contest, controller);
        }
        catch (FileNotFoundException e) {
            StaticLog.log("Unable to open file" + logFileName, e);
            this.evalLog = null;
        }
    }

    public static void printEvaluationLine(PrintWriter printWriter, Run run, IInternalContest inContest) {
        printWriter.print(new Date() + "|");
        printWriter.print("Site " + run.getSiteNumber() + "|");
        printWriter.print("Run " + run.getNumber() + "|");
        printWriter.print("Team " + run.getSubmitter().getClientNumber() + "|");
        printWriter.print(run.getProblemId() + "|");
        printWriter.print("Solved " + run.isSolved() + "|");
        printWriter.print("Proxy 0|");
        printWriter.print("Deleted " + run.isDeleted() + "|");
        JudgementRecord judgementRecord = run.getJudgementRecord();
        if (run.isJudged() && judgementRecord != null) {
            ElementId elementId = judgementRecord.getJudgementId();
            printWriter.print("Judgement " + inContest.getJudgement(elementId) + "|");
            printWriter.print("ValJud " + judgementRecord.isUsedValidator() + "|");
            printWriter.print("AccHit " + judgementRecord.isAcceptButtonHit() + "|");
            printWriter.print("Judge " + judgementRecord.getJudgerClientId() + "|");
        } else {
            printWriter.print("||||");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addRunListener(new RunListenerImplementation());
    }

    public String getPluginTitle() {
        return "Evaluation Log Writer";
    }

    protected void writeRunLine(Run run) {
        if (this.logOpened) {
            EvaluationLog.printEvaluationLine(this.evalLog, run, this.contest);
        } else {
            StaticLog.warning("Evaluation log not opened for write " + run);
        }
    }

    public boolean isLogOpened() {
        return this.logOpened;
    }

    public PrintWriter getEvalLog() {
        return this.evalLog;
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
            this.runChanged(event);
        }

        public void runChanged(RunEvent event) {
            Run run = event.getRun();
            if (run.isJudged()) {
                EvaluationLog.this.writeRunLine(run);
            }
        }

        public void runRemoved(RunEvent event) {
            Run run = event.getRun();
            EvaluationLog.this.writeRunLine(run);
        }
    }
}

