/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import java.io.File;
import java.io.Serializable;

public class RunResultsFileList
implements Serializable {
    private static final long serialVersionUID = -8277112546999332502L;
    private boolean writeToDisk = false;
    private RunResultFiles singleRunResultFiles = null;
    private String dirname = "db";

    public RunResultsFileList() {
    }

    private RunResultsFileList(String dirname) {
        this.dirname = dirname;
        Utilities.insureDir(dirname);
        this.writeToDisk = true;
    }

    public RunResultsFileList(int siteNumber) {
        this("db." + siteNumber);
    }

    private String getDirectoryName() {
        return this.dirname;
    }

    protected String stripChar(String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx > -1) {
            StringBuffer sb = new StringBuffer(s);
            idx = sb.indexOf(String.valueOf(ch));
            while (idx > -1) {
                sb.deleteCharAt(idx);
                idx = sb.indexOf(String.valueOf(ch));
            }
            return sb.toString();
        }
        return s;
    }

    private String stripChars(String s) {
        return this.stripChar(s, ' ');
    }

    private String getFileName(int siteNumber, int runNumber, JudgementRecord judgementRecord) {
        return String.valueOf(this.getDirectoryName()) + File.separator + "s" + siteNumber + "r" + runNumber + "." + this.stripChars(judgementRecord.getElementId().toString()) + ".files";
    }

    public String getFileName(Run run, JudgementRecord judgementRecord) {
        return this.getFileName(run.getSiteNumber(), run.getNumber(), judgementRecord);
    }

    public RunResultFiles add(Run run, JudgementRecord judgementRecord, RunResultFiles runFiles) {
        if (this.writeToDisk) {
            String filename = this.getFileName(run, judgementRecord);
            try {
                Utilities.writeObjectToFile(filename, runFiles);
                return runFiles;
            }
            catch (Exception e) {
                System.err.println("Unable to write file " + filename);
                e.printStackTrace();
                return null;
            }
        }
        this.singleRunResultFiles = runFiles;
        return this.singleRunResultFiles;
    }

    private RunResultFiles getRunResultFiles(int siteNumber, int runNumber, JudgementRecord judgementRecord) {
        if (this.writeToDisk) {
            String filename = this.getFileName(siteNumber, runNumber, judgementRecord);
            try {
                Object obj = Utilities.readObjectFromFile(filename);
                return (RunResultFiles)obj;
            }
            catch (Exception e) {
                System.err.println("Unable to read object from file " + filename);
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public RunResultFiles getRunResultFiles(Run run, JudgementRecord judgementRecord) {
        if (this.writeToDisk) {
            return this.getRunResultFiles(run.getSiteNumber(), run.getNumber(), judgementRecord);
        }
        if (this.singleRunResultFiles.getJudgementId().equals(judgementRecord.getElementId())) {
            return this.singleRunResultFiles;
        }
        return null;
    }

    public RunResultFiles[] getRunResultFiles(Run run) {
        JudgementRecord[] judgementRecord = run.getAllJudgementRecords();
        RunResultFiles[] runResultFiles = new RunResultFiles[judgementRecord.length];
        int i = 0;
        while (i < judgementRecord.length) {
            runResultFiles[i] = this.getRunResultFiles(run.getSiteNumber(), run.getNumber(), judgementRecord[i]);
            ++i;
        }
        return runResultFiles;
    }
}

