/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunList
implements Serializable {
    private static final long serialVersionUID = 1446963022315687590L;
    public static final String SVN_ID = "$Id: RunList.java 1791 2009-02-26 21:52:53Z laned $";
    private Hashtable<String, Run> runHash = new Hashtable(200);
    private String dirname = "db";
    private boolean saveToDisk = false;
    private int nextRunNumber = 1;

    public RunList() {
        this.saveToDisk = false;
    }

    private RunList(String dirname) {
        this.dirname = dirname;
        Utilities.insureDir(dirname);
        this.saveToDisk = true;
    }

    public RunList(int siteNumber, boolean saveToDisk) {
        this("db." + siteNumber);
        this.saveToDisk = saveToDisk;
    }

    private String getDirectoryName() {
        return this.dirname;
    }

    public Run addNewRun(Run run) {
        run.setNumber(this.nextRunNumber++);
        this.add(run);
        return run;
    }

    public void add(Run run) {
        this.runHash.put(this.getRunKey(run), run);
        if (this.saveToDisk) {
            this.writeToDisk();
        }
    }

    private Run get(String key) {
        return this.runHash.get(key);
    }

    public Run get(ElementId id) {
        return this.runHash.get(id.toString());
    }

    public Run get(Run run) {
        return this.get(this.getRunKey(run));
    }

    public String getRunKey(Run run) {
        return run.getElementId().toString();
    }

    public boolean delete(Run run) {
        Run fetchedRun = this.get(this.getRunKey(run));
        if (fetchedRun != null) {
            fetchedRun.setDeleted(true);
            this.writeToDisk();
            return true;
        }
        return false;
    }

    public void clear() {
        this.runHash = new Hashtable(200);
        this.writeToDisk();
    }

    public void updateRunStatus(Run run, Run.RunStates newState) {
        Run theRun = this.runHash.get(this.getRunKey(run));
        theRun.getElementId().incrementVersionNumber();
        theRun.setStatus(newState);
        this.writeToDisk();
    }

    public void updateRun(Run run) {
        run.getElementId().incrementVersionNumber();
        this.runHash.put(this.getRunKey(run), run);
        this.writeToDisk();
    }

    public void updateRun(Run run, JudgementRecord judgement, boolean manualReview) {
        Run theRun = this.runHash.get(this.getRunKey(run));
        theRun.getElementId().incrementVersionNumber();
        if (theRun.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
            if (manualReview && judgement.isComputerJudgement()) {
                judgement.setPreliminaryJudgement(true);
                theRun.setStatus(Run.RunStates.MANUAL_REVIEW);
            } else {
                theRun.setStatus(Run.RunStates.JUDGED);
            }
        } else {
            theRun.setStatus(Run.RunStates.JUDGED);
        }
        theRun.addJudgement(judgement);
        this.writeToDisk();
    }

    public Enumeration<Run> getRunList() {
        return this.runHash.elements();
    }

    private String getFileName() {
        return String.valueOf(this.getDirectoryName()) + File.separator + "runlist.dat";
    }

    private boolean writeToDisk() {
        if (!this.isSaveToDisk()) {
            return false;
        }
        try {
            return Utilities.writeObjectToFile(this.getFileName(), this.runHash);
        }
        catch (Exception e) {
            System.err.println("Exception writing RunList to disk ");
            e.printStackTrace();
            return false;
        }
    }

    public void loadFromDisk(int siteNumber) throws IOException, ClassNotFoundException {
        String filename = this.getFileName();
        if (Utilities.isFileThere(filename)) {
            this.runHash = (Hashtable)Utilities.readObjectFromFile(filename);
            this.nextRunNumber = this.lastRunNumber(siteNumber) + 1;
        } else {
            StaticLog.info("loadFromDisk:  INFO ? No files loaded, log this ?");
        }
    }

    private int lastRunNumber(int siteNumber) {
        int lastNumber = 0;
        Run[] runArray = this.getList();
        int n = runArray.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getSiteNumber() == siteNumber) {
                lastNumber = Math.max(lastNumber, run.getNumber());
            }
            ++n2;
        }
        return lastNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Hashtable<String, Run> hashtable = this.runHash;
        synchronized (hashtable) {
            return this.runHash.size();
        }
    }

    public Run[] getList() {
        if (this.runHash.size() == 0) {
            return new Run[0];
        }
        return this.runHash.values().toArray(new Run[this.size()]);
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }
}

