/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;

public class RunFilesList
implements Serializable {
    private static final long serialVersionUID = -15984887352160586L;
    public static final String SVN_ID = "$Id: RunFilesList.java 1587 2008-10-12 21:18:46Z laned $";
    private boolean writeToDisk = false;
    private boolean cacheRunFiles = false;
    private RunFiles singleRunFiles = null;
    private HashMap<String, RunFiles> runFilesHash = new HashMap();
    private String dirname = "db";

    public RunFilesList(boolean cacheRunFiles) {
        this.cacheRunFiles = cacheRunFiles;
    }

    public RunFilesList(String dirname) {
        this.dirname = dirname;
        Utilities.insureDir(dirname);
        this.writeToDisk = true;
    }

    public RunFilesList(int siteNumber) {
        this("db." + siteNumber);
    }

    public RunFilesList() {
    }

    public String getDirectoryName() {
        return this.dirname;
    }

    private String getFileName(int siteNumber, int runNumber) {
        return String.valueOf(this.getDirectoryName()) + File.separator + "s" + siteNumber + "r" + runNumber + ".files";
    }

    private String getFileName(Run run) {
        return this.getFileName(run.getSiteNumber(), run.getNumber());
    }

    protected String getRunKey(int siteNumber, int runNumber) {
        return "s" + siteNumber + "r" + runNumber;
    }

    public RunFiles add(Run run, RunFiles runFiles) {
        if (this.writeToDisk) {
            String filename = this.getFileName(run);
            try {
                Utilities.writeObjectToFile(filename, runFiles);
                return runFiles;
            }
            catch (Exception e) {
                System.err.println("Unable to write file " + filename);
                e.printStackTrace();
                return null;
            }
        }
        if (this.cacheRunFiles) {
            String key = this.getRunKey(run.getSiteNumber(), run.getNumber());
            this.runFilesHash.put(key, runFiles);
            return runFiles;
        }
        this.singleRunFiles = runFiles;
        return this.singleRunFiles;
    }

    private RunFiles getRunFiles(int siteNumber, int runNumber) {
        if (this.writeToDisk) {
            String filename = this.getFileName(siteNumber, runNumber);
            try {
                Object obj = Utilities.readObjectFromFile(filename);
                return (RunFiles)obj;
            }
            catch (Exception e) {
                System.err.println("Unable to read object from file " + filename);
                e.printStackTrace();
                return null;
            }
        }
        if (this.cacheRunFiles) {
            String key = this.getRunKey(siteNumber, runNumber);
            return this.runFilesHash.get(key);
        }
        return null;
    }

    public RunFiles getRunFiles(Run run) {
        if (this.writeToDisk) {
            return this.getRunFiles(run.getSiteNumber(), run.getNumber());
        }
        if (this.cacheRunFiles) {
            return this.getRunFiles(run.getSiteNumber(), run.getNumber());
        }
        if (this.singleRunFiles != null && run.getElementId().equals(this.singleRunFiles.getRunId())) {
            return this.singleRunFiles;
        }
        return null;
    }

    public String getRunKey(Run run) {
        return run.getElementId().toString();
    }

    public void clearCache() {
        this.runFilesHash = new HashMap();
        this.singleRunFiles = null;
    }

    public boolean isCacheRunFiles() {
        return this.cacheRunFiles;
    }

    public void setCacheRunFiles(boolean cacheRunFiles) {
        this.cacheRunFiles = cacheRunFiles;
    }

    public boolean isWriteToDisk() {
        return this.writeToDisk;
    }
}

