/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.list;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClarificationList
implements Serializable {
    public static final String SVN_ID = "$Id: ClarificationList.java 478 2007-04-30 17:24:41Z laned $";
    private static final long serialVersionUID = 8506339011148953151L;
    private Hashtable<String, Clarification> clarHash = new Hashtable();
    private String directoryName = "db";
    private boolean saveToDisk = false;
    private int nextClarificationNumber = 1;

    public ClarificationList() {
        this.saveToDisk = false;
    }

    private ClarificationList(String directoryName) {
        this.directoryName = directoryName;
        Utilities.insureDir(directoryName);
        this.saveToDisk = true;
    }

    public ClarificationList(int siteNumber, boolean saveToDisk) {
        this("db." + siteNumber);
        this.saveToDisk = saveToDisk;
    }

    public Clarification addNewClarification(Clarification clarification) {
        clarification.setNumber(this.nextClarificationNumber++);
        this.add(clarification);
        return clarification;
    }

    public void add(Clarification clarification) {
        this.clarHash.put(this.getClarificationKey(clarification), clarification);
        if (this.saveToDisk) {
            this.writeToDisk();
        }
    }

    public Clarification get(Clarification clarification) {
        return this.clarHash.get(this.getClarificationKey(clarification));
    }

    public Clarification get(ElementId elementId) {
        return this.clarHash.get(elementId.toString());
    }

    public String getClarificationKey(Clarification clarification) {
        return clarification.getElementId().toString();
    }

    public boolean delete(Clarification clarification) {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification != null) {
            fetchedClarification.setDeleted(true);
            this.writeToDisk();
            return true;
        }
        return false;
    }

    public void clear() {
        this.clarHash = new Hashtable();
        this.writeToDisk();
    }

    public void add(Clarification[] clarList) {
        Clarification[] clarificationArray = clarList;
        int n = clarList.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            this.add(clarification);
            ++n2;
        }
    }

    public int size() {
        return this.clarHash.size();
    }

    public Clarification[] getList() {
        Clarification[] list = new Clarification[this.clarHash.size()];
        if (this.clarHash.size() == 0) {
            return list;
        }
        return this.clarHash.values().toArray(new Clarification[this.size()]);
    }

    public void updateClarification(Clarification clarification) {
        clarification.getElementId().incrementVersionNumber();
        this.clarHash.put(this.getClarificationKey(clarification), clarification);
        this.writeToDisk();
    }

    public void updateClarification(Clarification clarification, Clarification.ClarificationStates newState, ClientId sourceId) {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification == null) {
            throw new SecurityException("Unable to find/update clarifications " + clarification);
        }
        fetchedClarification.getElementId().incrementVersionNumber();
        fetchedClarification.setState(newState);
        this.writeToDisk();
    }

    public Clarification updateClarification(Clarification clarification, Clarification.ClarificationStates newState, ClientId sourceId, String answer, boolean sendToAll) {
        Clarification fetchedClarification = this.get(clarification);
        if (fetchedClarification != null) {
            fetchedClarification.getElementId().incrementVersionNumber();
            fetchedClarification.setState(newState);
            fetchedClarification.setAnswer(answer);
            fetchedClarification.setWhoJudgedItId(sourceId);
            fetchedClarification.setSendToAll(sendToAll);
            this.writeToDisk();
            return fetchedClarification;
        }
        throw new SecurityException("Unable to find/update clarifications " + clarification);
    }

    public Enumeration<Clarification> getClarList() {
        return this.clarHash.elements();
    }

    private String getFileName() {
        return String.valueOf(this.getDirectoryName()) + File.separator + "clarlist.dat";
    }

    public void loadFromDisk(int siteNumber) throws IOException, ClassNotFoundException {
        String filename = this.getFileName();
        if (Utilities.isFileThere(filename)) {
            this.clarHash = (Hashtable)Utilities.readObjectFromFile(filename);
            this.nextClarificationNumber = this.lastClarificationNumber(siteNumber) + 1;
        }
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    private boolean writeToDisk() {
        if (!this.isSaveToDisk()) {
            return false;
        }
        try {
            return Utilities.writeObjectToFile(this.getFileName(), this.clarHash);
        }
        catch (Exception e) {
            System.err.println("Exception writing RunList to disk ");
            e.printStackTrace();
            return false;
        }
    }

    private int lastClarificationNumber(int siteNumber) {
        int lastNumber = 0;
        Clarification[] clarificationArray = this.getList();
        int n = clarificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if (clarification.getSiteNumber() == siteNumber) {
                lastNumber = Math.max(lastNumber, clarification.getNumber());
            }
            ++n2;
        }
        return lastNumber;
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }
}

