/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.exception.IllegalTSVFormatException;
import edu.csus.ecs.pc2.core.imports.ICPCAccount;
import edu.csus.ecs.pc2.core.imports.ICPCImportData;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.util.TabSeparatedValueParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public final class LoadICPCData {
    private static final int TEAM_TAB = 11;
    private static final int SITE_TAB = 22;
    private static final int CONTEST_TAB = 33;

    public static ICPCImportData loadSites(String directory, Site[] sites) throws Exception {
        if (sites != null) {
            Arrays.sort(sites, new SiteComparatorBySiteNumber());
        }
        ICPCImportData siteData = new ICPCImportData();
        String fs = File.separator;
        String path = String.valueOf(directory) + fs;
        String file = "PC2_Contest.tab";
        if (!new File(String.valueOf(path) + file).exists()) {
            throw new FileNotFoundException(String.valueOf(path) + file);
        }
        LoadICPCData.readFile(String.valueOf(path) + file, 33, sites, siteData);
        file = "_PC2_Site.tab";
        if (!new File(String.valueOf(path) + file).exists()) {
            file = "PC2_Site.tab";
            if (!new File(String.valueOf(path) + file).exists()) {
                throw new FileNotFoundException(String.valueOf(path) + file);
            }
        }
        LoadICPCData.readFile(String.valueOf(path) + file, 22, sites, siteData);
        return siteData;
    }

    public static ICPCImportData loadAccounts(String directory, Group[] groups, Account[] existingAccounts) throws Exception {
        int n;
        ICPCImportData accountData = new ICPCImportData();
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        if (groups != null) {
            Group[] groupArray = groups;
            n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                if (group.getGroupId() != 0) {
                    groupMap.put(Integer.toString(group.getGroupId()), group);
                }
                ++n2;
            }
        }
        HashMap<ClientId, Account> existingAccountsMap = new HashMap<ClientId, Account>();
        if (existingAccounts != null) {
            Account[] accountArray = existingAccounts;
            int n3 = existingAccounts.length;
            n = 0;
            while (n < n3) {
                Account account = accountArray[n];
                existingAccountsMap.put(account.getClientId(), account);
                ++n;
            }
        }
        String fs = File.separator;
        String path = String.valueOf(directory) + fs;
        String file = "_PC2_Team.tab";
        if (!new File(String.valueOf(path) + file).exists()) {
            file = "PC2_Team.tab";
            if (!new File(String.valueOf(path) + file).exists()) {
                throw new FileNotFoundException(String.valueOf(path) + file);
            }
        }
        LoadICPCData.readFile(String.valueOf(path) + file, 11, null, accountData);
        ICPCAccount[] accounts = accountData.getAccounts();
        if (accounts != null && accounts.length > 0) {
            ICPCAccount[] iCPCAccountArray = accounts;
            int n4 = accounts.length;
            int n5 = 0;
            while (n5 < n4) {
                ICPCAccount account = iCPCAccountArray[n5];
                if (account.getGroupExternalId().length() > 0 && groupMap.containsKey(account.getGroupExternalId())) {
                    int accountNum;
                    int siteNum;
                    ClientId clientId;
                    Group group = (Group)groupMap.get(account.getGroupExternalId());
                    account.setGroupId(group.getElementId());
                    if (group.getSite() != null && existingAccountsMap.containsKey(clientId = new ClientId(siteNum = group.getSite().getSiteNumber(), ClientType.Type.TEAM, accountNum = account.getAccountNumber()))) {
                        account.setClientId(clientId);
                    }
                }
                ++n5;
            }
        }
        return accountData;
    }

    static void readFile(String filename, int fileType, Site[] sites, ICPCImportData importedData) throws Exception {
        Vector<ICPCAccount> accounts = new Vector<ICPCAccount>();
        Vector<Group> groups = new Vector<Group>();
        int lineCount = 0;
        FileReader fileReader = new FileReader(filename);
        BufferedReader in = new BufferedReader(fileReader);
        String line = in.readLine();
        ++lineCount;
        while (line != null) {
            try {
                if (line.startsWith("#")) {
                    line = in.readLine();
                    ++lineCount;
                    continue;
                }
                String[] values = TabSeparatedValueParser.parseLine(line);
                switch (fileType) {
                    case 11: {
                        accounts.add(LoadICPCData.processTeam(values));
                        break;
                    }
                    case 22: {
                        groups.add(LoadICPCData.processSite(values, sites));
                        break;
                    }
                    case 33: {
                        importedData.setContestTitle(LoadICPCData.processContest(values));
                        break;
                    }
                    default: {
                        new Exception("Unknown file type");
                        break;
                    }
                }
            }
            catch (IllegalTSVFormatException e2) {
                throw e2;
            }
            catch (Exception e) {
                String msg = "Error " + filename + ":" + lineCount + ": " + e.getMessage();
                Exception sendException = new Exception(msg);
                sendException.setStackTrace(e.getStackTrace());
                throw sendException;
            }
            line = in.readLine();
            ++lineCount;
        }
        in.close();
        fileReader.close();
        in = null;
        fileReader = null;
        if (fileType == 11) {
            importedData.setAccounts(accounts.toArray(new ICPCAccount[accounts.size()]));
        } else if (fileType == 22) {
            importedData.setGroups(groups.toArray(new Group[groups.size()]));
        }
    }

    private static ICPCAccount processTeam(String[] values) {
        int offset = 0;
        int clientNumber = 0;
        switch (values.length) {
            case 10: {
                if (values[0].length() > 0) {
                    clientNumber = Integer.parseInt(values[0]);
                }
                offset = 0;
                break;
            }
            case 9: {
                offset = -1;
                break;
            }
        }
        ICPCAccount account = new ICPCAccount();
        if (clientNumber != 0) {
            account.setAccountNumber(clientNumber);
        }
        account.setExternalId(values[1 + offset]);
        String groupId = values[2 + offset];
        if (groupId != null && groupId.trim().length() > 0) {
            account.setGroupExternalId(groupId.trim());
        }
        account.setExternalName(values[4 + offset]);
        account.setLongSchoolName(values[5 + offset]);
        account.setShortSchoolName(values[6 + offset]);
        return account;
    }

    private static Group processSite(String[] values, Site[] sites) {
        int siteNum;
        int offset = values.length == 8 ? -1 : 0;
        Group group = new Group(values[3 + offset]);
        if (values.length == 9 && sites != null && (siteNum = Integer.parseInt(values[0])) <= sites.length) {
            group.setSite(sites[siteNum - 1].getElementId());
        }
        group.setGroupId(Integer.parseInt(values[1 + offset]));
        return group;
    }

    private static String processContest(String[] values) {
        String title = "";
        if (values.length > 0) {
            title = values[1];
        }
        return title;
    }

    private LoadICPCData() {
    }
}

