/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.imports.ICPCAccount;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICPCImportData {
    private String contestTitle;
    private Group[] groups;
    private ICPCAccount[] accounts;

    public ICPCImportData() {
    }

    public ICPCImportData(Vector<Account> inAccounts, Group[] inGroups, String inContestTitle) {
        HashMap<ElementId, String> groupHash = new HashMap<ElementId, String>();
        this.groups = inGroups;
        int i = 0;
        while (i < inGroups.length) {
            groupHash.put(inGroups[i].getElementId(), Integer.toString(inGroups[i].getGroupId()));
            ++i;
        }
        this.contestTitle = inContestTitle;
        Enumeration<Account> accountsEnum = inAccounts.elements();
        this.accounts = new ICPCAccount[inAccounts.size()];
        int accountCount = 0;
        while (accountsEnum.hasMoreElements()) {
            ICPCAccount icpcAccount;
            Account account = accountsEnum.nextElement();
            this.accounts[accountCount] = icpcAccount = new ICPCAccount(account, (String)groupHash.get(account.getGroupId()));
            ++accountCount;
        }
    }

    public ICPCAccount[] getAccounts() {
        return this.accounts;
    }

    public void setAccounts(ICPCAccount[] accounts) {
        this.accounts = accounts;
    }

    public String getContestTitle() {
        return this.contestTitle;
    }

    public void setContestTitle(String contestTitle) {
        this.contestTitle = contestTitle;
    }

    public Group[] getGroups() {
        return this.groups;
    }

    public void setGroups(Group[] groups) {
        this.groups = groups;
    }
}

