/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.IResultsParser;
import edu.csus.ecs.pc2.core.log.Log;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLResultsParser
implements IResultsParser {
    public static final String SVN_ID = "$Id: XMLResultsParser.java 1700 2008-12-01 21:15:36Z boudreat $";
    private Log log = null;
    private Hashtable<String, String> results = new Hashtable();
    private static final String OUTCOME_KEY = "outcome";
    private static final String RESULT_KEY = "result";

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("Usage: java edu.csus.ecs.pc2.core.execute.XMLResultsParser filename");
            System.exit(1);
        }
        Log log = new Log("edu.csus.ecs.pc2", null, "logs", "parser");
        XMLResultsParser parser = new XMLResultsParser();
        parser.setLog(log);
        if (parser.parseValidatorResultsFile(argv[0])) {
            Enumeration<String> enumeration = parser.getResults().keys();
            while (enumeration.hasMoreElements()) {
                String element = enumeration.nextElement();
                System.out.println("found attribute " + element + " value=" + parser.getResults().get(element));
            }
        }
    }

    private void processAttributes(NamedNodeMap nodeMap) {
        int i = 0;
        while (i < nodeMap.getLength()) {
            String item;
            Node node = nodeMap.item(i);
            if (node != null && (item = node.getNodeName()) != null) {
                this.results.put(item, node.getNodeValue());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parseValidatorResultsFile(String resultsFileName) {
        String content = "";
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuildFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(resultsFileName));
            doc.getDocumentElement().normalize();
            String rootNode = doc.getDocumentElement().getNodeName();
            if (!rootNode.equals(RESULT_KEY)) {
                this.log.config("parseResultXML() looking for result rootNode, but found root node: " + rootNode);
                return false;
            }
            content = doc.getDocumentElement().getTextContent();
            if (content != null) {
                this.results.put("CONTENT", content);
            }
            NamedNodeMap attr = doc.getDocumentElement().getAttributes();
            this.processAttributes(attr);
            if (this.results.containsKey(OUTCOME_KEY)) {
                return true;
            }
            this.log.config("parseResultXML() could not find 'outcome' attribute");
            return false;
        }
        catch (SAXParseException spe) {
            this.log.log(Log.CONFIG, "parseResultXML() SAX exception", spe);
            return false;
        }
        catch (SAXException se) {
            this.log.log(Log.CONFIG, "parseResultXML() SAX exception", se);
            return false;
        }
        catch (Throwable t) {
            this.log.log(Log.CONFIG, "parseResultXML() exception", t);
        }
        return false;
    }

    @Override
    public Hashtable<String, String> getResults() {
        return this.results;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }
}

