/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.ExecuteTimer;
import edu.csus.ecs.pc2.core.log.Log;
import java.io.BufferedReader;
import java.io.PrintWriter;

public class IOCollector
extends Thread {
    public static final String SVN_ID = "$Id: IOCollector.java 293 2007-04-20 06:35:22Z laned $";
    private BufferedReader bufReader;
    private PrintWriter outWriter;
    private boolean stopIt = false;
    private ExecuteTimer localTimer = null;
    private long maxFileSize;
    private Log log = null;

    public IOCollector(Log log, BufferedReader inReader, PrintWriter printer, ExecuteTimer myTimer, long newMaxFileSize) {
        this.log = log;
        this.maxFileSize = newMaxFileSize;
        this.bufReader = inReader;
        this.outWriter = printer;
        this.localTimer = myTimer;
    }

    protected void finalize() throws Throwable {
        this.bufReader = null;
        this.outWriter = null;
        this.localTimer = null;
    }

    public void haltMe() {
        this.stopIt = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long offset = 0L;
        try {
            int theChar = this.bufReader.read();
            while (true) {
                if (this.stopIt || theChar == -1 || offset >= this.maxFileSize) {
                    if (this.stopIt) {
                        this.outWriter.println();
                        this.outWriter.println("Output halted by operator");
                    }
                    if (offset >= this.maxFileSize) {
                        this.outWriter.println();
                        this.outWriter.println("Output exceeds maximum file size " + new Long(this.maxFileSize));
                    }
                    try {
                        theChar = this.bufReader.read();
                        while (!this.stopIt) {
                            if (theChar == -1) {
                                return;
                            }
                            theChar = this.bufReader.read();
                        }
                        return;
                    }
                    catch (Exception exception) {
                        this.log.log(Log.DEBUG, "IOCollector:Run: caught notImportant exception");
                        return;
                    }
                }
                ++offset;
                this.outWriter.print((char)theChar);
                theChar = this.bufReader.read();
            }
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "ioCollector - Exception in run() ", ex);
        }
    }
}

