/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.archive;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class PacketArchiver
implements UIPlugin {
    private static final long serialVersionUID = 5563690515605317578L;
    public static final String SVN_ID = "$Id: PacketArchiver.java 1192 2008-01-24 14:46:45Z laned $";
    private static int nextPacketNumber = 1;
    private static long serialNumber = new Date().getTime() % 10000L;
    private String outputDirectoryName = "packets";
    private IInternalContest contest;
    private IInternalController controller;
    private String lastArchiveFilename;

    public PacketArchiver() {
        this.outputDirectoryName = String.valueOf(this.getPC2BaseDirectory()) + File.separator + this.outputDirectoryName;
        Utilities.insureDir(this.outputDirectoryName);
    }

    public PacketArchiver(String outputDirectroryName) {
        this.outputDirectoryName = outputDirectroryName;
        Utilities.insureDir(outputDirectroryName);
    }

    public int packetsWritten() {
        return nextPacketNumber - 1;
    }

    public String getLastArchiveFilename() {
        return this.lastArchiveFilename;
    }

    public String getPC2BaseDirectory() {
        return ".";
    }

    public boolean writeNextPacket(Packet packet) throws IOException {
        this.lastArchiveFilename = String.valueOf(this.outputDirectoryName) + File.separator + "packet" + serialNumber + "." + nextPacketNumber + ".packet";
        boolean wasWritten = this.savePacket(this.lastArchiveFilename, packet);
        ++nextPacketNumber;
        return wasWritten;
    }

    public Packet loadPacket(String filename) throws IOException, ClassNotFoundException {
        if (!Utilities.isFileThere(filename)) {
            return null;
        }
        Object object = Utilities.readObjectFromFile(filename);
        return (Packet)object;
    }

    public boolean savePacket(String filename, Packet packet) throws IOException {
        return Utilities.writeObjectToFile(filename, packet);
    }

    protected String getOutputDirectoryName() {
        return this.outputDirectoryName;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    public String getPluginTitle() {
        return "Packet Archiver";
    }
}

