/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.security.FileSecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;

public final class Utilities {
    private static boolean debugMode = false;

    private Utilities() {
    }

    public static boolean insureDir(String dirName) {
        File dir = null;
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("insureDir Directory " + dir.getName() + " could not be created.");
        }
        return dir.isDirectory();
    }

    public static Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        try {
            return FileSecurity.readSealedFile(filename);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean writeObjectToFile(String filename, Serializable serializable) throws IOException {
        try {
            FileSecurity.writeSealedFile(filename, serializable);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    public static boolean isFileThere(String filename) {
        File file = new File(filename);
        return file.isFile();
    }

    public static boolean isEquals(char[] oldBuffer, char[] newBuffer) {
        if (oldBuffer == null) {
            return newBuffer == null;
        }
        if (newBuffer == null) {
            return false;
        }
        if (oldBuffer.length != newBuffer.length) {
            return false;
        }
        int i = 0;
        while (i < newBuffer.length) {
            if (newBuffer[i] != oldBuffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] loadFile(String filename) throws IOException {
        Vector<String> lines = new Vector<String>();
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        if (!new File(filename).exists()) {
            return new String[0];
        }
        FileReader fileReader = new FileReader(filename);
        BufferedReader in = new BufferedReader(fileReader);
        String line = in.readLine();
        while (line != null) {
            lines.addElement(line);
            line = in.readLine();
        }
        in.close();
        fileReader.close();
        in = null;
        fileReader = null;
        if (lines.size() == 0) {
            return new String[0];
        }
        String[] out = new String[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            out[i] = (String)lines.elementAt(i);
            ++i;
        }
        return out;
    }

    public static String getCurrentDirectory() {
        File curdir = new File(".");
        try {
            return curdir.getCanonicalPath();
        }
        catch (Exception exception) {
            return ".";
        }
    }

    public static String getL10nDateTime() {
        Locale currentLocale = Locale.getDefault();
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(0, 1, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getL10nDateTime(int dateStyle, int timeStyle, Locale currentLocale) {
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, currentLocale);
        return dateFormatter.format(today);
    }

    public static String getRFC2822DateTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        return String.format("%1$ta, %1$te %1$tb %1$tY %1$tT %1$tz", calendar);
    }

    public static String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    public static String[] loadINIFile(String filename) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            while ((line = file.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                v.addElement(line);
            }
            file.close();
            Object var2_2 = null;
        }
        catch (Exception exception) {
            return null;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String forHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '(') {
                result.append("&#040;");
            } else if (character == ')') {
                result.append("&#041;");
            } else if (character == '#') {
                result.append("&#035;");
            } else if (character == '%') {
                result.append("&#037;");
            } else if (character == ';') {
                result.append("&#059;");
            } else if (character == '+') {
                result.append("&#043;");
            } else if (character == '-') {
                result.append("&#045;");
            } else if (character == '\n') {
                result.append("<br>");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        Utilities.debugMode = debugMode;
    }

    public static String basename(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    public static String dirname(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex == -1) {
            return path;
        }
        if (lastIndex == 0) {
            return path;
        }
        return path.substring(0, lastIndex);
    }
}

