/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

public class RomanNumeral {
    public static final String SVN_ID = "$Id: RomanNumeral.java 93 2007-04-01 03:33:59Z laned $";
    private final long num;
    private static int[] numbers = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static String[] letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    public RomanNumeral(long arabic) {
        if (arabic < 1L) {
            throw new NumberFormatException("Value of RomanNumeral must be positive.");
        }
        if (arabic > 3999L) {
            throw new NumberFormatException("Value of RomanNumeral must be 3999 or less.");
        }
        this.num = arabic;
    }

    public RomanNumeral(String roman) {
        if (roman.length() == 0) {
            throw new NumberFormatException("An empty string does not define a Roman numeral.");
        }
        roman = roman.toUpperCase();
        int i = 0;
        int arabic = 0;
        while (i < roman.length()) {
            char letter = roman.charAt(i);
            int number = this.letterToNumber(letter);
            if (number < 0) {
                throw new NumberFormatException("Illegal character \"" + letter + "\" in roman numeral.");
            }
            if (++i == roman.length()) {
                arabic += number;
                continue;
            }
            int nextNumber = this.letterToNumber(roman.charAt(i));
            if (nextNumber > number) {
                arabic += nextNumber - number;
                ++i;
                continue;
            }
            arabic += number;
        }
        if (arabic > 3999) {
            throw new NumberFormatException("Roman numeral must have value 3999 or less.");
        }
        this.num = arabic;
    }

    private int letterToNumber(char letter) {
        switch (letter) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        roman = "";
        n = this.num;
        i = 0;
        ** GOTO lbl10
        {
            roman = String.valueOf(roman) + RomanNumeral.letters[i];
            n -= (long)RomanNumeral.numbers[i];
            do {
                if (n >= (long)RomanNumeral.numbers[i]) continue block0;
                ++i;
lbl10:
                // 2 sources

            } while (i < RomanNumeral.numbers.length);
        }
        return roman;
    }

    public long toInt() {
        return this.num;
    }
}

