/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;

public class PermissionGroup {
    private PermissionList teamPermissionList = new PermissionList();
    private PermissionList judgePermissionList = new PermissionList();
    private PermissionList scoreboardPermissionList = new PermissionList();
    private PermissionList administratorPermissionList = new PermissionList();
    private PermissionList serverPermissionList = new PermissionList();
    private PermissionList spectatorPermissionList = new PermissionList();

    public PermissionGroup() {
        this.initialize();
    }

    private void initialize() {
        Permission.Type[] typeArray = Permission.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            this.administratorPermissionList.addPermission(type);
            this.serverPermissionList.addPermission(type);
            ++n2;
        }
        this.administratorPermissionList.removePermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
        this.serverPermissionList.removePermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
        this.administratorPermissionList.removePermission(Permission.Type.BALLOON_EMAIL);
        this.serverPermissionList.removePermission(Permission.Type.BALLOON_EMAIL);
        this.administratorPermissionList.removePermission(Permission.Type.BALLOON_PRINT);
        this.serverPermissionList.removePermission(Permission.Type.BALLOON_PRINT);
        this.administratorPermissionList.removePermission(Permission.Type.RESPECT_EOC_SUPPRESSION);
        this.administratorPermissionList.removePermission(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        this.teamPermissionList.addPermission(Permission.Type.LOGIN);
        this.teamPermissionList.addPermission(Permission.Type.DISPLAY_ON_SCOREBOARD);
        this.teamPermissionList.addPermission(Permission.Type.TEST_RUN);
        this.teamPermissionList.addPermission(Permission.Type.VIEW_CLARIFICATIONS);
        this.teamPermissionList.addPermission(Permission.Type.VIEW_RUNS);
        this.teamPermissionList.addPermission(Permission.Type.SUBMIT_CLARIFICATION);
        this.teamPermissionList.addPermission(Permission.Type.SUBMIT_RUN);
        this.judgePermissionList.addPermission(Permission.Type.CHANGE_PASSWORD);
        this.judgePermissionList.addPermission(Permission.Type.JUDGE_RUN);
        this.judgePermissionList.addPermission(Permission.Type.LOGIN);
        this.judgePermissionList.addPermission(Permission.Type.REJUDGE_RUN);
        this.judgePermissionList.addPermission(Permission.Type.TEST_RUN);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_CLARIFICATIONS);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_RUNS);
        this.judgePermissionList.addPermission(Permission.Type.ANSWER_CLARIFICATION);
        this.judgePermissionList.addPermission(Permission.Type.SUBMIT_CLARIFICATION);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_ALL_JUDGEMENTS);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_STANDINGS);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_SUMMARY_ATTEMPTS_GRID);
        this.judgePermissionList.addPermission(Permission.Type.VIEW_RUN_JUDGEMENT_HISTORIES);
        this.judgePermissionList.addPermission(Permission.Type.GENERATE_NEW_CLARIFICATION);
        this.judgePermissionList.addPermission(Permission.Type.ALLOWED_TO_AUTO_JUDGE);
        this.spectatorPermissionList.addPermission(Permission.Type.CHANGE_PASSWORD);
        this.spectatorPermissionList.addPermission(Permission.Type.LOGIN);
        this.spectatorPermissionList.addPermission(Permission.Type.TEST_RUN);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_CLARIFICATIONS);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_RUNS);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_ALL_JUDGEMENTS);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_STANDINGS);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_SUMMARY_ATTEMPTS_GRID);
        this.spectatorPermissionList.addPermission(Permission.Type.VIEW_RUN_JUDGEMENT_HISTORIES);
        this.spectatorPermissionList.addPermission(Permission.Type.ALLOWED_TO_FETCH_RUN);
        this.scoreboardPermissionList.addPermission(Permission.Type.BALLOON_EMAIL);
        this.scoreboardPermissionList.addPermission(Permission.Type.BALLOON_OUTPUT_SHUTOFF);
        this.scoreboardPermissionList.addPermission(Permission.Type.BALLOON_PRINT);
        this.scoreboardPermissionList.addPermission(Permission.Type.CHANGE_PASSWORD);
        this.scoreboardPermissionList.addPermission(Permission.Type.LOGIN);
        this.scoreboardPermissionList.addPermission(Permission.Type.VIEW_STANDINGS);
        this.scoreboardPermissionList.addPermission(Permission.Type.VIEW_SUMMARY_ATTEMPTS_GRID);
    }

    public PermissionList getPermissionList(ClientType.Type type) {
        switch (type) {
            case ADMINISTRATOR: {
                return this.administratorPermissionList;
            }
            case SERVER: {
                return this.serverPermissionList;
            }
            case JUDGE: 
            case EXECUTOR: {
                return this.judgePermissionList;
            }
            case SPECTATOR: {
                return this.spectatorPermissionList;
            }
            case SCOREBOARD: {
                return this.scoreboardPermissionList;
            }
        }
        return this.teamPermissionList;
    }
}

