/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;

public class ParseArguments {
    private Hashtable<String, String> argHash = new Hashtable();
    private Vector<String> filelist = new Vector();
    private static final String NULL_VALUE = "<GAA9223372036854775807";
    private String[] requireArgOpts = null;

    public ParseArguments() {
    }

    public ParseArguments(String[] args) {
        this.loadArgs(args);
    }

    public void dumpArgs(PrintStream pw) {
        pw.println();
        pw.println("There are " + this.argHash.size() + " options ");
        TreeSet<String> ts = new TreeSet<String>();
        ts.addAll(this.argHash.keySet());
        for (String key : ts) {
            String obj = this.argHash.get(key);
            String value = "<null>";
            if (obj != null) {
                value = obj;
            }
            if (value.equals(NULL_VALUE)) {
                value = "<null>";
            }
            pw.println(String.valueOf(key) + " = " + value);
        }
        pw.println("There are " + this.filelist.size() + " arguments ");
        int i = 0;
        while (i < this.filelist.size()) {
            String value = this.filelist.elementAt(i);
            pw.println("[" + i + "] " + value);
            ++i;
        }
    }

    public void dumpArgs(PrintWriter pw) {
        pw.println();
        pw.println("There are " + this.argHash.size() + " options ");
        TreeSet<String> ts = new TreeSet<String>();
        ts.addAll(this.argHash.keySet());
        for (String key : ts) {
            String obj = this.argHash.get(key);
            String value = "<null>";
            if (obj != null) {
                value = obj;
            }
            if (value.equals(NULL_VALUE)) {
                value = "<null>";
            }
            pw.println(String.valueOf(key) + " = " + value);
        }
        pw.println("There are " + this.filelist.size() + " arguments ");
        int i = 0;
        while (i < this.filelist.size()) {
            String value = this.filelist.elementAt(i);
            pw.println("[" + i + "] " + value);
            ++i;
        }
    }

    public String getArg(int idx) {
        if (this.filelist.size() < 1) {
            return null;
        }
        if (idx < 0) {
            return null;
        }
        return this.filelist.elementAt(idx);
    }

    public int getArgCount() {
        return this.filelist.size();
    }

    public Long getLongOptionValue(String argKey) {
        String s = this.getOptValue(argKey);
        if (s == null) {
            return null;
        }
        long v = Long.parseLong(s);
        return new Long(v);
    }

    public String getOptValue(String argKey) {
        if (argKey == null) {
            throw new IllegalArgumentException("argKey is null");
        }
        String obj = this.argHash.get(argKey);
        if (obj != null || obj instanceof String) {
            String outString = obj;
            if (outString.equals(NULL_VALUE)) {
                return null;
            }
            return outString;
        }
        return null;
    }

    public boolean isOptPresent(String argKey) {
        if (argKey == null) {
            throw new IllegalArgumentException("argKey is null");
        }
        String obj = this.argHash.get(argKey);
        return obj != null;
    }

    public void loadArgs(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args is null");
        }
        String curOpt = null;
        boolean pastArgs = false;
        int i = 0;
        while (i < args.length) {
            String value = args[i];
            if (pastArgs) {
                this.filelist.addElement(value);
            } else if (value.equals("--")) {
                pastArgs = true;
            } else if (value.startsWith("-")) {
                if (curOpt != null) {
                    this.argHash.put(curOpt, NULL_VALUE);
                }
                curOpt = value;
            } else if (curOpt != null) {
                if (this.hasArgOpt(curOpt)) {
                    this.argHash.put(curOpt, value);
                } else {
                    this.argHash.put(curOpt, NULL_VALUE);
                    pastArgs = true;
                    this.filelist.addElement(value);
                }
                curOpt = null;
            } else {
                pastArgs = true;
                this.filelist.addElement(value);
            }
            ++i;
        }
        if (curOpt != null) {
            this.argHash.put(curOpt, NULL_VALUE);
        }
    }

    public static void main(String[] args) {
        ParseArguments pa = new ParseArguments();
        pa.loadArgs(args);
        pa.dumpArgs(System.out);
        System.out.println();
        System.out.println("Using -l option ");
        pa = new ParseArguments();
        pa.setRequireArgOpts("-l");
        pa.loadArgs(args);
        pa.dumpArgs(System.out);
    }

    public boolean optHasValue(String argKey) {
        if (argKey == null) {
            throw new IllegalArgumentException("argKey is null");
        }
        String obj = this.argHash.get(argKey);
        if (obj == null) {
            return false;
        }
        return obj.equals(NULL_VALUE);
    }

    public String[] getRequireArgOpts() {
        return this.requireArgOpts;
    }

    private boolean hasArgOpt(String arg) {
        if (this.requireArgOpts == null) {
            return false;
        }
        int i = 0;
        while (i < this.requireArgOpts.length) {
            if (this.requireArgOpts[i].equals(arg.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setRequireArgOpts(String[] newRequireArgOpts) {
        this.requireArgOpts = newRequireArgOpts;
    }

    public void setRequireArgOpts(String newRequireArgOpts) {
        this.requireArgOpts = new String[1];
        this.requireArgOpts[0] = newRequireArgOpts;
    }

    public ParseArguments(String[] args, String[] requiredArgs) {
        this.setRequireArgOpts(requiredArgs);
        this.loadArgs(args);
    }
}

