/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.ClarificationUnavailableException;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.RunUnavailableException;
import edu.csus.ecs.pc2.core.exception.UnableToUncheckoutRunException;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.log.EvaluationLog;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestLoginSuccessData;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemDataFilesList;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.packet.PacketType;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class PacketHandler {
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private EvaluationLog evaluationLog = null;

    public PacketHandler(IInternalController controller, IInternalContest contest) {
        this.controller = controller;
        this.contest = contest;
    }

    public PacketHandler(InternalController controller, IInternalContest contest) {
        this.controller = controller;
        this.contest = contest;
    }

    public void handlePacket(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        PacketType.Type packetType = packet.getType();
        this.info("handlePacket start " + packet);
        PacketFactory.dumpPacket(this.controller.getLog(), packet, "handlePacket");
        if (Utilities.isDebugMode()) {
            PacketFactory.dumpPacket(System.out, packet, "handlePacket");
        }
        ClientId fromId = packet.getSourceId();
        switch (packetType) {
            case MESSAGE: {
                PacketFactory.dumpPacket(System.err, packet, null);
                this.handleMessagePacket(packet);
                break;
            }
            case RUN_SUBMISSION_CONFIRM: {
                Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
                this.contest.addRun(run);
                if (!this.isServer()) break;
                this.sendToJudgesAndOthers(packet, this.isThisSite(run));
                break;
            }
            case RUN_SUBMISSION: {
                this.runSubmission(packet, fromId);
                break;
            }
            case CLARIFICATION_SUBMISSION: {
                this.confirmSubmission(packet, fromId);
                break;
            }
            case CLARIFICATION_ANSWER: {
                this.answerClarification(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_ANSWER_UPDATE: {
                this.sendAnswerClarification(packet);
                break;
            }
            case CLARIFICATION_SUBMISSION_CONFIRM: {
                Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
                this.contest.addClarification(clarification);
                if (!this.isServer()) break;
                this.sendToJudgesAndOthers(packet, this.isThisSite(clarification));
                break;
            }
            case CLARIFICATION_UNCHECKOUT: {
                this.cancelClarificationCheckOut(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_CHECKOUT: {
                this.checkoutClarification(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_AVAILABLE: {
                this.sendClarificationAvailable(packet);
                break;
            }
            case LOGIN_FAILED: {
                String message = PacketFactory.getStringValue(packet, "MESSAGE_STRING");
                this.contest.loginDenied(packet.getDestinationId(), connectionHandlerID, message);
                break;
            }
            case CLARIFICATION_NOT_AVAILABLE: {
                Clarification clar = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
                this.contest.clarificationNotAvailable(clar);
                if (!this.isServer()) break;
                this.sendToJudgesAndOthers(packet, this.isThisSite(clar));
                break;
            }
            case RUN_NOTAVAILABLE: {
                this.handleRunNotAvailable(packet);
                break;
            }
            case FORCE_DISCONNECTION: {
                this.sendForceDisconnection(packet);
                break;
            }
            case ESTABLISHED_CONNECTION: {
                this.establishConnection(packet, connectionHandlerID);
                break;
            }
            case DROPPED_CONNECTION: {
                this.droppedConnection(packet, connectionHandlerID);
                break;
            }
            case RUN_AVAILABLE: {
                this.runAvailable(packet);
                break;
            }
            case RUN_JUDGEMENT: {
                this.acceptRunJudgement(packet, connectionHandlerID);
                break;
            }
            case RUN_JUDGEMENT_UPDATE: {
                this.sendJudgementUpdate(packet);
                break;
            }
            case RUN_UPDATE: {
                this.updateRun(packet, connectionHandlerID);
                break;
            }
            case RUN_UPDATE_NOTIFICATION: {
                this.sendRunUpdateNotification(packet);
                break;
            }
            case RUN_UNCHECKOUT: {
                Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
                ClientId whoCanceledId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
                this.cancelRun(packet, run, whoCanceledId, connectionHandlerID);
                break;
            }
            case START_ALL_CLOCKS: {
                this.startContest(packet, connectionHandlerID);
                if (!this.isThisSite(packet.getSourceId())) break;
                this.controller.sendToServers(packet);
                break;
            }
            case STOP_ALL_CLOCKS: {
                this.stopContest(packet, connectionHandlerID);
                if (!this.isThisSite(packet.getSourceId())) break;
                this.controller.sendToServers(packet);
                break;
            }
            case START_CONTEST_CLOCK: {
                this.startContest(packet, connectionHandlerID);
                break;
            }
            case STOP_CONTEST_CLOCK: {
                this.stopContest(packet, connectionHandlerID);
                break;
            }
            case UPDATE_CONTEST_CLOCK: {
                this.updateContestClock(packet);
                break;
            }
            case CLOCK_STARTED: {
                this.startClock(packet);
                break;
            }
            case CLOCK_STOPPED: {
                this.clockStopped(packet);
                break;
            }
            case ADD_SETTING: {
                this.addNewSetting(packet);
                break;
            }
            case DELETE_SETTING: {
                this.deleteSetting(packet);
                break;
            }
            case GENERATE_ACCOUNTS: {
                this.generateAccounts(packet);
                break;
            }
            case UPDATE_SETTING: {
                this.updateSetting(packet);
                break;
            }
            case RUN_CHECKOUT: 
            case RUN_CHECKOUT_NOTIFICATION: {
                this.runCheckout(packet, packetType);
                break;
            }
            case RUN_REJUDGE_CHECKOUT: {
                this.runCheckout(packet, packetType);
                break;
            }
            case CLARIFICATION_REQUEST: {
                this.requestClarification(packet, connectionHandlerID);
                break;
            }
            case RUN_REQUEST: {
                this.runRequest(packet, connectionHandlerID);
                break;
            }
            case RUN_REJUDGE_REQUEST: {
                this.requestRejudgeRun(packet, connectionHandlerID);
                break;
            }
            case LOGOUT: {
                this.logoutClient(packet);
                break;
            }
            case LOGIN: {
                this.loginClient(packet);
                break;
            }
            case PASSWORD_CHANGE_REQUEST: {
                this.attemptChangePassword(packet);
                break;
            }
            case PASSWORD_CHANGE_RESULTS: {
                this.handlePasswordChangeResults(packet);
                break;
            }
            case LOGIN_SUCCESS: {
                this.loginSuccess(packet, connectionHandlerID, fromId);
                break;
            }
            case SERVER_SETTINGS: {
                this.loadSettingsFromRemoteServer(packet, connectionHandlerID);
                this.info(" handlePacket SERVER_SETTINGS - from another site -- all settings loaded " + packet);
                if (!this.isServer()) break;
                this.sendToJudgesAndOthers(packet, false);
                break;
            }
            case RECONNECT_SITE_REQUEST: {
                this.reconnectSite(packet);
                break;
            }
            case SECURITY_MESSAGE: {
                this.handleSecurityMessage(packet);
                break;
            }
            case FETCH_RUN: {
                this.requestFetchedRun(packet, connectionHandlerID);
                break;
            }
            case FETCHED_REQUESTED_RUN: {
                this.handleFetchedRun(packet, connectionHandlerID);
                break;
            }
            case RUN_EXECUTION_STATUS: {
                this.handleRunExecutionStatus(packet, connectionHandlerID);
                break;
            }
            default: {
                Exception exception = new Exception("PacketHandler.handlePacket Unhandled packet " + packet);
                this.controller.getLog().log(Log.WARNING, "Unhandled Packet ", exception);
            }
        }
        this.info("handlePacket end " + packet);
    }

    private void handleRunNotAvailable(Packet packet) {
        ClientId clientId;
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        this.contest.runNotAvailable(run);
        if (this.isServer() && this.isThisSite(clientId = packet.getDestinationId())) {
            this.controller.sendToClient(packet);
        }
    }

    private void handleRunExecutionStatus(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId judgeClientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        RunExecutionStatus status = (RunExecutionStatus)((Object)PacketFactory.getObjectValue(packet, "RUN_STATUS"));
        if (this.isServer()) {
            if (!this.isThisSite(judgeClientId)) {
                this.sendToSpectatorsAndSites(packet, false);
            } else {
                Packet runExecuteStatusPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.sendToSpectatorsAndSites(runExecuteStatusPacket, true);
            }
        } else {
            this.contest.updateRunStatus(run, status, judgeClientId);
        }
    }

    private void requestFetchedRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoRequestsRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.securityCheck(Permission.Type.ALLOWED_TO_FETCH_RUN, whoRequestsRunId, connectionHandlerID);
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet fetchRunPacket = PacketFactory.createFetchRun(serverClientId, whoRequestsRunId, run, serverClientId);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), fetchRunPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                theRun = this.contest.getRun(run.getElementId());
                RunFiles runFiles = this.contest.getRunFiles(run);
                RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                Packet fetchedRunPacket = PacketFactory.createFetchedRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                this.controller.sendToClient(fetchedRunPacket);
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void runAvailable(Packet packet) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        this.contest.availableRun(run);
        if (this.isServer()) {
            this.sendToJudgesAndOthers(packet, this.isThisSite(run));
        }
    }

    private void runSubmission(Packet packet, ClientId fromId) {
        Run submittedRun = (Run)PacketFactory.getObjectValue(packet, "RUN");
        RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
        Run run = this.contest.acceptRun(submittedRun, runFiles);
        Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(this.contest.getClientId(), fromId, run);
        this.controller.sendToClient(confirmPacket);
        if (this.isServer()) {
            this.sendToJudgesAndOthers(confirmPacket, true);
        }
    }

    private void confirmSubmission(Packet packet, ClientId fromId) {
        Clarification submittedClarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        Clarification clarification = this.contest.acceptClarification(submittedClarification);
        Packet confirmPacket = PacketFactory.createClarSubmissionConfirm(this.contest.getClientId(), fromId, clarification);
        this.controller.sendToClient(confirmPacket);
        if (this.isServer()) {
            this.sendToJudgesAndOthers(confirmPacket, true);
        }
    }

    private void runRequest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId requestFromId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Boolean readOnly = (Boolean)PacketFactory.getObjectValue(packet, "READ_ONLY");
        Boolean computerJudge = (Boolean)PacketFactory.getObjectValue(packet, "COMPUTER_JUDGE");
        if (readOnly != null) {
            this.checkoutRun(packet, run, requestFromId, readOnly, computerJudge, connectionHandlerID);
        } else {
            this.requestRun(packet, run, requestFromId, connectionHandlerID, computerJudge);
        }
    }

    private void clockStopped(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        this.contest.stopContest(siteNumber);
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        ContestTime contestTime = this.contest.getContestTime(siteNumber);
        this.info("Clock for site " + contestTime.getSiteNumber() + " stopped by " + clientId + " elapsed " + contestTime.getElapsedTimeStr());
        if (this.isServer()) {
            this.controller.sendToTeams(packet);
            this.sendToJudgesAndOthers(packet, false);
        }
    }

    private void startClock(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        this.contest.startContest(siteNumber);
        ContestTime contestTime = this.contest.getContestTime(siteNumber);
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.info("Clock for site " + contestTime.getSiteNumber() + " started by " + clientId + " elapsed " + contestTime.getElapsedTimeStr());
        if (this.isServer()) {
            this.controller.sendToTeams(packet);
            this.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handlePasswordChangeResults(Packet packet) {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Boolean passwordChanged = (Boolean)PacketFactory.getObjectValue(packet, "PASSWORD_CHANGED");
        String message = (String)PacketFactory.getObjectValue(packet, "MESSAGE_STRING");
        String mess = passwordChanged != false ? "Password changed " + message : "Password NOT changed " + message;
        this.controller.getLog().log(Log.INFO, mess);
        this.contest.passwordChanged(passwordChanged, clientId, message);
    }

    private void attemptChangePassword(Packet packet) {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        String password = (String)PacketFactory.getObjectValue(packet, "PASSWORD");
        String newPassword = (String)PacketFactory.getObjectValue(packet, "NEW_PASSWORD");
        if (clientId == null || password == null || newPassword == null) {
            String mess = "Invalid request ";
            if (password == null) {
                mess = String.valueOf(mess) + " password not specified";
            }
            if (newPassword == null) {
                mess = String.valueOf(mess) + " no new password specified ";
            }
            this.sendPasswordResultsBackToClient(packet.getSourceId(), false, mess);
        } else if (!this.isThisSite(clientId)) {
            String mess = "Security Warning client from other site tried to change password " + clientId;
            this.controller.getLog().log(Log.WARNING, mess);
            Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, mess, packet.getSourceId(), null, null, packet);
            this.controller.sendToAdministrators(violationPacket);
            this.controller.sendToServers(violationPacket);
            this.sendPasswordResultsBackToClient(clientId, false, "Can not change password from site " + clientId);
        } else {
            try {
                if (this.contest.isValidLoginAndPassword(clientId, password)) {
                    Account account = this.contest.getAccount(clientId);
                    account.setPassword(newPassword);
                    this.contest.updateAccount(account);
                    account = this.contest.getAccount(clientId);
                    this.sendPasswordResultsBackToClient(clientId, true, "Password changed");
                    Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId()));
                    this.controller.sendToAdministrators(updatePacket);
                    this.controller.sendToServers(updatePacket);
                }
            }
            catch (Exception exception) {
                this.sendPasswordResultsBackToClient(clientId, false, "Current password does not match, try again");
            }
        }
    }

    private void sendPasswordResultsBackToClient(ClientId clientId, boolean changed, String message) {
        Packet passwordChangeResult = PacketFactory.createPasswordChangeResult(clientId, clientId, changed, message);
        this.controller.sendToClient(passwordChangeResult);
    }

    protected void droppedConnection(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ConnectionHandlerID inConnectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        if (this.isServer()) {
            if (this.isThisSite(packet.getSourceId())) {
                this.controller.sendToServers(packet);
            }
            this.sendToJudgesAndOthers(packet, false);
            this.contest.connectionDropped(inConnectionHandlerID);
        } else {
            this.contest.connectionDropped(inConnectionHandlerID);
        }
    }

    private void handleSecurityMessage(Packet inPacket) {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(inPacket, "CLIENT_ID");
        String message = (String)PacketFactory.getObjectValue(inPacket, "MESSAGE");
        ContestSecurityException contestSecurityException = (ContestSecurityException)PacketFactory.getObjectValue(inPacket, "EXCEPTION");
        this.controller.getLog().log(Log.WARNING, "Security violation " + clientId + " " + message);
        this.contest.newSecurityMessage(clientId, "", message, contestSecurityException);
        if (this.isServer()) {
            Packet forwardPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, inPacket);
            this.controller.sendToAdministrators(forwardPacket);
        }
    }

    private void establishConnection(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ConnectionHandlerID inConnectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        if (this.isServer()) {
            this.controller.sendToAdministrators(packet);
            if (this.isThisSite(packet.getSourceId())) {
                this.controller.sendToServers(packet);
            }
            this.contest.connectionEstablished(inConnectionHandlerID);
        } else {
            this.contest.connectionEstablished(inConnectionHandlerID);
        }
    }

    protected void checkoutClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, whoCheckedOut, connectionHandlerID);
        }
        this.contest.updateClarification(clarification, whoCheckedOut);
        if (this.isServer()) {
            this.sendToJudgesAndOthers(packet, false);
        }
    }

    protected boolean isAllowed(ClientId clientId, Permission.Type type) {
        try {
            Account account = this.contest.getAccount(clientId);
            if (account != null) {
                return account.getPermissionList().isAllowed(type);
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        return false;
    }

    protected void securityCheck(Permission.Type type, ClientId clientId, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        if (this.controller.getSecurityLevel() < 10) {
            return;
        }
        if (!this.isAllowed(clientId, type)) {
            throw new ContestSecurityException(clientId, connectionHandlerID, clientId + " not allowed to " + (Object)((Object)type));
        }
    }

    private void acceptRunJudgement(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        JudgementRecord judgementRecord = (JudgementRecord)PacketFactory.getObjectValue(packet, "JUDGEMENT_RECORD");
        RunResultFiles runResultFiles = (RunResultFiles)PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
        ClientId whoJudgedRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.judgeRun(run, judgementRecord, runResultFiles, whoJudgedRunId, connectionHandlerID, packet);
    }

    private void runCheckout(Packet packet, PacketType.Type packetType) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        switch (packetType) {
            case RUN_CHECKOUT: 
            case RUN_REJUDGE_CHECKOUT: {
                RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
                RunResultFiles[] runResultFiles = (RunResultFiles[])PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
                this.contest.updateRun(run, runFiles, whoCheckedOut, runResultFiles);
                break;
            }
            case RUN_CHECKOUT_NOTIFICATION: {
                if (this.contest.getClientId().equals(whoCheckedOut)) break;
                this.contest.updateRun(run, whoCheckedOut);
                break;
            }
            default: {
                this.controller.getLog().log(Log.WARNING, "Attempted to runCheckout with packet: " + packet);
            }
        }
        if (this.isServer()) {
            this.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handleFetchedRun(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        RunResultFiles[] runResultFiles = (RunResultFiles[])PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
        this.contest.updateRun(run, runFiles, whoCheckedOut, runResultFiles);
    }

    private void requestRejudgeRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoRequestsRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.createRunRejudgeRequest(this.contest.getClientId(), serverClientId, run, whoRequestsRunId);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                try {
                    this.securityCheck(Permission.Type.REJUDGE_RUN, whoRequestsRunId, connectionHandlerID);
                    theRun = this.contest.checkoutRun(run, whoRequestsRunId, true, false);
                    RunFiles runFiles = this.contest.getRunFiles(run);
                    Packet checkOutPacket = PacketFactory.createRejudgeCheckedOut(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId);
                    this.controller.sendToClient(checkOutPacket);
                    this.sendToJudgesAndOthers(checkOutPacket, true);
                }
                catch (RunUnavailableException runUnavailableException) {
                    theRun = this.contest.getRun(run.getElementId());
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, theRun);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void reconnectSite(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (siteNumber != null) {
            try {
                this.controller.getLog().log(Log.INFO, "Client " + packet.getSourceId() + " requests reconnection to site " + siteNumber);
                this.controller.sendServerLoginRequest(siteNumber);
            }
            catch (Exception e) {
                this.controller.getLog().log(Log.WARNING, "Unable to send reconnection request to ", e);
            }
        }
    }

    private void handleMessagePacket(Packet packet) {
        if (this.isThisSite(packet.getDestinationId().getSiteNumber())) {
            if (!packet.getDestinationId().getClientType().equals((Object)ClientType.Type.SERVER)) {
                this.controller.sendToClient(packet);
            }
        } else {
            String message = (String)PacketFactory.getObjectValue(packet, "MESSAGE_STRING");
            Packet messagePacket = PacketFactory.createMessage(this.contest.getClientId(), packet.getDestinationId(), message);
            int siteNumber = packet.getDestinationId().getSiteNumber();
            this.controller.sendToRemoteServer(siteNumber, messagePacket);
        }
    }

    private void loginSuccess(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) {
        if (!this.contest.isLoggedIn()) {
            ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
            if (this.isServer(clientId)) {
                String uberSecretatPassworden = (String)PacketFactory.getObjectValue(packet, "CONTEST_PASSWORD");
                if (uberSecretatPassworden == null) {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ");
                    System.err.println("FATAL ERROR - Contest Security Password is null ");
                    System.exit(44);
                }
                new FileSecurity("db." + clientId.getSiteNumber());
                try {
                    FileSecurity.verifyPassword(uberSecretatPassworden.toCharArray());
                }
                catch (FileSecurityException fileSecurityException) {
                    if (fileSecurityException.getMessage().equals("KEY_FILE_NOT_FOUND")) {
                        try {
                            FileSecurity.saveSecretKey(uberSecretatPassworden.toCharArray());
                        }
                        catch (Exception e) {
                            StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                            System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                            System.exit(44);
                        }
                    } else {
                        StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", fileSecurityException);
                        System.err.println("FATAL ERROR " + fileSecurityException.getMessage() + " check logs");
                        System.exit(44);
                    }
                }
                catch (Exception e) {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                    System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                    System.exit(44);
                }
                this.controller.setContestPassword(uberSecretatPassworden);
            }
            this.info(" handlePacket original LOGIN_SUCCESS before ");
            this.loadDataIntoModel(packet, connectionHandlerID);
            this.info(" handlePacket original LOGIN_SUCCESS after -- all settings loaded ");
            if (this.isServer()) {
                if (this.contest.isLocalLoggedIn(fromId)) {
                    this.contest.removeLogin(fromId);
                }
                if (this.contest.isRemoteLoggedIn(fromId)) {
                    this.contest.removeRemoteLogin(fromId);
                }
                this.contest.addLocalLogin(fromId, connectionHandlerID);
                this.controller.sendToClient(this.createContestSettingsPacket(packet.getSourceId()));
            }
        } else if (this.isServer(packet.getDestinationId())) {
            if (this.contest.isRemoteLoggedIn(fromId)) {
                this.contest.removeRemoteLogin(fromId);
            }
            this.contest.addLocalLogin(fromId, connectionHandlerID);
            this.loadSettingsFromRemoteServer(packet, connectionHandlerID);
            this.controller.sendToClient(this.createContestSettingsPacket(packet.getSourceId()));
        } else {
            Exception ex = new Exception("Client " + this.contest.getClientId() + " received unexpected packet, not logged in but got a " + packet);
            this.controller.getLog().log(Log.WARNING, ex.getMessage(), ex);
        }
    }

    private void dumpServerLoginLists(String comment) {
        ClientId clientId;
        this.info("dumpLoginLists (Site " + this.contest.getSiteNumber() + ") " + comment);
        ClientId[] clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
        String message = "   " + clientIds.length + "  local logins:";
        ClientId[] clientIdArray = clientIds;
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            clientId = clientIdArray[n2];
            message = String.valueOf(message) + " Site " + clientId.getSiteNumber();
            ++n2;
        }
        this.info(String.valueOf(message) + ".");
        clientIds = this.contest.getRemoteLoggedInClients(ClientType.Type.SERVER);
        message = "   " + clientIds.length + " remote logins:";
        clientIdArray = clientIds;
        n = clientIds.length;
        n2 = 0;
        while (n2 < n) {
            clientId = clientIdArray[n2];
            message = String.valueOf(message) + " Site " + clientId.getSiteNumber();
            ++n2;
        }
        this.info(String.valueOf(message) + ".");
    }

    private void updateContestClock(Packet packet) {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        ContestTime contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME");
        if (this.isServer()) {
            if (this.isThisSite(contestTime.getSiteNumber())) {
                this.contest.updateContestTime(contestTime);
                ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
                this.controller.getLog().info("Contest Settings updated by " + who + " running=" + updatedContestTime.isContestRunning() + " elapsed = " + updatedContestTime.getElapsedTimeStr() + " remaining= " + updatedContestTime.getRemainingTimeStr() + " length=" + updatedContestTime.getContestLengthStr());
                Packet updatePacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.controller.sendToTeams(updatePacket);
                this.sendToJudgesAndOthers(updatePacket, true);
            } else {
                this.controller.sendToRemoteServer(siteNumber, packet);
            }
            this.controller.writeConfigToDisk();
        } else {
            this.controller.sendToTeams(packet);
            if (this.isServer()) {
                this.sendToJudgesAndOthers(packet, true);
            }
        }
        if (this.isServer()) {
            this.controller.writeConfigToDisk();
        }
    }

    private boolean isThisSite(ClientId sourceId) {
        return this.isThisSite(sourceId.getSiteNumber());
    }

    private void sendForceDisconnection(Packet packet) {
        ConnectionHandlerID connectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        ClientId clientToLogoffId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (clientToLogoffId != null) {
                if (this.contest.isRemoteLoggedIn(clientToLogoffId)) {
                    this.controller.sendToRemoteServer(clientToLogoffId.getSiteNumber(), packet);
                } else {
                    this.controller.removeConnection(connectionHandlerID);
                }
            } else if (connectionHandlerID != null) {
                if (this.contest.isConnected(connectionHandlerID)) {
                    this.controller.forceConnectionDrop(connectionHandlerID);
                } else {
                    this.controller.sendToServers(packet);
                }
            }
        } else if (clientToLogoffId != null) {
            this.controller.removeLogin(clientToLogoffId);
        } else if (connectionHandlerID != null) {
            this.controller.removeConnection(connectionHandlerID);
        }
    }

    private void updateRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        JudgementRecord judgementRecord = (JudgementRecord)PacketFactory.getObjectValue(packet, "JUDGEMENT_RECORD");
        ClientId whoChangedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (this.isThisSite(run)) {
                this.securityCheck(Permission.Type.EDIT_RUN, packet.getSourceId(), connectionHandlerID);
                if (this.isSuperUser(packet.getSourceId())) {
                    this.info("updateRun by " + packet.getSourceId() + " " + run);
                    if (judgementRecord != null) {
                        run.addJudgement(judgementRecord);
                        this.contest.updateRun(run, whoChangedRun);
                    } else {
                        this.contest.updateRun(run, whoChangedRun);
                    }
                } else {
                    throw new SecurityException("Non-admin user " + packet.getSourceId() + " attempted to update run " + run);
                }
                Run theRun = this.contest.getRun(run.getElementId());
                Packet runUpdatedPacket = PacketFactory.createRunUpdateNotification(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theRun, whoChangedRun);
                this.sendToJudgesAndOthers(runUpdatedPacket, true);
                if (theRun.isJudged() && theRun.getJudgementRecord().isSendToTeam()) {
                    Packet notifyPacket = PacketFactory.clonePacket(this.contest.getClientId(), run.getSubmitter(), runUpdatedPacket);
                    this.sendJudgementToTeam(notifyPacket, theRun);
                }
            } else {
                this.controller.sendToRemoteServer(run.getSiteNumber(), packet);
            }
        } else {
            if (this.contest.isLocalLoggedIn(run.getSubmitter())) {
                this.controller.sendToClient(packet);
            }
            this.sendToJudgesAndOthers(packet, false);
        }
    }

    private void loginClient(Packet packet) {
        if (this.contest.isLoggedIn()) {
            ClientId whoLoggedIn = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
            ConnectionHandlerID connectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
            if (this.isServer()) {
                this.info("LOGIN from other site " + whoLoggedIn);
                if (!this.contest.isLocalLoggedIn(whoLoggedIn)) {
                    if (!this.isThisSite(whoLoggedIn)) {
                        if (this.isServer(whoLoggedIn)) {
                            if (!this.contest.isRemoteLoggedIn(whoLoggedIn)) {
                                this.contest.addRemoteLogin(whoLoggedIn, connectionHandlerID);
                                this.sendToJudgesAndOthers(packet, false);
                            }
                        } else {
                            this.contest.addRemoteLogin(whoLoggedIn, connectionHandlerID);
                            this.sendToJudgesAndOthers(packet, false);
                        }
                    }
                } else {
                    this.controller.getLog().log(Log.DEBUG, "LOGIN packet, server site " + whoLoggedIn + " logged onto " + packet.getSourceId() + ", already logged in on this site");
                }
            } else {
                this.contest.addLogin(whoLoggedIn, connectionHandlerID);
            }
        } else {
            this.info("Note: got a LOGIN packet before this site was logged in " + packet);
        }
    }

    private void logoutClient(Packet packet) {
        ClientId whoLoggedOff = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (this.isServer(whoLoggedOff)) {
                this.controller.getLog().info("No logoff server allowed, logoff packet " + packet + " ignored");
            } else if (this.contest.isLocalLoggedIn(whoLoggedOff)) {
                this.controller.logoffUser(whoLoggedOff);
            } else if (this.isServer(packet.getSourceId()) && whoLoggedOff.getSiteNumber() == packet.getSourceId().getSiteNumber()) {
                this.contest.removeRemoteLogin(whoLoggedOff);
                this.sendToJudgesAndOthers(packet, false);
            } else {
                this.controller.sendToRemoteServer(whoLoggedOff.getSiteNumber(), packet);
            }
        } else {
            this.contest.removeLogin(whoLoggedOff);
        }
    }

    private void sendJudgementUpdate(Packet packet) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoModifiedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.updateRun(run, whoModifiedRun);
            this.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.updateRun(run, whoModifiedRun);
        }
    }

    private void sendAnswerClarification(Packet packet) {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoModifiedClarification = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoModifiedClarification, clarification.isSendToAll());
            this.sendToJudgesAndOthers(packet, false);
            if (clarification.isSendToAll()) {
                this.controller.sendToTeams(packet);
            } else if (this.isThisSite(clarification)) {
                Packet answerPacket = PacketFactory.clonePacket(this.contest.getClientId(), clarification.getSubmitter(), packet);
                this.controller.sendToClient(answerPacket);
            }
        } else {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoModifiedClarification, clarification.isSendToAll());
        }
    }

    private void sendRunUpdateNotification(Packet packet) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoModifiedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.updateRun(run, whoModifiedRun);
            this.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.updateRun(run, whoModifiedRun);
        }
    }

    private void generateAccounts(Packet packet) {
        ClientType.Type type = (ClientType.Type)((Object)PacketFactory.getObjectValue(packet, "CLIENT_TYPE"));
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        Integer count = (Integer)PacketFactory.getObjectValue(packet, "COUNT");
        Integer startCount = (Integer)PacketFactory.getObjectValue(packet, "START_COUNT");
        Boolean active = (Boolean)PacketFactory.getObjectValue(packet, "CREATE_ACCOUNT_ACTIVE");
        if (this.isServer()) {
            if (this.isThisSite(siteNumber)) {
                Vector<Account> accountVector = this.contest.generateNewAccounts(type.toString(), count, startCount, active);
                Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
                this.controller.writeConfigToDisk();
                Packet newAccountsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, accounts);
                this.sendToJudgesAndOthers(newAccountsPacket, true);
            } else {
                this.controller.sendToRemoteServer(siteNumber, packet);
            }
        } else {
            throw new SecurityException("Client " + this.contest.getClientId() + " was sent generate account packet " + packet);
        }
    }

    private void startContest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (packet.getType().equals((Object)PacketType.Type.START_ALL_CLOCKS)) {
            siteNumber = new Integer(this.contest.getSiteNumber());
        }
        if (this.isThisSite(siteNumber)) {
            this.securityCheck(Permission.Type.START_CONTEST_CLOCK, packet.getSourceId(), connectionHandlerID);
            this.contest.startContest(siteNumber);
            ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
            this.controller.getLog().info("Clock STARTED by " + who + " elapsed = " + updatedContestTime.getElapsedTimeStr());
            Packet startContestPacket = PacketFactory.createContestStarted(this.contest.getClientId(), PacketFactory.ALL_SERVERS, updatedContestTime.getSiteNumber(), who);
            this.controller.sendToTeams(startContestPacket);
            this.sendToJudgesAndOthers(startContestPacket, true);
        } else if (packet.getType().equals((Object)PacketType.Type.START_ALL_CLOCKS)) {
            ClientId[] clientIds;
            ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                Packet startContestPacket = PacketFactory.createStartContestClock(this.contest.getClientId(), PacketFactory.ALL_SERVERS, siteNumber, packet.getSourceId());
                this.controller.sendToRemoteServer(clientId.getSiteNumber(), startContestPacket);
                ++n2;
            }
        } else {
            this.controller.sendToRemoteServer(siteNumber, packet);
        }
        if (this.isServer()) {
            this.controller.writeConfigToDisk();
        }
    }

    private void stopContest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (packet.getType().equals((Object)PacketType.Type.STOP_ALL_CLOCKS)) {
            siteNumber = new Integer(this.contest.getSiteNumber());
        }
        if (this.isThisSite(siteNumber)) {
            this.securityCheck(Permission.Type.STOP_CONTEST_CLOCK, who, connectionHandlerID);
            this.contest.stopContest(siteNumber);
            ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
            this.controller.getLog().info("Clock STOPPED by " + who + " elapsed = " + updatedContestTime.getElapsedTimeStr());
            Packet stopContestPacket = PacketFactory.createContestStopped(this.contest.getClientId(), PacketFactory.ALL_SERVERS, updatedContestTime.getSiteNumber(), who);
            this.controller.sendToTeams(stopContestPacket);
            this.sendToJudgesAndOthers(stopContestPacket, true);
        } else if (packet.getType().equals((Object)PacketType.Type.STOP_ALL_CLOCKS)) {
            ClientId[] clientIds;
            ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                Packet startContestPacket = PacketFactory.createStopContestClock(this.contest.getClientId(), PacketFactory.ALL_SERVERS, siteNumber, packet.getSourceId());
                this.controller.sendToRemoteServer(clientId.getSiteNumber(), startContestPacket);
                ++n2;
            }
        } else {
            this.controller.sendToRemoteServer(siteNumber, packet);
        }
        if (this.isServer()) {
            this.controller.writeConfigToDisk();
        }
    }

    private void deleteSetting(Packet packet) {
    }

    private void addNewSetting(Packet packet) {
        ClientSettings clientSettings;
        Account[] accounts;
        BalloonSettings balloonSettings;
        ContestTime contestTime;
        Group group;
        Language language;
        Judgement judgement;
        boolean sendToTeams = false;
        Site site = (Site)PacketFactory.getObjectValue(packet, "SITE");
        if (site != null) {
            this.contest.addSite(site);
            sendToTeams = true;
        }
        if ((judgement = (Judgement)PacketFactory.getObjectValue(packet, "JUDGEMENT")) != null) {
            this.contest.addJudgement(judgement);
            sendToTeams = true;
        }
        if ((language = (Language)PacketFactory.getObjectValue(packet, "LANGUAGE")) != null) {
            this.contest.addLanguage(language);
            sendToTeams = true;
        }
        if ((group = (Group)PacketFactory.getObjectValue(packet, "GROUP")) != null) {
            this.contest.addGroup(group);
            sendToTeams = true;
        }
        Problem problem = (Problem)PacketFactory.getObjectValue(packet, "PROBLEM");
        ProblemDataFiles problemDataFiles = (ProblemDataFiles)PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
        if (problem != null) {
            if (problemDataFiles != null) {
                this.contest.addProblem(problem, problemDataFiles);
            } else {
                this.contest.addProblem(problem);
            }
            sendToTeams = true;
        }
        if ((contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME")) != null) {
            this.contest.addContestTime(contestTime);
            sendToTeams = true;
        }
        if ((balloonSettings = (BalloonSettings)PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS")) != null) {
            this.contest.addBalloonSettings(balloonSettings);
            sendToTeams = true;
        }
        Packet updatePacket = null;
        Account oneAccount = (Account)PacketFactory.getObjectValue(packet, "ACCOUNT");
        if (oneAccount != null) {
            if (this.isServer()) {
                if (this.isThisSite(oneAccount)) {
                    ClientId clientId = oneAccount.getClientId();
                    Vector<Account> accountVector = this.contest.generateNewAccounts(clientId.getClientType().toString(), 1, true);
                    Account addedAccount = accountVector.firstElement();
                    addedAccount.setDisplayName(oneAccount.getDisplayName());
                    addedAccount.setPassword(oneAccount.getPassword());
                    addedAccount.clearListAndLoadPermissions(oneAccount.getPermissionList());
                    this.contest.updateAccount(addedAccount);
                    updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, this.contest.getAccount(addedAccount.getClientId()));
                }
            } else {
                this.contest.updateAccount(oneAccount);
            }
        }
        if ((accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY")) != null) {
            Account account;
            Vector<Account> addAccountsVector = new Vector<Account>();
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                account = accountArray[n2];
                if (this.contest.getAccount(account.getClientId()) == null) {
                    addAccountsVector.add(account);
                }
                ++n2;
            }
            if (addAccountsVector.size() > 0) {
                this.contest.addAccounts(addAccountsVector.toArray(new Account[addAccountsVector.size()]));
            }
            if (this.isServer()) {
                accountArray = accounts;
                n = accounts.length;
                n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.contest.isLocalLoggedIn(account.getClientId())) {
                        Packet newPacket = account.getClientId().getClientType().equals((Object)ClientType.Type.TEAM) ? PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId())) : PacketFactory.clonePacket(this.contest.getClientId(), account.getClientId(), packet);
                        this.controller.sendToClient(newPacket);
                    }
                    ++n2;
                }
            }
        }
        if ((clientSettings = (ClientSettings)PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS")) != null) {
            this.contest.addClientSettings(clientSettings);
            ClientId toId = clientSettings.getClientId();
            if (this.isJudge(toId)) {
                try {
                    this.sendToJudgesAndOthers(packet, this.isThisSite(toId));
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                }
            }
            if (this.contest.isLocalLoggedIn(clientSettings.getClientId())) {
                try {
                    Packet newSettingsPacket = PacketFactory.clonePacket(this.contest.getClientId(), toId, packet);
                    this.controller.sendToClient(newSettingsPacket);
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                }
            }
        }
        if (this.isServer()) {
            this.controller.writeConfigToDisk();
            boolean sendToOtherServers = this.isThisSite(packet.getSourceId().getSiteNumber());
            if (updatePacket != null) {
                this.sendToJudgesAndOthers(updatePacket, sendToOtherServers);
            } else {
                Packet addPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.sendToJudgesAndOthers(addPacket, sendToOtherServers);
                if (sendToTeams) {
                    this.controller.sendToTeams(addPacket);
                }
            }
        }
    }

    private void updateSetting(Packet packet) {
        ClientSettings clientSettings;
        ContestInformation contestInformation;
        Account[] accounts;
        Account oneAccount;
        BalloonSettings balloonSettings;
        ContestTime contestTime;
        Group group;
        Language language;
        Judgement judgement;
        boolean sendToTeams = false;
        Packet oneUpdatePacket = null;
        Site site = (Site)PacketFactory.getObjectValue(packet, "SITE");
        if (site != null) {
            this.contest.updateSite(site);
            sendToTeams = true;
        }
        if ((judgement = (Judgement)PacketFactory.getObjectValue(packet, "JUDGEMENT")) != null) {
            this.contest.updateJudgement(judgement);
            sendToTeams = true;
        }
        if ((language = (Language)PacketFactory.getObjectValue(packet, "LANGUAGE")) != null) {
            this.contest.updateLanguage(language);
            sendToTeams = true;
        }
        if ((group = (Group)PacketFactory.getObjectValue(packet, "GROUP")) != null) {
            this.contest.updateGroup(group);
            sendToTeams = true;
        }
        Problem problem = (Problem)PacketFactory.getObjectValue(packet, "PROBLEM");
        ProblemDataFiles problemDataFiles = (ProblemDataFiles)PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
        if (problem != null) {
            if (problemDataFiles != null) {
                this.contest.updateProblem(problem, problemDataFiles);
            } else {
                this.contest.updateProblem(problem);
            }
            sendToTeams = true;
        }
        if ((contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME")) != null) {
            this.contest.updateContestTime(contestTime);
            sendToTeams = true;
        }
        if ((balloonSettings = (BalloonSettings)PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS")) != null) {
            this.contest.updateBalloonSettings(balloonSettings);
            sendToTeams = true;
        }
        if ((oneAccount = (Account)PacketFactory.getObjectValue(packet, "ACCOUNT")) != null) {
            this.contest.updateAccount(oneAccount);
            if (this.isThisSite(oneAccount.getClientId().getSiteNumber()) && this.isServer()) {
                oneUpdatePacket = PacketFactory.clonePacket(this.contest.getClientId(), oneAccount.getClientId(), packet);
                this.controller.sendToClient(oneUpdatePacket);
            }
        }
        if ((accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY")) != null) {
            Account account;
            Vector<Account> addAccountsVector = new Vector<Account>();
            Vector<Account> updateAccountsVector = new Vector<Account>();
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                account = accountArray[n2];
                if (this.contest.getAccount(account.getClientId()) == null) {
                    addAccountsVector.add(account);
                } else {
                    updateAccountsVector.add(account);
                }
                ++n2;
            }
            if (addAccountsVector.size() > 0) {
                this.contest.addAccounts(addAccountsVector.toArray(new Account[addAccountsVector.size()]));
            }
            if (updateAccountsVector.size() > 0) {
                this.contest.updateAccounts(updateAccountsVector.toArray(new Account[updateAccountsVector.size()]));
            }
            if (this.isServer()) {
                accountArray = accounts;
                n = accounts.length;
                n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.contest.isLocalLoggedIn(account.getClientId())) {
                        Packet updatePacket = account.getClientId().getClientType().equals((Object)ClientType.Type.TEAM) ? PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId())) : PacketFactory.clonePacket(this.contest.getClientId(), account.getClientId(), packet);
                        this.controller.sendToClient(updatePacket);
                    }
                    ++n2;
                }
            }
        }
        if ((contestInformation = (ContestInformation)PacketFactory.getObjectValue(packet, "CONTEST_INFORMATION")) != null) {
            this.contest.updateContestInformation(contestInformation);
            sendToTeams = true;
        }
        if ((clientSettings = (ClientSettings)PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS")) != null) {
            ClientId toId;
            this.contest.updateClientSettings(clientSettings);
            if (this.isServer() && !this.isJudge(toId = clientSettings.getClientId()) && this.contest.isLocalLoggedIn(toId)) {
                Packet updatePacket = PacketFactory.clonePacket(this.contest.getClientId(), toId, packet);
                this.controller.sendToClient(updatePacket);
            }
        }
        if (this.isServer()) {
            this.controller.writeConfigToDisk();
            boolean sendToOtherServers = this.isThisSite(packet.getSourceId().getSiteNumber());
            if (oneUpdatePacket != null) {
                this.sendToJudgesAndOthers(oneUpdatePacket, sendToOtherServers);
            } else {
                Packet updatePacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.sendToJudgesAndOthers(updatePacket, sendToOtherServers);
                if (sendToTeams) {
                    this.controller.sendToTeams(updatePacket);
                }
            }
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    private boolean isThisSite(ISubmission submission) {
        return submission.getSiteNumber() == this.contest.getSiteNumber();
    }

    public void sendToJudgesAndOthers(Packet packet, boolean sendToServers) {
        if (this.isServer()) {
            this.controller.sendToAdministrators(packet);
            this.controller.sendToJudges(packet);
            this.controller.sendToScoreboards(packet);
            if (sendToServers) {
                this.controller.sendToServers(packet);
            }
        } else {
            this.info("Warning - tried to send packet to others (as non server) " + packet);
            Exception ex = new Exception("User " + packet.getSourceId() + " tried to send packet to judges and others");
            this.controller.getLog().log(Log.WARNING, "Warning - tried to send packet to others (as non server) " + packet, ex);
        }
    }

    public void sendToSpectatorsAndSites(Packet packet, boolean sendToServers) {
        if (this.isServer()) {
            this.controller.sendToSpectators(packet);
            if (sendToServers) {
                this.controller.sendToServers(packet);
            }
        } else {
            this.info("Warning - tried to send packet to others (as non server) " + packet);
            Exception ex = new Exception("User " + packet.getSourceId() + " tried to send packet to judges and others");
            this.controller.getLog().log(Log.WARNING, "Warning - tried to send packet to others (as non server) " + packet, ex);
        }
    }

    private boolean isSuperUser(ClientId id) {
        return id.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    public void cancelRun(Packet packet, Run run, ClientId whoCanceledRun, ConnectionHandlerID connectionHandlerID) {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                this.controller.sendToRemoteServer(run.getSiteNumber(), packet);
            } else {
                try {
                    this.contest.cancelRunCheckOut(run, whoCanceledRun);
                    Run availableRun = this.contest.getRun(run.getElementId());
                    Packet availableRunPacket = PacketFactory.createRunAvailable(this.contest.getClientId(), whoCanceledRun, availableRun);
                    this.sendToJudgesAndOthers(availableRunPacket, true);
                }
                catch (UnableToUncheckoutRunException e) {
                    this.controller.getLog().log(Log.WARNING, "Security Warning " + e.getMessage(), e);
                    Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, e.getMessage(), whoCanceledRun, connectionHandlerID, null, packet);
                    this.controller.sendToAdministrators(violationPacket);
                    this.controller.sendToServers(violationPacket);
                }
            }
        } else {
            this.contest.updateRun(run, whoCanceledRun);
        }
    }

    public void cancelClarificationCheckOut(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCancelledIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(clarification)) {
                ClientId destinationId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet cancelPacket = PacketFactory.clonePacket(this.contest.getClientId(), destinationId, packet);
                this.controller.sendToRemoteServer(clarification.getSiteNumber(), cancelPacket);
            } else {
                this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                Packet cancelPacket = PacketFactory.createClarificationAvailable(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theClarification);
                if (this.isServer()) {
                    this.sendToJudgesAndOthers(cancelPacket, true);
                }
            }
        } else {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
        }
    }

    private void sendClarificationAvailable(Packet packet) {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCancelledIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
            this.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
        }
    }

    private void answerClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoAnsweredIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(clarification)) {
                ClientId destinationId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet answerPacket = PacketFactory.clonePacket(this.contest.getClientId(), destinationId, packet);
                this.controller.sendToRemoteServer(clarification.getSiteNumber(), answerPacket);
            } else {
                this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, whoAnsweredIt, connectionHandlerID);
                this.contest.answerClarification(clarification, clarification.getAnswer(), whoAnsweredIt, clarification.isSendToAll());
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                Packet answerPacket = PacketFactory.createAnsweredClarificationUpdate(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theClarification, theClarification.getAnswer(), whoAnsweredIt);
                this.sendToJudgesAndOthers(answerPacket, true);
                if (clarification.isSendToAll()) {
                    this.controller.sendToTeams(answerPacket);
                } else {
                    Packet answerForTeamPacket = PacketFactory.clonePacket(this.contest.getClientId(), clarification.getSubmitter(), answerPacket);
                    this.controller.sendToClient(answerForTeamPacket);
                }
            }
        } else {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoAnsweredIt, clarification.isSendToAll());
        }
    }

    protected void judgeRun(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoJudgedId, ConnectionHandlerID connectionHandlerID, Packet packet) throws ContestSecurityException {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet judgementPacket = PacketFactory.clonePacket(this.contest.getClientId(), serverClientId, packet);
                this.controller.sendToRemoteServer(run.getSiteNumber(), judgementPacket);
            } else {
                RunResultFiles rrf;
                this.securityCheck(Permission.Type.JUDGE_RUN, whoJudgedId, connectionHandlerID);
                judgementRecord.setWhenJudgedTime(this.contest.getContestTime().getElapsedMins());
                this.contest.addRunJudgement(run, judgementRecord, runResultFiles, whoJudgedId);
                Run theRun = this.contest.getRun(run.getElementId());
                if (judgementRecord.isComputerJudgement()) {
                    if (this.contest.getProblem(theRun.getProblemId()).isManualReview()) {
                        if (this.contest.getProblem(theRun.getProblemId()).isPrelimaryNotification()) {
                            rrf = runResultFiles;
                            if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                                rrf = null;
                            }
                            Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                            this.sendJudgementToTeam(judgementPacket, theRun);
                        }
                    } else {
                        rrf = runResultFiles;
                        if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                            rrf = null;
                        }
                        Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                        this.sendJudgementToTeam(judgementPacket, theRun);
                    }
                } else {
                    rrf = runResultFiles;
                    if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                        rrf = null;
                    }
                    Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                    this.sendJudgementToTeam(judgementPacket, theRun);
                }
                Packet judgementUpdatePacket = PacketFactory.createRunJudgmentUpdate(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theRun, whoJudgedId);
                this.sendToJudgesAndOthers(judgementUpdatePacket, true);
            }
        } else {
            this.contest.updateRun(run, judgementRecord.getJudgerClientId());
        }
    }

    private void sendJudgementToTeam(Packet judgementPacket, Run run) {
        if (run.isJudged() && run.getJudgementRecord().isSendToTeam()) {
            JudgementNotificationsList judgementNotificationsList = this.contest.getContestInformation().getJudgementNotificationsList();
            if (!RunUtilities.supppressJudgement(judgementNotificationsList, run, this.contest.getContestTime())) {
                this.controller.sendToClient(judgementPacket);
            } else {
                this.controller.getLog().info("Notification not sent to " + run.getSubmitter() + " for run " + run);
            }
        } else {
            this.controller.getLog().warning("Attempted to send back unjudged run to team " + run);
        }
    }

    private void requestRun(Packet packet, Run run, ClientId whoRequestsRunId, ConnectionHandlerID connectionHandlerID, boolean computerJudge) throws ContestSecurityException {
        this.checkoutRun(packet, run, whoRequestsRunId, false, computerJudge, connectionHandlerID);
    }

    private void requestClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        ElementId clarificationId = (ElementId)PacketFactory.getObjectValue(packet, "REQUESTED_CLARIFICATION_ELEMENT_ID");
        ClientId requestFromId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        boolean readOnly = false;
        if (this.isServer()) {
            Clarification clarification = this.contest.getClarification(clarificationId);
            if (!this.isThisSite(clarification)) {
                ClientId serverClientId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.clonePacket(this.contest.getClientId(), serverClientId, packet);
                    this.controller.sendToRemoteServer(clarification.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createClarificationNotAvailable(this.contest.getClientId(), requestFromId, clarification, requestFromId);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                if (readOnly) {
                    this.info("requestClarification read-only not implemented, yet");
                } else {
                    try {
                        this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, requestFromId, connectionHandlerID);
                        theClarification = this.contest.checkoutClarification(clarification, requestFromId);
                        Packet checkOutPacket = PacketFactory.createCheckedOutClarification(this.contest.getClientId(), requestFromId, theClarification, requestFromId);
                        this.controller.sendToClient(checkOutPacket);
                        this.sendToJudgesAndOthers(checkOutPacket, true);
                    }
                    catch (ClarificationUnavailableException clarUnavailableException) {
                        this.controller.getLog().info("clarUnavailableException " + clarUnavailableException.getMessage());
                        Packet notAvailableRunPacket = PacketFactory.createClarificationNotAvailable(this.contest.getClientId(), requestFromId, clarification, requestFromId);
                        this.controller.sendToClient(notAvailableRunPacket);
                    }
                }
            }
        } else {
            throw new SecurityException("requestClarification - sent to client " + this.contest.getClientId());
        }
    }

    private void checkoutRun(Packet packet, Run run, ClientId whoRequestsRunId, boolean readOnly, boolean computerJudge, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.createRunRequest(this.contest.getClientId(), serverClientId, run, whoRequestsRunId, readOnly, computerJudge);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                if (readOnly) {
                    theRun = this.contest.getRun(run.getElementId());
                    RunFiles runFiles = this.contest.getRunFiles(run);
                    RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                    Packet checkOutPacket = PacketFactory.createCheckedOutRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                    this.controller.sendToClient(checkOutPacket);
                } else {
                    try {
                        this.securityCheck(Permission.Type.JUDGE_RUN, whoRequestsRunId, connectionHandlerID);
                        theRun = this.contest.checkoutRun(run, whoRequestsRunId, false, computerJudge);
                        RunFiles runFiles = this.contest.getRunFiles(run);
                        if (runFiles == null) {
                            try {
                                this.contest.cancelRunCheckOut(run, whoRequestsRunId);
                            }
                            catch (UnableToUncheckoutRunException unableToUncheckoutRunException) {
                                this.controller.getLog().severe("Problem canceling run checkout after error getting run files.");
                            }
                            throw new RunUnavailableException("Error retrieving files.");
                        }
                        RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                        Packet checkOutPacket = PacketFactory.createCheckedOutRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                        this.controller.sendToClient(checkOutPacket);
                        Packet checkOutNotificationPacket = PacketFactory.createCheckedOutRunNotification(this.contest.getClientId(), whoRequestsRunId, theRun, whoRequestsRunId);
                        this.sendToJudgesAndOthers(checkOutNotificationPacket, true);
                    }
                    catch (RunUnavailableException runUnavailableException) {
                        this.controller.getLog().info("runUnavailableException " + runUnavailableException.getMessage());
                        theRun = this.contest.getRun(run.getElementId());
                        Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, theRun);
                        this.controller.sendToClient(notAvailableRunPacket);
                    }
                }
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void addAllRunsToModel(Packet packet) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (!this.isServer() || !this.isThisSite(run)) {
                        this.contest.addRun(run);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addAllClarificationsToModel(Packet packet) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                Clarification[] clarificationArray = clarifications;
                int n = clarifications.length;
                int n2 = 0;
                while (n2 < n) {
                    Clarification clarification = clarificationArray[n2];
                    if (!this.isServer() || !this.isThisSite(clarification)) {
                        if (this.contest.getClarification(clarification.getElementId()) != null) {
                            this.contest.updateClarification(clarification, null);
                        } else {
                            this.contest.addClarification(clarification);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addAllAccountsToModel(Packet packet) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                Account[] accountArray = accounts;
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Account account = accountArray[n2];
                    if (this.isServer()) {
                        if (!this.isThisSite(account)) {
                            this.contest.updateAccount(account);
                        }
                    } else {
                        this.contest.updateAccount(account);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addAllConnectionIdsToModel(Packet packet) {
        try {
            ConnectionHandlerID[] connectionHandlerIDs = (ConnectionHandlerID[])PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID_LIST");
            if (connectionHandlerIDs != null) {
                ConnectionHandlerID[] connectionHandlerIDArray = connectionHandlerIDs;
                int n = connectionHandlerIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionHandlerID connectionHandlerID = connectionHandlerIDArray[n2];
                    this.contest.connectionEstablished(connectionHandlerID);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addLoginsToModel(Packet packet) {
        try {
            ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOGGED_IN_USERS");
            if (clientIds != null) {
                ClientId[] clientIdArray = clientIds;
                int n = clientIds.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionHandlerID fakeId;
                    ClientId clientId = clientIdArray[n2];
                    if (this.isServer()) {
                        if (!this.contest.isLocalLoggedIn(clientId) && !this.isThisSite(clientId.getSiteNumber())) {
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            this.info("addLoginsToModel: Adding remote login " + clientId);
                            this.contest.addRemoteLogin(clientId, fakeId);
                        }
                    } else {
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                        this.contest.addRemoteLogin(clientId, fakeId);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void dumpClientList(ClientId[] clientIds, String comment) {
        if (clientIds == null || clientIds.length == 0) {
            this.info(String.valueOf(comment) + " no clients in list ");
        } else {
            Arrays.sort(clientIds, new ClientIdComparator());
            ClientId[] clientIdArray = clientIds;
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                this.info(String.valueOf(comment) + " " + clientId);
                ++n2;
            }
        }
    }

    private boolean isThisSite(Account account) {
        return account.getSiteNumber() == this.contest.getSiteNumber();
    }

    private void loadSettingsFromRemoteServer(Packet packet, ConnectionHandlerID connectionHandlerID) {
        int remoteSiteNumber = packet.getSourceId().getSiteNumber();
        this.addRemoteContestTimesToModel(packet, remoteSiteNumber);
        this.addRemoteRunsToModel(packet, remoteSiteNumber);
        this.addRemoteClarificationsToModel(packet, remoteSiteNumber);
        this.addRemoteAccountsToModel(packet, remoteSiteNumber);
        this.addRemoteAllClientSettingsToModel(packet, remoteSiteNumber);
        this.addRemoteLoginsToModel(packet, remoteSiteNumber);
        if (this.isServer()) {
            this.loginToOtherSites(packet);
        }
    }

    private void addRemoteLoginsToModel(Packet packet, int remoteSiteNumber) {
        try {
            ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOGGED_IN_USERS");
            if (clientIds != null) {
                ClientId[] clientIdArray = clientIds;
                int n = clientIds.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionHandlerID fakeId;
                    ClientId clientId = clientIdArray[n2];
                    if (this.isServer(clientId)) {
                        if (!this.contest.isLocalLoggedIn(clientId) && !this.isThisSite(clientId.getSiteNumber())) {
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            this.info("Adding remote login " + clientId);
                            this.contest.addRemoteLogin(clientId, fakeId);
                        }
                    } else if (remoteSiteNumber == clientId.getSiteNumber()) {
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + "-" + clientId);
                        this.contest.addRemoteLogin(clientId, fakeId);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addRemoteAllClientSettingsToModel(Packet packet, int remoteSiteNumber) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                ClientSettings[] clientSettingsArray = clientSettings;
                int n = clientSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientSettings clientSettings2 = clientSettingsArray[n2];
                    if (remoteSiteNumber == clientSettings2.getSiteNumber()) {
                        this.contest.updateClientSettings(clientSettings2);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addRemoteAccountsToModel(Packet packet, int remoteSiteNumber) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                Account[] accountArray = accounts;
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Account account = accountArray[n2];
                    if (remoteSiteNumber == account.getSiteNumber()) {
                        this.contest.updateAccount(account);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addRemoteClarificationsToModel(Packet packet, int remoteSiteNumber) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                Clarification[] clarificationArray = clarifications;
                int n = clarifications.length;
                int n2 = 0;
                while (n2 < n) {
                    Clarification clarification = clarificationArray[n2];
                    if (remoteSiteNumber == clarification.getSiteNumber()) {
                        this.contest.addClarification(clarification);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addRemoteRunsToModel(Packet packet, int remoteSiteNumber) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (remoteSiteNumber == run.getSiteNumber()) {
                        this.contest.updateRun(run, packet.getSourceId());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addRemoteContestTimesToModel(Packet packet, int remoteSiteNumber) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                ContestTime[] contestTimeArray = contestTimes;
                int n = contestTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    ContestTime contestTime = contestTimeArray[n2];
                    if (remoteSiteNumber == contestTime.getSiteNumber()) {
                        if (this.contest.getContestTime(contestTime.getSiteNumber()) != null) {
                            this.contest.updateContestTime(contestTime);
                        } else {
                            this.contest.addContestTime(contestTime);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void loadDataIntoModel(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ContestTime contestTime;
        ClientId clientId = null;
        try {
            clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
            if (clientId != null) {
                this.contest.setClientId(clientId);
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        this.controller.setSiteNumber(clientId.getSiteNumber());
        this.addSitesToModel(packet);
        if (this.isServer()) {
            this.controller.initializeServer();
        }
        this.addLanguagesToModel(packet);
        this.addProblemsToModel(packet);
        this.addGroupsToModel(packet);
        try {
            Judgement[] judgements = (Judgement[])PacketFactory.getObjectValue(packet, "JUDGEMENT_LIST");
            if (judgements != null) {
                Judgement[] judgementArray = judgements;
                int n = judgements.length;
                int n2 = 0;
                while (n2 < n) {
                    Judgement judgement = judgementArray[n2];
                    if (this.contest.getJudgement(judgement.getElementId()) != null) {
                        this.contest.updateJudgement(judgement);
                    } else {
                        this.contest.addJudgement(judgement);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        try {
            contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME");
            if (contestTime != null) {
                if (this.isServer()) {
                    if (this.isThisSite(contestTime.getSiteNumber())) {
                        this.controller.setContestTime(contestTime);
                    } else if (this.contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        this.contest.addContestTime(contestTime);
                    } else {
                        this.contest.updateContestTime(contestTime);
                    }
                } else {
                    GregorianCalendar serverTransmitTime = (GregorianCalendar)PacketFactory.getObjectValue(packet, "SERVER_CLOCK_OFFSET");
                    contestTime.calculateLocalClockOffset(serverTransmitTime);
                    if (this.contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        this.contest.addContestTime(contestTime);
                    } else {
                        this.contest.updateContestTime(contestTime);
                    }
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        try {
            ContestInformation contestInformation = (ContestInformation)PacketFactory.getObjectValue(packet, "CONTEST_INFORMATION");
            if (contestInformation != null) {
                this.contest.updateContestInformation(contestInformation);
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        this.addAllClientSettingsToModel(packet);
        this.initializeContestTime();
        this.addAllContestTimesToModel(packet);
        this.addAllRunsToModel(packet);
        this.addAllClarificationsToModel(packet);
        this.addAllAccountsToModel(packet);
        this.addAllConnectionIdsToModel(packet);
        this.addLoginsToModel(packet);
        this.addBalloonSettingsToModel(packet);
        try {
            Problem generalProblem = (Problem)PacketFactory.getObjectValue(packet, "GENERAL_PROBLEM");
            if (generalProblem != null) {
                this.contest.setGeneralProblem(generalProblem);
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged in General Problem ", e);
        }
        if (this.contest.isLoggedIn()) {
            if (this.contest.getContestTime() == null) {
                contestTime = new ContestTime();
                contestTime.setSiteNumber(this.contest.getSiteNumber());
                this.contest.addContestTime(contestTime);
            }
            this.controller.startMainUI(this.contest.getClientId());
            if (this.isServer()) {
                this.loginToOtherSites(packet);
            }
        } else {
            String message = "Trouble logging in, check logs";
            this.contest.loginDenied(packet.getDestinationId(), connectionHandlerID, message);
        }
        try {
            if (this.evaluationLog == null && this.isServer()) {
                Utilities.insureDir("logs");
                this.evaluationLog = new EvaluationLog("logs" + File.separator + "evals.log", this.contest, this.controller);
                this.evaluationLog.getEvalLog().println("# Log opened " + new Date());
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addLanguagesToModel(Packet packet) {
        try {
            Language[] languages = (Language[])PacketFactory.getObjectValue(packet, "LANGUAGE_LIST");
            if (languages != null) {
                Language[] languageArray = languages;
                int n = languages.length;
                int n2 = 0;
                while (n2 < n) {
                    Language language = languageArray[n2];
                    if (this.contest.getLanguage(language.getElementId()) != null) {
                        this.contest.updateLanguage(language);
                    } else {
                        this.contest.addLanguage(language);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addGroupsToModel(Packet packet) {
        try {
            Group[] groups = (Group[])PacketFactory.getObjectValue(packet, "GROUP_LIST");
            if (groups != null) {
                Group[] groupArray = groups;
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    Group group = groupArray[n2];
                    if (this.contest.getGroup(group.getElementId()) != null) {
                        this.contest.updateGroup(group);
                    } else {
                        this.contest.addGroup(group);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void initializeContestTime() {
        if (this.isServer() && this.contest.getContestTime() == null) {
            ContestTime contestTime = new ContestTime(this.contest.getSiteNumber());
            this.contest.addContestTime(contestTime);
            this.info("Initialized contest time " + contestTime.getRemainingTimeStr() + " for site " + contestTime.getSiteNumber());
        }
    }

    private void addBalloonSettingsToModel(Packet packet) {
        try {
            BalloonSettings[] balloonSettings = (BalloonSettings[])PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS_LIST");
            if (balloonSettings != null) {
                BalloonSettings[] balloonSettingsArray = balloonSettings;
                int n = balloonSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    BalloonSettings balloonSettings2 = balloonSettingsArray[n2];
                    this.contest.updateBalloonSettings(balloonSettings2);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addAllClientSettingsToModel(Packet packet) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                ClientSettings[] clientSettingsArray = clientSettings;
                int n = clientSettings.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientSettings clientSettings2 = clientSettingsArray[n2];
                    ClientId clientId = clientSettings2.getClientId();
                    if (this.isServer()) {
                        if (!this.isThisSite(clientId)) {
                            this.contest.updateClientSettings(clientSettings2);
                        }
                    } else {
                        this.contest.updateClientSettings(clientSettings2);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addProblemsToModel(Packet packet) {
        int n;
        int n2;
        IElementObject[] iElementObjectArray;
        ProblemDataFilesList problemDataFilesList = new ProblemDataFilesList();
        try {
            ProblemDataFiles[] problemDataFiles = (ProblemDataFiles[])PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
            if (problemDataFiles != null) {
                iElementObjectArray = problemDataFiles;
                n2 = problemDataFiles.length;
                n = 0;
                while (n < n2) {
                    IElementObject problemDataFile = iElementObjectArray[n];
                    problemDataFilesList.add(problemDataFile);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
        try {
            Problem[] problems = (Problem[])PacketFactory.getObjectValue(packet, "PROBLEM_LIST");
            if (problems != null) {
                iElementObjectArray = problems;
                n2 = problems.length;
                n = 0;
                while (n < n2) {
                    IElementObject problem = iElementObjectArray[n];
                    ProblemDataFiles problemDataFiles = (ProblemDataFiles)problemDataFilesList.get(problem);
                    if (this.contest.getProblem(((Problem)problem).getElementId()) != null) {
                        if (problemDataFiles == null) {
                            this.contest.updateProblem((Problem)problem);
                        } else {
                            this.contest.updateProblem((Problem)problem, problemDataFiles);
                        }
                    } else if (problemDataFiles == null) {
                        this.contest.addProblem((Problem)problem);
                    } else {
                        this.contest.addProblem((Problem)problem, problemDataFiles);
                    }
                    ++n;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addAllContestTimesToModel(Packet packet) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                ContestTime[] contestTimeArray = contestTimes;
                int n = contestTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    ContestTime contestTime = contestTimeArray[n2];
                    if (this.contest.getSiteNumber() != contestTime.getSiteNumber()) {
                        if (this.contest.getContestTime(contestTime.getSiteNumber()) != null) {
                            this.contest.updateContestTime(contestTime);
                        } else {
                            this.contest.addContestTime(contestTime);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void addSitesToModel(Packet packet) {
        try {
            Site[] sites = (Site[])PacketFactory.getObjectValue(packet, "SITE_LIST");
            if (sites != null) {
                Site[] siteArray = sites;
                int n = sites.length;
                int n2 = 0;
                while (n2 < n) {
                    Site site = siteArray[n2];
                    this.info("addSitesToModel " + site);
                    this.contest.updateSite(site);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void loginToOtherSites(Packet packet) {
        this.dumpServerLoginLists("loginToOtherSites");
        Site[] siteArray = this.contest.getSites();
        int n = siteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            if (!this.isThisSite(site.getSiteNumber())) {
                try {
                    ClientId serverClientId = new ClientId(site.getSiteNumber(), ClientType.Type.SERVER, 0);
                    if (this.contest.isRemoteLoggedIn(serverClientId)) {
                        this.controller.sendServerLoginRequest(site.getSiteNumber());
                    } else if (this.contest.isLocalLoggedIn(serverClientId)) {
                        this.info("Not logging into site " + site.getSiteNumber() + ", site already logged in");
                    } else {
                        this.info("Not logging into site " + site.getSiteNumber() + ", site is not connected to contest.");
                    }
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logging into other site ", e);
                }
            }
            ++n2;
        }
    }

    private Account[] getAllAccounts() {
        Vector<Account> allAccounts = new Vector<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            if (this.contest.getAccounts(ctype).size() > 0) {
                Vector<Account> accounts = this.contest.getAccounts(ctype);
                allAccounts.addAll(accounts);
            }
            ++n2;
        }
        Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
        return accountList;
    }

    private ClientId[] getAllLoggedInUsers() {
        Vector<ClientId> clientList = new Vector<ClientId>();
        this.dumpServerLoginLists("getAllLoggedInUsers");
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId[] users;
            ClientType.Type ctype = typeArray[n2];
            ClientId[] clientIdArray = users = this.contest.getAllLoggedInClients(ctype);
            int n3 = users.length;
            int n4 = 0;
            while (n4 < n3) {
                ClientId clientId = clientIdArray[n4];
                clientList.addElement(clientId);
                ++n4;
            }
            ++n2;
        }
        if (clientList.size() == 0) {
            return new ClientId[0];
        }
        ClientId[] clients = clientList.toArray(new ClientId[clientList.size()]);
        return clients;
    }

    Packet createContestSettingsPacket(ClientId clientId, Packet packet) {
        return PacketFactory.createContestSettingsPacket(this.contest.getClientId(), clientId, packet);
    }

    public Packet createContestSettingsPacket(ClientId clientId) {
        return PacketFactory.createContestSettingsPacket(this.contest.getClientId(), clientId, this.createLoginSuccessPacket(clientId, null));
    }

    public Packet createLoginSuccessPacket(ClientId clientId, String contestSecurityPassword) {
        Run[] runs = null;
        Clarification[] clarifications = null;
        ProblemDataFiles[] problemDataFiles = new ProblemDataFiles[]{};
        ClientSettings[] clientSettings = null;
        Account[] accounts = null;
        Site[] sites = null;
        if (this.contest.getClientSettings(clientId) == null) {
            ClientSettings clientSettings2 = new ClientSettings(clientId);
            clientSettings2.put("LoginDate", new Date().toString());
            this.contest.addClientSettings(clientSettings2);
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.TEAM)) {
            runs = this.contest.getRuns(clientId);
            clarifications = this.contest.getClarifications(clientId);
            clientSettings = new ClientSettings[]{this.contest.getClientSettings(clientId)};
            accounts = new Account[]{this.contest.getAccount(clientId)};
            Site[] realSites = this.contest.getSites();
            sites = new Site[realSites.length];
            int i = 0;
            while (i < realSites.length) {
                sites[i] = new Site(realSites[i].getDisplayName(), realSites[i].getSiteNumber());
                ++i;
            }
        } else {
            runs = this.contest.getRuns();
            clarifications = this.contest.getClarifications();
            problemDataFiles = this.contest.getProblemDataFiles();
            clientSettings = this.contest.getClientSettingsList();
            accounts = this.getAllAccounts();
            sites = this.contest.getSites();
        }
        ContestLoginSuccessData contestLoginSuccessData = new ContestLoginSuccessData();
        contestLoginSuccessData.setAccounts(accounts);
        contestLoginSuccessData.setBalloonSettingsArray(this.contest.getBalloonSettings());
        contestLoginSuccessData.setClarifications(clarifications);
        contestLoginSuccessData.setClientSettings(clientSettings);
        contestLoginSuccessData.setConnectionHandlerIDs(this.contest.getConnectionHandleIDs());
        contestLoginSuccessData.setContestTimes(this.contest.getContestTimes());
        contestLoginSuccessData.setGroups(this.contest.getGroups());
        contestLoginSuccessData.setJudgements(this.contest.getJudgements());
        contestLoginSuccessData.setLanguages(this.contest.getLanguages());
        contestLoginSuccessData.setLoggedInUsers(this.getAllLoggedInUsers());
        contestLoginSuccessData.setProblemDataFiles(problemDataFiles);
        contestLoginSuccessData.setProblems(this.contest.getProblems());
        contestLoginSuccessData.setRuns(runs);
        contestLoginSuccessData.setSites(sites);
        contestLoginSuccessData.setGeneralProblem(this.contest.getGeneralProblem());
        if (this.isServer(clientId)) {
            contestLoginSuccessData.setContestSecurityPassword(contestSecurityPassword);
        }
        Packet loginSuccessPacket = PacketFactory.createLoginSuccess(this.contest.getClientId(), clientId, this.contest.getContestTime(), this.contest.getSiteNumber(), this.contest.getContestInformation(), contestLoginSuccessData);
        return loginSuccessPacket;
    }

    private boolean isServer(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isJudge(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isServer() {
        return this.isServer(this.contest.getClientId());
    }

    public void info(String s) {
        this.controller.getLog().info(s);
    }

    public void info(String s, Exception exception) {
        this.controller.getLog().log(Log.INFO, s, exception);
    }
}

