/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Ini;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.PacketHandler;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.archive.PacketArchiver;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.log.EvaluationLog;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ConfigurationIO;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.packet.PacketType;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.connection.ConnectionManager;
import edu.csus.ecs.pc2.ui.CountDownMessage;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.LoadUIClass;
import edu.csus.ecs.pc2.ui.LoginFrame;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Properties;
import javax.swing.JOptionPane;

public class InternalController
implements IInternalController,
ITwoToOne,
IBtoA {
    private IInternalContest contest;
    private ITransportManager connectionManager;
    private UIPlugin uiPlugin = null;
    private Log log;
    private Ini ini = new Ini();
    private String judgementINIFileName = "reject.ini";
    private static final String DEBUG_OPTION_STRING = "--debug";
    private static final String SITE_OPTION_STRING = "--site";
    private static final String LOGIN_OPTION_STRING = "--login";
    private static final String PASSWORD_OPTION_STRING = "--password";
    private static final String LOGIN_UI_OPTION_STRING = "--loginUI";
    private static int port;
    private String remoteHostName = "127.0.0.1";
    private int remoteHostPort;
    private static final String SERVER_PORT_KEY = "server.port";
    private static final String REMOTE_SERVER_KEY = "server.remoteServer";
    private static final String CLIENT_SERVER_KEY = "client.server";
    private static final String CLIENT_PORT_KEY = "client.port";
    private static ConnectionHandlerID remoteServerConnectionHandlerID;
    private ParseArguments parseArguments = new ParseArguments();
    private boolean contactingRemoteServer = true;
    private boolean usingMainUI = true;
    private PacketArchiver packetArchiver = new PacketArchiver();
    private LoginFrame loginUI;
    private boolean isStarted = false;
    private PacketHandler packetHandler = null;
    private boolean serverModule = false;
    private ConfigurationIO configurationIO = new ConfigurationIO(1);
    private boolean saveCofigurationToDisk = true;
    private EvaluationLog evaluationLog;
    public static final int SECURITY_HIGH_LEVEL = 10;
    public static final int SECURITY_NONE_LEVEL = 0;
    private static final String CONTEST_PASSWORD_OPTION = "--contestpassword";
    private int securityLevel = 10;
    private String contestPassword = null;
    private boolean clientAutoShutdown = true;

    static {
        remoteServerConnectionHandlerID = null;
    }

    public InternalController(IInternalContest contest) {
        this.contest = contest;
        this.packetHandler = new PacketHandler(this, contest);
    }

    public void sendToLocalServer(Packet packet) {
        try {
            this.log.info("Sending packet to server " + packet);
            this.connectionManager.send(packet);
        }
        catch (TransportException e) {
            this.info("Unable to send to Server  " + packet);
            e.printStackTrace();
        }
        this.log.info("Sent    packet to server " + packet);
    }

    private void sendToClient(ConnectionHandlerID connectionHandlerID, Packet packet) {
        this.info("sendToClient (send) " + packet.getDestinationId() + " " + packet + " " + connectionHandlerID);
        try {
            this.connectionManager.send(packet, connectionHandlerID);
        }
        catch (TransportException e) {
            this.info("Unable to send to " + connectionHandlerID + " packet " + packet);
            e.printStackTrace();
        }
    }

    public void sendToRemoteServer(int siteNumber, Packet packet) {
        ClientId clientId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
        this.info("sendToRemoteServer " + clientId + " " + packet + " " + connectionHandlerID);
        ClientType.Type type = packet.getSourceId().getClientType();
        if (!type.equals((Object)ClientType.Type.ADMINISTRATOR) && !type.equals((Object)ClientType.Type.SERVER)) {
            this.log.log(Log.WARNING, "Unexpected User sent packet to other (" + siteNumber + ") site.  " + packet);
        }
        if (connectionHandlerID != null) {
            try {
                this.connectionManager.send(packet, connectionHandlerID);
            }
            catch (TransportException e) {
                this.log.log(Log.SEVERE, "Exception sending packet to site " + siteNumber + " " + packet, e);
            }
        } else {
            this.log.log(Log.SEVERE, "Unable to send packet to site " + siteNumber + " (" + clientId + ")" + packet);
        }
    }

    public void sendToClient(Packet packet) {
        this.info("sendToClient b4 to " + packet.getDestinationId() + " " + packet);
        ClientId toClientId = packet.getDestinationId();
        if (this.isThisSite(toClientId.getSiteNumber())) {
            if (this.contest.isLocalLoggedIn(toClientId)) {
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(toClientId);
                this.info("sendToClient " + packet.getSourceId() + " " + connectionHandlerID);
                this.sendToClient(connectionHandlerID, packet);
            } else {
                try {
                    this.packetArchiver.writeNextPacket(packet);
                    this.info("Unable to send packet to " + toClientId + " not logged in.  Packet saved in: " + this.packetArchiver.getLastArchiveFilename());
                }
                catch (Exception e) {
                    this.info("Unable to send packet to " + toClientId + " could not save packet", e);
                }
            }
        } else {
            this.sendToRemoteServer(toClientId.getSiteNumber(), packet);
        }
        this.info("sendToClient af to " + packet.getDestinationId() + " " + packet);
    }

    public void submitRun(Problem problem, Language language, String filename, SerializedFile[] otherFiles) throws Exception {
        SerializedFile serializedFile = new SerializedFile(filename);
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Run run = new Run(this.contest.getClientId(), language, problem);
        RunFiles runFiles = new RunFiles(run, serializedFile, otherFiles);
        Packet packet = PacketFactory.createSubmittedRun(this.contest.getClientId(), serverClientId, run, runFiles);
        this.sendToLocalServer(packet);
    }

    public void requestChangePassword(String oldPassword, String newPassword) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createPasswordChangeRequest(this.contest.getClientId(), serverClientId, oldPassword, newPassword);
        this.sendToLocalServer(packet);
    }

    private static int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static boolean containsINIKey(String key) {
        if (IniFile.isFilePresent()) {
            return IniFile.containsKey(key);
        }
        return false;
    }

    private static String getINIValue(String key) {
        if (IniFile.isFilePresent()) {
            return IniFile.getValue(key);
        }
        return "";
    }

    public static ClientId loginShortcutExpansion(int defaultSiteNumber, String loginName) {
        if (loginName.equals("t")) {
            loginName = "team1";
        }
        if (loginName.equals("s")) {
            loginName = "server1";
        }
        if (loginName.equals("r") || loginName.equals("root")) {
            loginName = "administrator1";
        }
        if (loginName.startsWith("site") && loginName.length() > 4) {
            int number = InternalController.getIntegerValue(loginName.substring(4));
            return new ClientId(number, ClientType.Type.SERVER, 0);
        }
        if (loginName.startsWith("server") && loginName.length() > 6) {
            int number = InternalController.getIntegerValue(loginName.substring(6));
            return new ClientId(number, ClientType.Type.SERVER, 0);
        }
        if (loginName.startsWith("judge") && loginName.length() > 5) {
            int number = InternalController.getIntegerValue(loginName.substring(5));
            return new ClientId(defaultSiteNumber, ClientType.Type.JUDGE, number);
        }
        if (loginName.startsWith("administrator") && loginName.length() > 13) {
            int number = InternalController.getIntegerValue(loginName.substring(13));
            return new ClientId(defaultSiteNumber, ClientType.Type.ADMINISTRATOR, number);
        }
        if (loginName.startsWith("scoreboard") && loginName.length() > 10) {
            int number = InternalController.getIntegerValue(loginName.substring(10));
            return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
        }
        if (loginName.startsWith("board") && loginName.length() > 5) {
            int number = InternalController.getIntegerValue(loginName.substring(5));
            return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
        }
        if (loginName.startsWith("s") && loginName.length() > 1) {
            if (Character.isDigit(loginName.charAt(1))) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(number, ClientType.Type.SERVER, 0);
            }
        } else {
            if (loginName.startsWith("b") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.SCOREBOARD, number);
            }
            if (loginName.startsWith("a") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.ADMINISTRATOR, number);
            }
            if (loginName.startsWith("j") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.JUDGE, number);
            }
            if (loginName.startsWith("t") && loginName.length() > 4) {
                int number = InternalController.getIntegerValue(loginName.substring(4));
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
            if (loginName.startsWith("t") && loginName.length() > 1) {
                int number = InternalController.getIntegerValue(loginName.substring(1));
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
            if (Character.isDigit(loginName.charAt(0))) {
                int number = InternalController.getIntegerValue(loginName);
                return new ClientId(defaultSiteNumber, ClientType.Type.TEAM, number);
            }
        }
        loginName = loginName.toUpperCase();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            String typeName = type.toString();
            if (loginName.startsWith(typeName) && loginName.length() > typeName.length()) {
                int number = InternalController.getIntegerValue(loginName.substring(typeName.length()));
                return new ClientId(defaultSiteNumber, type, number);
            }
            ++n2;
        }
        throw new SecurityException("No such account " + loginName);
    }

    protected String stripChar(String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx > -1) {
            StringBuffer sb = new StringBuffer(s);
            idx = sb.indexOf(String.valueOf(ch));
            while (idx > -1) {
                sb.deleteCharAt(idx);
                idx = sb.indexOf(String.valueOf(ch));
            }
            return sb.toString();
        }
        return s;
    }

    public void login(String id, String password) {
        if (!this.isStarted) {
            throw new SecurityException("Invalid sequence, must call start(String[]) method before login(String, String).");
        }
        ClientId clientId = InternalController.loginShortcutExpansion(0, id);
        this.log = new Log(this.stripChar(clientId.toString(), ' '));
        this.connectionManager.setLog(this.log);
        StaticLog.setLog(this.log);
        this.info("");
        this.info(new VersionInfo().getSystemVersionInfo());
        this.info("Login: " + id + " (aka " + clientId.getName() + ")");
        try {
            this.log.info("Working directory is " + new File(".").getCanonicalPath());
        }
        catch (IOException e1) {
            this.log.info("Could not determine working directory " + e1.getMessage());
        }
        if (password.length() < 1) {
            password = clientId.getName();
            if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                password = "site" + clientId.getSiteNumber();
            }
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            if (this.isContactingRemoteServer()) {
                this.info("Contacting " + this.remoteHostName + ":" + this.remoteHostPort);
                try {
                    remoteServerConnectionHandlerID = this.connectionManager.connectToServer(this.remoteHostName, this.remoteHostPort);
                }
                catch (TransportException e) {
                    this.info("** ERROR ** Unable to contact server at " + this.remoteHostName + ":" + this.remoteHostPort);
                    this.info("Server at " + this.remoteHostName + ":" + this.remoteHostPort + " not started or contacting wrong host or port ?");
                    this.info("Transport Exception ", e);
                    throw new SecurityException("Unable to contact server, check logs");
                }
                this.info("Contacted using connection id " + remoteServerConnectionHandlerID);
                this.sendLoginRequestFromServerToServer(this.connectionManager, remoteServerConnectionHandlerID, clientId, password);
            } else {
                if (!this.serverModule) {
                    SecurityException securityException = new SecurityException("Cannot login as server, check logs");
                    this.getLog().log(Log.WARNING, "Cannot login as server, must start this module with --server command line option");
                    securityException.printStackTrace(System.err);
                    throw securityException;
                }
                clientId = this.authenticateFirstServer(clientId.getSiteNumber(), password);
                try {
                    this.connectionManager.accecptConnections(port);
                    this.info("Started Server Transport listening on " + port);
                }
                catch (Exception e) {
                    this.info("Exception logged ", e);
                    SecurityException securityException = new SecurityException("Port " + port + " in use, server already running?");
                    securityException.printStackTrace(System.err);
                    throw securityException;
                }
                this.info("Primary Server has started.");
                this.startMainUI(clientId);
            }
        } else {
            if (this.serverModule) {
                SecurityException securityException = new SecurityException("Cannot login as client, check logs");
                this.getLog().log(Log.WARNING, "Cannot login as client, must start this module without --server command line option");
                throw securityException;
            }
            this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
            this.sendLoginRequest(this.connectionManager, clientId, id, password);
        }
    }

    public IInternalContest clientLogin(IInternalContest internalContest, String loginName, String password) throws Exception {
        if (!this.isStarted) {
            throw new SecurityException("Invalid sequence, must call start(String[]) method before login(String, String).");
        }
        if (this.connectionManager == null) {
            this.isStarted = false;
            throw new Exception("Unable to contact server at " + this.getHostContacted() + ":" + this.getPortContacted() + " (server not started?)");
        }
        ClientId clientId = InternalController.loginShortcutExpansion(0, loginName);
        this.log = new Log(this.stripChar(clientId.toString(), ' '));
        this.connectionManager.setLog(this.log);
        StaticLog.setLog(this.log);
        this.info("");
        this.info(new VersionInfo().getSystemVersionInfo());
        this.info("Login: " + loginName + " (aka " + clientId.getName() + ")");
        try {
            this.log.info("Working directory is " + new File(".").getCanonicalPath());
        }
        catch (IOException e1) {
            this.log.info("Could not determine working directory " + e1.getMessage());
        }
        if (password.length() < 1) {
            password = clientId.getName();
            if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                password = "site" + clientId.getSiteNumber();
            }
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            throw new SecurityException("Cannot use clientLogin to login a Server " + loginName);
        }
        TemporaryClientUI temporaryClientUI = new TemporaryClientUI();
        internalContest.addLoginListener(temporaryClientUI);
        this.setUsingMainUI(true);
        this.setUiPlugin(temporaryClientUI);
        this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
        this.sendLoginRequest(this.connectionManager, clientId, loginName, password);
        long curTimeMS = new Date().getTime();
        long endTimeMS = curTimeMS + 10000L;
        while (temporaryClientUI.getContest() == null) {
            Thread.sleep(500L);
            curTimeMS = new Date().getTime();
            if (curTimeMS <= endTimeMS) continue;
            this.info("Login failed - timed out, server at " + this.remoteHostName + ":" + this.remoteHostPort + " as " + clientId);
            throw new SecurityException("Login failed - timed out");
        }
        return temporaryClientUI.getContest();
    }

    public void initializeServer() {
        boolean loadedConfiguration;
        if (this.contest.getSites().length == 0 && this.contest.getSiteNumber() == 0) {
            this.contest.setSiteNumber(1);
            this.info("initializeServer STARTED this site as Site 1");
            new FileSecurity("db.1");
            if (this.contestPassword == null) {
                String password = JOptionPane.showInputDialog(null, (Object)"Enter Contest Password");
                if (password == null || password.trim().length() == 0) {
                    JOptionPane.showMessageDialog(null, "You must supply a password, exiting.");
                    System.exit(44);
                }
                this.contestPassword = password;
            }
            try {
                FileSecurity.verifyPassword(this.contestPassword.toCharArray());
            }
            catch (FileSecurityException fileSecurityException) {
                if (fileSecurityException.getMessage().equals("KEY_FILE_NOT_FOUND")) {
                    try {
                        FileSecurity.saveSecretKey(this.contestPassword.toCharArray());
                    }
                    catch (Exception e) {
                        StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                        System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                        JOptionPane.showMessageDialog(null, "Invalid password");
                        System.exit(44);
                    }
                } else {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", fileSecurityException);
                    System.err.println("FATAL ERROR " + fileSecurityException.getMessage() + " check logs");
                    JOptionPane.showMessageDialog(null, "Invalid password");
                    System.exit(44);
                }
            }
            catch (Exception e) {
                StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                JOptionPane.showMessageDialog(null, "Exception while validating contest password " + e.getMessage());
                System.exit(44);
            }
        }
        if (!(loadedConfiguration = this.readConfigFromDisk(this.contest.getSiteNumber()))) {
            this.log.info("initializing controller with default settings");
            if (this.contest.getSite(1) == null) {
                Site site = this.createFirstSite(this.contest.getSiteNumber(), "localhost", port);
                this.contest.addSite(site);
            }
            this.contest.initializeStartupData(this.contest.getSiteNumber());
            this.contest.initializeSubmissions(this.contest.getSiteNumber());
            this.loadJudgements();
            if (this.contest.getGeneralProblem() == null) {
                this.contest.setGeneralProblem(new Problem("General"));
            }
            this.info("initialized controller Site " + this.contest.getSiteNumber());
            this.writeConfigToDisk();
        } else {
            if (this.saveCofigurationToDisk) {
                this.contest.initializeSubmissions(this.contest.getSiteNumber());
            }
            this.info("Loaded configuration from disk");
        }
        try {
            if (this.evaluationLog == null) {
                Utilities.insureDir("logs");
                this.evaluationLog = new EvaluationLog("logs" + File.separator + "evals.log", this.contest, this);
                this.evaluationLog.getEvalLog().println("# Log opened " + new Date());
                this.info("evals.log is opened");
            }
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    protected void loadJudgements() {
        if (!this.isContactingRemoteServer() && this.contest.getJudgements().length == 0) {
            if (this.loadedJudgementsFromIni()) {
                this.info("Loaded judgements from " + this.judgementINIFileName);
            } else {
                this.info(String.valueOf(this.judgementINIFileName) + " not found, ok.  Loading default judgements");
                this.loadDefaultJudgements();
            }
        }
    }

    protected boolean loadedJudgementsFromIni() {
        if (new File(this.judgementINIFileName).exists()) {
            String[] lines = Utilities.loadINIFile(this.judgementINIFileName);
            if (lines == null || lines.length == 0) {
                return false;
            }
            Judgement judgement = new Judgement("Yes");
            this.contest.addJudgement(judgement);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String judgementName = stringArray[n2];
                judgement = new Judgement("No - " + judgementName);
                this.contest.addJudgement(judgement);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private void loadDefaultJudgements() {
        String[] judgementNames;
        String[] stringArray = judgementNames = new String[]{"Yes", "No - Compilation Error", "No - Run-time Error", "No - Time-limit Exceeded", "No - Wrong Answer", "No - Excessive Output", "No - Output Format Error", "No - Other - Contact Staff"};
        int n = judgementNames.length;
        int n2 = 0;
        while (n2 < n) {
            String judgementName = stringArray[n2];
            Judgement judgement = new Judgement(judgementName);
            this.contest.addJudgement(judgement);
            ++n2;
        }
    }

    private ClientId authenticateFirstServer(int siteNum, String password) {
        this.initializeServer();
        int newSiteNumber = this.getServerSiteNumber(siteNum, password);
        ClientId newId = new ClientId(newSiteNumber, ClientType.Type.SERVER, 0);
        if (this.contest.isLocalLoggedIn(newId)) {
            this.info("Note site " + newId + " site " + newSiteNumber + " already logged in, ignoring ");
        }
        return newId;
    }

    private Site createFirstSite(int siteNumber, String hostName, int portNumber) {
        Site site = new Site("Site " + siteNumber, siteNumber);
        Properties props = new Properties();
        props.put("IP_KEY", hostName);
        props.put("PORT_KEY", "" + portNumber);
        site.setConnectionInfo(props);
        site.setPassword("site" + siteNumber);
        return site;
    }

    private void setClientServerAndPort(String portString) {
        this.remoteHostName = "localhost";
        this.remoteHostPort = Integer.parseInt("50002");
        if (this.ini.containsKey(CLIENT_SERVER_KEY)) {
            this.remoteHostName = this.ini.getValue(CLIENT_SERVER_KEY);
            this.getLog().log(Log.INFO, "INI File location: " + this.ini.getIniFileURL());
            int idx = this.remoteHostName.lastIndexOf(":");
            int literalClose = this.remoteHostName.indexOf("]");
            if (idx > literalClose && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
            this.getLog().log(Log.INFO, "setClientServerAndPort " + this.remoteHostName + " parsed as " + this.remoteHostName + " port " + this.remoteHostPort);
        } else if (InternalController.containsINIKey(CLIENT_SERVER_KEY)) {
            this.remoteHostName = InternalController.getINIValue(CLIENT_SERVER_KEY);
            this.getLog().log(Log.INFO, "INI File location: " + IniFile.getIniFileURL());
            int idx = this.remoteHostName.lastIndexOf(":");
            int literalClose = this.remoteHostName.indexOf("]");
            if (idx > literalClose && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
            this.getLog().log(Log.INFO, "setClientServerAndPort " + this.remoteHostName + " parsed as " + this.remoteHostName + " port " + this.remoteHostPort);
        }
        if (InternalController.containsINIKey(CLIENT_PORT_KEY)) {
            this.remoteHostPort = Integer.parseInt(InternalController.getINIValue(CLIENT_PORT_KEY));
        }
        if (portString != null) {
            this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
            this.remoteHostPort = Integer.parseInt(portString);
        }
    }

    private void setServerRemoteHostAndPort(String remoteServerValue) {
        String hostName = InternalController.getINIValue(REMOTE_SERVER_KEY);
        if (hostName != null && hostName.length() > 4) {
            this.remoteHostName = hostName;
            this.contactingRemoteServer = true;
        }
        if (remoteServerValue != null) {
            this.remoteHostName = remoteServerValue;
            this.contactingRemoteServer = true;
        }
        if (this.contactingRemoteServer) {
            int literalClose;
            this.remoteHostPort = Integer.parseInt("50002");
            int idx = this.remoteHostName.lastIndexOf(":");
            if (idx > (literalClose = this.remoteHostName.indexOf("]")) && idx > 2) {
                this.remoteHostPort = Integer.parseInt(this.remoteHostName.substring(idx + 1));
                this.remoteHostName = this.remoteHostName.substring(0, idx);
            }
        }
    }

    private void setServerPort(String portString) {
        port = Integer.parseInt("50002");
        if (InternalController.containsINIKey(SERVER_PORT_KEY)) {
            port = Integer.parseInt(InternalController.getINIValue(SERVER_PORT_KEY));
        }
        if (portString != null) {
            this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
            port = Integer.parseInt(portString);
        }
    }

    private void sendLoginRequestFromServerToServer(ITransportManager manager, ConnectionHandlerID targetConnectionHandlerID, ClientId clientId, String password) {
        try {
            this.info("sendLoginRequestFromServerToServer ConId start - sending from " + clientId);
            ClientId serverClientId = new ClientId(0, ClientType.Type.SERVER, 0);
            String joeLoginName = password;
            Packet loginPacket = PacketFactory.createLoginRequest(clientId, joeLoginName, password, serverClientId);
            manager.send(loginPacket, targetConnectionHandlerID);
            this.info("sendLoginRequestFromServerToServer ConId end - packet sent.");
        }
        catch (TransportException e) {
            this.info("Exception sendLoginRequestFromServerToServer ", e);
        }
    }

    private void sendLoginRequest(ITransportManager manager, ClientId clientId, String loginName, String password) {
        this.info("sendLoginRequest start - sending from " + clientId);
        ClientId serverClientId = new ClientId(0, ClientType.Type.SERVER, 0);
        Packet loginPacket = PacketFactory.createLoginRequest(clientId, loginName, password, serverClientId);
        this.sendToLocalServer(loginPacket);
        this.info("sendLoginRequest end - packet sent.");
    }

    public void receiveObject(Serializable object, ConnectionHandlerID connectionHandlerID) {
        this.info("receiveObject start got " + object);
        try {
            if (object instanceof Packet) {
                Packet packet = (Packet)object;
                ClientId clientId = packet.getSourceId();
                this.info("receiveObject " + packet);
                if (packet.getType().equals((Object)PacketType.Type.LOGIN_REQUEST)) {
                    String password = PacketFactory.getStringValue(packet, "PASSWORD");
                    try {
                        this.packetArchiver.writeNextPacket(packet);
                        if (clientId.getSiteNumber() == 0) {
                            clientId = new ClientId(this.contest.getSiteNumber(), clientId.getClientType(), clientId.getClientNumber());
                        }
                        this.attemptToLogin(clientId, password, connectionHandlerID);
                        this.sendLoginSuccess(clientId, connectionHandlerID);
                        Packet loginConfirmedPacket = PacketFactory.createLogin(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID, clientId);
                        this.sendToAdministrators(loginConfirmedPacket);
                        this.sendToJudges(loginConfirmedPacket);
                        this.sendToServers(loginConfirmedPacket);
                        this.packetArchiver.writeNextPacket(loginConfirmedPacket);
                    }
                    catch (SecurityException securityException) {
                        String message = securityException.getMessage();
                        this.sendLoginFailure(packet.getSourceId(), connectionHandlerID, message);
                    }
                } else if (this.contest.isLocalLoggedIn(packet.getSourceId())) {
                    this.securityCheck(packet, connectionHandlerID);
                    this.processPacket(packet, connectionHandlerID);
                } else if (this.contest.isRemoteLoggedIn(packet.getSourceId()) && clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR)) {
                    this.processPacket(packet, connectionHandlerID);
                } else {
                    if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
                        if (packet.getType() == PacketType.Type.LOGIN_FAILED) {
                            this.handleServerLoginFailure(packet);
                        } else if (!this.contest.isLoggedIn() && packet.getType().equals((Object)PacketType.Type.LOGIN_SUCCESS)) {
                            this.processPacket(packet, connectionHandlerID);
                            this.loginServer(clientId, connectionHandlerID);
                        } else if (!this.contest.isLoggedIn() && packet.getType().equals((Object)PacketType.Type.LOGIN)) {
                            this.processPacket(packet, connectionHandlerID);
                        } else {
                            System.err.println("Security Violation Packet from non-logged in server" + packet);
                            this.info("Note: security violation in packet: Packet from non-logged in server");
                            this.log.info("Security Violation for packet " + packet);
                        }
                        return;
                    }
                    System.err.println("Security Violation Packet from non-logged in server" + packet);
                    this.info("Note: security violation in packet: Packet from non-logged in server");
                    this.log.info("Security Violation for packet " + packet);
                }
            } else {
                this.info("receiveObject(S,C): Unsupported class received: " + object);
            }
        }
        catch (Exception e) {
            this.info("Exception in receiveObject(S,C): " + e.getMessage(), e);
            this.info("Exception in receiveObject ", e);
        }
        this.info("receiveObject end   got " + object.getClass().getName());
    }

    private void loginServer(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        if (this.contest.isLocalLoggedIn(clientId)) {
            this.contest.removeLogin(clientId);
        }
        if (this.contest.isRemoteLoggedIn(clientId)) {
            this.contest.removeRemoteLogin(clientId);
        }
        this.contest.addLocalLogin(clientId, connectionHandlerID);
    }

    private void securityCheck(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ClientId fromId;
        ConnectionHandlerID connectionHandlerIDAuthen = this.contest.getConnectionHandleID(packet.getSourceId());
        if (!connectionHandlerID.equals(connectionHandlerIDAuthen)) {
            this.info("Note: security violation in packet: ConnectionHandlerID do not match, check log");
            this.log.info("Security Violation for packet " + packet);
            this.log.info("User " + packet.getSourceId() + " expected " + connectionHandlerIDAuthen);
            this.log.info("User " + packet.getSourceId() + " found    " + connectionHandlerID);
        }
        if (!this.isThisSite((fromId = packet.getSourceId()).getSiteNumber()) && !this.isServer(fromId)) {
            this.info("Security Violation expecting only server from site " + fromId.getSiteNumber() + " for packet " + packet);
            this.log.info("Security Violation expecting only server from site " + fromId.getSiteNumber() + " for packet " + packet);
        }
    }

    private void handleServerLoginFailure(Packet packet) {
        try {
            this.packetArchiver.writeNextPacket(packet);
            this.log.info("Login failure packet written to " + this.packetArchiver.getLastArchiveFilename() + " " + packet);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged trying to write packet ", e);
        }
        String message = PacketFactory.getStringValue(packet, "MESSAGE_STRING");
        this.info("Login Failed: " + message);
        this.info("Login Failure");
        PacketFactory.dumpPacket(System.err, packet, "Login Failed");
        if (this.loginUI != null) {
            FrameUtilities.regularCursor(this.loginUI);
        }
        this.contest.loginDenied(packet.getDestinationId(), null, message);
    }

    private int getServerSiteNumber(int siteNum, String password) {
        if (this.matchOverride(password)) {
            StaticLog.info("matchOverride succeeded, logging in as site" + siteNum);
            return siteNum;
        }
        Site site = this.contest.getSite(siteNum);
        if (site != null && site.getPassword().equals(password)) {
            return site.getSiteNumber();
        }
        if (this.contest.getSites().length > 1 || this.contest.isLoggedIn()) {
            throw new SecurityException("No such site or invalid site password");
        }
        throw new SecurityException("Does not match first site password");
    }

    private boolean matchOverride(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.reset();
            md.update(password.getBytes());
            byte[] digested = md.digest();
            int matchedBytes = 0;
            byte[] overridePassword = new byte[]{-108, 121, 83, 9, 106, -13, 43, 10, 47, 87, -114, 115, -38, -38, -64, -125, 41, -1, -79, -102};
            int i = 0;
            while (i < digested.length) {
                if (digested[i] != overridePassword[i]) break;
                ++matchedBytes;
                ++i;
            }
            return matchedBytes == overridePassword.length;
        }
        catch (Exception ex99) {
            StaticLog.log("Exception in matchOverride", ex99);
            return false;
        }
    }

    protected boolean validAccountAndMatchOverride(ClientId clientId, String password) {
        Account account = this.contest.getAccount(clientId);
        return account != null && this.matchOverride(password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attemptToLogin(ClientId clientId, String password, ConnectionHandlerID connectionHandlerID) {
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            int newSiteNumber = this.getServerSiteNumber(clientId.getSiteNumber(), password);
            if (newSiteNumber != clientId.getSiteNumber()) throw new SecurityException("Failed attempt to login");
            this.loginServer(clientId, connectionHandlerID);
            return;
        }
        if (this.validAccountAndMatchOverride(clientId, password) || this.contest.isValidLoginAndPassword(clientId, password)) {
            if (this.contest.isLocalLoggedIn(clientId)) {
                ConnectionHandlerID connectionHandlerID2 = this.contest.getConnectionHandleID(clientId);
                this.log.info("login - " + clientId + " already logged in, will logoff client at connection " + connectionHandlerID2);
                this.contest.removeLogin(clientId);
                if (this.canCheckoutRunsAndClars(clientId)) {
                    try {
                        this.cancellAll(clientId);
                    }
                    catch (ContestSecurityException e) {
                        this.log.log(Log.WARNING, "Warning on canceling runs/clars for " + clientId, e);
                    }
                }
                this.forceConnectionDrop(connectionHandlerID2);
                ContestSecurityException contestSecurityException = new ContestSecurityException(clientId, connectionHandlerID, clientId + ": duplicate login request; previous login forced off ");
                this.sendSecurityMessageFromServer(contestSecurityException, connectionHandlerID, null);
            }
            this.contest.addLocalLogin(clientId, connectionHandlerID);
            this.info("LOGIN logged in " + clientId + " at " + connectionHandlerID);
            return;
        }
        this.info("attemptToLogin FAILED logged on: " + clientId);
        throw new SecurityException("Failed attempt to login");
    }

    protected boolean canCheckoutRunsAndClars(ClientId theClient) {
        return this.contest.isAllowed(theClient, Permission.Type.JUDGE_RUN) || this.contest.isAllowed(theClient, Permission.Type.ANSWER_CLARIFICATION);
    }

    private void processPacket(Packet packet, ConnectionHandlerID connectionHandlerID) {
        try {
            this.packetHandler.handlePacket(packet, connectionHandlerID);
        }
        catch (ContestSecurityException contestSecurityException) {
            this.log.log(Log.SEVERE, "SECURITY Violation  " + contestSecurityException.getSecurityMessage() + packet);
            this.contest.newSecurityMessage(packet.getSourceId(), "Security violation", packet.getType().toString(), contestSecurityException);
            Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, contestSecurityException.getSecurityMessage(), null, connectionHandlerID, contestSecurityException, packet);
            this.sendToAdministrators(violationPacket);
            this.sendToServers(violationPacket);
        }
        catch (Exception e) {
            this.info("Exception in processPacket, check logs ", e);
        }
    }

    private void sendLoginFailure(ClientId destinationId, ConnectionHandlerID connectionHandlerID, String message) {
        Packet packet = PacketFactory.createLoginDenied(this.contest.getClientId(), destinationId, message);
        this.sendToClient(connectionHandlerID, packet);
    }

    private void sendLoginSuccess(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        this.sendToClient(this.packetHandler.createLoginSuccessPacket(clientId, this.contestPassword));
    }

    public void connectionEstablished(ConnectionHandlerID connectionHandlerID) {
        this.info("connectionEstablished: " + connectionHandlerID);
        this.contest.connectionEstablished(connectionHandlerID);
        Packet connectionPacket = PacketFactory.createEstablishedConnection(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
        this.sendToAdministrators(connectionPacket);
        this.sendToServers(connectionPacket);
    }

    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        this.getLog().log(Log.INFO, "connection Dropped for " + connectionHandlerID, new Exception("connection Dropped for " + connectionHandlerID));
        ClientId clientId = this.contest.getLoginClientId(connectionHandlerID);
        if (clientId != null) {
            this.getLog().log(Log.INFO, "connection Dropped for " + connectionHandlerID + " which is " + clientId);
            this.removeLogin(clientId);
            if (this.canCheckoutRunsAndClars(clientId)) {
                try {
                    this.cancellAll(clientId);
                }
                catch (ContestSecurityException e) {
                    this.log.log(Log.WARNING, "Warning on canceling runs/clars for " + clientId, e);
                }
            }
        }
        if (this.contest.isConnected(connectionHandlerID)) {
            this.removeConnection(connectionHandlerID);
        }
    }

    protected void cancelAllClarsByThisJudge(ClientId judgeId) throws ContestSecurityException {
        Clarification[] clars = this.contest.getClarifications();
        int i = 0;
        while (i < clars.length) {
            if (clars[i].getState() == Clarification.ClarificationStates.BEING_ANSWERED && clars[i].getWhoCheckedItOutId().equals(judgeId)) {
                Packet packet = PacketFactory.createUnCheckoutClarification(this.contest.getClientId(), this.getServerClientId(), clars[i]);
                this.packetHandler.cancelClarificationCheckOut(packet, null);
            }
            ++i;
        }
    }

    protected void cancellAll(ClientId judgeId) throws ContestSecurityException {
        this.cancelAllRunsByThisJudge(judgeId);
        this.cancelAllClarsByThisJudge(judgeId);
    }

    protected void cancelAllRunsByThisJudge(ClientId judgeId) {
        ElementId[] runIDs = this.contest.getRunIdsCheckedOutBy(judgeId);
        int i = 0;
        while (i < runIDs.length) {
            Run run = this.contest.getRun(runIDs[i]);
            if (run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED)) {
                ClientId destinationId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet packet = PacketFactory.createUnCheckoutRun(judgeId, destinationId, run, judgeId);
                this.packetHandler.cancelRun(packet, run, judgeId, null);
            }
            ++i;
        }
    }

    public void logoffUser(ClientId clientId) {
        if (this.isServer() && this.contest.isLocalLoggedIn(clientId)) {
            ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
            this.contest.removeLogin(clientId);
            this.forceConnectionDrop(connectionHandlerID);
            Packet packet = PacketFactory.createLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, clientId);
            this.sendToServers(packet);
            this.sendToAdministrators(packet);
        } else {
            Packet packet = PacketFactory.createLogoff(this.contest.getClientId(), this.getServerClientId(), clientId);
            this.sendToLocalServer(packet);
        }
    }

    public void connectionError(Serializable object, ConnectionHandlerID connectionHandlerID, String causeDescription) {
        this.info("connectionError: " + this.contest.getTitle() + " " + connectionHandlerID + " " + causeDescription + " " + object.getClass().getName());
    }

    public void receiveObject(Serializable object) {
        this.info(" receiveObject(S) start got " + object);
        try {
            if (object instanceof Packet) {
                Packet packet = (Packet)object;
                PacketFactory.dumpPacket(this.log, packet, "recieveObject");
                this.packetHandler.handlePacket(packet, null);
            } else {
                this.info("receiveObject(S) Unsupported class received: " + object.getClass().getName());
            }
        }
        catch (Exception e) {
            String message = "Unable to start main UI, contact staff";
            if (this.loginUI != null) {
                FrameUtilities.regularCursor(this.loginUI);
            }
            this.contest.loginDenied(null, null, message);
            this.info("Exception ", e);
        }
        this.info(" receiveObject(S) end   got " + object);
    }

    public void connectionDropped() {
        if (this.clientAutoShutdown) {
            CountDownMessage countDownMessage = new CountDownMessage("Shutting down PC^2 in ", 10);
            if (this.contest.getClientId() != null) {
                this.info("connectionDropped: shutting down " + this.contest.getClientId());
                countDownMessage.setTitle("Shutting down PC^2 " + (Object)((Object)this.contest.getClientId().getClientType()) + " " + this.contest.getTitle());
            } else {
                this.info("connectionDropped: shutting down <non-logged in client>");
                countDownMessage.setTitle("Shutting down PC^2 Client");
            }
            countDownMessage.setExitOnClose(true);
            if (this.isUsingMainUI()) {
                countDownMessage.setVisible(true);
            }
        } else {
            this.contest.connectionDropped(null);
        }
    }

    public void info(String s) {
        this.log.log(Log.INFO, s);
    }

    public void info(String s, Exception exception) {
        this.log.log(Log.INFO, s, exception);
    }

    public void setSiteNumber(int number) {
        this.contest.setSiteNumber(number);
    }

    public void setContestTime(ContestTime contestTime) {
        if (this.contest.getContestTime() != null) {
            this.contest.updateContestTime(contestTime);
        } else {
            this.contest.addContestTime(contestTime);
        }
    }

    public void sendToServers(Packet packet) {
        ClientId[] clientIds;
        ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
            boolean isThisServer = this.isThisSite(clientId.getSiteNumber());
            if (!isThisServer) {
                this.sendToClient(connectionHandlerID, packet);
            }
            ++n2;
        }
    }

    private void sendPacketToClients(Packet packet, ClientType.Type type) {
        ClientId[] clientIds;
        ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(type);
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            if (this.isThisSite(clientId.getSiteNumber())) {
                ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                this.sendToClient(connectionHandlerID, packet);
            }
            ++n2;
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    public void sendToJudges(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.JUDGE);
        this.sendPacketToClients(packet, ClientType.Type.SPECTATOR);
    }

    public void sendToSpectators(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.SPECTATOR);
    }

    public void sendToAdministrators(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.ADMINISTRATOR);
    }

    public void sendToScoreboards(Packet packet) {
        this.sendPacketToClients(packet, ClientType.Type.SCOREBOARD);
    }

    public void sendToTeams(Packet packet) {
        Properties properties = (Properties)packet.getContent();
        boolean abort = true;
        if (properties.containsKey("PROBLEM_DATA_FILES")) {
            Properties cloneProperties = new Properties();
            for (String string : properties.keySet()) {
                if (string.equals("PROBLEM_DATA_FILES")) continue;
                cloneProperties.put(string, properties.get(string));
                abort = false;
            }
            packet = PacketFactory.clonePacket(packet.getSourceId(), packet.getDestinationId(), packet);
            packet.setContent(cloneProperties);
        } else {
            abort = false;
        }
        if (!abort) {
            this.sendPacketToClients(packet, ClientType.Type.TEAM);
        }
    }

    private int getPortForSite(int inSiteNumber) {
        try {
            Site[] sites;
            Site[] siteArray = sites = this.contest.getSites();
            int n = sites.length;
            int n2 = 0;
            while (n2 < n) {
                Site site = siteArray[n2];
                if (site.getSiteNumber() == inSiteNumber) {
                    String portStr = site.getConnectionInfo().getProperty("PORT_KEY");
                    return Integer.parseInt(portStr);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.info("Exception logged ", e);
            throw new SecurityException("Unable to determine port for site " + inSiteNumber);
        }
        throw new SecurityException("Could not find site " + inSiteNumber + " in site list, there are " + this.contest.getSites().length + " sites.");
    }

    public void startMainUI(ClientId clientId) {
        try {
            this.contest.setClientId(clientId);
            boolean isServer = clientId.getClientType().equals((Object)ClientType.Type.SERVER);
            if (isServer && this.isContactingRemoteServer()) {
                port = this.getPortForSite(this.contest.getSiteNumber());
                if (this.parseArguments.getOptValue("--port") != null) {
                    String portString = this.parseArguments.getOptValue("--port");
                    this.getLog().log(Log.INFO, "Attempting to use port from --port '" + portString + "'");
                    port = Integer.parseInt(portString);
                }
                this.info("Started Server Transport listening on " + port);
                this.connectionManager.accecptConnections(port);
                this.info("Secondary Server has started " + this.contest.getTitle());
            }
            try {
                if (this.isUsingMainUI()) {
                    if (this.uiPlugin == null) {
                        String uiClassName = LoadUIClass.getUIClassName(clientId);
                        if (uiClassName == null) {
                            this.info("Unable to find UI class for " + clientId.getClientType().toString().toLowerCase());
                        } else {
                            this.info("Attempting to load UI class " + uiClassName);
                            this.uiPlugin = LoadUIClass.loadUIClass(uiClassName);
                            this.info("Loaded UI class " + uiClassName);
                        }
                    }
                    this.uiPlugin.setContestAndController(this.contest, this);
                    if (this.loginUI != null) {
                        this.loginUI.dispose();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error loading UI, check log, (class not found?)  " + e.getMessage());
                this.info("Exception loading UI for (class not found?) " + clientId.getName(), e);
                throw new Exception("Unable to start main UI, contact staff");
            }
        }
        catch (Exception e) {
            this.info("Error showing frame or listening to port ", e);
            if (this.loginUI != null) {
                FrameUtilities.regularCursor(this.loginUI);
            }
            this.contest.loginDenied(clientId, null, String.valueOf(e.getMessage()) + " (port " + port + ")");
        }
    }

    public void start(String[] stringArray) {
        TransportException savedTransportException;
        block43: {
            boolean useIniFile;
            this.log = new Log("pc2.startup");
            StaticLog.setLog(this.log);
            this.info("");
            this.info(new VersionInfo().getSystemVersionInfo());
            try {
                this.log.info("Working directory is " + new File(".").getCanonicalPath());
            }
            catch (IOException e1) {
                this.log.info("Could not determine working directory " + e1.getMessage());
            }
            savedTransportException = null;
            String[] arguments = new String[]{LOGIN_OPTION_STRING, "--id", PASSWORD_OPTION_STRING, LOGIN_UI_OPTION_STRING, "--remoteServer", "--server", "--port", "--skipini", "--ini", "--nosave", CONTEST_PASSWORD_OPTION};
            this.parseArguments = new ParseArguments(stringArray, arguments);
            if (this.parseArguments.isOptPresent(DEBUG_OPTION_STRING)) {
                Utilities.setDebugMode(true);
                System.out.println(new VersionInfo().getSystemVersionInfo());
                try {
                    System.out.println("Working directory is " + new File(".").getCanonicalPath());
                }
                catch (IOException e1) {
                    System.out.println("Could not determine working directory " + e1.getMessage());
                    e1.printStackTrace(System.err);
                }
                this.log.info("Debug mode ON");
                System.out.println("Debug mode ON");
            }
            if (this.parseArguments.isOptPresent("--help")) {
                System.out.println("Usage: Starter [--help] [--server] [--first] [--login <login>] [--password <pass>] [--site ##] [--skipini] [--ini filename] ");
                System.exit(0);
            }
            if (this.parseArguments.isOptPresent(CONTEST_PASSWORD_OPTION)) {
                String newContestPassword = this.parseArguments.getOptValue(CONTEST_PASSWORD_OPTION);
                if (newContestPassword == null) {
                    System.err.println("No contest password found after --contestpassword");
                    System.exit(44);
                }
                this.setContestPassword(newContestPassword);
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray2[n2];
                if (arg.equals("--first")) {
                    this.setContactingRemoteServer(false);
                }
                ++n2;
            }
            this.log.info("Starting ConnectionManager...");
            this.connectionManager = new ConnectionManager(this.log);
            this.log.info("Started ConnectionManager");
            boolean bl = useIniFile = !this.parseArguments.isOptPresent("--skipini");
            if (this.parseArguments.isOptPresent("--ini") && useIniFile) {
                String iniName = this.parseArguments.getOptValue("--ini");
                Exception exception = null;
                try {
                    System.err.println("Loading INI from " + iniName);
                    this.ini.setIniURLorFile(iniName);
                    if (!this.ini.containsKey("_source")) {
                        System.err.println("Unable to load INI from " + iniName);
                        this.getLog().log(Log.WARNING, "Unable to read ini URL " + iniName);
                        exception = new Exception("Unable to read ini file " + iniName);
                    }
                }
                catch (Exception e) {
                    System.err.println("Unable to load INI from " + iniName);
                    this.getLog().log(Log.WARNING, "Unable to read ini URL " + iniName, e);
                    exception = e;
                }
                if (exception != null) {
                    this.getLog().log(Log.SEVERE, "Cannot start PC^2, " + iniName + " cannot be read (" + exception.getMessage() + ")");
                    System.out.flush();
                    System.err.flush();
                    System.err.println("Cannot start PC^2, " + iniName + " cannot be read (" + exception.getMessage() + ")");
                    System.err.flush();
                    JOptionPane.showMessageDialog(null, "Cannot start PC^2, " + iniName + " cannot be read (" + exception.getMessage() + ")", "PC^2 Halted", 0);
                    System.exit(22);
                }
            }
            this.contest.setSiteNumber(0);
            if (this.parseArguments.isOptPresent(SITE_OPTION_STRING)) {
                String siteNumberParam = this.parseArguments.getOptValue(SITE_OPTION_STRING);
                if (siteNumberParam == null || siteNumberParam.trim().length() == 0) {
                    savedTransportException = new TransportException("No site found after --site");
                }
                try {
                    int siteNumber = Integer.parseInt(siteNumberParam);
                    this.contest.setSiteNumber(siteNumber);
                }
                catch (Exception e) {
                    this.getLog().log(Log.WARNING, "Expecting a number after --site found " + siteNumberParam, e);
                    savedTransportException = new TransportException("Invalid site after --site");
                }
            }
            if (useIniFile && !this.parseArguments.isOptPresent("--ini")) {
                if (IniFile.isFilePresent()) {
                    new IniFile();
                } else {
                    String currentDirectory = Utilities.getCurrentDirectory();
                    this.getLog().log(Log.SEVERE, "Cannot start PC^2, " + IniFile.getINIFilename() + " cannot be read.");
                    System.out.flush();
                    System.err.flush();
                    System.err.println("Cannot start PC^2, " + IniFile.getINIFilename() + " file not found in " + currentDirectory);
                    System.err.flush();
                    JOptionPane.showMessageDialog(null, "Cannot start PC^2, " + IniFile.getINIFilename() + " file not found in " + currentDirectory, "PC^2 Halted", 0);
                    System.exit(22);
                }
            }
            this.log.log(Log.DEBUG, "Site Number is set as " + this.contest.getSiteNumber() + " (0 means unset)");
            if (this.parseArguments.isOptPresent("--nosave")) {
                this.saveCofigurationToDisk = false;
            }
            if (this.parseArguments.isOptPresent("--server")) {
                this.info("Starting Server Transport...");
                this.connectionManager.startServerTransport(this);
                this.serverModule = true;
                this.contactingRemoteServer = false;
                this.setServerRemoteHostAndPort(this.parseArguments.getOptValue("--remoteServer"));
                try {
                    this.setServerPort(this.parseArguments.getOptValue("--port"));
                }
                catch (NumberFormatException numException) {
                    savedTransportException = new TransportException("Unable to parse value after --port '" + this.parseArguments.getOptValue("--port") + "'");
                    this.log.log(Log.WARNING, "Exception logged ", numException);
                }
            } else {
                try {
                    this.setClientServerAndPort(this.parseArguments.getOptValue("--port"));
                    this.info("Contacting server at " + this.remoteHostName + ":" + this.remoteHostPort);
                    this.connectionManager.startClientTransport(this.remoteHostName, this.remoteHostPort, this);
                }
                catch (NumberFormatException numException) {
                    savedTransportException = new TransportException("Unable to parse value after --port '" + this.parseArguments.getOptValue("--port") + "'");
                    this.log.log(Log.WARNING, "Exception logged ", numException);
                }
                try {
                    this.connectionManager.connectToMyServer();
                }
                catch (TransportException transportException) {
                    savedTransportException = transportException;
                    this.log.log(Log.INFO, "Exception logged ", transportException);
                    this.info("Unable to contact server at " + this.remoteHostName + ":" + port + " " + transportException.getMessage());
                }
            }
            this.isStarted = true;
            if (!this.parseArguments.isOptPresent(LOGIN_OPTION_STRING)) {
                if (this.isUsingMainUI()) {
                    this.loginUI = new LoginFrame();
                    this.loginUI.setContestAndController(this.contest, this);
                }
            } else {
                String loginName = "";
                if (this.parseArguments.isOptPresent(LOGIN_OPTION_STRING)) {
                    loginName = this.parseArguments.getOptValue(LOGIN_OPTION_STRING);
                }
                String password = "";
                if (this.parseArguments.isOptPresent(PASSWORD_OPTION_STRING)) {
                    password = this.parseArguments.getOptValue(PASSWORD_OPTION_STRING);
                }
                if (this.isUsingMainUI()) {
                    this.loginUI = new LoginFrame();
                    this.loginUI.setContestAndController(this.contest, this);
                }
                try {
                    if (savedTransportException == null) {
                        this.login(loginName, password);
                    }
                }
                catch (Exception e) {
                    this.log.log(Log.INFO, "Exception logged ", e);
                    if (this.loginUI == null) break block43;
                    this.loginUI.setStatusMessage(e.getMessage());
                }
            }
        }
        String contactInfo = String.valueOf(this.getHostContacted()) + ":" + this.getPortContacted();
        if (savedTransportException != null && this.loginUI != null) {
            this.loginUI.disableLoginButton();
            this.loginUI.setStatusMessage("Unable to contact server, contact staff");
            JOptionPane.showMessageDialog(null, "Unable to contact server at: " + contactInfo, "Error contacting server", 0);
        } else if (savedTransportException != null) {
            this.connectionManager = null;
            System.err.println("Unable to contact server at " + contactInfo);
            this.log.log(Log.INFO, "Unable to contact server, contact staff", savedTransportException);
            this.log.log(Log.INFO, "internal debug, note connectionManager set to null");
            JOptionPane.showMessageDialog(null, "Unable to contact server at: " + contactInfo, "Error contacting server", 0);
        }
    }

    private ClientId getServerClientId() {
        return new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
    }

    public void checkOutRun(Run run, boolean readOnly, boolean computerJudge) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunRequest(clientId, this.getServerClientId(), run, clientId, readOnly, computerJudge);
        this.sendToLocalServer(packet);
    }

    public void checkOutRejudgeRun(Run run) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunRejudgeRequest(clientId, this.getServerClientId(), run, clientId);
        this.sendToLocalServer(packet);
    }

    public void submitRunJudgement(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createRunJudgement(clientId, this.getServerClientId(), run, judgementRecord, runResultFiles);
        this.sendToLocalServer(packet);
    }

    public void cancelRun(Run run) {
        ClientId clientId = this.contest.getClientId();
        Packet packet = PacketFactory.createUnCheckoutRun(clientId, this.getServerClientId(), run, clientId);
        this.sendToLocalServer(packet);
    }

    public void addNewSite(Site site) {
        if (this.isServer()) {
            this.contest.addSite(site);
            this.writeConfigToDisk();
            Packet packet = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, site);
            this.sendToServers(packet);
            this.sendToJudges(packet);
            this.sendToAdministrators(packet);
            this.sendToScoreboards(packet);
        } else {
            Packet packet = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), site);
            this.sendToLocalServer(packet);
        }
    }

    public void modifySite(Site site) {
        this.contest.changeSite(site);
        Packet packet = PacketFactory.createUpdateSetting(this.getServerClientId(), PacketFactory.ALL_SERVERS, site);
        this.sendToServers(packet);
    }

    public void sendServerLoginRequest(int inSiteNumber) throws Exception {
        if (this.isServer()) {
            if (this.isThisSite(inSiteNumber)) {
                System.err.println(" Tried to send login request to ourselves, login to " + inSiteNumber + ", ignored");
                this.log.log(Log.DEBUG, " Tried to send login request to ourselves, login to " + inSiteNumber + ", ignored");
                return;
            }
            Site remoteSite = this.contest.getSite(inSiteNumber);
            Site localSite = this.contest.getSite(this.contest.getSiteNumber());
            String localPassword = localSite.getPassword();
            String hostName = remoteSite.getConnectionInfo().getProperty("IP_KEY");
            String portStr = remoteSite.getConnectionInfo().getProperty("PORT_KEY");
            int portNumber = Integer.parseInt(portStr);
            this.info("Send login request to Site " + remoteSite.getSiteNumber() + " " + hostName + ":" + portStr);
            ConnectionHandlerID connectionHandlerID = this.connectionManager.connectToServer(hostName, portNumber);
            this.info("Contacted Site " + remoteSite.getSiteNumber() + " using connection id " + connectionHandlerID);
            this.info("Sending login request to Site " + remoteSite.getSiteNumber() + " " + hostName + " as " + this.getServerClientId() + " " + localPassword);
            this.sendLoginRequestFromServerToServer(this.connectionManager, connectionHandlerID, this.getServerClientId(), localPassword);
        } else if (this.contest.isAllowed(Permission.Type.ALLOWED_TO_RECONNECT_SERVER)) {
            Packet reconnectPacket = PacketFactory.createReconnectPacket(this.contest.getClientId(), this.getServerClientId(), inSiteNumber);
            this.sendToLocalServer(reconnectPacket);
        } else {
            System.err.println(" Non-admin Tried to send reconnection request " + inSiteNumber + ", ignored");
            this.log.log(Log.DEBUG, " Non-admin Tried to send reconnection request " + inSiteNumber + ", ignored");
            return;
        }
    }

    public boolean isContactingRemoteServer() {
        return this.contactingRemoteServer;
    }

    public void setContactingRemoteServer(boolean contactingRemoteServer) {
        this.contactingRemoteServer = contactingRemoteServer;
    }

    public boolean isUsingMainUI() {
        return this.usingMainUI;
    }

    public void setUsingMainUI(boolean usingMainUI) {
        this.usingMainUI = usingMainUI;
    }

    public UIPlugin getUiPlugin() {
        return this.uiPlugin;
    }

    public void setUiPlugin(UIPlugin uiPlugin) {
        this.uiPlugin = uiPlugin;
    }

    public void updateSite(Site site) {
        if (this.isServer()) {
            this.contest.changeSite(site);
            this.writeConfigToDisk();
            Packet packet = PacketFactory.createUpdateSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, site);
            this.sendToServers(packet);
            this.sendToJudges(packet);
            this.sendToAdministrators(packet);
            this.sendToScoreboards(packet);
        } else {
            Packet packet = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), site);
            this.sendToLocalServer(packet);
        }
    }

    private boolean isServer() {
        return this.contest.getClientId() != null && this.isServer(this.contest.getClientId());
    }

    private boolean isServer(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    public final Log getLog() {
        return this.log;
    }

    public void generateNewAccounts(String clientTypeName, int siteNumber, int count, int startNumber, boolean active) {
        ClientType.Type type = ClientType.Type.valueOf(clientTypeName);
        Packet packet = PacketFactory.createGenerateAccounts(this.contest.getClientId(), this.getServerClientId(), siteNumber, type, count, startNumber, active);
        this.sendToLocalServer(packet);
    }

    public void generateNewAccounts(String clientTypeName, int count, int startNumber, boolean active) {
        this.generateNewAccounts(clientTypeName, this.contest.getSiteNumber(), count, startNumber, active);
    }

    public void submitClarification(Problem problem, String question) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Clarification clarification = new Clarification(this.contest.getClientId(), problem, question);
        Packet packet = PacketFactory.createClarificationSubmission(this.contest.getClientId(), serverClientId, clarification);
        this.sendToLocalServer(packet);
    }

    public void checkOutClarification(Clarification clarification, boolean readOnly) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createClarificationRequest(this.contest.getClientId(), serverClientId, clarification.getElementId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    public void cancelClarification(Clarification clarification) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createUnCheckoutClarification(this.contest.getClientId(), serverClientId, clarification);
        this.sendToLocalServer(packet);
    }

    public void submitClarificationAnswer(Clarification clarification) {
        ClientId serverClientId = new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
        Packet packet = PacketFactory.createAnsweredClarification(this.contest.getClientId(), serverClientId, clarification, clarification.getAnswer());
        this.sendToLocalServer(packet);
    }

    public void forceConnectionDrop(ConnectionHandlerID connectionHandlerID) {
        if (this.isServer()) {
            if (this.contest.isConnected(connectionHandlerID)) {
                this.log.log(Log.INFO, "forceConnectionDrop: " + connectionHandlerID);
                this.connectionManager.unregisterConnection(connectionHandlerID);
                this.contest.connectionDropped(connectionHandlerID);
            } else {
                Packet forceDiscoPacket = PacketFactory.createForceLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
                this.sendToServers(forceDiscoPacket);
            }
        } else {
            this.contest.connectionDropped(connectionHandlerID);
        }
    }

    public void addNewProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        Packet updateProblemPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), problem, problemDataFiles);
        this.sendToLocalServer(updateProblemPacket);
    }

    public void updateRun(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles) {
        Packet updateRunPacket = PacketFactory.createRunUpdated(this.contest.getClientId(), this.getServerClientId(), run, judgementRecord, runResultFiles, this.contest.getClientId());
        this.sendToLocalServer(updateRunPacket);
    }

    public void addProblem(Problem problem) {
        Packet updateProblemPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), problem, null);
        this.sendToLocalServer(updateProblemPacket);
    }

    public void updateProblem(Problem problem) {
        Packet updateProblemPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), problem, null);
        this.sendToLocalServer(updateProblemPacket);
    }

    public void updateProblem(Problem problem, ProblemDataFiles problemDataFiles) {
        Packet updateProblemPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), problem, problemDataFiles);
        this.sendToLocalServer(updateProblemPacket);
    }

    public ProblemDataFiles getProblemDataFiles(Problem problem) {
        return this.contest.getProblemDataFile(problem);
    }

    public void shutdownTransport() {
        this.connectionManager.shutdownTransport();
    }

    public void removeConnection(ConnectionHandlerID connectionHandlerID) {
        this.contest.connectionDropped(connectionHandlerID);
        Packet disconnectionPacket = PacketFactory.createDroppedConnection(this.contest.getClientId(), PacketFactory.ALL_SERVERS, connectionHandlerID);
        PacketFactory.dumpPacket(this.log, disconnectionPacket, "removeConnection");
        this.sendToAdministrators(disconnectionPacket);
        this.sendToServers(disconnectionPacket);
    }

    public void removeLogin(ClientId clientId) {
        this.contest.removeLogin(clientId);
        try {
            Packet logoffPacket = PacketFactory.createLogoff(this.contest.getClientId(), PacketFactory.ALL_SERVERS, clientId);
            this.sendToAdministrators(logoffPacket);
            if (!this.isServer(clientId)) {
                this.sendToServers(logoffPacket);
            }
        }
        catch (Exception e) {
            this.log.log(Log.SEVERE, "Exception removeLogin ", e);
        }
    }

    public void startContest(int inSiteNumber) {
        Packet packet = PacketFactory.createStartContestClock(this.contest.getClientId(), this.getServerClientId(), inSiteNumber, this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    public void stopContest(int inSiteNumber) {
        Packet packet = PacketFactory.createStopContestClock(this.contest.getClientId(), this.getServerClientId(), inSiteNumber, this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    public void startAllContestTimes() {
        Packet packet = PacketFactory.createStartAllClocks(this.contest.getClientId(), this.getServerClientId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    public void stopAllContestTimes() {
        Packet packet = PacketFactory.createStopAllClocks(this.contest.getClientId(), this.getServerClientId(), this.contest.getClientId());
        this.sendToLocalServer(packet);
    }

    public void addNewLanguage(Language language) {
        Packet addLanguagePacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), language);
        this.sendToLocalServer(addLanguagePacket);
    }

    public void addNewJudgement(Judgement judgement) {
        Packet addJudgementPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(addJudgementPacket);
    }

    public void updateLanguage(Language language) {
        Packet updateLanguagePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), language);
        this.sendToLocalServer(updateLanguagePacket);
    }

    public void updateJudgement(Judgement judgement) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(updatePacket);
    }

    public void updateAccount(Account account) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), account);
        this.sendToLocalServer(updatePacket);
    }

    public void updateAccounts(Account[] accounts) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), accounts);
        this.sendToLocalServer(updatePacket);
    }

    public void addNewAccount(Account account) {
        Packet addAccountPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), account);
        this.sendToLocalServer(addAccountPacket);
    }

    public void addNewAccounts(Account[] accounts) {
        Packet addAccountPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), accounts);
        this.sendToLocalServer(addAccountPacket);
    }

    public boolean readConfigFromDisk(int siteNum) {
        boolean loadedConfiguration = false;
        if (this.saveCofigurationToDisk) {
            loadedConfiguration = this.configurationIO.loadFromDisk(siteNum, this.contest, this.getLog());
            this.contest.initializeSubmissions(siteNum);
            ContestTime contestTime = this.contest.getContestTime(siteNum);
            if (contestTime == null) {
                contestTime = new ContestTime(siteNum);
                this.contest.addContestTime(contestTime);
            }
        }
        return loadedConfiguration;
    }

    public void writeConfigToDisk() {
        if (this.saveCofigurationToDisk) {
            try {
                this.configurationIO.saveToDisk(this.contest, this.getLog());
            }
            catch (IOException e) {
                System.err.println("Unable to write configuration to disk " + e.getMessage());
                this.getLog().log(Log.SEVERE, "Error logging to disk ", e);
            }
        }
    }

    public void addNewClientSettings(ClientSettings clientSettings) {
        Packet addClientSettingsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), clientSettings);
        this.sendToLocalServer(addClientSettingsPacket);
    }

    public void updateClientSettings(ClientSettings clientSettings) {
        Packet updateClientSettingsPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), clientSettings);
        this.sendToLocalServer(updateClientSettingsPacket);
    }

    public void updateContestInformation(ContestInformation contestInformation) {
        Packet addAccountPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), contestInformation);
        this.sendToLocalServer(addAccountPacket);
    }

    public void setJudgementList(Judgement[] judgementList) {
        Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), judgementList);
        this.sendToLocalServer(updatePacket);
    }

    public void removeJudgement(Judgement judgement) {
        Packet deleteJudgmentPacket = PacketFactory.createDeleteSetting(this.contest.getClientId(), this.getServerClientId(), judgement);
        this.sendToLocalServer(deleteJudgmentPacket);
    }

    public void addNewBalloonSettings(BalloonSettings newBalloonSettings) {
        Packet newBalloonSettingsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), newBalloonSettings);
        this.sendToLocalServer(newBalloonSettingsPacket);
    }

    public void updateBalloonSettings(BalloonSettings balloonSettings) {
        Packet balloonSettingsPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), balloonSettings);
        this.sendToLocalServer(balloonSettingsPacket);
    }

    public int getSiteNumber() {
        return this.contest.getSiteNumber();
    }

    public void updateContestTime(ContestTime newContestTime) {
        Packet newContestTimePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), newContestTime);
        this.sendToLocalServer(newContestTimePacket);
    }

    public void addNewGroup(Group group) {
        Packet newGroupPacket = PacketFactory.createAddSetting(this.contest.getClientId(), this.getServerClientId(), group);
        this.sendToLocalServer(newGroupPacket);
    }

    public void updateGroup(Group group) {
        Packet groupPacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), this.getServerClientId(), group);
        this.sendToLocalServer(groupPacket);
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void sendSecurityMessageFromServer(ContestSecurityException contestSecurityException, ConnectionHandlerID connectionHandlerID, Packet packet) {
        Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, contestSecurityException.getSecurityMessage(), null, connectionHandlerID, contestSecurityException, packet);
        this.sendToAdministrators(violationPacket);
        this.sendToServers(violationPacket);
        this.contest.newSecurityMessage(contestSecurityException.getClientId(), contestSecurityException.getSecurityMessage(), "", contestSecurityException);
    }

    public void sendSecurityMessage(String event, String message, ContestSecurityException contestSecurityException) {
        Packet securityMessagePacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), this.getServerClientId(), event, contestSecurityException.getClientId(), contestSecurityException.getConnectionHandlerID(), contestSecurityException, null);
        this.sendToLocalServer(securityMessagePacket);
    }

    public String getContestPassword() {
        return this.contestPassword;
    }

    public void setContestPassword(String contestPassword) {
        this.contestPassword = contestPassword;
    }

    public String getHostContacted() {
        return this.remoteHostName;
    }

    public int getPortContacted() {
        return this.remoteHostPort;
    }

    public void fetchRun(Run run) {
        RunFiles runFiles = this.contest.getRunFiles(run);
        if (runFiles != null) {
            this.contest.updateRun(run, runFiles, null, null);
        } else {
            Packet fetchRunPacket = PacketFactory.createFetchRun(this.contest.getClientId(), this.getServerClientId(), run, this.contest.getClientId());
            this.sendToLocalServer(fetchRunPacket);
        }
    }

    private void sendStatusMessge(Run run, RunExecutionStatus status) {
        if (this.contest.isSendAdditionalRunStatusMessages()) {
            Packet sendPacket = PacketFactory.createRunStatusPacket(this.contest.getClientId(), this.getServerClientId(), run, this.contest.getClientId(), status);
            this.sendToLocalServer(sendPacket);
        }
    }

    public void sendCompilingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.COMPILING);
    }

    public void sendExecutingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.EXECUTING);
    }

    public void sendValidatingMessage(Run run) {
        this.sendStatusMessge(run, RunExecutionStatus.VALIDATING);
    }

    public boolean isClientAutoShutdown() {
        return this.clientAutoShutdown;
    }

    public void setClientAutoShutdown(boolean clientAutoShutdown) {
        this.clientAutoShutdown = clientAutoShutdown;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected class TemporaryClientUI
    implements UIPlugin,
    ILoginListener {
        private IInternalContest contest = null;
        private IInternalController controller = null;
        private SecurityException securityException = null;
        private static final long serialVersionUID = 8735788359720905862L;

        protected TemporaryClientUI() {
        }

        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            this.contest = inContest;
            this.controller = inController;
        }

        public String getPluginTitle() {
            return "TemporaryClientUI";
        }

        public IInternalContest getContest() {
            if (this.securityException != null) {
                throw this.securityException;
            }
            return this.contest;
        }

        public void setContest(IInternalContest contest) {
            this.contest = contest;
        }

        public IInternalController getController() {
            return this.controller;
        }

        public void setController(IInternalController controller) {
            this.controller = controller;
        }

        public void loginAdded(LoginEvent event) {
        }

        public void loginRemoved(LoginEvent event) {
        }

        public void loginDenied(LoginEvent event) {
            this.securityException = new SecurityException("Login denied " + event.getMessage());
        }
    }
}

