/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.implementation.RunImplementation;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import java.util.Vector;

public class RunListenerList {
    private Vector<IRunEventListener> listenerList = new Vector();
    private IInternalContest contest = null;
    private IInternalController controller = null;

    private void fireRunListener(RunEvent runEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            RunImplementation run = new RunImplementation(runEvent.getRun(), this.contest, this.controller);
            boolean finalJudgementCycle = this.isFinalJudgementCycle(runEvent.getRun());
            block0 : switch (runEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).runSubmitted(run);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).runDeleted(run);
                    break;
                }
                case CHANGED: {
                    if (runEvent.getDetailedAction() != null) {
                        switch (runEvent.getDetailedAction()) {
                            case CHECKEDOUT_RUN: 
                            case CHECKEDOUT_REJUDGE_RUN: {
                                this.listenerList.elementAt(i).runCheckedOut(run, finalJudgementCycle);
                                break block0;
                            }
                        }
                        this.listenerList.elementAt(i).runUpdated(run, finalJudgementCycle);
                        break;
                    }
                    this.listenerList.elementAt(i).runJudged(run, finalJudgementCycle);
                    break;
                }
                case RUN_AVAILABLE: {
                    this.listenerList.elementAt(i).runJudgingCanceled(run, finalJudgementCycle);
                    break;
                }
                case RUN_COMPILING: {
                    this.listenerList.elementAt(i).runCompiling(run, finalJudgementCycle);
                    break;
                }
                case RUN_EXECUTING: {
                    this.listenerList.elementAt(i).runExecuting(run, finalJudgementCycle);
                    break;
                }
                case RUN_VALIDATING: {
                    this.listenerList.elementAt(i).runValidating(run, finalJudgementCycle);
                    break;
                }
                case CHECKEDOUT_RUN: {
                    this.listenerList.elementAt(i).runCheckedOut(run, finalJudgementCycle);
                    break;
                }
                case CHECKEDOUT_REJUDGE_RUN: 
                case RUN_HELD: 
                case RUN_NOT_AVIALABLE: 
                case RUN_REVOKED: {
                    break;
                }
            }
            ++i;
        }
    }

    private boolean isFinalJudgementCycle(Run run) {
        JudgementRecord record = run.getJudgementRecord();
        if (record != null) {
            return !record.isPreliminaryJudgement();
        }
        return false;
    }

    public void addRunListener(IRunEventListener runEventListener) {
        this.listenerList.add(runEventListener);
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addRunListener(new Listener());
    }

    public void removeRunListener(IRunEventListener runEventListener) {
        this.listenerList.remove(runEventListener);
    }

    class Listener
    implements IRunListener {
        Listener() {
        }

        public void runAdded(RunEvent event) {
            RunListenerList.this.fireRunListener(event);
        }

        public void runChanged(RunEvent event) {
            RunListenerList.this.fireRunListener(event);
        }

        public void runRemoved(RunEvent event) {
            RunListenerList.this.fireRunListener(event);
        }
    }
}

