/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.implementation.StandingImplementation;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import java.io.StringReader;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GenerateStandings {
    private String[] fetchStandingRow(Node node) {
        String[] outArray = new String[7];
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node standingNode = attributes.item(i);
            String value = standingNode.getNodeValue();
            String name = standingNode.getNodeName();
            if (name.equals("rank")) {
                outArray[0] = value;
            } else if (name.equals("teamName")) {
                outArray[1] = value;
            } else if (name.equals("solved")) {
                outArray[2] = value;
            } else if (name.equals("points")) {
                outArray[3] = value;
            } else if (name.equals("teamId")) {
                outArray[4] = value;
            } else if (name.equals("teamSiteId")) {
                outArray[5] = value;
            } else if (name.equals("teamKey")) {
                outArray[6] = value;
            }
            ++i;
        }
        return outArray;
    }

    public IStanding[] getStandings(IInternalContest contest, Log log) {
        Document document = null;
        String xmlString = null;
        Vector<StandingImplementation> standings = new Vector<StandingImplementation>();
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            xmlString = defaultScoringAlgorithm.getStandings(contest, new Properties(), log);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
            NodeList list = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("teamStanding")) {
                    try {
                        String[] cols = this.fetchStandingRow(node);
                        int rank = Integer.parseInt(cols[0]);
                        int numProblemsSolved = Integer.parseInt(cols[2]);
                        int penaltyPoints = Integer.parseInt(cols[3]);
                        int clientNumber = Integer.parseInt(cols[4]);
                        int siteNumber = Integer.parseInt(cols[5]);
                        ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, clientNumber);
                        StandingImplementation standingImplementation = new StandingImplementation(contest, clientId, rank, numProblemsSolved, penaltyPoints);
                        standings.addElement(standingImplementation);
                    }
                    catch (Exception e) {
                        log.log(Log.WARNING, "Exception while parsing/generating standings row ", e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception logged ", e);
        }
        return standings.toArray(new StandingImplementation[standings.size()]);
    }
}

