/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.IClarificationEventListener;
import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.IContestClock;
import edu.csus.ecs.pc2.api.IGroup;
import edu.csus.ecs.pc2.api.IJudgement;
import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.ISite;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.implementation.ClarificationImplementation;
import edu.csus.ecs.pc2.api.implementation.ClarificationListenerList;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.ConfigurationListenerList;
import edu.csus.ecs.pc2.api.implementation.ConnectionEventListenerList;
import edu.csus.ecs.pc2.api.implementation.ContestTimeImplementation;
import edu.csus.ecs.pc2.api.implementation.GenerateStandings;
import edu.csus.ecs.pc2.api.implementation.GroupImplementation;
import edu.csus.ecs.pc2.api.implementation.JudgementImplementation;
import edu.csus.ecs.pc2.api.implementation.LanguageImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.RunImplementation;
import edu.csus.ecs.pc2.api.implementation.RunListenerList;
import edu.csus.ecs.pc2.api.implementation.SiteImplementation;
import edu.csus.ecs.pc2.api.implementation.TeamImplementation;
import edu.csus.ecs.pc2.api.listener.IConfigurationUpdateListener;
import edu.csus.ecs.pc2.api.listener.IConnectionEventListener;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import java.util.Vector;

public class Contest
implements IContest {
    private boolean loggedIn = true;
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private RunListenerList runListenerList = new RunListenerList();
    private ConnectionEventListenerList connectionEventListenerList = new ConnectionEventListenerList();
    private ClarificationListenerList clarificationListenerList = new ClarificationListenerList();
    private ConfigurationListenerList configurationListenerList = new ConfigurationListenerList();
    private GenerateStandings generateStandings = new GenerateStandings();
    private Log log = null;

    public Contest(IInternalContest contest, IInternalController controller, Log log) {
        this.contest = contest;
        this.controller = controller;
        this.log = log;
        this.runListenerList.setContestAndController(contest, controller);
        this.clarificationListenerList.setContestAndController(contest, controller);
        this.configurationListenerList.setContest(contest);
        this.connectionEventListenerList.setContestAndController(contest, controller, this);
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String getTitle() {
        Account account = this.contest.getAccount(this.contest.getClientId());
        return account.getDisplayName();
    }

    public ITeam[] getTeams() {
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.TEAM);
        ITeam[] teamImplementations = new TeamImplementation[vector.size()];
        int i = 0;
        while (i < teamImplementations.length) {
            teamImplementations[i] = new TeamImplementation(vector.elementAt(i), this.contest);
            ++i;
        }
        return teamImplementations;
    }

    public String getSiteName(int siteNumber) {
        Site site = this.contest.getSite(siteNumber);
        return site.getDisplayName();
    }

    public String getContestTitle() {
        return this.contest.getContestInformation().getContestTitle();
    }

    public String getSiteName() {
        return this.getSiteName(this.contest.getSiteNumber());
    }

    public ILanguage[] getLanguages() {
        Language[] languages = this.contest.getLanguages();
        ILanguage[] implementations = new LanguageImplementation[languages.length];
        int i = 0;
        while (i < languages.length) {
            implementations[i] = new LanguageImplementation(languages[i]);
            ++i;
        }
        return implementations;
    }

    public IProblem[] getProblems() {
        Problem[] problems = this.contest.getProblems();
        IProblem[] implementations = new ProblemImplementation[problems.length];
        int i = 0;
        while (i < problems.length) {
            implementations[i] = new ProblemImplementation(problems[i], this.contest);
            ++i;
        }
        return implementations;
    }

    public IJudgement[] getJudgements() {
        Judgement[] judgements = this.contest.getJudgements();
        IJudgement[] implementations = new JudgementImplementation[judgements.length];
        int i = 0;
        while (i < judgements.length) {
            implementations[i] = new JudgementImplementation(judgements[i]);
            ++i;
        }
        return implementations;
    }

    public IRun[] getRuns() {
        Run[] runs = this.contest.getRuns();
        IRun[] runImplementations = new RunImplementation[runs.length];
        int i = 0;
        while (i < runs.length) {
            runImplementations[i] = new RunImplementation(runs[i], this.contest, this.controller);
            ++i;
        }
        return runImplementations;
    }

    public void addRunListener(IRunEventListener runEventListener) {
        this.runListenerList.addRunListener(runEventListener);
    }

    public void removeRunListener(IRunEventListener runEventListener) {
        this.runListenerList.removeRunListener(runEventListener);
    }

    public void addConnectionListener(IConnectionEventListener connectionEventListener) {
        this.connectionEventListenerList.addConnectionListener(connectionEventListener);
    }

    public void removeConnectionListener(IConnectionEventListener connectionEventListener) {
        this.connectionEventListenerList.removeConnectionListener(connectionEventListener);
    }

    public void addContestConfigurationUpdateListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.configurationListenerList.addContestUpdateConfigurationListener(contestUpdateConfigurationListener);
    }

    public void removeContestConfigurationUpdateListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.configurationListenerList.removeContestUpdateConfigurationListener(contestUpdateConfigurationListener);
    }

    public IContestClock getContestClock() {
        return new ContestTimeImplementation(this.contest.getContestTime());
    }

    public IGroup[] getGroups() {
        Group[] groups = this.contest.getGroups();
        IGroup[] groupImplementations = new GroupImplementation[groups.length];
        int i = 0;
        while (i < groups.length) {
            groupImplementations[i] = new GroupImplementation(groups[i], this.contest);
            ++i;
        }
        return groupImplementations;
    }

    public IClient getMyClient() {
        return new ClientImplementation(this.contest.getClientId(), this.contest);
    }

    public boolean isContestClockRunning() {
        return this.contest.getContestTime().isContestRunning();
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public IStanding getStanding(ITeam team) {
        IStanding[] standings = this.generateStandings.getStandings(this.contest, this.log);
        if (standings == null) {
            return null;
        }
        IStanding[] iStandingArray = standings;
        int n = standings.length;
        int n2 = 0;
        while (n2 < n) {
            IStanding standing = iStandingArray[n2];
            if (team.getAccountNumber() == standing.getClient().getAccountNumber() && team.getSiteNumber() == standing.getClient().getSiteNumber()) {
                return standing;
            }
            ++n2;
        }
        return null;
    }

    public IStanding[] getStandings() {
        return this.generateStandings.getStandings(this.contest, this.log);
    }

    public ISite[] getSites() {
        Site[] sites = this.contest.getSites();
        ISite[] siteImplementations = new SiteImplementation[sites.length];
        int i = 0;
        while (i < sites.length) {
            siteImplementations[i] = new SiteImplementation(sites[i]);
            ++i;
        }
        return siteImplementations;
    }

    public String getServerHostName() {
        return this.controller.getHostContacted();
    }

    public int getServerPort() {
        return this.controller.getPortContacted();
    }

    public IClarification[] getClarifications() {
        Clarification[] clarifications = this.contest.getClarifications();
        IClarification[] clarificationImplementations = new ClarificationImplementation[clarifications.length];
        int i = 0;
        while (i < clarifications.length) {
            clarificationImplementations[i] = new ClarificationImplementation(clarifications[i], this.contest, this.controller);
            ++i;
        }
        return clarificationImplementations;
    }

    public void removeClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.clarificationListenerList.removeClarificationListener(clarificationEventListener);
    }

    public void addClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.clarificationListenerList.addClarificationListener(clarificationEventListener);
    }
}

