/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.exceptions.LoginFailureException;
import edu.csus.ecs.pc2.api.exceptions.NotLoggedInException;
import edu.csus.ecs.pc2.api.implementation.Contest;
import edu.csus.ecs.pc2.api.listener.IConnectionEventListener;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;

public class ServerConnection {
    private InternalController controller;
    private IInternalContest internalContest;
    private Contest contest = null;

    public IContest login(String login, String password) throws LoginFailureException {
        if (this.contest != null) {
            throw new LoginFailureException("Already logged in as: " + this.contest.getMyClient().getLoginName());
        }
        this.internalContest = new InternalContest();
        this.controller = new InternalController(this.internalContest);
        this.controller.setUsingMainUI(false);
        this.controller.setClientAutoShutdown(false);
        try {
            this.controller.start(new String[0]);
            this.internalContest = this.controller.clientLogin(this.internalContest, login, password);
            this.contest = new Contest(this.internalContest, this.controller, this.controller.getLog());
            this.contest.addConnectionListener(new ConnectionEventListenerImplementation());
            return this.contest;
        }
        catch (Exception e) {
            throw new LoginFailureException(e.getMessage());
        }
    }

    public boolean logoff() throws NotLoggedInException {
        if (this.contest == null) {
            throw new NotLoggedInException("Can not log off, not logged in");
        }
        try {
            this.controller.logoffUser(this.internalContest.getClientId());
            this.contest.setLoggedIn(false);
            this.contest = null;
            return true;
        }
        catch (Exception e) {
            throw new NotLoggedInException(e);
        }
    }

    public Contest getContest() throws NotLoggedInException {
        if (this.contest != null) {
            return this.contest;
        }
        throw new NotLoggedInException("Can not get IContest, not logged in");
    }

    public boolean isLoggedIn() {
        return this.contest != null && this.contest.isLoggedIn();
    }

    public IClient getMyClient() throws NotLoggedInException {
        if (this.contest != null) {
            return this.contest.getMyClient();
        }
        throw new NotLoggedInException("Not logged in");
    }

    protected class ConnectionEventListenerImplementation
    implements IConnectionEventListener {
        protected ConnectionEventListenerImplementation() {
        }

        public void connectionDropped() {
            ServerConnection.this.contest = null;
        }
    }
}

