/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb.util;

import com.ibm.webrunner.j2mclb.util.TableModel;
import com.ibm.webrunner.j2mclb.util.event.TableEvent;
import com.ibm.webrunner.j2mclb.util.event.TableListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DatabaseTable
extends TableModel {
    public static final String DEFAULT_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String DEFAULT_URL = "jdbc:odbc:{0}";
    public static final String DEFAULT_USER_NAME = "";
    public static final String DEFAULT_USER_PASSWORD = "";
    public static final String DEFAULT_QUERY = "SELECT * FROM {0}";
    private Vector fColumnInfo = new Vector(5, 5);
    private transient Vector fRowInfo;
    private transient Vector fColumns;
    private Vector fTableListeners = new Vector();
    private String fDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String fURL = "jdbc:odbc:{0}";
    private String fUser = "";
    private String fPassword = "";
    private String fQuery = "SELECT * FROM {0}";
    private transient Connection fConnection;
    private transient DatabaseMetaData fDatabaseMetaData;
    private transient Statement fStatement;
    private transient ResultSet fResultSet;
    private transient ResultSetMetaData fResultSetMetaData;

    public DatabaseTable() {
    }

    public DatabaseTable(String string, String string2, String string3, String string4) {
        this(DEFAULT_DRIVER, string, string2, string3, string4);
    }

    public DatabaseTable(String string, String string2, String string3, String string4, String string5) {
        this.setUrl(string2);
        this.setUserName(string3);
        this.setUserPassword(string4);
        this.setQuery(string5);
        this.setDriver(string);
        this.setConnected(true);
    }

    public void addColumn(Object[] objectArray, Object object) {
    }

    public void addRow(Object[] objectArray, Object object) {
    }

    public void addTableListener(TableListener tableListener) {
        this.fTableListeners.addElement(tableListener);
    }

    public void fireTableEvent(TableEvent tableEvent) {
        Vector vector = (Vector)this.fTableListeners.clone();
        int n = vector.size();
        switch (tableEvent.getID()) {
            case 0: {
                int n2 = 0;
                while (n2 < n) {
                    ((TableListener)vector.elementAt(n2)).tableRefreshed(tableEvent);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    ((TableListener)vector.elementAt(n3)).tableChanged(tableEvent);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < n) {
                    ((TableListener)vector.elementAt(n4)).columnChanged(tableEvent);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < n) {
                    ((TableListener)vector.elementAt(n5)).rowChanged(tableEvent);
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < n) {
                    ((TableListener)vector.elementAt(n6)).elementChanged(tableEvent);
                    ++n6;
                }
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < n) {
                    ((TableListener)vector.elementAt(n7)).columnInfoChanged(tableEvent);
                    ++n7;
                }
                break;
            }
            case 6: {
                int n8 = 0;
                while (n8 < n) {
                    ((TableListener)vector.elementAt(n8)).columnAdded(tableEvent);
                    ++n8;
                }
                break;
            }
            case 7: {
                int n9 = 0;
                while (n9 < n) {
                    ((TableListener)vector.elementAt(n9)).columnRemoved(tableEvent);
                    ++n9;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n) {
                    ((TableListener)vector.elementAt(n10)).columnInserted(tableEvent);
                    ++n10;
                }
                break;
            }
            case 9: {
                int n11 = 0;
                while (n11 < n) {
                    ((TableListener)vector.elementAt(n11)).rowInfoChanged(tableEvent);
                    ++n11;
                }
                break;
            }
            case 10: {
                int n12 = 0;
                while (n12 < n) {
                    ((TableListener)vector.elementAt(n12)).rowAdded(tableEvent);
                    ++n12;
                }
                break;
            }
            case 11: {
                int n13 = 0;
                while (n13 < n) {
                    ((TableListener)vector.elementAt(n13)).rowRemoved(tableEvent);
                    ++n13;
                }
                break;
            }
            case 12: {
                int n14 = 0;
                while (n14 < n) {
                    ((TableListener)vector.elementAt(n14)).rowInserted(tableEvent);
                    ++n14;
                }
                break;
            }
        }
    }

    public int getColumnCount() {
        return this.fColumnInfo.size();
    }

    public int getColumnIndex(Object object) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n = this.fColumnInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fColumnInfo.elementAt(n2);
                if (object == null) {
                    if (e == null) {
                        return n2;
                    }
                } else if (e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getColumnInfo(int n) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.fColumnInfo.elementAt(n);
        }
    }

    public String getDriver() {
        return this.fDriver;
    }

    public Object getElement(int n, int n2) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n3 = this.fColumnInfo.size();
            if (n2 < 0 || n2 >= n3) {
                return null;
            }
            int n4 = this.fRowInfo.size();
            if (n < 0 || n >= n4) {
                return null;
            }
            return ((Vector)this.fColumns.elementAt(n2)).elementAt(n);
        }
    }

    private Object getObject(ResultSet resultSet, int n, int n2) throws SQLException {
        switch (n2) {
            case -7: {
                boolean bl = resultSet.getBoolean(n);
                if (bl) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case -6: 
            case 5: {
                return new Short(resultSet.getShort(n));
            }
            case 4: {
                return new Integer(resultSet.getInt(n));
            }
            case -5: {
                return new Long(resultSet.getLong(n));
            }
            case 6: {
                return new Float(resultSet.getFloat(n));
            }
            case 7: 
            case 8: {
                return new Double(resultSet.getDouble(n));
            }
            case 2: {
                return new Long(resultSet.getLong(n));
            }
            case 3: {
                return new Double(resultSet.getDouble(n));
            }
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(n);
            }
            case 91: {
                return resultSet.getDate(n);
            }
            case 92: 
            case 93: {
                return resultSet.getTime(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(n);
            }
            case 1111: {
                return "[OTHER]";
            }
        }
        return null;
    }

    public String getQuery() {
        return this.fQuery;
    }

    public int getRowCount() {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n = this.fColumnInfo.size();
            if (n > 0) {
                n = ((Vector)this.fColumns.elementAt(0)).size();
            }
            return n;
        }
    }

    public int getRowIndex(Object object) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n = this.fRowInfo.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.fRowInfo.elementAt(n2);
                if (object == null) {
                    if (e == null) {
                        return n2;
                    }
                } else if (e != null && e.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getRowInfo(int n) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.fRowInfo.elementAt(n);
        }
    }

    public String getUrl() {
        return this.fURL;
    }

    public String getUserName() {
        return this.fUser;
    }

    public String getUserPassword() {
        return this.fPassword;
    }

    public void insertColumn(Object[] objectArray, Object object, int n) {
    }

    public void insertRow(Object[] objectArray, Object object, int n) {
    }

    public boolean isConnected() {
        return this.fConnection != null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.fColumnInfo.size();
        this.fColumns = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.fColumns.addElement(new Vector(50, 50));
            ++n2;
        }
        this.fRowInfo = new Vector(50, 50);
        this.setConnected(true);
    }

    public void removeAllColumns() {
    }

    public void removeAllRows() {
    }

    public void removeColumn(int n) {
    }

    public void removeRow(int n) {
    }

    public void removeTableListener(TableListener tableListener) {
        this.fTableListeners.removeElement(tableListener);
    }

    public void replaceColumn(Object[] objectArray, Object object, int n) {
    }

    public void replaceRow(Object[] objectArray, Object object, int n) {
    }

    public void setColumnInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fColumnInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            this.fColumnInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 5, -1, n);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setConnected(boolean bl) {
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            if (bl) {
                if (this.fConnection != null) {
                    return;
                }
            } else {
                if (this.fConnection != null) {
                    try {
                        this.fConnection.close();
                    }
                    catch (SQLException sQLException) {}
                    this.fConnection = null;
                    this.fDatabaseMetaData = null;
                    this.fStatement = null;
                    this.fResultSet = null;
                    this.fResultSetMetaData = null;
                }
                return;
            }
            if (this.fURL.equals(DEFAULT_URL) || this.fQuery.equals(DEFAULT_QUERY)) {
                return;
            }
            this.fColumns = new Vector(5, 5);
            this.fRowInfo = new Vector(50, 50);
            try {
                this.fConnection = DriverManager.getConnection(this.fURL, this.fUser, this.fPassword);
                this.fDatabaseMetaData = this.fConnection.getMetaData();
                this.fStatement = this.fConnection.createStatement();
                this.fResultSet = this.fStatement.executeQuery(this.fQuery);
                this.fResultSetMetaData = this.fResultSet.getMetaData();
                int n = this.fResultSetMetaData.getColumnCount();
                int[] nArray = new int[n];
                int n2 = 1;
                while (n2 <= n) {
                    this.fColumnInfo.addElement(this.fResultSetMetaData.getColumnLabel(n2));
                    this.fColumns.addElement(new Vector(50, 50));
                    nArray[n2 - 1] = this.fResultSetMetaData.getColumnType(n2);
                    ++n2;
                }
                while (this.fResultSet.next()) {
                    n2 = 1;
                    while (n2 <= n) {
                        Object object = this.getObject(this.fResultSet, n2, nArray[n2 - 1]);
                        Vector vector = (Vector)this.fColumns.elementAt(n2 - 1);
                        vector.addElement(object);
                        ++n2;
                    }
                    this.fRowInfo.addElement(null);
                }
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
                this.fConnection = null;
                this.fDatabaseMetaData = null;
                this.fStatement = null;
                this.fResultSet = null;
                this.fColumnInfo = null;
                this.fRowInfo = null;
                this.fColumns = null;
            }
        }
    }

    public void setDriver(String string) {
        if (string == null) {
            string = DEFAULT_DRIVER;
        }
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            try {
                Class.forName(string);
                this.fDriver = string;
            }
            catch (Exception exception) {}
        }
    }

    public void setElement(Object object, int n, int n2) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n3 = this.fColumns.size();
            if (n2 < 0 || n2 >= n3) {
                return;
            }
            int n4 = ((Vector)this.fColumns.elementAt(0)).size();
            if (n < 0 || n >= n4) {
                return;
            }
            ((Vector)this.fColumns.elementAt(n2)).setElementAt(object, n);
        }
        serializable = new TableEvent(this, 4, n, n2);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setQuery(String string) {
        if (string == null) {
            string = DEFAULT_QUERY;
        }
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            this.fQuery = string;
        }
    }

    public void setRowInfo(Object object, int n) {
        Serializable serializable = this;
        synchronized (serializable) {
            int n2 = this.fRowInfo.size();
            if (n < 0 || n >= n2) {
                return;
            }
            this.fRowInfo.setElementAt(object, n);
        }
        serializable = new TableEvent(this, 9, n, -1);
        this.fireTableEvent((TableEvent)serializable);
    }

    public void setUrl(String string) {
        if (string == null) {
            string = DEFAULT_URL;
        }
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            this.fURL = string;
        }
    }

    public void setUserName(String string) {
        if (string == null) {
            string = "";
        }
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            this.fUser = string;
        }
    }

    public void setUserPassword(String string) {
        if (string == null) {
            string = "";
        }
        DatabaseTable databaseTable = this;
        synchronized (databaseTable) {
            this.fPassword = string;
        }
    }
}

