/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb;

import com.ibm.webrunner.j2mclb.Alignment;
import com.ibm.webrunner.j2mclb.Caption;
import com.ibm.webrunner.j2mclb.CaptionBar;
import com.ibm.webrunner.j2mclb.ListboxCaption;
import com.ibm.webrunner.j2mclb.ListboxColumn;
import com.ibm.webrunner.j2mclb.ListboxTable;
import com.ibm.webrunner.j2mclb.Paintable;
import com.ibm.webrunner.j2mclb.ScrollerPane;
import com.ibm.webrunner.j2mclb.event.CaptionBarEvent;
import com.ibm.webrunner.j2mclb.event.CaptionBarListener;
import com.ibm.webrunner.j2mclb.event.ListboxEvent;
import com.ibm.webrunner.j2mclb.event.ListboxListener;
import com.ibm.webrunner.j2mclb.util.IntegerVector;
import com.ibm.webrunner.j2mclb.util.Sorter;
import com.ibm.webrunner.j2mclb.util.TableModel;
import com.ibm.webrunner.j2mclb.util.event.TableEvent;
import com.ibm.webrunner.j2mclb.util.event.TableListener;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MultiColumnListboxBase
extends JPanel
implements ItemSelectable {
    protected transient Object LOCK;
    public static final Object DEFAULT_KEY = null;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    public static final int DEFAULT_CAPTIONBAR_HEIGHT = 20;
    public static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("Table.background");
    public static final Color DEFAULT_FOREGROUND_COLOR = UIManager.getColor("Table.foreground");
    public static final Color DEFAULT_SEPARATOR_COLOR = UIManager.getColor("Table.gridColor");
    public static final Color DEFAULT_SELECTION_BACKGROUND = UIManager.getColor("Table.selectionBackground");
    public static final Color DEFAULT_SELECTION_FOREGROUND = UIManager.getColor("Table.selectionForeground");
    ScrollerPane fScrollPane = new ScrollerPane();
    CaptionBar fCaptionBar = new CaptionBar();
    ViewArea fViewArea = new ViewArea(this);
    EventHandler fEventHandler = new EventHandler(this);
    TableModel fTable;
    boolean fListboxTable = false;
    Vector fColumnInfo;
    IntegerVector fColumns;
    IntegerVector fRows;
    BitSet fSelected;
    transient Vector fCaptionBarListeners;
    transient Vector fListboxListeners;
    transient Vector fItemListeners;
    boolean fHSeparator = false;
    boolean fVSeparator = false;
    Color fSeparatorColor = DEFAULT_SEPARATOR_COLOR;
    boolean fSelectable = true;
    Color fSelectionForeground = DEFAULT_SELECTION_FOREGROUND;
    Color fSelectionBackground = DEFAULT_SELECTION_BACKGROUND;
    boolean fUpdate = true;
    transient Image fBackgroundImage;
    boolean fMultipleSelections = false;
    int fMouseDownRow = -1;
    int fClickCount;
    long fClickTime;
    int fLastCaptionSelected = -1;
    int fLastSelected = -1;
    int fFocusLine = 0;
    boolean fHasFocus;

    protected MultiColumnListboxBase() {
        this((TableModel)null);
    }

    protected MultiColumnListboxBase(TableModel tableModel) {
        super(new BorderLayout());
        this.init();
        this.add((Component)this.fScrollPane, "Center");
        this.setBorderVisible(true);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.setForeground(DEFAULT_FOREGROUND_COLOR);
        this.setCaptionBarHeight(20);
        this.setRowHeight(20);
        this.setHorizontalSeparatorVisible(true);
        this.setVerticalSeparatorVisible(true);
        this.setContinuousDrag(true);
        this.fScrollPane.setSnapToVerticalUnitIncrement(true);
        this.fScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.fScrollPane.setColumnHeaderView(this.fCaptionBar);
        this.fScrollPane.setViewportView(this.fViewArea);
        this.setTableModel(tableModel);
    }

    protected void addCaptionBarListener(CaptionBarListener captionBarListener) {
        if (captionBarListener != null) {
            this.fCaptionBarListeners.addElement(captionBarListener);
        }
    }

    protected ListboxColumn addColumn(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                tableModel = new ListboxTable();
                this.setTableModel(tableModel);
            }
            ListboxColumn listboxColumn = null;
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                tableModel.addColumn(null, object);
                listboxColumn = this.getColumnInfo(this.getColumnCount() - 1);
            }
            return listboxColumn;
        }
    }

    protected void addColumns(Object[] objectArray) {
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n = 0;
        while (n < objectArray.length) {
            this.addColumn(objectArray[n]);
            ++n;
        }
        this.setUpdate(bl);
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fItemListeners == null) {
                this.fItemListeners = new Vector();
            }
            this.fItemListeners.addElement(itemListener);
        }
    }

    protected void addListboxListener(ListboxListener listboxListener) {
        if (listboxListener != null) {
            this.fListboxListeners.addElement(listboxListener);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.fViewArea.addMouseListener(mouseListener);
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener != null) {
            this.fViewArea.addMouseMotionListener(mouseMotionListener);
        }
    }

    protected void addRow(Object[] objectArray) {
        this.addRow(objectArray, DEFAULT_KEY);
    }

    protected void addRow(Object[] objectArray, Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (objectArray == null) {
                return;
            }
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                tableModel = new ListboxTable();
                this.setTableModel(tableModel);
            }
            Object[] objectArray2 = new Object[this.getColumnCount()];
            int n = 0;
            while (n < objectArray.length) {
                if (n >= objectArray2.length) break;
                objectArray2[this.listboxColumnToTableColumn((int)n)] = objectArray[n];
                ++n;
            }
            tableModel.addRow(objectArray2, object);
        }
    }

    protected void addRows(Object[][] objectArray) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n = 0;
        while (n < objectArray.length) {
            this.addRow(objectArray[n], DEFAULT_KEY);
            ++n;
        }
        this.setUpdate(bl);
    }

    protected void addRows(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n = 0;
        while (n < objectArray.length) {
            Object object = n < objectArray2.length ? objectArray2[n] : DEFAULT_KEY;
            this.addRow(objectArray[n], object);
            ++n;
        }
        this.setUpdate(bl);
    }

    protected boolean allowSelection(ListboxEvent listboxEvent) {
        return true;
    }

    protected void autoSizeColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2;
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n3 = this.getColumnCount();
            if (n < 0 || n >= n3) {
                return;
            }
            ListboxColumn listboxColumn = this.getColumnInfo(n);
            if (!listboxColumn.isResizable()) {
                return;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Font font = this.fCaptionBar.getFont();
            FontMetrics fontMetrics = toolkit.getFontMetrics(font);
            int n4 = 0;
            String string = listboxColumn.getLabel().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                n2 = fontMetrics.stringWidth(stringTokenizer.nextToken()) + 14;
                if (n2 <= n4) continue;
                n4 = n2;
            }
            fontMetrics = toolkit.getFontMetrics(this.getFont());
            n2 = this.listboxColumnToTableColumn(n);
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n5 = tableModel.getRowCount();
                int n6 = 0;
                while (n6 < n5) {
                    Object object2 = tableModel.getElement(n6, n2);
                    if (object2 != null) {
                        int n7 = 0;
                        if (object2 instanceof JComponent) {
                            n7 = ((JComponent)object2).getPreferredSize().width;
                        } else if (object2 instanceof Paintable) {
                            n7 = ((Paintable)object2).getSize().width;
                        } else {
                            String string2 = this.paintHook(object2.toString(), n6, n);
                            n7 = fontMetrics.stringWidth(string2) + 10;
                        }
                        if (n7 > n4) {
                            n4 = n7;
                        }
                    }
                    ++n6;
                }
            }
            listboxColumn.setWidth(n4);
            if (this.getUpdate()) {
                this.setSize();
            }
        }
    }

    protected ListboxCaption createCaption() {
        return new ListboxCaption();
    }

    protected void deliverEvent(EventObject eventObject) {
        if (eventObject instanceof ListboxEvent) {
            this.fireListboxEvent((ListboxEvent)eventObject);
            return;
        }
        if (eventObject instanceof CaptionBarEvent) {
            this.fireCaptionBarEvent((CaptionBarEvent)eventObject);
            return;
        }
        if (eventObject instanceof ItemEvent) {
            this.fireItemEvent((ItemEvent)eventObject);
            return;
        }
    }

    protected void deselectAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            this.fSelected = new BitSet(this.getRowCount());
            this.fLastSelected = -1;
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected void deselectColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.fCaptionBar.getSelectedCaptionIndex();
            if (n3 != -1) {
                this.fCaptionBar.getCaption(n3).setSelected(false);
            }
        }
    }

    protected void deselectRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            if (!this.getMultipleSelections()) {
                this.deselectAllRows();
            } else {
                this.fSelected.clear(n);
                if (this.fLastSelected == n) {
                    this.fLastSelected = -1;
                }
            }
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected void deselectRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n = this.getRowCount();
                boolean bl = this.getMultipleSelections();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.listboxRowToTableRow(n2);
                    Object object3 = tableModel.getRowInfo(n3);
                    if (object == null && object3 == null || object.equals(object3)) {
                        if (!bl) {
                            this.deselectAllRows();
                            break;
                        }
                        this.fSelected.clear(n2);
                        if (this.fLastSelected != n2) break;
                        this.fLastSelected = -1;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected void fireCaptionBarEvent(CaptionBarEvent captionBarEvent) {
        Vector vector = (Vector)this.fCaptionBarListeners.clone();
        int n = vector.size();
        if (captionBarEvent.getID() == 2000) {
            int n2 = 0;
            while (n2 < n) {
                ((CaptionBarListener)vector.elementAt(n2)).captionSelected(captionBarEvent);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                ((CaptionBarListener)vector.elementAt(n3)).captionResized(captionBarEvent);
                ++n3;
            }
        }
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        if (this.fItemListeners != null) {
            Vector vector = (Vector)this.fItemListeners.clone();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ItemListener)vector.elementAt(n2)).itemStateChanged(itemEvent);
                ++n2;
            }
        }
    }

    protected void fireListboxEvent(ListboxEvent listboxEvent) {
        Vector vector = (Vector)this.fListboxListeners.clone();
        int n = vector.size();
        if (listboxEvent.getID() == 2000) {
            int n2 = 0;
            while (n2 < n) {
                ((ListboxListener)vector.elementAt(n2)).rowSelected(listboxEvent);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                ((ListboxListener)vector.elementAt(n3)).rowDeselected(listboxEvent);
                ++n3;
            }
        }
    }

    public Color getBackground() {
        if (this.fViewArea != null) {
            return this.fViewArea.getBackground();
        }
        return super.getBackground();
    }

    protected Image getBackgroundImage() {
        return this.fBackgroundImage;
    }

    protected Color getCaptionBarBackground() {
        return this.fCaptionBar.getBackground();
    }

    protected Image getCaptionBarBackgroundImage() {
        return this.fCaptionBar.getBackgroundImage();
    }

    protected Font getCaptionBarFont() {
        return this.fCaptionBar.getFont();
    }

    protected Color getCaptionBarForeground() {
        return this.fCaptionBar.getForeground();
    }

    protected int getCaptionBarHeight() {
        return this.fCaptionBar.getSize().height;
    }

    protected Object[] getColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return null;
            }
            Object[] objectArray = null;
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n2 = tableModel.getColumnCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                int n3 = this.listboxColumnToTableColumn(n);
                objectArray = new Object[tableModel.getRowCount()];
                int n4 = 0;
                while (n4 < objectArray.length) {
                    int n5 = this.listboxRowToTableRow(n4);
                    objectArray[n4] = tableModel.getElement(n5, n3);
                    ++n4;
                }
            }
            return objectArray;
        }
    }

    protected int getColumnCount() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                return this.fColumns.size();
            }
        }
        return 0;
    }

    protected ListboxColumn getColumnInfo(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            if (n < 0 || n >= this.getColumnCount()) {
                return null;
            }
            return (ListboxColumn)this.fColumnInfo.elementAt(n);
        }
    }

    protected boolean getContinuousDrag() {
        return this.fCaptionBar.getContinuousDrag();
    }

    public Color getForeground() {
        if (this.fViewArea != null) {
            return this.fViewArea.getForeground();
        }
        return super.getForeground();
    }

    protected Adjustable getHorizontalAdjuster() {
        return this.fScrollPane.getHorizontalScrollBar();
    }

    protected int getIndexByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return -1;
            }
            TableModel tableModel2 = this.fTable;
            synchronized (tableModel2) {
                int n = this.getRowCount();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.listboxRowToTableRow(n2);
                    Object object3 = tableModel.getRowInfo(n3);
                    if (object == null && object3 == null || object.equals(object3)) {
                        return n2;
                    }
                    ++n2;
                }
            }
            return -1;
        }
    }

    protected Object[] getKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return null;
            }
            int n = this.getRowCount();
            if (n == 0) {
                return null;
            }
            Object[] objectArray = new Object[n];
            TableModel tableModel2 = this.fTable;
            synchronized (tableModel2) {
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.listboxRowToTableRow(n2);
                    objectArray[n2] = tableModel.getRowInfo(n3);
                    ++n2;
                }
            }
            return objectArray;
        }
    }

    protected Object getListboxLock() {
        return this.LOCK;
    }

    protected boolean getMultipleSelections() {
        return this.fMultipleSelections;
    }

    protected Object[] getRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return null;
            }
            Object[] objectArray = null;
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n2 = this.getRowCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                int n3 = this.listboxRowToTableRow(n);
                objectArray = new Object[this.getColumnCount()];
                int n4 = 0;
                while (n4 < objectArray.length) {
                    int n5 = this.listboxColumnToTableColumn(n4);
                    objectArray[n4] = tableModel.getElement(n3, n5);
                    ++n4;
                }
            }
            return objectArray;
        }
    }

    protected Object[] getRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            int n = this.getIndexByKey(object);
            if (n == -1) {
                return null;
            }
            return this.getRow(n);
        }
    }

    protected int getRowCount() {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel != null) {
                return tableModel.getRowCount();
            }
        }
        return 0;
    }

    protected int getRowHeight() {
        return this.fScrollPane.getVerticalScrollBar().getUnitIncrement();
    }

    protected Object getRowKey(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return null;
            }
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            return tableModel.getRowInfo(n);
        }
    }

    protected int getSelectedColumnIndex() {
        return this.fCaptionBar.getSelectedCaptionIndex();
    }

    protected int getSelectedIndex() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.isRowSelected(n2)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    protected int[] getSelectedIndexes() {
        Object object = this.LOCK;
        synchronized (object) {
            Vector<Integer> vector = new Vector<Integer>();
            int n = this.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.isRowSelected(n2)) {
                    vector.addElement(new Integer(n2));
                }
                ++n2;
            }
            int[] nArray = new int[vector.size()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = (Integer)vector.elementAt(n3);
                ++n3;
            }
            return nArray;
        }
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedRows();
    }

    protected Object[] getSelectedRow() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.isRowSelected(n2)) {
                    return this.getRow(n2);
                }
                ++n2;
            }
            return new Object[0];
        }
    }

    protected Object[][] getSelectedRows() {
        Object object = this.LOCK;
        synchronized (object) {
            int[] nArray = this.getSelectedIndexes();
            Object[][] objectArray = new Object[nArray.length][this.getColumnCount()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.getRow(nArray[n]);
                ++n;
            }
            return objectArray;
        }
    }

    protected Color getSelectionBackground() {
        return this.fSelectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.fSelectionForeground;
    }

    protected Color getSeparatorColor() {
        return this.fSeparatorColor;
    }

    protected TableModel getTableModel() {
        return this.fTable;
    }

    protected boolean getUpdate() {
        return this.fUpdate;
    }

    protected Adjustable getVerticalAdjuster() {
        return this.fScrollPane.getVerticalScrollBar();
    }

    protected int getVisibleColumn() {
        Object object = this.LOCK;
        synchronized (object) {
            Adjustable adjustable = this.getHorizontalAdjuster();
            int n = adjustable.getValue();
            adjustable.getVisibleAmount();
            int n2 = 0;
            int n3 = this.getColumnCount();
            int n4 = 0;
            while (n4 < n3) {
                ListboxColumn listboxColumn = this.getColumnInfo(n4);
                if (listboxColumn.isVisible() && n2 >= n) {
                    return n4;
                }
                n2 += listboxColumn.getWidth();
                ++n4;
            }
        }
        return -1;
    }

    protected int getVisibleColumnCount() {
        int n = 0;
        Object object = this.LOCK;
        synchronized (object) {
            Adjustable adjustable = this.getHorizontalAdjuster();
            int n2 = adjustable.getValue();
            adjustable.getVisibleAmount();
            int n3 = 0;
            int n4 = this.getColumnCount();
            int n5 = 0;
            while (n5 < n4) {
                ListboxColumn listboxColumn = this.getColumnInfo(n5);
                if (listboxColumn.isVisible() && n3 >= n2) {
                    ++n;
                }
                n3 += listboxColumn.getWidth();
                ++n5;
            }
        }
        return n;
    }

    protected int getVisibleRow() {
        return this.fScrollPane.getVerticalScrollBar().getValue() / this.getRowHeight();
    }

    protected int getVisibleRowCount() {
        return this.fScrollPane.getVerticalScrollBar().getVisibleAmount() / this.getRowHeight();
    }

    private void init() {
        this.LOCK = new Object();
        this.fCaptionBarListeners = new Vector();
        this.fListboxListeners = new Vector();
        this.removeComponentListener(this.fEventHandler);
        this.addComponentListener(this.fEventHandler);
        this.removeFocusListener(this.fEventHandler);
        this.addFocusListener(this.fEventHandler);
        this.removeKeyListener(this.fEventHandler);
        this.addKeyListener(this.fEventHandler);
        this.fCaptionBar.removeCaptionBarListener(this.fEventHandler);
        this.fCaptionBar.addCaptionBarListener(this.fEventHandler);
        this.fViewArea.removeMouseListener(this.fEventHandler);
        this.fViewArea.addMouseListener(this.fEventHandler);
    }

    protected void insertRow(Object[] objectArray, int n) {
        this.insertRow(objectArray, DEFAULT_KEY, n);
    }

    protected void insertRow(Object[] objectArray, Object object, int n) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (objectArray == null) {
                return;
            }
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                tableModel = new ListboxTable();
                this.setTableModel(tableModel);
            }
            Object[] objectArray2 = new Object[this.getColumnCount()];
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (n2 >= objectArray2.length) break;
                objectArray2[this.listboxColumnToTableColumn((int)n2)] = objectArray[n2];
                ++n2;
            }
            tableModel.insertRow(objectArray2, object, n);
        }
    }

    protected void insertRows(Object[][] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n2 = objectArray2 == null ? 0 : objectArray2.length;
        int n3 = objectArray.length - 1;
        while (n3 >= 0) {
            if (n3 < n2) {
                this.insertRow(objectArray[n3], DEFAULT_KEY, n);
            } else {
                this.insertRow(objectArray[n3], objectArray2[n3], n);
            }
            --n3;
        }
        this.setUpdate(bl);
    }

    protected void insertRows(Object[][] objectArray, int n) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.insertRow(objectArray[n2], DEFAULT_KEY, n);
            ++n2;
        }
        this.setUpdate(bl);
    }

    protected void invertSelections() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.getRowCount();
            if (n == 0 || !this.fMultipleSelections) {
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.isRowSelected(n2)) {
                    this.fSelected.clear(n2);
                } else {
                    this.fSelected.set(n2);
                }
                ++n2;
            }
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected boolean isBorderVisible() {
        return this.getBorder() != null;
    }

    protected boolean isCaptionBarVisible() {
        return this.fScrollPane.getColumnHeaderView() != null;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected boolean isHorizontalScrollbarVisible() {
        return this.fScrollPane.getHorizontalScrollBarPolicy() == 30;
    }

    protected boolean isHorizontalSeparatorVisible() {
        return this.fHSeparator;
    }

    protected boolean isRowSelected(int n) {
        return this.fSelected.get(n);
    }

    protected boolean isSelectable() {
        return this.fSelectable;
    }

    protected boolean isVerticalScrollbarVisible() {
        return this.fScrollPane.getVerticalScrollBarPolicy() == 20;
    }

    protected boolean isVerticalSeparatorVisible() {
        return this.fVSeparator;
    }

    protected int listboxColumnToTableColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return -1;
            }
            return this.fColumns.elementAt(n);
        }
    }

    protected int listboxRowToTableRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.fRows.size();
            if (n < 0 || n >= n2) {
                return -1;
            }
            return this.fRows.elementAt(n);
        }
    }

    protected void makeRowVisible(int n) {
        this.setVisibleRow(n);
    }

    protected String paintHook(String string, int n, int n2) {
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    protected void removeAllColumns() {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel != null) {
                tableModel.removeAllColumns();
            }
        }
    }

    protected void removeAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel != null) {
                tableModel.removeAllRows();
            }
        }
    }

    protected void removeCaptionBarListener(CaptionBarListener captionBarListener) {
        if (captionBarListener != null) {
            this.fCaptionBarListeners.removeElement(captionBarListener);
        }
    }

    protected void removeColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n2 = this.getColumnCount();
                if (n < 0 || n >= n2) {
                    return;
                }
                int n3 = this.listboxColumnToTableColumn(n);
                tableModel.removeColumn(n3);
            }
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fItemListeners != null) {
                this.fItemListeners.removeElement(itemListener);
                if (this.fItemListeners.size() == 0) {
                    this.fItemListeners = null;
                }
            }
        }
    }

    protected void removeListboxListener(ListboxListener listboxListener) {
        if (listboxListener != null) {
            this.fListboxListeners.removeElement(listboxListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.fViewArea.removeMouseListener(mouseListener);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener != null) {
            this.fViewArea.removeMouseMotionListener(mouseMotionListener);
        }
    }

    protected void removeRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.listboxRowToTableRow(n);
            tableModel.removeRow(n3);
        }
    }

    protected void removeRows(int n, int n2) {
        boolean bl = this.getUpdate();
        this.setUpdate(false);
        int n3 = 0;
        while (n3 < n2) {
            this.removeRow(n);
            ++n3;
        }
        this.setUpdate(bl);
    }

    protected void replaceColumn(Object[] objectArray, int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.listboxColumnToTableColumn(n);
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                Object object2 = tableModel.getColumnInfo(n3);
                tableModel.replaceColumn(objectArray, object2, n3);
            }
        }
    }

    protected void replaceRow(Object[] objectArray, int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.listboxRowToTableRow(n);
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                Object object2 = tableModel.getRowInfo(n3);
                tableModel.replaceRow(objectArray, object2, n3);
            }
        }
    }

    protected void selectAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.getRowCount();
            if (n == 0 || !this.fMultipleSelections || this.getColumnCount() == 0) {
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                this.fSelected.set(n2);
                ++n2;
            }
            this.fLastSelected = 0;
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected void selectColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = this.fCaptionBar.getSelectedCaptionIndex();
            if (n3 != -1) {
                this.fCaptionBar.getCaption(n3).setSelected(false);
            }
            this.fCaptionBar.getCaption(n).setSelected(true);
            if (this.getUpdate()) {
                this.fCaptionBar.repaint();
            }
            if (tableModel != null) {
                this.sort();
            }
        }
    }

    protected void selectRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return;
            }
            if (!this.getMultipleSelections()) {
                this.deselectAllRows();
            }
            this.fSelected.set(n);
            this.fLastSelected = n;
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    protected void selectRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                int n = this.getRowCount();
                boolean bl = this.getMultipleSelections();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.listboxRowToTableRow(n2);
                    Object object3 = tableModel.getRowInfo(n3);
                    if (object == null && object3 == null || object.equals(object3)) {
                        if (!bl) {
                            this.deselectAllRows();
                        }
                        this.fSelected.set(n2);
                        this.fLastSelected = n2;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.getUpdate()) {
                this.repaint();
            }
        }
    }

    public void setBackground(Color color) {
        if (this.fViewArea != null) {
            this.fViewArea.setBackground(color);
        } else {
            super.setBackground(color);
        }
        this.repaint();
    }

    protected void setBackgroundImage(Image image) {
        this.fBackgroundImage = image;
        if (this.getUpdate()) {
            this.repaint();
        }
    }

    protected void setBorderVisible(boolean bl) {
        if (bl != this.isBorderVisible()) {
            this.setBorder(bl ? BorderFactory.createLineBorder(Color.black) : null);
            this.doLayout();
        }
    }

    protected void setCaptionBarBackground(Color color) {
        this.fCaptionBar.setBackground(color);
    }

    protected void setCaptionBarBackgroundImage(Image image) {
        this.fCaptionBar.setBackgroundImage(image);
    }

    protected void setCaptionBarFont(Font font) {
        this.fCaptionBar.setFont(font);
    }

    protected void setCaptionBarForeground(Color color) {
        this.fCaptionBar.setForeground(color);
    }

    protected void setCaptionBarHeight(int n) {
        if (n > 0) {
            this.fCaptionBar.setSize(this.fCaptionBar.getSize().width, n);
        }
    }

    protected void setCaptionBarVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.isCaptionBarVisible()) {
                this.fScrollPane.setColumnHeaderView(bl ? this.fCaptionBar : null);
            }
        }
    }

    protected void setContinuousDrag(boolean bl) {
        this.fCaptionBar.setContinuousDrag(bl);
    }

    public void setForeground(Color color) {
        if (this.fViewArea != null) {
            this.fViewArea.setForeground(color);
        } else {
            super.setForeground(color);
        }
        this.repaint();
    }

    protected void setHorizontalScrollbarVisible(boolean bl) {
        int n = bl ? 30 : 31;
        this.fScrollPane.setHorizontalScrollBarPolicy(n);
    }

    protected void setHorizontalSeparatorVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.fHSeparator) {
                this.fHSeparator = bl;
                if (this.getUpdate()) {
                    this.repaint();
                }
            }
        }
    }

    protected void setMultipleSelections(boolean bl) {
        this.fMultipleSelections = bl;
    }

    protected void setRowHeight(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.getRowHeight() != n) {
                this.fScrollPane.getVerticalScrollBar().setUnitIncrement(n);
                if (this.getUpdate()) {
                    this.setSize();
                }
            }
        }
    }

    protected void setRowKey(Object object, int n) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return;
            }
            tableModel.setRowInfo(object, n);
        }
    }

    protected void setSelectable(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fSelectable != bl) {
                this.fSelectable = bl;
                if (!bl) {
                    this.deselectAllRows();
                }
            }
        }
    }

    protected void setSelectionBackground(Color color) {
        if (color == null) {
            color = DEFAULT_SELECTION_BACKGROUND;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSelectionBackground.equals(color)) {
                this.fSelectionBackground = color;
                if (this.getUpdate()) {
                    this.repaint();
                }
            }
        }
    }

    protected void setSelectionForeground(Color color) {
        if (color == null) {
            color = DEFAULT_SELECTION_BACKGROUND;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSelectionForeground.equals(color)) {
                this.fSelectionForeground = color;
                if (this.getUpdate()) {
                    this.repaint();
                }
            }
        }
    }

    protected void setSeparatorColor(Color color) {
        if (color == null) {
            color = DEFAULT_SEPARATOR_COLOR;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSeparatorColor.equals(color)) {
                this.fSeparatorColor = color;
                if (this.getUpdate()) {
                    this.repaint();
                }
            }
        }
    }

    protected void setSize() {
        int n = 0;
        int n2 = this.getRowCount() * this.getRowHeight();
        Object object = this.LOCK;
        synchronized (object) {
            int n3 = this.getColumnCount();
            int n4 = 0;
            while (n4 < n3) {
                ListboxColumn listboxColumn = this.getColumnInfo(n4);
                if (listboxColumn.isVisible()) {
                    n += listboxColumn.getWidth();
                }
                ++n4;
            }
        }
        this.fViewArea.setSize(n, n2);
        object = this.fScrollPane.getViewport().getSize();
        if (n < ((Dimension)object).width || n2 < ((Dimension)object).height) {
            this.fViewArea.setSize(n > ((Dimension)object).width ? n : ((Dimension)object).width, n2 > ((Dimension)object).height ? n2 : ((Dimension)object).height);
        }
        this.repaint();
    }

    protected void setTableModel(TableModel tableModel) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                this.fTable.removeTableListener(this.fEventHandler);
            }
            this.fTable = tableModel;
            this.fCaptionBar.removeAll();
            this.fViewArea.removeAll();
            if (this.fTable == null) {
                this.fColumnInfo = null;
                this.fColumns = null;
                this.fRows = null;
                this.fSelected = null;
                return;
            }
            TableModel tableModel2 = this.fTable;
            synchronized (tableModel2) {
                int n = this.fTable.getColumnCount();
                int n2 = this.fTable.getRowCount();
                this.fColumnInfo = new Vector(n);
                this.fColumns = new IntegerVector(n);
                this.fRows = new IntegerVector(n2);
                this.fSelected = new BitSet(n2);
                this.fTable.addTableListener(this.fEventHandler);
                int n3 = 0;
                while (n3 < n) {
                    ListboxCaption listboxCaption = this.createCaption();
                    listboxCaption.setLabel(this.fTable.getColumnInfo(n3));
                    this.fCaptionBar.addCaption(listboxCaption);
                    ListboxColumn listboxColumn = new ListboxColumn(this, n3, listboxCaption);
                    this.fColumnInfo.addElement(listboxColumn);
                    this.fColumns.addElement(n3);
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    this.fRows.addElement(n3);
                    ++n3;
                }
                this.fListboxTable = this.fTable instanceof ListboxTable;
            }
            this.setSize();
        }
    }

    protected void setUpdate(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            this.fUpdate = bl;
            if (bl) {
                this.setSize();
                this.repaint();
            }
        }
    }

    protected void setVerticalScrollbarVisible(boolean bl) {
        int n = bl ? 20 : 21;
        this.fScrollPane.setVerticalScrollBarPolicy(n);
    }

    protected void setVerticalSeparatorVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.fVSeparator) {
                this.fVSeparator = bl;
                if (this.getUpdate()) {
                    this.repaint();
                }
            }
        }
    }

    protected void setVisibleColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                ListboxColumn listboxColumn = this.getColumnInfo(n4);
                if (listboxColumn.isVisible()) {
                    n3 += listboxColumn.getWidth();
                }
                ++n4;
            }
            this.fScrollPane.setViewPosition(new Point(n3, this.fScrollPane.getViewPosition().y));
        }
    }

    protected void setVisibleRow(int n) {
        this.fScrollPane.getVerticalScrollBar().setValue(n * this.getRowHeight());
    }

    protected void sort() {
        Object object = this.LOCK;
        synchronized (object) {
            TableModel tableModel = this.getTableModel();
            if (tableModel == null) {
                return;
            }
            TableModel tableModel2 = tableModel;
            synchronized (tableModel2) {
                ListboxColumn listboxColumn;
                Sorter sorter;
                int n = this.fCaptionBar.getSelectedCaptionIndex();
                if (n != -1 && (sorter = (listboxColumn = this.getColumnInfo(n)).getSorter()) != null) {
                    if (listboxColumn.getState()) {
                        sorter.setSortOrder(1);
                    } else {
                        sorter.setSortOrder(0);
                    }
                    int[] nArray = sorter.sort(this.getColumn(n));
                    if (this.fListboxTable) {
                        ListboxTable listboxTable = (ListboxTable)tableModel;
                        Object[][] objectArray = new Object[nArray.length][this.getColumnCount()];
                        Object[] objectArray2 = new Object[nArray.length];
                        BitSet bitSet = new BitSet(this.fSelected.size());
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            objectArray[n2] = this.getRow(nArray[n2]);
                            objectArray2[n2] = listboxTable.getRowInfo(nArray[n2]);
                            if (this.isRowSelected(nArray[n2])) {
                                bitSet.set(n2);
                            }
                            ++n2;
                        }
                        this.fSelected = bitSet;
                        n2 = 0;
                        boolean bl = false;
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            listboxTable.replaceRowImpl(objectArray[n3], objectArray2[n3], n3);
                            if (n2 == 0 && nArray[n3] == this.fLastSelected) {
                                this.fLastSelected = n3;
                                n2 = 1;
                            }
                            if (!bl && nArray[n3] == this.fFocusLine) {
                                this.fFocusLine = n3;
                                bl = true;
                            }
                            ++n3;
                        }
                        if (this.getUpdate()) {
                            this.repaint();
                        }
                    } else {
                        IntegerVector integerVector = new IntegerVector();
                        BitSet bitSet = new BitSet(this.fSelected.size());
                        boolean bl = false;
                        boolean bl2 = false;
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            int n5 = nArray[n4];
                            if (this.isRowSelected(n5)) {
                                bitSet.set(n4);
                            }
                            integerVector.addElement(this.listboxRowToTableRow(n5));
                            if (!bl && n5 == this.fLastSelected) {
                                this.fLastSelected = n4;
                                bl = true;
                            }
                            if (!bl2 && n5 == this.fFocusLine) {
                                this.fFocusLine = n4;
                                bl2 = true;
                            }
                            ++n4;
                        }
                        this.fRows = integerVector;
                        this.fSelected = bitSet;
                    }
                    if (this.getUpdate()) {
                        this.repaint();
                    }
                }
            }
        }
    }

    protected int tableColumnToListboxColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getColumnCount();
            if (n < 0 || n >= n2) {
                return -1;
            }
            return this.fColumns.indexOf(n);
        }
    }

    protected int tableRowToListboxRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            int n2 = this.getRowCount();
            if (n < 0 || n >= n2) {
                return -1;
            }
            return this.fRows.indexOf(n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("model=" + this.fTable);
        if (this.fSelectable) {
            stringBuffer.append(",selection=");
            if (this.fMultipleSelections) {
                stringBuffer.append("multiple");
            } else {
                stringBuffer.append("single");
            }
        }
        if (this.fCaptionBar.isVisible()) {
            stringBuffer.append(",capbar");
        }
        if (this.fHSeparator) {
            stringBuffer.append(",hsep");
        }
        if (this.fVSeparator) {
            stringBuffer.append(",vsep");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void useSystemColors() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.getUpdate();
            this.setUpdate(false);
            this.fCaptionBar.setBackground(UIManager.getColor("TableHeader.background"));
            this.fCaptionBar.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.fViewArea.setBackground(UIManager.getColor("Table.background"));
            this.fViewArea.setForeground(UIManager.getColor("Table.foreground"));
            this.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
            this.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
            this.setUpdate(bl);
        }
    }

    class EventHandler
    implements TableListener,
    CaptionBarListener,
    ComponentListener,
    FocusListener,
    MouseListener,
    KeyListener,
    Serializable {
        /* synthetic */ MultiColumnListboxBase this$0;

        public void tableRefreshed(TableEvent tableEvent) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                if (tableEvent.getRow() != -1) {
                    int[] nArray = tableEvent.getIndexes();
                    IntegerVector integerVector = (IntegerVector)this.this$0.fRows.clone();
                    BitSet bitSet = new BitSet(nArray.length);
                    int n = 0;
                    while (n < nArray.length) {
                        integerVector.setElementAt(nArray[n], n);
                        if (this.this$0.isRowSelected(this.this$0.listboxRowToTableRow(n))) {
                            bitSet.set(n);
                        }
                        ++n;
                    }
                    this.this$0.fRows = integerVector;
                    this.this$0.fSelected = bitSet;
                } else if (tableEvent.getColumn() != -1) {
                    int[] nArray = tableEvent.getIndexes();
                    IntegerVector integerVector = (IntegerVector)this.this$0.fColumns.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        integerVector.setElementAt(nArray[n], n);
                        ++n;
                    }
                    this.this$0.fColumns = integerVector;
                }
            }
            if (this.this$0.getUpdate()) {
                this.this$0.repaint();
            }
        }

        public void tableChanged(TableEvent tableEvent) {
            this.this$0.setTableModel(this.this$0.fTable);
        }

        public void columnChanged(TableEvent tableEvent) {
            this.elementChanged(tableEvent);
        }

        public void rowChanged(TableEvent tableEvent) {
            this.elementChanged(tableEvent);
        }

        public void elementChanged(TableEvent tableEvent) {
            if (this.this$0.getUpdate()) {
                this.this$0.repaint();
            }
        }

        public void columnInfoChanged(TableEvent tableEvent) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                TableModel tableModel = this.this$0.getTableModel();
                if (tableModel != null) {
                    TableModel tableModel2 = tableModel;
                    synchronized (tableModel2) {
                        int n = tableEvent.getColumn();
                        int n2 = this.this$0.getColumnCount();
                        int n3 = 0;
                        while (n3 < n2) {
                            if (this.this$0.fColumns.elementAt(n3) == n) {
                                Caption caption = this.this$0.fCaptionBar.getCaption(n3);
                                caption.setLabel(tableModel.getColumnInfo(n));
                                if (!this.this$0.getUpdate()) break;
                                this.this$0.fCaptionBar.repaint();
                                break;
                            }
                            ++n3;
                        }
                    }
                }
            }
        }

        public void columnAdded(TableEvent tableEvent) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                TableModel tableModel = this.this$0.getTableModel();
                if (tableModel == null) {
                    return;
                }
                int n = tableEvent.getColumn();
                ListboxCaption listboxCaption = this.this$0.createCaption();
                listboxCaption.setLabel(tableModel.getColumnInfo(n));
                this.this$0.fCaptionBar.addCaption(listboxCaption);
                ListboxColumn listboxColumn = new ListboxColumn(this.this$0, n, listboxCaption);
                this.this$0.fColumnInfo.addElement(listboxColumn);
                this.this$0.fColumns.addElement(n);
                if (this.this$0.getUpdate()) {
                    this.this$0.setSize();
                }
            }
        }

        public void columnRemoved(TableEvent tableEvent) {
            int n = tableEvent.getColumn();
            if (n == -2) {
                this.this$0.setTableModel(this.this$0.fTable);
                return;
            }
            Object object = this.this$0.LOCK;
            synchronized (object) {
                n = this.this$0.fColumns.indexOf(tableEvent.getColumn());
                this.this$0.fColumnInfo.removeElementAt(n);
                int n2 = this.this$0.getColumnCount();
                int n3 = tableEvent.getColumn() + 1;
                while (n3 < n2) {
                    int n4 = this.this$0.fColumns.indexOf(n3);
                    this.this$0.fColumns.setElementAt(this.this$0.fColumns.elementAt(n4) - 1, n4);
                    ++n3;
                }
                this.this$0.fColumns.removeElementAt(n);
                if (this.this$0.getUpdate()) {
                    this.this$0.setSize();
                }
            }
        }

        public void columnInserted(TableEvent tableEvent) {
            this.columnAdded(tableEvent);
        }

        public void rowInfoChanged(TableEvent tableEvent) {
        }

        public void rowAdded(TableEvent tableEvent) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n = this.this$0.fRows.size();
                this.this$0.fRows.addElement(n);
                if (this.this$0.getUpdate()) {
                    this.this$0.setSize();
                }
            }
        }

        public void rowRemoved(TableEvent tableEvent) {
            int n = tableEvent.getRow();
            Object object = this.this$0.LOCK;
            synchronized (object) {
                if (n == -2) {
                    this.this$0.fRows = new IntegerVector();
                    this.this$0.fSelected = new BitSet();
                    this.this$0.fFocusLine = 0;
                    this.this$0.fLastSelected = -1;
                } else {
                    int n2 = this.this$0.fRows.size();
                    int n3 = this.this$0.fRows.indexOf(n);
                    while (n3 < n2 - 1) {
                        if (this.this$0.isRowSelected(n3 + 1)) {
                            this.this$0.fSelected.set(n3);
                        } else {
                            this.this$0.fSelected.clear(n3);
                        }
                        ++n3;
                    }
                    this.this$0.fSelected.clear(n2 - 1);
                    n3 = n + 1;
                    while (n3 < n2) {
                        int n4 = this.this$0.fRows.indexOf(n3);
                        int n5 = this.this$0.listboxRowToTableRow(n4) - 1;
                        this.this$0.fRows.setElementAt(n5, n4);
                        ++n3;
                    }
                    if (n < this.this$0.fLastSelected) {
                        --this.this$0.fLastSelected;
                    } else if (n == this.this$0.fLastSelected) {
                        this.this$0.fLastSelected = 0;
                    }
                    if (n < this.this$0.fFocusLine) {
                        --this.this$0.fFocusLine;
                    } else if (n == this.this$0.fFocusLine) {
                        this.this$0.fFocusLine = 0;
                    }
                    this.this$0.fRows.removeElementAt(this.this$0.fRows.indexOf(n));
                }
            }
            if (this.this$0.getUpdate()) {
                this.this$0.setSize();
            }
        }

        public void rowInserted(TableEvent tableEvent) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n = tableEvent.getRow();
                int n2 = this.this$0.fRows.size();
                int n3 = n2 - 1;
                while (n3 >= n) {
                    int n4 = this.this$0.fRows.indexOf(n3);
                    int n5 = this.this$0.listboxRowToTableRow(n4) + 1;
                    this.this$0.fRows.setElementAt(n5, n4);
                    --n3;
                }
                if (this.this$0.fListboxTable) {
                    this.this$0.fRows.insertElementAt(n, n);
                    n3 = n2;
                    while (n3 > n) {
                        if (this.this$0.isRowSelected(n3 - 1)) {
                            this.this$0.fSelected.set(n3);
                        } else {
                            this.this$0.fSelected.clear(n3);
                        }
                        --n3;
                    }
                    this.this$0.fSelected.clear(n);
                    if (n <= this.this$0.fLastSelected) {
                        ++this.this$0.fLastSelected;
                    }
                    if (n <= this.this$0.fFocusLine) {
                        ++this.this$0.fFocusLine;
                    }
                } else {
                    this.this$0.fRows.addElement(n);
                }
            }
            if (this.this$0.getUpdate()) {
                this.this$0.setSize();
            }
        }

        public void captionSelected(CaptionBarEvent captionBarEvent) {
            this.this$0.requestFocus();
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n = captionBarEvent.getCaption();
                ListboxCaption listboxCaption = (ListboxCaption)this.this$0.fCaptionBar.getCaption(n);
                ListboxColumn listboxColumn = this.this$0.getColumnInfo(n);
                if (listboxColumn.isSortable()) {
                    if (n == this.this$0.fLastCaptionSelected) {
                        listboxCaption.setState(!listboxCaption.getState());
                        if (listboxCaption.getState()) {
                            listboxColumn.getSorter().setSortOrder(0);
                        } else {
                            listboxColumn.getSorter().setSortOrder(1);
                        }
                    }
                    this.this$0.fLastCaptionSelected = n;
                    this.this$0.sort();
                }
            }
            this.this$0.fireCaptionBarEvent(captionBarEvent);
        }

        public void captionResized(CaptionBarEvent captionBarEvent) {
            CaptionBar captionBar = (CaptionBar)captionBarEvent.getSource();
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n = captionBarEvent.getCaption();
                if (captionBarEvent.getClickCount() > 1) {
                    this.this$0.autoSizeColumn(n);
                } else {
                    Caption caption = captionBar.getCaption(n);
                    ListboxColumn listboxColumn = this.this$0.getColumnInfo(n);
                    listboxColumn.setWidth(caption.getLength());
                }
                if (this.this$0.getUpdate()) {
                    this.this$0.setSize();
                }
            }
            this.this$0.fireCaptionBarEvent(captionBarEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.this$0.setSize();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public synchronized void focusGained(FocusEvent focusEvent) {
            this.this$0.fHasFocus = true;
            if (this.this$0.getUpdate()) {
                this.this$0.repaint();
            }
        }

        public synchronized void focusLost(FocusEvent focusEvent) {
            this.this$0.fHasFocus = false;
            if (this.this$0.getUpdate()) {
                this.this$0.repaint();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.this$0.requestFocus();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (!this.this$0.fHasFocus) {
                this.this$0.requestFocus();
            }
            if (object == this.this$0.fViewArea) {
                ListboxEvent listboxEvent = null;
                Object object2 = this.this$0.LOCK;
                synchronized (object2) {
                    int n;
                    int n2;
                    TableModel tableModel = this.this$0.getTableModel();
                    if (!this.this$0.isSelectable() || tableModel == null) {
                        return;
                    }
                    int n3 = this.this$0.getColumnCount();
                    if (n3 < 1) {
                        return;
                    }
                    int n4 = this.this$0.getRowCount();
                    int n5 = this.this$0.getRowHeight();
                    int n6 = mouseEvent.getX();
                    int n7 = mouseEvent.getY();
                    int n8 = mouseEvent.getModifiers();
                    boolean bl = mouseEvent.isShiftDown();
                    boolean bl2 = mouseEvent.isControlDown();
                    boolean bl3 = mouseEvent.isAltDown();
                    boolean bl4 = mouseEvent.isMetaDown();
                    int n9 = -1;
                    int n10 = -1;
                    int n11 = n7 / n5;
                    if (n11 >= n4) {
                        return;
                    }
                    long l = System.currentTimeMillis();
                    this.this$0.fClickCount = n11 != this.this$0.fMouseDownRow ? 1 : (l - this.this$0.fClickTime < 400L ? ++this.this$0.fClickCount : 1);
                    this.this$0.fMouseDownRow = n11;
                    this.this$0.fClickTime = l;
                    n9 = this.this$0.fMouseDownRow;
                    if (n9 < 0 || n9 >= n4) {
                        return;
                    }
                    int n12 = this.this$0.fLastSelected;
                    int n13 = this.this$0.fFocusLine;
                    boolean bl5 = this.this$0.getUpdate();
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 < n3) {
                        Caption caption = this.this$0.fCaptionBar.getCaption(n15);
                        if (caption.isVisible()) {
                            n2 = caption.getLength();
                            if (n6 >= n14 && n6 < n14 + n2) {
                                n10 = n15;
                                break;
                            }
                            n14 += n2;
                        }
                        ++n15;
                    }
                    if (n10 == -1) {
                        n15 = 0;
                        n = 0;
                    } else {
                        n15 = n6 - n14;
                        n = n7 - n9 * n5;
                    }
                    if (bl4) {
                        if (n8 == 4 || bl3) {
                            n12 = n13 = n9;
                            listboxEvent = new ListboxEvent(this.this$0, 2000, n13, n10, this.this$0.fClickCount, n8, n15, n);
                            if (!this.this$0.allowSelection(listboxEvent)) {
                                return;
                            }
                            this.this$0.setUpdate(false);
                            this.this$0.deselectAllRows();
                            this.this$0.selectRow(n13);
                        } else {
                            listboxEvent = new ListboxEvent(this.this$0, 2000, n12, n10, this.this$0.fClickCount, n8, n15, n);
                            if (!this.this$0.allowSelection(listboxEvent)) {
                                return;
                            }
                        }
                    } else if (bl) {
                        n13 = n9;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n13, n10, this.this$0.fClickCount, n8, n15, n);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        if (!bl2) {
                            this.this$0.deselectAllRows();
                        }
                        if (this.this$0.getMultipleSelections()) {
                            if (n12 < n13) {
                                n2 = n12;
                                while (n2 <= n13) {
                                    this.this$0.selectRow(n2);
                                    ++n2;
                                }
                            } else {
                                n2 = n13;
                                while (n2 <= n12) {
                                    this.this$0.selectRow(n2);
                                    ++n2;
                                }
                            }
                        } else {
                            this.this$0.selectRow(n13);
                        }
                    } else if (bl2) {
                        n12 = n13 = n9;
                        n2 = this.this$0.isRowSelected(n13) ? 2001 : 2000;
                        listboxEvent = new ListboxEvent(this.this$0, n2, n13, n10, this.this$0.fClickCount, n8, n15, n);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        if (n2 == 2000) {
                            this.this$0.selectRow(n13);
                        } else {
                            this.this$0.deselectRow(n13);
                        }
                    } else {
                        n12 = n13 = n9;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n13, n10, this.this$0.fClickCount, n8, n15, n);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        this.this$0.selectRow(n13);
                    }
                    this.this$0.fLastSelected = n12;
                    this.this$0.fFocusLine = n13;
                    this.this$0.setUpdate(bl5);
                }
                if (listboxEvent != null) {
                    this.this$0.deliverEvent(listboxEvent);
                    if (this.this$0.fItemListeners != null) {
                        object2 = new Integer(listboxEvent.getRow());
                        int n = listboxEvent.getID() == 2000 ? 1 : 2;
                        ItemEvent itemEvent = new ItemEvent(this.this$0, 701, object2, n);
                        this.this$0.deliverEvent(itemEvent);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!this.this$0.fHasFocus) {
                this.this$0.requestFocus();
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            boolean bl3 = keyEvent.isAltDown();
            switch (n) {
                case 9: {
                    this.this$0.transferFocus();
                    return;
                }
                case 37: 
                case 39: {
                    JScrollBar jScrollBar = this.this$0.fScrollPane.getHorizontalScrollBar();
                    int n3 = jScrollBar.getValue();
                    int n4 = jScrollBar.getUnitIncrement();
                    jScrollBar.setValue(n3 + (n == 39 ? n4 : -n4));
                    return;
                }
            }
            if (bl3) {
                return;
            }
            ListboxEvent listboxEvent = null;
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n5 = this.this$0.fLastSelected;
                int n6 = this.this$0.fFocusLine;
                this.this$0.getRowHeight();
                int n7 = this.this$0.getVisibleRow();
                int n8 = this.this$0.getVisibleRowCount();
                int n9 = this.this$0.getRowCount() - 1;
                boolean bl4 = this.this$0.getUpdate();
                if (!this.this$0.fSelectable) {
                    bl = false;
                    bl3 = false;
                    bl2 = true;
                }
                boolean bl5 = bl && this.this$0.getMultipleSelections();
                switch (n) {
                    case 32: {
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 10: {
                        if (!this.this$0.isRowSelected(n6)) {
                            return;
                        }
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 2, n2);
                        if (this.this$0.allowSelection(listboxEvent)) break;
                        return;
                    }
                    case 36: {
                        if (n6 == 0) {
                            return;
                        }
                        n6 = 0;
                        n7 = 0;
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            int n10 = n6;
                            while (n10 <= n5) {
                                this.this$0.selectRow(n10);
                                ++n10;
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 33: {
                        if (n6 == 0) {
                            return;
                        }
                        if (n6 == n7) {
                            if ((n6 -= n8) < 0) {
                                n6 = 0;
                            }
                            n7 = n6;
                        } else {
                            n6 = n7;
                        }
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            if (n5 < n6) {
                                int n11 = n5;
                                while (n11 <= n6) {
                                    this.this$0.selectRow(n11);
                                    ++n11;
                                }
                            } else {
                                int n12 = n6;
                                while (n12 <= n5) {
                                    this.this$0.selectRow(n12);
                                    ++n12;
                                }
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 38: {
                        if (n6 == 0) {
                            return;
                        }
                        if (--n6 < n7 || n6 > n7 + n8) {
                            n7 = n6;
                        }
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            if (n5 < n6) {
                                int n13 = n5;
                                while (n13 <= n6) {
                                    this.this$0.selectRow(n13);
                                    ++n13;
                                }
                            } else {
                                int n14 = n6;
                                while (n14 <= n5) {
                                    this.this$0.selectRow(n14);
                                    ++n14;
                                }
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 40: {
                        if (n6 == n9) {
                            return;
                        }
                        if (++n6 < n7 || n6 > n7 + n8) {
                            n7 = n6;
                        } else if (n6 == n7 + n8) {
                            ++n7;
                        }
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            if (n5 < n6) {
                                int n15 = n5;
                                while (n15 <= n6) {
                                    this.this$0.selectRow(n15);
                                    ++n15;
                                }
                            } else {
                                int n16 = n6;
                                while (n16 <= n5) {
                                    this.this$0.selectRow(n16);
                                    ++n16;
                                }
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 34: {
                        if (n6 == n9) {
                            return;
                        }
                        if (n6 == n7 + n8 - 1) {
                            if ((n6 += n8) > n9) {
                                n6 = n9;
                            }
                            n7 += n8;
                        } else {
                            n6 = n7 + n8 - 1;
                            if (n6 > n9) {
                                n6 = n9;
                            }
                        }
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            if (n5 < n6) {
                                int n17 = n5;
                                while (n17 <= n6) {
                                    this.this$0.selectRow(n17);
                                    ++n17;
                                }
                            } else {
                                int n18 = n6;
                                while (n18 <= n5) {
                                    this.this$0.selectRow(n18);
                                    ++n18;
                                }
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    case 35: {
                        if (n6 == n9) {
                            return;
                        }
                        n6 = n9;
                        if (n6 > n7 + n8 - 1 && (n7 = n6 - n8 + 1) < 0) {
                            n7 = 0;
                        }
                        if (!bl5 && !bl2) {
                            n5 = n6;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.this$0, 2000, n6, -1, 1, n2);
                        if (!this.this$0.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.this$0.setUpdate(false);
                        this.this$0.deselectAllRows();
                        if (bl5 && this.this$0.getMultipleSelections()) {
                            int n19 = n5;
                            while (n19 <= n6) {
                                this.this$0.selectRow(n19);
                                ++n19;
                            }
                            break;
                        }
                        this.this$0.selectRow(n6);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.this$0.fLastSelected = n5;
                this.this$0.fFocusLine = n6;
                this.this$0.setVisibleRow(n7);
                this.this$0.setUpdate(bl4);
            }
            if (listboxEvent != null) {
                this.this$0.deliverEvent(listboxEvent);
                if (this.this$0.fItemListeners != null) {
                    object = new ItemEvent(this.this$0, 701, new Integer(listboxEvent.getRow()), 1);
                    this.this$0.deliverEvent((EventObject)object);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        EventHandler(MultiColumnListboxBase multiColumnListboxBase) {
            this.this$0 = multiColumnListboxBase;
        }
    }

    class ViewArea
    extends JComponent {
        /* synthetic */ MultiColumnListboxBase this$0;
        private transient Hashtable fComponents;

        public ViewArea(MultiColumnListboxBase multiColumnListboxBase) {
            this.this$0 = multiColumnListboxBase;
            this.setLayout(null);
            this.init();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.init();
        }

        private void init() {
            this.fComponents = new Hashtable();
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            try {
                try {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    Image image = this.this$0.getBackgroundImage();
                    if (image == null) {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else {
                        n5 = image.getWidth(this);
                        int n6 = image.getHeight(this);
                        int n7 = rectangle.width / n5 + 2;
                        n4 = rectangle.height / n6 + 2;
                        n3 = rectangle.x / n5 * n5;
                        int n8 = rectangle.y / n6 * n6;
                        n2 = 0;
                        while (n2 < n7) {
                            n = 0;
                            while (n < n4) {
                                int bl = n3 + n2 * n5;
                                int color = n8 + n * n6;
                                graphics.drawImage(image, bl, color, this);
                                ++n;
                            }
                            ++n2;
                        }
                    }
                    n5 = this.this$0.getRowCount();
                    TableModel tableModel = this.this$0.getTableModel();
                    if (n5 == 0 || tableModel == null) {
                        this.removeAll();
                        Object var3_21 = null;
                        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        return;
                    }
                    Dimension dimension = this.getSize();
                    n4 = this.this$0.getVisibleRow();
                    n3 = this.this$0.getVisibleRowCount() + 2;
                    FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.this$0.getFont());
                    n2 = this.this$0.getRowHeight();
                    n = this.this$0.isHorizontalSeparatorVisible() ? 1 : 0;
                    boolean bl = this.this$0.isVerticalSeparatorVisible();
                    Color color = this.this$0.getSeparatorColor();
                    Color color2 = this.this$0.getSelectionBackground();
                    Color color3 = this.this$0.getSelectionForeground();
                    Rectangle rectangle2 = new Rectangle();
                    TableModel tableModel2 = tableModel;
                    synchronized (tableModel2) {
                        Component[] componentArray = this.getComponents();
                        this.fComponents.clear();
                        int n6 = 0;
                        while (n6 < componentArray.length) {
                            this.fComponents.put(componentArray[n6], Boolean.FALSE);
                            ++n6;
                        }
                        n6 = n4;
                        int n7 = n6 + n3 < n5 ? n6 + n3 : n5;
                        int enumeration = n6;
                        while (enumeration < n7) {
                            rectangle2.x = 0;
                            rectangle2.y = enumeration * n2;
                            rectangle2.width = dimension.width;
                            rectangle2.height = n2;
                            this.paintRow(graphics, fontMetrics, tableModel, enumeration, color2, color3, n != 0, bl, color, rectangle, rectangle2);
                            ++enumeration;
                        }
                        Enumeration enumeration2 = this.fComponents.keys();
                        while (enumeration2.hasMoreElements()) {
                            Component component = (Component)enumeration2.nextElement();
                            Boolean bl2 = (Boolean)this.fComponents.get(component);
                            if (bl2.booleanValue()) continue;
                            this.remove(component);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            catch (Throwable throwable) {
                Object var3_22 = null;
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                throw throwable;
            }
            Object var3_23 = null;
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void paintRow(Graphics graphics, FontMetrics fontMetrics, TableModel tableModel, int n, Color color, Color color2, boolean bl, boolean bl2, Color color3, Rectangle rectangle, Rectangle rectangle2) {
            int n2 = rectangle2.x;
            int n3 = rectangle2.y;
            int n4 = rectangle2.width;
            int n5 = rectangle2.height;
            int n6 = this.this$0.listboxRowToTableRow(n);
            boolean bl3 = this.this$0.isRowSelected(n);
            if (bl3) {
                rectangle2 = SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(this.this$0.getSelectionBackground());
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            int n7 = tableModel.getColumnCount();
            int n8 = 0;
            while (n8 < n7) {
                int n9 = this.this$0.listboxColumnToTableColumn(n8);
                ListboxColumn listboxColumn = this.this$0.getColumnInfo(n9);
                if (listboxColumn.isVisible()) {
                    Object object;
                    int n10 = listboxColumn.getWidth();
                    Color color4 = listboxColumn.getBackground();
                    Color color5 = listboxColumn.getForeground();
                    rectangle2.x = n2;
                    rectangle2.y = n3;
                    rectangle2.width = n10;
                    rectangle2.height = n5;
                    SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                    graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (bl3) {
                        graphics.setColor(color2);
                    } else {
                        if (color4 != null) {
                            graphics.setColor(color4);
                            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        object = color5 != null ? color5 : this.this$0.getForeground();
                        graphics.setColor((Color)object);
                    }
                    if (bl2 || bl) {
                        rectangle2.x = n2;
                        rectangle2.y = n3;
                        rectangle2.width = n10 - (bl2 ? 1 : 0);
                        rectangle2.height = n5 - (bl ? 1 : 0);
                        SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    if ((object = tableModel.getElement(n6, n9)) != null) {
                        StringTokenizer stringTokenizer;
                        Object object2;
                        if (object instanceof JComponent) {
                            object2 = (JComponent)object;
                            if (!this.fComponents.containsKey(object2)) {
                                ((JComponent)object2).setVisible(false);
                                this.add((Component)object2);
                            }
                            Rectangle rectangle3 = ((Component)object2).getBounds();
                            if (rectangle3.x != n2 || rectangle3.y != n3) {
                                ((Component)object2).setLocation(n2, n3);
                            }
                            if (rectangle3.width != n10 - (bl2 ? 1 : 0) || rectangle3.height != n5 - (bl ? 1 : 0)) {
                                ((Component)object2).setSize(n10 - (bl2 ? 1 : 0), n5 - (bl ? 1 : 0));
                                ((Container)object2).doLayout();
                            }
                            rectangle3 = ((Component)object2).getBounds();
                            if (!((Component)object2).isVisible()) {
                                ((JComponent)object2).setVisible(true);
                            }
                            Graphics graphics2 = null;
                            try {
                                graphics2 = graphics.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                            }
                            catch (Exception exception) {}
                            if (graphics2 != null) {
                                try {
                                    ((JComponent)object2).paint(graphics2);
                                }
                                catch (Throwable throwable) {
                                    stringTokenizer = null;
                                    graphics2.dispose();
                                    throw throwable;
                                }
                                stringTokenizer = null;
                                graphics2.dispose();
                            }
                            this.fComponents.remove(object2);
                            this.fComponents.put(object2, Boolean.TRUE);
                        } else if (object instanceof Paintable) {
                            object2 = null;
                            try {
                                object2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            }
                            catch (Exception exception) {}
                            if (object2 != null) {
                                try {
                                    ((Paintable)object).paint((Graphics)object2);
                                }
                                catch (Throwable throwable) {
                                    Object var27_28 = null;
                                    ((Graphics)object2).dispose();
                                    throw throwable;
                                }
                                Object var27_29 = null;
                                ((Graphics)object2).dispose();
                            }
                        } else {
                            object2 = this.this$0.paintHook(object.toString(), n, n8);
                            int n11 = fontMetrics.getAscent() + 2 + n3;
                            int n12 = fontMetrics.getHeight();
                            stringTokenizer = new StringTokenizer((String)object2, "\n");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string = stringTokenizer.nextToken();
                                int n13 = 2 + n2;
                                Alignment alignment = listboxColumn.getAlignment();
                                if (alignment.isCenter()) {
                                    n13 += (n10 - fontMetrics.stringWidth(string)) / 2;
                                } else if (alignment.isRight()) {
                                    n13 += n10 - 4 - fontMetrics.stringWidth(string);
                                }
                                graphics.drawString(string, n13, n11);
                                n11 += n12;
                            }
                        }
                    }
                    if (bl2 || bl) {
                        rectangle2.x = n2;
                        rectangle2.y = n3;
                        rectangle2.width = n10;
                        rectangle2.height = n5;
                        SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics.setColor(color3);
                        if (bl) {
                            graphics.drawLine(n2, n3 + n5 - 1, n2 + n10 - 1, n3 + n5 - 1);
                        }
                        if (bl2) {
                            graphics.drawLine(n2 + n10 - 1, n3, n2 + n10 - 1, n3 + n5 - 1);
                        }
                    }
                    n2 += n10;
                }
                ++n8;
            }
            if (bl) {
                rectangle2.x = n2;
                rectangle2.y = n3;
                rectangle2.width = n4 - n2;
                rectangle2.height = n5;
                SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(color3);
                graphics.drawLine(n2, n3 + n5 - 1, n4 - 1, n3 + n5 - 1);
            }
        }

        public Dimension getPreferredSize() {
            int n = 0;
            int n2 = this.this$0.getRowCount() * this.this$0.getRowHeight();
            Object object = this.this$0.LOCK;
            synchronized (object) {
                int n3 = this.this$0.getColumnCount();
                int n4 = 0;
                while (n4 < n3) {
                    ListboxColumn listboxColumn = this.this$0.getColumnInfo(n4);
                    if (listboxColumn.isVisible()) {
                        n += listboxColumn.getWidth();
                    }
                    ++n4;
                }
            }
            return new Dimension(n, n2);
        }
    }
}

