/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb;

import com.ibm.webrunner.j2mclb.Alignment;
import com.ibm.webrunner.j2mclb.ListboxCaption;
import com.ibm.webrunner.j2mclb.MultiColumnListboxBase;
import com.ibm.webrunner.j2mclb.util.Sorter;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ListboxColumn
implements Serializable {
    public static final Alignment DEFAULT_ALIGNMENT = Alignment.LEFT;
    private MultiColumnListboxBase fParent;
    private int fColumn;
    private ListboxCaption fCaption;
    private Sorter fSorter = null;
    private Alignment fAlignment = DEFAULT_ALIGNMENT;
    private Color fBackground = null;
    private Color fForeground = null;

    public ListboxColumn() {
        this.init();
    }

    public ListboxColumn(MultiColumnListboxBase multiColumnListboxBase, int n, ListboxCaption listboxCaption) {
        this();
        this.fParent = multiColumnListboxBase;
        this.fColumn = n;
        this.fCaption = listboxCaption;
    }

    public Alignment getAlignment() {
        return this.fAlignment;
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public Color getForeground() {
        return this.fForeground;
    }

    public Object getLabel() {
        return this.fParent.getTableModel().getColumnInfo(this.fColumn);
    }

    public Sorter getSorter() {
        return this.fSorter;
    }

    protected boolean getState() {
        return this.fCaption.getState();
    }

    public int getWidth() {
        return this.fCaption.getLength();
    }

    private void init() {
    }

    public boolean isResizable() {
        return this.fCaption.isResizable();
    }

    public boolean isSelected() {
        return this.fCaption.isSelected();
    }

    public boolean isSortable() {
        return this.fCaption.isSortable();
    }

    public boolean isVisible() {
        return this.fCaption.isVisible();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void setAlignment(Alignment alignment) {
        if (!this.fAlignment.equals(alignment)) {
            this.fAlignment = alignment;
            this.fParent.repaint();
        }
    }

    public void setBackground(Color color) {
        this.fBackground = color;
        this.fParent.repaint();
    }

    public void setForeground(Color color) {
        this.fForeground = color;
        this.fParent.repaint();
    }

    public void setLabel(Object object) {
        this.fParent.getTableModel().setColumnInfo(object, this.fColumn);
        this.fCaption.setLabel(object);
    }

    public void setResizable(boolean bl) {
        this.fCaption.setResizable(bl);
    }

    public void setSorter(Sorter sorter) {
        boolean bl = false;
        if (sorter != null) {
            bl = true;
        }
        this.fCaption.setSortable(bl);
        this.fSorter = sorter;
    }

    protected void setState(boolean bl) {
        this.fCaption.setState(bl);
        this.fParent.repaint();
    }

    public void setVisible(boolean bl) {
        this.fCaption.setVisible(bl);
        this.fParent.setSize();
    }

    public void setWidth(int n) {
        this.fCaption.setLength(n);
        this.fParent.setSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append(",label=" + this.fParent.getTableModel().getColumnInfo(this.fColumn).toString());
        if (this.isSortable()) {
            stringBuffer.append(",sortable");
        }
        stringBuffer.append(",sorter=" + this.fSorter);
        stringBuffer.append(",alignment=" + this.fAlignment.toString());
        stringBuffer.append(",background=" + this.fBackground);
        stringBuffer.append(",foreground=" + this.fForeground);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

