#
#

include $(HERE)/config.mk

CFLAGS = -O2 -Wall -Wstrict-prototypes -Winline -pipe -Wall -DCARDBUS

CPPFLAGS = $(PCDEBUG) -D__KERNEL__ -DMODULE -I$(HERE)/include \
	   -I$(LINUX)/include -I$(LINUX) 

CC_MODULE = gcc  -c $(CFLAGS) $(CPPFLAGS)

ETC = $(PREFIX)/etc/pcmcia
MANDIR = $(PREFIX)/usr/man

all: ;	rm -rf ohci1394.o
	$(CC_MODULE) ohci1394.c

install-modules: $(MODULES)
	mkdir -p $(PREFIX)/$(MODDIR)/pcmcia
	cp $(MODULES) $(PREFIX)/$(MODDIR)/pcmcia

install-clients: all
	for f in $(CLIENTS) ; do				\
	    [ -r $$f.conf ] && cp $$f.conf $(ETC)/$$f.conf ;	\
	    cmp -s $$f $(ETC)/$$f && continue ;			\
	    [ -r $(ETC)/$$f ] && mv $(ETC)/$$f $(ETC)/$$f.O ;	\
	    cp $$f $(ETC)/$$f ;					\
	    OPTS=$(ETC)/$$f.opts ;				\
	    test -r $$OPTS || cp $$f.opts $$OPTS ;		\
	done

install-man4: $(MAN4)
	mkdir -p $(MANDIR)/man4
	cp $(MAN4) $(MANDIR)/man4


clean:
	rm -f core core.* *.o .*.o *.s *.a *~ .depend .depfiles/*.d

