## Awk program to get rid of comments and other refuse not needed by the
## subsequent documentation program.
## GDH 2/7/96

## This uses the "metacomment" characters &&stopdoc  &&startdoc
## to chop out parts of files that are irrelevant


## In this function, we assume that anything nested beyond level
## depththresh gets deleted from output

BEGIN {
	classthresh = 1;           # printlevel in classes          
	baseprintlevel = 0;        # what level of nesting is printed 
	                           # change with &&shownesting
	keepbraces   = 0;          # change with &&keepbraces

        nogen       = 0;           # Used for &&stopdoc &&startdoc directives
	insavecomment   = 0;       # Used to keep the documentation comments
	incomment   = 0;           # Set if we are in a multi-line comment
	modeclass   = 0;           # Set if we are in a class declaration
	decmode     = 0;           # public =1 protected =2 private =3 
	nestingdepth = 0;          # 

}


## This is the only real parsing that is done;
## this function is used to print out text that
## is at a specific level of nesting.  This
## allows us to print the body of classes, but
## strip inline function bodies and the like.

function printnonnested(str,depththresh,keepbraces)
{

# Is there anything of interest in this string?

  while ((matchpos = match(str,"({|})")) > 0) {

    if (nestingdepth <= depththresh)
      printf("%s",substr(str,0,RSTART-(1-keepbraces)));

    if (substr(str,matchpos,1) == "{")
      nestingdepth++;
    else 
      nestingdepth --;

    str = substr(str,RSTART+1);
  }

  if (nestingdepth <=depththresh)
      print str;
}
  
## Look for metacomments that are important to us

/&&stopdoc/ {nogen = 1; next;}

/&&startdoc/ {nogen = 0; next;}

             {if (nogen) next;}

/&&shownestingto/ {baseprintlevel = $2; next;}
/&&keepbraces/ {keepbraces = $2; next;}


## Always kill processor directives (for now, assume one line)

/^#/   {next;}

##### Always pass the comments we care about!!

## Here are one-shot comments with a //* demarkation

/\/\/\*/ {print $0; next; }

## Here are longer comments with a /** **/ demarkation

/\/\*\*/ {
          insavecomment=1;
          print $0;
	  next;
         }

/\*\*\// {print $0; insavecomment = 0;next;}

         {if (insavecomment) {print $0;next;}}

## Always kill normal comments; This does "one-liners"; the 
## idea is to pass on the "normal" text to later processing
## but to kill anything after the comment

/\/\/([^*]|$)/ {
  matchpos = match($0,"\/\/");
  if (matchpos > 1)
    $0 = substr($0,0,matchpos-1);
  else
    next;
}


## This does multi-line comments.  The same story as above;
## except now we have to explicitly take care of starting
## and stopping of the comment

/(^|[^\/])\/\*([^*]|$)/    {
  matchpos = index($0,"/*");
  if (matchpos > 0) {
    if ((match2 = index($0,"*/")) == 0) {
      incomment = 1;
      $0 = substr($0,0,matchpos-1);
    }
    else
      $0 = substr($0,0,matchpos-1) substr($0,match2+2);
  }
}

/(^|^*)\*\// {
  incomment = 0;
  matchpos = index($0,"*/");
  if (matchpos > 1)
    $0 = substr($0,matchpos+2)
}

###### Dealing with classes!!

## Look for forward class declarations

/^class.*;/ {next;}

## Note when we are in a class and should start looking for the 
## opening brace.

/^class/ {modeclass = 1;decmode = 3;}

## Note when we see a protected or public marker

/public:/ {decmode = 1;print $0;next;}
/protected:/ {decmode = 2;print $0;next;}
/private:/ {decmode = 3;print $0;next;}

##** Some other random things

## Look for extern "C"

/extern "C"/ {$0 = substr($0,index($0,"\"C\"")+3);}

## Default actions

      {
	if (incomment == 1) next;
	
	if (modeclass && (decmode <= classthresh))
	  printnonnested($0,baseprintlevel+1,keepbraces);
	else
	  printnonnested($0,baseprintlevel,keepbraces);

	if (nestingdepth ==0) {
	  if (modeclass)
	    print "//&&endclass";
	  modeclass =0;
	  decmode = 0;
	}
      }


	   
