## Awk program to generate simple html documentation after other things
## have been stripped. 
## GDH 2/7/96

##  Currently does not handle single line enclosed comments, that is
##  /** sldkfjsd **/  won't be handled right.


BEGIN {
	incomment     = 0;
        preformatting = 0;
	inusage       = 0;
}

function printafter(marker,str)
{
	print substr(str,index(str,marker)+length(marker));
}

/^ *$/   { if (preformatting) print "<BR>"; next;}

## Here is what we do to make the class look interesting

/^class/ {if (preformatting) {
            print "</PRE>";
            preformatting = 0;
          }
          print "<P> <h3>" $0 "</h3>";
          print "<A name=#" $2 "</A>"; next;}
/^public:/ {print "<P> <h4> Public Functions: </h4><P>";next;}
/^protected:/ {next;}
/^private:/ {next;}

/&&endclass/ {print "<P> <hr>";next;}
/&&Usage:/   {
      if (preformatting)
         print "</PRE>";
      print "<A name=#" $2 "</A>"; 
      print "<P><h3> Usage </h3>";
      print "<B>" $2 "</B><CODE>" ;
      printafter($2,$0);
      print "</CODE><BR> <PRE>";
      inusage = 1; next;}
/&&endUsage/   {if (!preformatting) print "</PRE><P><P>";
		 inusage = 0; next;}

      {if (inusage) {print $0; next;}}

/&&Section/  {print "<h2>";printafter("&&Section",$0);
	      print  "</h2>";next;}

/&&Subsection/  {print "<h3>";printafter("&&Subsection",$0);
	      print  "</h3>";next;}



## Here are one-shot comments with a //* demarkation

/\/\/\*/ {if (preformatting) {
             print "</PRE>";
             preformatting = 0;
         }
          print $0;
	  next;
         }

## Here are longer comments with a /** **/ demarkation

/\/\*\*/ {
          if (preformatting) 
             {print "</PRE>";
	     preformatting = 0;}
          incomment=1;
          print $0;
	  next;
         }

/\*\*\// {print $0 "<BR>";incomment = 0;next;}

         {
           if ((!incomment) && (!preformatting)) {
              preformatting = 1;
	     print "<P><PRE>";
          }
          print $0;
         }


END {if (preformatting) print "</PRE>";}