#include <linux/types.h>

#define vm_offset_t /*off_t*/ volatile char *
#define printf printk
#define bzero(p, s) memset(p, 0, s)
#define disable_intr cli
#define enable_intr sti
#define bool_t int
#define quad_t long long

#define TRUE  (1)
#define FALSE (0)

#define min(a, b) ((a) < (b) ? (a) : (b))

#ifndef PAGE_SIZE
#include <asm/page.h>
#endif

/* calc # of pages needed (overestimate) */
#define btoc(bytes)	((bytes+(PAGE_SIZE-1)) / PAGE_SIZE)

#define DELAY(usecs)	udelay(usecs)
#include <asm/delay.h>

#define vtophys virt_to_phys
#include <asm/io.h>

#ifdef BIGPHYSAREA
#include <linux/bigphysarea.h>
#else
#define bigphysarea_alloc(size)		get_bktr_mem(unit, size)
#define bigphysarea_free(ptr, size)	kfree(ptr)
#endif

