#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>

#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "writeavi.h"

static int   fd, blocksize;
static char  *buffer;

int
sound_open(struct MOVIE_PARAMS *params)
{
    int afmt,trigger;
    
    if (-1 == (fd = open("/dev/dsp", O_RDONLY))) {
	perror("open /dev/dsp");
	goto err;
    }
    
    /* format */
    switch (params->bits) {
    case 8:
	afmt = AFMT_U8;
	ioctl(fd, SNDCTL_DSP_SETFMT, &afmt);
	if (afmt != AFMT_U8) {
	    fprintf(stderr,"Oops: no 8 bit sound ?\n");
	    goto err;
	}
	break;
    default:
	fprintf(stderr,"%d bit sound not supported\n",
		params->bits);
	goto err;
    }
    
    /* channels */
    ioctl(fd, SNDCTL_DSP_CHANNELS, &params->channels);
    /* sample rate */
    ioctl(fd, SNDCTL_DSP_SPEED,    &params->rate);

    if (-1 == ioctl(fd, SNDCTL_DSP_GETBLKSIZE,  &blocksize))
        goto err;
    buffer = malloc(blocksize);

    /* trigger record */
    trigger = ~PCM_ENABLE_INPUT;
    ioctl(fd,SNDCTL_DSP_SETTRIGGER,&trigger);
    trigger = PCM_ENABLE_INPUT;
    ioctl(fd,SNDCTL_DSP_SETTRIGGER,&trigger);

    return fd;
    
 err:
    params->channels = 0;
    params->bits     = 0;
    params->rate     = 0;
    return -1;
}

int
sound_bufsize()
{
    return blocksize;
}

void*
sound_read()
{
    if (blocksize != read(fd,buffer,blocksize)) {
	perror("read /dev/dsp");
	exit(1);
    }
    return buffer;
}

void
sound_close()
{
    free(buffer);
    close(fd);
}
