/*
 * misc colorspace conversion functions
 *
 * most of them have common arguments (wanna be able to use function
 * pointers):
 *	 foo(unsigned char* dest, unsigned char* src, int width, int height);
 *
 *  (c) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 */

#include "colorspace.h"

/* ------------------------------------------------------------------- */
/* RGB conversions                                                     */

void swap_rgb24(char *mem, int n)
{
    char  c;
    char *p = mem;
    int   i = n;

    while (--i) {
	c = p[0]; p[0] = p[2]; p[2] = c;
	p += 3;
    }
}

void rgb24_to_bgr24(char *dest, char *src, int w, int h)
{
    register char *s = src;
    register char *d = dest;
    register int   i = w*h;

    while (--i) {
	*(d++) = s[2];
	*(d++) = s[1];
	*(d++) = s[0];
	s += 3;
    }
}

void
rgb24_to_rgb32(unsigned char *dest, unsigned char *src, int w, int h)
{
    int             i    = w*h;

    while (i--) {
        *(dest++) = *(src++);
        *(dest++) = *(src++);
        *(dest++) = *(src++);
	*(dest++) = 0;
    }
}

/* ------------------------------------------------------------------- */
/* YUV conversions                                                     */

void
packed422_to_planar422(unsigned char *d, unsigned char *s, int w, int h)
{
    int i;
    unsigned char *y,*u,*v;

    i = (w * h)/2;
    y = d;
    u = y + w * h;
    v = u + w * h / 2;
    
    while (--i) {
	*(y++) = *(s++);
	*(u++) = *(s++);
	*(y++) = *(s++);
        *(v++) = *(s++);
    }
}

void
packed422_to_planar411(unsigned char *d, unsigned char *s, int w, int h)
{
    int  a,b;
    unsigned char *y,*u,*v;

    y = d;
    u = y + w * h;
    v = u + w * h / 4;

    for (a = h; a > 0; a -= 2) {
	for (b = w; b > 0; b -= 2) {
	    
	    *(y++) = *(s++);
	    *(u++) = *(s++);
	    *(y++) = *(s++);
	    *(v++) = *(s++);
	}
	for (b = w; b > 0; b -= 2) {
	    *(y++) = *(s++);
	    s++;
	    *(y++) = *(s++);
	    s++;
	}
    }
}
