/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Tools.hh
//
//  Globally useful definitions for Tools system.
//
//  6 - 6 - 93
//  Sidd Puri
//
//-----------------------------------------------------------------------------

#ifndef Tools_h
#define Tools_h
#include "Tracker.hh"

#ifdef __GNUC__
// get rid of this for egcs 
// #include <std.h>
#endif

//-----------------------------------------------------------------------------
//  Global inline functions
//-----------------------------------------------------------------------------

template<class T> inline T min2 (T a, T b)
{ return a < b? a: b; }

template<class T> inline T max2 (T a, T b)
{ return a > b? a: b; }

#ifndef __SC__
template<class T> inline T abs (T x)
{ return x > 0? x: -x; }

template<class T> inline int signum (T x)
{ return x > 0? 1: -1; }

#else
#include <stdlib.h>
#define signum(x) (x >= 0)
#endif

inline stupid_bool_val odd (int n)
{ return (stupid_bool_val)(n & 1); }

inline int round (float x)
{ return signum(x)*int (abs(x) + .5); }

inline float half (int l)
{ return float (l) / 2; }

inline float rad_deg (float r)
{ return r / M_PI * 180; }

inline float deg_rad (float d)
{ return d / 180 * M_PI; }

template<class T> inline T sqr (T x)
{ return x*x;}

template<class T> inline void copy (T *dest, T *src,int n)
{memcpy(dest,src,n*sizeof(T));}

inline void bitset(unsigned &bits, int n) {
  bits |= (0x1 << n);
}

inline int isset(unsigned bits, int n) {
  return ((bits & (0x1 << n)) != 0);
}

inline void bitclear(unsigned &bits, int n) {
  bits &= ~(0x1 << n);
}

inline void bittoggle(unsigned &bits,int n, int flag) {
  if (flag)
    bitset(bits,n);
  else
    bitclear(bits,n);
}

#endif
